/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.authority;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.RuleManager;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class AuthorityRuleManager {
    private static volatile RuleManager<AuthorityRule> authorityRules = new RuleManager();
    private static final RulePropertyListener LISTENER = new RulePropertyListener();
    private static SentinelProperty<List<AuthorityRule>> currentProperty = new DynamicSentinelProperty<List<AuthorityRule>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<AuthorityRule>> property) {
        AssertUtil.notNull(property, "property cannot be null");
        RulePropertyListener rulePropertyListener = LISTENER;
        synchronized (rulePropertyListener) {
            if (currentProperty != null) {
                currentProperty.removeListener(LISTENER);
            }
            property.addListener(LISTENER);
            currentProperty = property;
            RecordLog.info("[AuthorityRuleManager] Registering new property to authority rule manager", new Object[0]);
        }
    }

    public static void loadRules(List<AuthorityRule> rules) {
        currentProperty.updateValue(rules);
    }

    public static boolean hasConfig(String resource) {
        return authorityRules.hasConfig(resource);
    }

    public static List<AuthorityRule> getRules() {
        return authorityRules.getRules();
    }

    static List<AuthorityRule> getRules(String resource) {
        return authorityRules.getRules(resource);
    }

    public static boolean isValidRule(AuthorityRule rule) {
        return rule != null && !StringUtil.isBlank(rule.getResource()) && rule.getStrategy() >= 0 && StringUtil.isNotBlank(rule.getLimitApp()) && RuleManager.checkRegexResourceField(rule);
    }

    static {
        currentProperty.addListener(LISTENER);
    }

    private static class RulePropertyListener
    implements PropertyListener<List<AuthorityRule>> {
        private RulePropertyListener() {
        }

        @Override
        public synchronized void configLoad(List<AuthorityRule> value) {
            authorityRules.updateRules(this.loadAuthorityConf(value));
            RecordLog.info("[AuthorityRuleManager] Authority rules loaded: {}", authorityRules);
        }

        @Override
        public synchronized void configUpdate(List<AuthorityRule> conf) {
            authorityRules.updateRules(this.loadAuthorityConf(conf));
            RecordLog.info("[AuthorityRuleManager] Authority rules received: {}", authorityRules);
        }

        private Map<String, List<AuthorityRule>> loadAuthorityConf(List<AuthorityRule> list) {
            ConcurrentHashMap<String, List<AuthorityRule>> newRuleMap = new ConcurrentHashMap<String, List<AuthorityRule>>();
            if (list == null || list.isEmpty()) {
                return newRuleMap;
            }
            for (AuthorityRule rule : list) {
                String identity;
                ArrayList<AuthorityRule> ruleSet;
                if (!AuthorityRuleManager.isValidRule(rule)) {
                    RecordLog.warn("[AuthorityRuleManager] Ignoring invalid authority rule when loading new rules: {}", rule);
                    continue;
                }
                if (StringUtil.isBlank(rule.getLimitApp())) {
                    rule.setLimitApp("default");
                }
                if ((ruleSet = (ArrayList<AuthorityRule>)newRuleMap.get(identity = rule.getResource())) == null) {
                    ruleSet = new ArrayList<AuthorityRule>();
                    ruleSet.add(rule);
                    newRuleMap.put(identity, ruleSet);
                    continue;
                }
                RecordLog.warn("[AuthorityRuleManager] Ignoring redundant rule: {}", rule.toString());
            }
            return newRuleMap;
        }
    }
}

