/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.img.GraphicsUtil;
import cn.hutool.core.img.Img;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class ImgUtil {
    public static final String IMAGE_TYPE_GIF = "gif";
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_JPEG = "jpeg";
    public static final String IMAGE_TYPE_BMP = "bmp";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_PSD = "psd";

    public static void scale(File srcImageFile, File destImageFile, float scale) {
        ImgUtil.scale((Image)ImgUtil.read(srcImageFile), destImageFile, scale);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, float scale) {
        ImgUtil.scale((Image)ImgUtil.read(srcStream), destStream, scale);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, float scale) {
        ImgUtil.scale((Image)ImgUtil.read(srcStream), destStream, scale);
    }

    public static void scale(Image srcImg, File destFile, float scale) throws IORuntimeException {
        Img.from(srcImg).setTargetImageType(FileUtil.extName(destFile)).scale(scale).write(destFile);
    }

    public static void scale(Image srcImg, OutputStream out, float scale) throws IORuntimeException {
        ImgUtil.scale(srcImg, ImgUtil.getImageOutputStream(out), scale);
    }

    public static void scale(Image srcImg, ImageOutputStream destImageStream, float scale) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.scale(srcImg, scale), destImageStream);
    }

    public static Image scale(Image srcImg, float scale) {
        return Img.from(srcImg).scale(scale).getImg();
    }

    public static Image scale(Image srcImg, int width, int height) {
        return Img.from(srcImg).scale(width, height).getImg();
    }

    public static void scale(File srcImageFile, File destImageFile, int width, int height, Color fixedColor) throws IORuntimeException {
        ImgUtil.write(ImgUtil.scale(ImgUtil.read(srcImageFile), width, height, fixedColor), destImageFile);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, int width, int height, Color fixedColor) throws IORuntimeException {
        ImgUtil.scale(ImgUtil.read(srcStream), ImgUtil.getImageOutputStream(destStream), width, height, fixedColor);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, int width, int height, Color fixedColor) throws IORuntimeException {
        ImgUtil.scale(ImgUtil.read(srcStream), destStream, width, height, fixedColor);
    }

    public static void scale(Image srcImage, ImageOutputStream destImageStream, int width, int height, Color fixedColor) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.scale(srcImage, width, height, fixedColor), destImageStream);
    }

    public static Image scale(Image srcImage, int width, int height, Color fixedColor) {
        return Img.from(srcImage).scale(width, height, fixedColor).getImg();
    }

    public static void cut(File srcImgFile, File destImgFile, Rectangle rectangle) {
        ImgUtil.cut((Image)ImgUtil.read(srcImgFile), destImgFile, rectangle);
    }

    public static void cut(InputStream srcStream, OutputStream destStream, Rectangle rectangle) {
        ImgUtil.cut((Image)ImgUtil.read(srcStream), destStream, rectangle);
    }

    public static void cut(ImageInputStream srcStream, ImageOutputStream destStream, Rectangle rectangle) {
        ImgUtil.cut((Image)ImgUtil.read(srcStream), destStream, rectangle);
    }

    public static void cut(Image srcImage, File destFile, Rectangle rectangle) throws IORuntimeException {
        ImgUtil.write(ImgUtil.cut(srcImage, rectangle), destFile);
    }

    public static void cut(Image srcImage, OutputStream out, Rectangle rectangle) throws IORuntimeException {
        ImgUtil.cut(srcImage, ImgUtil.getImageOutputStream(out), rectangle);
    }

    public static void cut(Image srcImage, ImageOutputStream destImageStream, Rectangle rectangle) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.cut(srcImage, rectangle), destImageStream);
    }

    public static Image cut(Image srcImage, Rectangle rectangle) {
        return Img.from(srcImage).setPositionBaseCentre(false).cut(rectangle).getImg();
    }

    public static Image cut(Image srcImage, int x, int y) {
        return ImgUtil.cut(srcImage, x, y, -1);
    }

    public static Image cut(Image srcImage, int x, int y, int radius) {
        return Img.from(srcImage).cut(x, y, radius).getImg();
    }

    public static void slice(File srcImageFile, File descDir, int destWidth, int destHeight) {
        ImgUtil.slice(ImgUtil.read(srcImageFile), descDir, destWidth, destHeight);
    }

    public static void slice(Image srcImage, File descDir, int destWidth, int destHeight) {
        if (destWidth <= 0) {
            destWidth = 200;
        }
        if (destHeight <= 0) {
            destHeight = 150;
        }
        int srcWidth = srcImage.getWidth(null);
        int srcHeight = srcImage.getHeight(null);
        try {
            if (srcWidth > destWidth && srcHeight > destHeight) {
                int cols = 0;
                int rows = 0;
                cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor(srcWidth / destWidth) + 1;
                rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor(srcHeight / destHeight) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        Image tag = ImgUtil.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                        ImageIO.write(ImgUtil.toRenderedImage(tag), IMAGE_TYPE_JPEG, new File(descDir, "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void sliceByRowsAndCols(File srcImageFile, File destDir, int rows, int cols) {
        try {
            ImgUtil.sliceByRowsAndCols(ImageIO.read(srcImageFile), destDir, rows, cols);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, int rows, int cols) {
        if (!destDir.exists()) {
            FileUtil.mkdir(destDir);
        } else if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination Dir must be a Directory !");
        }
        try {
            if (rows <= 0 || rows > 20) {
                rows = 2;
            }
            if (cols <= 0 || cols > 20) {
                cols = 2;
            }
            BufferedImage bi = ImgUtil.toBufferedImage(srcImage);
            int srcWidth = ((Image)bi).getWidth(null);
            int srcHeight = ((Image)bi).getHeight(null);
            int destWidth = NumberUtil.partValue(srcWidth, cols);
            int destHeight = NumberUtil.partValue(srcHeight, rows);
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    Image tag = ImgUtil.cut(bi, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                    ImageIO.write(ImgUtil.toRenderedImage(tag), IMAGE_TYPE_JPEG, new File(destDir, "_r" + i + "_c" + j + ".jpg"));
                }
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File srcImageFile, File destImageFile) {
        Assert.notNull(srcImageFile);
        Assert.notNull(destImageFile);
        Assert.isFalse(srcImageFile.equals(destImageFile), "Src file is equals to dest file!", new Object[0]);
        String srcExtName = FileUtil.extName(srcImageFile);
        String destExtName = FileUtil.extName(destImageFile);
        if (StrUtil.equalsIgnoreCase(srcExtName, destExtName)) {
            FileUtil.copy(srcImageFile, destImageFile, true);
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImgUtil.getImageOutputStream(destImageFile);
            ImgUtil.convert(ImgUtil.read(srcImageFile), destExtName, imageOutputStream, StrUtil.equalsIgnoreCase(IMAGE_TYPE_PNG, srcExtName));
        }
        finally {
            IoUtil.close(imageOutputStream);
        }
    }

    public static void convert(InputStream srcStream, String formatName, OutputStream destStream) {
        ImgUtil.write((Image)ImgUtil.read(srcStream), formatName, ImgUtil.getImageOutputStream(destStream));
    }

    @Deprecated
    public static void convert(ImageInputStream srcStream, String formatName, ImageOutputStream destStream) {
        ImgUtil.write((Image)ImgUtil.read(srcStream), formatName, destStream);
    }

    @Deprecated
    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream) {
        ImgUtil.convert(srcImage, formatName, destImageStream, false);
    }

    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream, boolean isSrcPng) {
        try {
            ImageIO.write((RenderedImage)(isSrcPng ? ImgUtil.copyImage(srcImage, 1) : ImgUtil.toBufferedImage(srcImage)), formatName, destImageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void gray(File srcImageFile, File destImageFile) {
        ImgUtil.gray((Image)ImgUtil.read(srcImageFile), destImageFile);
    }

    public static void gray(InputStream srcStream, OutputStream destStream) {
        ImgUtil.gray((Image)ImgUtil.read(srcStream), ImgUtil.getImageOutputStream(destStream));
    }

    public static void gray(ImageInputStream srcStream, ImageOutputStream destStream) {
        ImgUtil.gray((Image)ImgUtil.read(srcStream), destStream);
    }

    public static void gray(Image srcImage, File outFile) {
        ImgUtil.write(ImgUtil.gray(srcImage), outFile);
    }

    public static void gray(Image srcImage, OutputStream out) {
        ImgUtil.gray(srcImage, ImgUtil.getImageOutputStream(out));
    }

    public static void gray(Image srcImage, ImageOutputStream destImageStream) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.gray(srcImage), destImageStream);
    }

    public static Image gray(Image srcImage) {
        return Img.from(srcImage).gray().getImg();
    }

    public static void binary(File srcImageFile, File destImageFile) {
        ImgUtil.binary(ImgUtil.read(srcImageFile), destImageFile);
    }

    public static void binary(InputStream srcStream, OutputStream destStream, String imageType) {
        ImgUtil.binary((Image)ImgUtil.read(srcStream), ImgUtil.getImageOutputStream(destStream), imageType);
    }

    public static void binary(ImageInputStream srcStream, ImageOutputStream destStream, String imageType) {
        ImgUtil.binary((Image)ImgUtil.read(srcStream), destStream, imageType);
    }

    public static void binary(Image srcImage, File outFile) {
        ImgUtil.write(ImgUtil.binary(srcImage), outFile);
    }

    public static void binary(Image srcImage, OutputStream out, String imageType) {
        ImgUtil.binary(srcImage, ImgUtil.getImageOutputStream(out), imageType);
    }

    public static void binary(Image srcImage, ImageOutputStream destImageStream, String imageType) throws IORuntimeException {
        ImgUtil.write(ImgUtil.binary(srcImage), imageType, destImageStream);
    }

    public static Image binary(Image srcImage) {
        return Img.from(srcImage).binary().getImg();
    }

    public static void pressText(File imageFile, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImgUtil.pressText((Image)ImgUtil.read(imageFile), destFile, pressText, color, font, x, y, alpha);
    }

    public static void pressText(InputStream srcStream, OutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImgUtil.pressText((Image)ImgUtil.read(srcStream), ImgUtil.getImageOutputStream(destStream), pressText, color, font, x, y, alpha);
    }

    public static void pressText(ImageInputStream srcStream, ImageOutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImgUtil.pressText((Image)ImgUtil.read(srcStream), destStream, pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.write(ImgUtil.pressText(srcImage, pressText, color, font, x, y, alpha), destFile);
    }

    public static void pressText(Image srcImage, OutputStream to, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.pressText(srcImage, ImgUtil.getImageOutputStream(to), pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, ImageOutputStream destImageStream, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.pressText(srcImage, pressText, color, font, x, y, alpha), destImageStream);
    }

    public static Image pressText(Image srcImage, String pressText, Color color, Font font, int x, int y, float alpha) {
        return Img.from(srcImage).pressText(pressText, color, font, x, y, alpha).getImg();
    }

    public static void pressImage(File srcImageFile, File destImageFile, Image pressImg, int x, int y, float alpha) {
        ImgUtil.pressImage((Image)ImgUtil.read(srcImageFile), destImageFile, pressImg, x, y, alpha);
    }

    public static void pressImage(InputStream srcStream, OutputStream destStream, Image pressImg, int x, int y, float alpha) {
        ImgUtil.pressImage((Image)ImgUtil.read(srcStream), ImgUtil.getImageOutputStream(destStream), pressImg, x, y, alpha);
    }

    public static void pressImage(ImageInputStream srcStream, ImageOutputStream destStream, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.pressImage((Image)ImgUtil.read(srcStream), destStream, pressImg, x, y, alpha);
    }

    public static void pressImage(Image srcImage, File outFile, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.write(ImgUtil.pressImage(srcImage, pressImg, x, y, alpha), outFile);
    }

    public static void pressImage(Image srcImage, OutputStream out, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.pressImage(srcImage, ImgUtil.getImageOutputStream(out), pressImg, x, y, alpha);
    }

    public static void pressImage(Image srcImage, ImageOutputStream destImageStream, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.pressImage(srcImage, pressImg, x, y, alpha), destImageStream);
    }

    public static Image pressImage(Image srcImage, Image pressImg, int x, int y, float alpha) {
        return Img.from(srcImage).pressImage(pressImg, x, y, alpha).getImg();
    }

    public static Image pressImage(Image srcImage, Image pressImg, Rectangle rectangle, float alpha) {
        return Img.from(srcImage).pressImage(pressImg, rectangle, alpha).getImg();
    }

    public static void rotate(File imageFile, int degree, File outFile) throws IORuntimeException {
        ImgUtil.rotate((Image)ImgUtil.read(imageFile), degree, outFile);
    }

    public static void rotate(Image image, int degree, File outFile) throws IORuntimeException {
        ImgUtil.write(ImgUtil.rotate(image, degree), outFile);
    }

    public static void rotate(Image image, int degree, OutputStream out) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.rotate(image, degree), ImgUtil.getImageOutputStream(out));
    }

    public static void rotate(Image image, int degree, ImageOutputStream out) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.rotate(image, degree), out);
    }

    public static Image rotate(Image image, int degree) {
        return Img.from(image).rotate(degree).getImg();
    }

    public static void flip(File imageFile, File outFile) throws IORuntimeException {
        ImgUtil.flip((Image)ImgUtil.read(imageFile), outFile);
    }

    public static void flip(Image image, File outFile) throws IORuntimeException {
        ImgUtil.write(ImgUtil.flip(image), outFile);
    }

    public static void flip(Image image, OutputStream out) throws IORuntimeException {
        ImgUtil.flip(image, ImgUtil.getImageOutputStream(out));
    }

    public static void flip(Image image, ImageOutputStream out) throws IORuntimeException {
        ImgUtil.writeJpg(ImgUtil.flip(image), out);
    }

    public static Image flip(Image image) {
        return Img.from(image).flip().getImg();
    }

    public static void compress(File imageFile, File outFile, float quality) throws IORuntimeException {
        Img.from(imageFile).setQuality(quality).write(outFile);
    }

    public static RenderedImage toRenderedImage(Image img) {
        if (img instanceof RenderedImage) {
            return (RenderedImage)((Object)img);
        }
        return ImgUtil.copyImage(img, 1);
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        return ImgUtil.copyImage(img, 1);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType) {
        BufferedImage bufferedImage;
        if (!imageType.equalsIgnoreCase(IMAGE_TYPE_PNG)) {
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
                if (1 != bufferedImage.getType()) {
                    bufferedImage = ImgUtil.copyImage(image, 1);
                }
            } else {
                bufferedImage = ImgUtil.copyImage(image, 1);
            }
        } else {
            bufferedImage = ImgUtil.toBufferedImage(image);
        }
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image img, int imageType) {
        return ImgUtil.copyImage(img, imageType, null);
    }

    public static BufferedImage copyImage(Image img, int imageType, Color backgroundColor) {
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), imageType);
        Graphics2D bGr = GraphicsUtil.createGraphics(bimage, backgroundColor);
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage toImage(String base64) throws IORuntimeException {
        return ImgUtil.toImage(Base64.decode(base64));
    }

    public static BufferedImage toImage(byte[] imageBytes) throws IORuntimeException {
        return ImgUtil.read(new ByteArrayInputStream(imageBytes));
    }

    public static String toBase64(Image image, String imageType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImgUtil.write(image, imageType, out);
        return Base64.encode(out.toByteArray());
    }

    public static void createImage(String str, Font font, Color backgroundColor, Color fontColor, ImageOutputStream out) throws IORuntimeException {
        Rectangle2D r = font.getStringBounds(str, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics g = image.getGraphics();
        g.setColor(backgroundColor);
        g.fillRect(0, 0, width, height);
        g.setColor(fontColor);
        g.setFont(font);
        g.drawString(str, 0, font.getSize());
        g.dispose();
        ImgUtil.writePng((Image)image, out);
    }

    public static Font createFont(File fontFile) {
        try {
            return Font.createFont(0, fontFile);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontFile);
            }
            catch (Exception e1) {
                throw new UtilException(e);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Font createFont(InputStream fontStream) {
        try {
            return Font.createFont(0, fontStream);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontStream);
            }
            catch (Exception e1) {
                throw new UtilException(e1);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        return GraphicsUtil.createGraphics(image, color);
    }

    public static void writeJpg(Image image, ImageOutputStream destImageStream) throws IORuntimeException {
        ImgUtil.write(image, IMAGE_TYPE_JPG, destImageStream);
    }

    public static void writePng(Image image, ImageOutputStream destImageStream) throws IORuntimeException {
        ImgUtil.write(image, IMAGE_TYPE_PNG, destImageStream);
    }

    public static void writeJpg(Image image, OutputStream out) throws IORuntimeException {
        ImgUtil.write(image, IMAGE_TYPE_JPG, out);
    }

    public static void writePng(Image image, OutputStream out) throws IORuntimeException {
        ImgUtil.write(image, IMAGE_TYPE_PNG, out);
    }

    public static void write(Image image, String imageType, OutputStream out) throws IORuntimeException {
        ImgUtil.write(image, imageType, ImgUtil.getImageOutputStream(out));
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream) throws IORuntimeException {
        return ImgUtil.write(image, imageType, destImageStream, 1.0f);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality) throws IORuntimeException {
        if (StrUtil.isBlank(imageType)) {
            imageType = IMAGE_TYPE_JPG;
        }
        ImageWriter writer = ImgUtil.getWriter(image, imageType);
        return ImgUtil.write((Image)ImgUtil.toBufferedImage(image, imageType), writer, destImageStream, quality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Image image, File targetFile) throws IORuntimeException {
        ImageOutputStream out = null;
        try {
            out = ImgUtil.getImageOutputStream(targetFile);
            ImgUtil.write(image, FileUtil.extName(targetFile), out);
        }
        finally {
            IoUtil.close(out);
        }
    }

    public static boolean write(Image image, ImageWriter writer, ImageOutputStream output, float quality) {
        if (writer == null) {
            return false;
        }
        writer.setOutput(output);
        RenderedImage renderedImage = ImgUtil.toRenderedImage(image);
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        try {
            if (null != imgWriteParams) {
                writer.write(null, new IIOImage(renderedImage, null, null), imgWriteParams);
            } else {
                writer.write(renderedImage);
            }
            output.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            writer.dispose();
        }
        return true;
    }

    public static ImageReader getReader(String type) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static BufferedImage read(String imageFilePath) {
        return ImgUtil.read(FileUtil.file(imageFilePath));
    }

    public static BufferedImage read(File imageFile) {
        try {
            return ImageIO.read(imageFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedImage read(Resource resource) {
        return ImgUtil.read(resource.getStream());
    }

    public static BufferedImage read(InputStream imageStream) {
        try {
            return ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedImage read(ImageInputStream imageStream) {
        try {
            return ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedImage read(URL imageUrl) {
        try {
            return ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ImageOutputStream getImageOutputStream(OutputStream out) throws IORuntimeException {
        try {
            return ImageIO.createImageOutputStream(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ImageOutputStream getImageOutputStream(File outFile) throws IORuntimeException {
        try {
            return ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ImageInputStream getImageInputStream(InputStream in) throws IORuntimeException {
        try {
            return ImageIO.createImageInputStream(in);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ImageWriter getWriter(Image img, String formatName) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(ImgUtil.toRenderedImage(img));
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, formatName);
        return iter.hasNext() ? iter.next() : null;
    }

    public static ImageWriter getWriter(String formatName) {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (null == writer && (iter = ImageIO.getImageWritersBySuffix(formatName)).hasNext()) {
            writer = iter.next();
        }
        return writer;
    }

    public static String toHex(Color color) {
        String R = Integer.toHexString(color.getRed());
        R = R.length() < 2 ? '0' + R : R;
        String G = Integer.toHexString(color.getGreen());
        G = G.length() < 2 ? '0' + G : G;
        String B = Integer.toHexString(color.getBlue());
        B = B.length() < 2 ? '0' + B : B;
        return '#' + R + G + B;
    }

    public static Color hexToColor(String hex) {
        return ImgUtil.getColor(Integer.parseInt(StrUtil.removePrefix(hex, "#"), 16));
    }

    public static Color getColor(int rgb) {
        return new Color(rgb);
    }

    public static Color getColor(String colorName) {
        if (StrUtil.isBlank(colorName)) {
            return null;
        }
        if ("BLACK".equals(colorName = colorName.toUpperCase())) {
            return Color.BLACK;
        }
        if ("WHITE".equals(colorName)) {
            return Color.WHITE;
        }
        if ("LIGHTGRAY".equals(colorName) || "LIGHT_GRAY".equals(colorName)) {
            return Color.LIGHT_GRAY;
        }
        if ("GRAY".equals(colorName)) {
            return Color.GRAY;
        }
        if ("DARK_GRAY".equals(colorName) || "DARK_GRAY".equals(colorName)) {
            return Color.DARK_GRAY;
        }
        if ("RED".equals(colorName)) {
            return Color.RED;
        }
        if ("PINK".equals(colorName)) {
            return Color.PINK;
        }
        if ("ORANGE".equals(colorName)) {
            return Color.ORANGE;
        }
        if ("YELLOW".equals(colorName)) {
            return Color.YELLOW;
        }
        if ("GREEN".equals(colorName)) {
            return Color.GREEN;
        }
        if ("MAGENTA".equals(colorName)) {
            return Color.MAGENTA;
        }
        if ("CYAN".equals(colorName)) {
            return Color.CYAN;
        }
        if ("BLUE".equals(colorName)) {
            return Color.BLUE;
        }
        if ("DARKGOLD".equals(colorName)) {
            return ImgUtil.hexToColor("#9e7e67");
        }
        if ("LIGHTGOLD".equals(colorName)) {
            return ImgUtil.hexToColor("#ac9c85");
        }
        if (StrUtil.startWith((CharSequence)colorName, '#')) {
            return ImgUtil.hexToColor(colorName);
        }
        if (StrUtil.startWith((CharSequence)colorName, '$')) {
            return ImgUtil.hexToColor("#" + colorName.substring(1));
        }
        List<String> rgb = StrUtil.split((CharSequence)colorName, ',');
        if (3 == rgb.size()) {
            Integer b;
            Integer g;
            Integer r = Convert.toInt(rgb.get(0));
            if (!ArrayUtil.hasNull(r, g = Convert.toInt(rgb.get(1)), b = Convert.toInt(rgb.get(2)))) {
                return new Color(r, g, b);
            }
        } else {
            return null;
        }
        return null;
    }

    public static Color randomColor() {
        return ImgUtil.randomColor(null);
    }

    public static Color randomColor(Random random) {
        if (null == random) {
            random = RandomUtil.getRandom();
        }
        return new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255));
    }
}

