/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.spring.core.consumer;

import cn.bizvane.rocketmq.spring.core.consumer.ConsumerBean;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.util.IOUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.beans.BeanUtils;

public class RocketMQConsumerUtils {
    public static RocketMQListener getListener(String topic, String tags) {
        if (ConsumerBean.SUBSCRIPTION_TABLE == null) {
            return null;
        }
        if (ConsumerBean.SUBSCRIPTION_TABLE.get(topic) == null) {
            return null;
        }
        RocketMQListener rocketMQListener = ConsumerBean.SUBSCRIPTION_TABLE.get(topic).get(tags);
        return rocketMQListener != null ? rocketMQListener : ConsumerBean.SUBSCRIPTION_TABLE.get(topic).get("*");
    }

    public static ConsumerMessage convertMessage(MessageExt messageExt, RocketMQListener listener) {
        Type[] genericInterfaces;
        Type bodyType = null;
        for (Type type : genericInterfaces = listener.getClass().getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType) || !type.getTypeName().startsWith(RocketMQListener.class.getName())) continue;
            bodyType = ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        ConsumerMessage<Object> message = new ConsumerMessage<Object>();
        BeanUtils.copyProperties((Object)messageExt, message);
        String body = new String(messageExt.getBody(), IOUtils.UTF8);
        if (Objects.equals(body.getClass(), bodyType)) {
            message.setMessage(body);
        } else {
            message.setMessage(JSON.parseObject((String)body, (Type)bodyType, (Feature[])new Feature[0]));
        }
        return message;
    }
}

