package cn.bizvane.rocketmq.spring.core.consumer;

import cn.bizvane.rocketmq.spring.autoconfigure.RocketMQProperties;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.consumer.MQConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;

import java.util.List;
import java.util.Map;

/**
 * @author wang.zeyan
 * @date 2019/08/21
 * 暂不支持 配置式 consumer
 */
@Slf4j
public class ConsumerConfigurationBean implements InitializingBean, ConsumerBean {

    /**
     * Map<topic:tags, MessageListener>
     */
    private Map<String, MessageListener> subscriptionTable;

    private List<MQConsumer> consumer;

    private RocketMQProperties properties;

    private ApplicationContext ctx;

    public ConsumerConfigurationBean(RocketMQProperties properties, ApplicationContext ctx) {
        this.properties = properties;
        this.ctx = ctx;
    }

    private void initConsumer(){
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        initConsumer();
    }

    @Override
    public void start() {

    }

    @Override
    public void shutdown() {

    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public Map<String, Map<String, RocketMQListener>> getSubscriptionTable() {
        return null;
    }
}
