package cn.bizvane.rocketmq.spring.core.consumer;


import cn.bizvane.rocketmq.spring.exception.ConsumerListenerFindException;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.common.message.MessageExt;

import java.util.function.Consumer;

/**
 * @author wang.zeyan
 * 2019/09/16
 */
@Slf4j
public abstract class AbstractMessageListener {

    Consumer<MessageExt> messageDiff = AbstractMessageListener::messageDiff;
    Consumer<MessageExt> abstractConsumer = AbstractMessageListener::abstractConsumer;

    private static void messageDiff(MessageExt m) {
        String maxOffsetProperty = m.getProperty(MessageConst.PROPERTY_MAX_OFFSET);
        if (maxOffsetProperty != null) {
            long maxOffset = Long.parseLong(maxOffsetProperty);
            long currentOffset = m.getQueueOffset();
            long diffOffset = maxOffset - currentOffset;
            log.info("topic:[{},{}], currentQueueId:{}, currentQueueOffset:{}, currentQueueMaxOffset:{}, diffOffset:{}", m.getTopic(), m.getTags(), m.getQueueId(), m.getQueueOffset(), maxOffset, diffOffset);
        }
    }

    private static void abstractConsumer(MessageExt m) {
        String topic = m.getTopic();
        String tags = m.getTags();
        String consumerGroup = m.getUserProperty("consumerGroup");

        RocketMQListener listener = RocketMQConsumerUtils.getListener(topic, tags);
        if (listener == null) {
            throw new ConsumerListenerFindException(String.format("topic: %s, tags: %s, listener不存在", topic, tags));
        }

        ConsumerMessage consumerMessage = RocketMQConsumerUtils.convertMessage(m, listener);
        listener.onMessage(consumerMessage);
    }
}
