package cn.bizvane.rocketmq.spring.autoconfigure;


import cn.bizvane.rocketmq.spring.core.producer.stat.RocketMQSendStats;
import cn.bizvane.rocketmq.spring.core.producer.stat.RocketMQSendStatsMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.rocketmq.client.producer.MQProducer;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


/**
 * @author wang.zeyan
 * 2019/10/29
 */
@Configuration
@AutoConfigureAfter({MetricsAutoConfiguration.class, RocketMQAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(MeterRegistry.class)
@ConditionalOnBean(MeterRegistry.class)
@ConditionalOnProperty(value = "management.metrics.binders.jvm.enabled", matchIfMissing = true)
public class RocketMQMetricsAutoConfiguration {

    @Bean
    @ConditionalOnBean({ MQProducer.class, RocketMQSendStats.class })
    @ConditionalOnMissingBean
    public RocketMQSendStatsMetrics rocketMqSendStatsMetrics(RocketMQSendStats rocketMQSendStats) {
        return new RocketMQSendStatsMetrics(rocketMQSendStats);
    }
}
