package cn.bizvane.rocketmq.spring.annotation;

import cn.bizvane.rocketmq.spring.core.consumer.RetryStrategy;

import java.lang.annotation.*;

/**
 * @author wang.zeyan
 * @date 2019/08/20
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Deprecated
public @interface Orderly {

    /**
     * 暂停当前队列消费时间, 默认使用全局配置, 单位: 毫秒(ms)
     * @return
     */
    int suspendCurrentQueueTimeMillis() default -1;


    /**
     * 顺序消息重试策略
     * @return
     */
    RetryStrategy retryStrategy() default RetryStrategy.RETRY_UNTIL_SUCCESS;

}

