package cn.bizvane.rocketmq.zipkin.aspect;

import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

import cn.bizvane.rocketmq.zipkin.RocketMQZipkin;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.common.message.Message;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.util.StringUtils;

import brave.ErrorParser;
import brave.Span;
import brave.Tracer;
import brave.propagation.B3SingleFormat;

/**
 * 
 * @author wang.zeyan
 * 2019/08/23
 */
@Aspect
@Slf4j
public class TraceMqProducerAspect extends AbstractTraceAspect implements RocketMQZipkin {

	public TraceMqProducerAspect(Tracer tracer, ErrorParser errorParser) {
		super(tracer, errorParser);
	}
	
	@Around("execution(* org.apache.rocketmq.client.producer.MQProducer.send(..)) && args(message,..)")
	public Object around(final ProceedingJoinPoint pjp, Message message) throws Throwable {
		Span span = null;
		try {
			String spanName = String.format("rocketmq-producer[%s][%s]", message.getTopic(), message.getTags());
			
			tracer.startScopedSpan(spanName);
			span = tracer.currentSpan();
			span.kind(Span.Kind.PRODUCER);
			
			if(!StringUtils.hasText(message.getKeys())) {
				message.setKeys(span.context().spanIdString());
			}
			span.tag("topic", message.getTopic());
			span.tag("keys", message.getKeys());
			span.tag("tags", message.getTags());
			log.info("{}", span);
			message.putUserProperty(B3, B3SingleFormat.writeB3SingleFormat(span.context()));
			return pjp.proceed();
		} catch (Exception e) {
			span.error(e);
			throw e;
		} finally {
			span.finish(2000);
		}
	}
	
}
