/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.http;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.ssssssss.magicapi.core.annotation.MagicModule;
import org.ssssssss.script.annotation.Comment;

@MagicModule(value="http")
public class HttpModule {
    private final RestTemplate template;
    private final HttpHeaders httpHeaders = new HttpHeaders();
    private Class<?> responseType = Object.class;
    private final MultiValueMap<String, Object> params = new LinkedMultiValueMap();
    private final MultiValueMap<String, Object> data = new LinkedMultiValueMap();
    private final Map<String, ?> variables = new HashMap();
    private String url;
    private HttpMethod method = HttpMethod.GET;
    private HttpEntity<Object> entity = null;
    private Object requestBody;

    public HttpModule(RestTemplate template) {
        this.template = template;
    }

    public HttpModule(RestTemplate template, String url) {
        this.template = template;
        this.url = url;
    }

    @Comment(value="\u521b\u5efa\u8fde\u63a5")
    public HttpModule connect(@Comment(name="url", value="\u76ee\u6807URL") String url) {
        return new HttpModule(this.template, url);
    }

    @Comment(value="\u8bbe\u7f6eURL\u53c2\u6570")
    public HttpModule param(@Comment(name="key", value="\u53c2\u6570\u540d") String key, Object ... values) {
        if (values != null) {
            for (Object value : values) {
                this.params.add((Object)key, value);
            }
        }
        return this;
    }

    @Comment(value="\u6279\u91cf\u8bbe\u7f6eURL\u53c2\u6570")
    public HttpModule param(@Comment(name="values", value="\u53c2\u6570\u503c") Map<String, Object> values) {
        values.forEach((key, value) -> this.param((String)key, Objects.toString(value, "")));
        return this;
    }

    @Comment(value="\u8bbe\u7f6eform\u53c2\u6570")
    public HttpModule data(@Comment(name="key", value="\u53c2\u6570\u540d") String key, Object ... values) {
        if (values != null) {
            for (Object value : values) {
                this.data.add((Object)key, value);
            }
        }
        return this;
    }

    @Comment(value="\u6279\u91cf\u8bbe\u7f6eform\u53c2\u6570")
    public HttpModule data(@Comment(name="values", value="\u53c2\u6570\u503c") Map<String, Object> values) {
        values.forEach((key, value) -> this.data((String)key, Objects.toString(value, "")));
        return this;
    }

    @Comment(value="\u8bbe\u7f6eheader")
    public HttpModule header(@Comment(name="key", value="header\u540d") String key, @Comment(name="value", value="header\u503c") String value) {
        this.httpHeaders.add(key, value);
        return this;
    }

    @Comment(value="\u6279\u91cf\u8bbe\u7f6eheader")
    public HttpModule header(@Comment(name="values", value="header\u503c") Map<String, Object> values) {
        values.entrySet().stream().filter(it -> it.getValue() != null).forEach(entry -> this.header((String)entry.getKey(), entry.getValue().toString()));
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u8bf7\u6c42\u65b9\u6cd5\uff0c\u9ed8\u8ba4GET")
    public HttpModule method(@Comment(name="method", value="\u8bf7\u6c42\u65b9\u6cd5") HttpMethod method) {
        this.method = method;
        return this;
    }

    @Comment(value="\u8bbe\u7f6e`RequestBody`")
    public HttpModule body(@Comment(name="requestBody", value="`RequestBody`") Object requestBody) {
        this.requestBody = requestBody;
        this.contentType(MediaType.APPLICATION_JSON);
        return this;
    }

    @Comment(value="\u81ea\u5b9a\u4e49`HttpEntity`")
    public HttpModule entity(@Comment(name="entity", value="`HttpEntity`") HttpEntity<Object> entity) {
        this.entity = entity;
        return this;
    }

    @Comment(value="\u8bbe\u7f6e`ContentType`")
    public HttpModule contentType(@Comment(name="contentType", value="Content-Type\u503c") String contentType) {
        return this.contentType(MediaType.parseMediaType((String)contentType));
    }

    @Comment(value="\u8bbe\u7f6e`ContentType`")
    public HttpModule contentType(@Comment(name="mediaType", value="Content-Type\u503c") MediaType mediaType) {
        this.httpHeaders.setContentType(mediaType);
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u8fd4\u56de\u503c\u4e3a`byte[]`")
    public HttpModule expectBytes() {
        this.responseType = byte[].class;
        return this;
    }

    @Comment(value="\u53d1\u9001`POST`\u8bf7\u6c42")
    public ResponseEntity<?> post() {
        this.method(HttpMethod.POST);
        return this.execute();
    }

    @Comment(value="\u53d1\u9001`GET`\u8bf7\u6c42")
    public ResponseEntity<?> get() {
        this.method(HttpMethod.GET);
        return this.execute();
    }

    @Comment(value="\u53d1\u9001`PUT`\u8bf7\u6c42")
    public ResponseEntity<?> put() {
        this.method(HttpMethod.PUT);
        return this.execute();
    }

    @Comment(value="\u53d1\u9001`DELETE`\u8bf7\u6c42")
    public ResponseEntity<?> delete() {
        this.method(HttpMethod.DELETE);
        return this.execute();
    }

    @Comment(value="\u53d1\u9001`HEAD`\u8bf7\u6c42")
    public ResponseEntity<?> head() {
        this.method(HttpMethod.HEAD);
        return this.execute();
    }

    @Comment(value="\u53d1\u9001`OPTIONS`\u8bf7\u6c42")
    public ResponseEntity<?> options() {
        this.method(HttpMethod.OPTIONS);
        return this.execute();
    }

    @Comment(value="\u53d1\u9001`TRACE`\u8bf7\u6c42")
    public ResponseEntity<?> trace() {
        this.method(HttpMethod.TRACE);
        return this.execute();
    }

    @Comment(value="\u53d1\u9001`PATCH`\u8bf7\u6c42")
    public ResponseEntity<?> patch() {
        this.method(HttpMethod.PATCH);
        return this.execute();
    }

    @Comment(value="\u6267\u884c\u8bf7\u6c42")
    public ResponseEntity<?> execute() {
        String queryString;
        if (!this.params.isEmpty() && StringUtils.isNotBlank((CharSequence)(queryString = this.params.entrySet().stream().map(it -> ((List)it.getValue()).stream().map(value -> (String)it.getKey() + "=" + value).collect(Collectors.joining("&"))).collect(Collectors.joining("&"))))) {
            this.url = this.url + (this.url.contains("?") ? "&" : "?") + queryString;
        }
        this.entity = !this.data.isEmpty() ? new HttpEntity(this.data, (MultiValueMap)this.httpHeaders) : (this.entity == null && this.requestBody != null ? new HttpEntity(this.requestBody, (MultiValueMap)this.httpHeaders) : new HttpEntity(null, (MultiValueMap)this.httpHeaders));
        return this.template.exchange(this.url, this.method, this.entity, this.responseType, this.variables);
    }
}

