/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.lang.Nullable;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.DynamicValuesPropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class DynamicPropertiesContextCustomizer
implements ContextCustomizer {
    private static final String PROPERTY_SOURCE_NAME = "Dynamic Test Properties";
    private final Set<Method> methods;

    DynamicPropertiesContextCustomizer(Set<Method> methods) {
        methods.forEach(this::assertValid);
        this.methods = methods;
    }

    private void assertValid(Method method) {
        Assert.state((boolean)Modifier.isStatic(method.getModifiers()), () -> "@DynamicPropertySource method '" + method.getName() + "' must be static");
        Class<?>[] types = method.getParameterTypes();
        Assert.state((types.length == 1 && types[0] == DynamicPropertyRegistry.class ? 1 : 0) != 0, () -> "@DynamicPropertySource method '" + method.getName() + "' must accept a single DynamicPropertyRegistry argument");
    }

    @Override
    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        MutablePropertySources sources = context.getEnvironment().getPropertySources();
        sources.addFirst((PropertySource)new DynamicValuesPropertySource(PROPERTY_SOURCE_NAME, this.buildDynamicPropertiesMap()));
    }

    private Map<String, Supplier<Object>> buildDynamicPropertiesMap() {
        LinkedHashMap map = new LinkedHashMap();
        DynamicPropertyRegistry dynamicPropertyRegistry = (name, valueSupplier) -> {
            Assert.hasText((String)name, (String)"'name' must not be null or blank");
            Assert.notNull((Object)valueSupplier, (String)"'valueSupplier' must not be null");
            map.put(name, valueSupplier);
        };
        this.methods.forEach(method -> {
            ReflectionUtils.makeAccessible((Method)method);
            ReflectionUtils.invokeMethod((Method)method, null, (Object[])new Object[]{dynamicPropertyRegistry});
        });
        return Collections.unmodifiableMap(map);
    }

    Set<Method> getMethods() {
        return this.methods;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof DynamicPropertiesContextCustomizer)) return false;
        DynamicPropertiesContextCustomizer that = (DynamicPropertiesContextCustomizer)other;
        if (!this.methods.equals(that.methods)) return false;
        return true;
    }

    public int hashCode() {
        return this.methods.hashCode();
    }
}

