/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import io.micrometer.observation.ObservationRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.aop.support.Pointcuts;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.ObservationAuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationManagerAfterMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.Jsr250AuthorizationManager;
import org.springframework.security.authorization.method.MethodExpressionAuthorizationManager;
import org.springframework.security.authorization.method.PostAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PostFilterAuthorizationMethodInterceptor;
import org.springframework.security.authorization.method.PreAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PreFilterAuthorizationMethodInterceptor;
import org.springframework.security.authorization.method.SecuredAuthorizationManager;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.config.method.AspectJMethodMatcher;
import org.springframework.security.config.method.PointcutDelegatingAuthorizationManager;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MethodSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_USE_JSR250 = "jsr250-enabled";
    private static final String ATT_USE_SECURED = "secured-enabled";
    private static final String ATT_USE_PREPOST = "pre-post-enabled";
    private static final String ATT_AUTHORIZATION_MGR = "authorization-manager-ref";
    private static final String ATT_OBSERVATION_REGISTRY_REF = "observation-registry-ref";
    private static final String ATT_ACCESS = "access";
    private static final String ATT_EXPRESSION = "expression";
    private static final String ATT_MODE = "mode";
    private static final String ATT_SECURITY_CONTEXT_HOLDER_STRATEGY_REF = "security-context-holder-strategy-ref";

    public BeanDefinition parse(Element element, ParserContext pc) {
        boolean jsr250Enabled;
        boolean securedEnabled;
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), pc.extractSource((Object)element));
        pc.pushContainingComponent(compositeDef);
        BeanMetadataElement securityContextHolderStrategy = this.getSecurityContextHolderStrategy(element);
        BeanMetadataElement observationRegistry = this.getObservationRegistry(element);
        boolean prePostAnnotationsEnabled = !element.hasAttribute(ATT_USE_PREPOST) || "true".equals(element.getAttribute(ATT_USE_PREPOST));
        boolean useAspectJ = "aspectj".equals(element.getAttribute(ATT_MODE));
        if (prePostAnnotationsEnabled) {
            BeanDefinitionBuilder preFilterInterceptor = BeanDefinitionBuilder.rootBeanDefinition(PreFilterAuthorizationMethodInterceptor.class).setRole(2).addPropertyValue("securityContextHolderStrategy", (Object)securityContextHolderStrategy);
            BeanDefinitionBuilder preAuthorizeInterceptor = BeanDefinitionBuilder.rootBeanDefinition(PreAuthorizeAuthorizationMethodInterceptor.class).setRole(2).addPropertyValue("securityContextHolderStrategy", (Object)securityContextHolderStrategy).addPropertyValue("observationRegistry", (Object)observationRegistry);
            BeanDefinitionBuilder postAuthorizeInterceptor = BeanDefinitionBuilder.rootBeanDefinition(PostAuthorizeAuthorizationMethodInterceptor.class).setRole(2).addPropertyValue("securityContextHolderStrategy", (Object)securityContextHolderStrategy).addPropertyValue("observationRegistry", (Object)observationRegistry);
            BeanDefinitionBuilder postFilterInterceptor = BeanDefinitionBuilder.rootBeanDefinition(PostFilterAuthorizationMethodInterceptor.class).setRole(2).addPropertyValue("securityContextHolderStrategy", (Object)securityContextHolderStrategy);
            Element expressionHandlerElt = DomUtils.getChildElementByTagName((Element)element, (String)"expression-handler");
            if (expressionHandlerElt != null) {
                String expressionHandlerRef = expressionHandlerElt.getAttribute("ref");
                preFilterInterceptor.addPropertyReference("expressionHandler", expressionHandlerRef);
                preAuthorizeInterceptor.addPropertyReference("expressionHandler", expressionHandlerRef);
                postAuthorizeInterceptor.addPropertyReference("expressionHandler", expressionHandlerRef);
                postFilterInterceptor.addPropertyReference("expressionHandler", expressionHandlerRef);
            } else {
                AbstractBeanDefinition expressionHandler = BeanDefinitionBuilder.rootBeanDefinition(MethodSecurityExpressionHandlerBean.class).getBeanDefinition();
                preFilterInterceptor.addPropertyValue("expressionHandler", (Object)expressionHandler);
                preAuthorizeInterceptor.addPropertyValue("expressionHandler", (Object)expressionHandler);
                postAuthorizeInterceptor.addPropertyValue("expressionHandler", (Object)expressionHandler);
                postFilterInterceptor.addPropertyValue("expressionHandler", (Object)expressionHandler);
            }
            pc.getRegistry().registerBeanDefinition("preFilterAuthorizationMethodInterceptor", (BeanDefinition)preFilterInterceptor.getBeanDefinition());
            pc.getRegistry().registerBeanDefinition("preAuthorizeAuthorizationMethodInterceptor", (BeanDefinition)preAuthorizeInterceptor.getBeanDefinition());
            pc.getRegistry().registerBeanDefinition("postAuthorizeAuthorizationMethodInterceptor", (BeanDefinition)postAuthorizeInterceptor.getBeanDefinition());
            pc.getRegistry().registerBeanDefinition("postFilterAuthorizationMethodInterceptor", (BeanDefinition)postFilterInterceptor.getBeanDefinition());
        }
        if (securedEnabled = "true".equals(element.getAttribute(ATT_USE_SECURED))) {
            BeanDefinitionBuilder securedInterceptor = BeanDefinitionBuilder.rootBeanDefinition(SecuredAuthorizationMethodInterceptor.class).setRole(2).addPropertyValue("securityContextHolderStrategy", (Object)securityContextHolderStrategy).addPropertyValue("observationRegistry", (Object)observationRegistry);
            pc.getRegistry().registerBeanDefinition("securedAuthorizationMethodInterceptor", (BeanDefinition)securedInterceptor.getBeanDefinition());
        }
        if (jsr250Enabled = "true".equals(element.getAttribute(ATT_USE_JSR250))) {
            BeanDefinitionBuilder jsr250Interceptor = BeanDefinitionBuilder.rootBeanDefinition(Jsr250AuthorizationMethodInterceptor.class).setRole(2).addPropertyValue("securityContextHolderStrategy", (Object)securityContextHolderStrategy).addPropertyValue("observationRegistry", (Object)observationRegistry);
            pc.getRegistry().registerBeanDefinition("jsr250AuthorizationMethodInterceptor", (BeanDefinition)jsr250Interceptor.getBeanDefinition());
        }
        ManagedMap managers = new ManagedMap();
        List methods = DomUtils.getChildElementsByTagName((Element)element, (String)"protect-pointcut");
        if (useAspectJ) {
            if (!methods.isEmpty()) {
                pc.getReaderContext().error("Cannot use <protect-pointcut> and mode='aspectj' together", pc.extractSource((Object)element));
            }
            this.registerInterceptors(pc.getRegistry());
        } else {
            if (!methods.isEmpty()) {
                for (Element protectElt : methods) {
                    managers.put(this.pointcut(protectElt), this.authorizationManager(element, protectElt));
                }
                BeanDefinitionBuilder protectPointcutInterceptor = BeanDefinitionBuilder.rootBeanDefinition(AuthorizationManagerBeforeMethodInterceptor.class).setRole(2).addPropertyValue("securityContextHolderStrategy", (Object)securityContextHolderStrategy).addConstructorArgValue((Object)this.pointcut(managers.keySet())).addConstructorArgValue((Object)this.authorizationManager((Map<Pointcut, BeanMetadataElement>)managers));
                pc.getRegistry().registerBeanDefinition("protectPointcutInterceptor", (BeanDefinition)protectPointcutInterceptor.getBeanDefinition());
            }
            AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)pc, (Element)element);
        }
        pc.popAndRegisterContainingComponent();
        return null;
    }

    private BeanMetadataElement getObservationRegistry(Element methodSecurityElmt) {
        String holderStrategyRef = methodSecurityElmt.getAttribute(ATT_OBSERVATION_REGISTRY_REF);
        if (StringUtils.hasText((String)holderStrategyRef)) {
            return new RuntimeBeanReference(holderStrategyRef);
        }
        return BeanDefinitionBuilder.rootBeanDefinition(ObservationRegistryFactory.class).getBeanDefinition();
    }

    private BeanMetadataElement getSecurityContextHolderStrategy(Element methodSecurityElmt) {
        String holderStrategyRef = methodSecurityElmt.getAttribute(ATT_SECURITY_CONTEXT_HOLDER_STRATEGY_REF);
        if (StringUtils.hasText((String)holderStrategyRef)) {
            return new RuntimeBeanReference(holderStrategyRef);
        }
        return BeanDefinitionBuilder.rootBeanDefinition(SecurityContextHolderStrategyFactory.class).getBeanDefinition();
    }

    private Pointcut pointcut(Element protectElt) {
        String expression = protectElt.getAttribute(ATT_EXPRESSION);
        expression = this.replaceBooleanOperators(expression);
        return new AspectJMethodMatcher(expression);
    }

    private Pointcut pointcut(Collection<Pointcut> pointcuts) {
        Pointcut result = null;
        for (Pointcut pointcut : pointcuts) {
            if (result == null) {
                result = pointcut;
                continue;
            }
            result = Pointcuts.union((Pointcut)result, (Pointcut)pointcut);
        }
        return result;
    }

    private String replaceBooleanOperators(String expression) {
        expression = StringUtils.replace((String)expression, (String)" and ", (String)" && ");
        expression = StringUtils.replace((String)expression, (String)" or ", (String)" || ");
        expression = StringUtils.replace((String)expression, (String)" not ", (String)" ! ");
        return expression;
    }

    private BeanMetadataElement authorizationManager(Element element, Element protectElt) {
        String authorizationManager = element.getAttribute(ATT_AUTHORIZATION_MGR);
        if (StringUtils.hasText((String)authorizationManager)) {
            return new RuntimeBeanReference(authorizationManager);
        }
        String access = protectElt.getAttribute(ATT_ACCESS);
        return BeanDefinitionBuilder.rootBeanDefinition(MethodExpressionAuthorizationManager.class).addConstructorArgValue((Object)access).getBeanDefinition();
    }

    private BeanMetadataElement authorizationManager(Map<Pointcut, BeanMetadataElement> managers) {
        return BeanDefinitionBuilder.rootBeanDefinition(PointcutDelegatingAuthorizationManager.class).addConstructorArgValue(managers).getBeanDefinition();
    }

    private void registerInterceptors(BeanDefinitionRegistry registry) {
        this.registerBeanDefinition("preFilterAuthorizationMethodInterceptor", "org.springframework.security.authorization.method.aspectj.PreFilterAspect", "preFilterAspect$0", registry);
        this.registerBeanDefinition("postFilterAuthorizationMethodInterceptor", "org.springframework.security.authorization.method.aspectj.PostFilterAspect", "postFilterAspect$0", registry);
        this.registerBeanDefinition("preAuthorizeAuthorizationMethodInterceptor", "org.springframework.security.authorization.method.aspectj.PreAuthorizeAspect", "preAuthorizeAspect$0", registry);
        this.registerBeanDefinition("postAuthorizeAuthorizationMethodInterceptor", "org.springframework.security.authorization.method.aspectj.PostAuthorizeAspect", "postAuthorizeAspect$0", registry);
        this.registerBeanDefinition("securedAuthorizationMethodInterceptor", "org.springframework.security.authorization.method.aspectj.SecuredAspect", "securedAspect$0", registry);
    }

    private void registerBeanDefinition(String beanName, String aspectClassName, String aspectBeanName, BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(beanName)) {
            return;
        }
        BeanDefinition interceptor = registry.getBeanDefinition(beanName);
        BeanDefinitionBuilder aspect = BeanDefinitionBuilder.rootBeanDefinition((String)aspectClassName);
        aspect.setFactoryMethod("aspectOf");
        aspect.setRole(2);
        aspect.addPropertyValue("securityInterceptor", (Object)interceptor);
        registry.registerBeanDefinition(aspectBeanName, (BeanDefinition)aspect.getBeanDefinition());
    }

    public static final class PreAuthorizeAuthorizationMethodInterceptor
    implements FactoryBean<AuthorizationManagerBeforeMethodInterceptor> {
        private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
        private final PreAuthorizeAuthorizationManager manager = new PreAuthorizeAuthorizationManager();

        public AuthorizationManagerBeforeMethodInterceptor getObject() {
            PreAuthorizeAuthorizationManager manager = this.manager;
            if (!this.observationRegistry.isNoop()) {
                manager = new ObservationAuthorizationManager(this.observationRegistry, (AuthorizationManager)this.manager);
            }
            AuthorizationManagerBeforeMethodInterceptor interceptor = AuthorizationManagerBeforeMethodInterceptor.preAuthorize((AuthorizationManager)manager);
            interceptor.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
            return interceptor;
        }

        public Class<?> getObjectType() {
            return AuthorizationManagerBeforeMethodInterceptor.class;
        }

        public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
            this.securityContextHolderStrategy = securityContextHolderStrategy;
        }

        public void setExpressionHandler(MethodSecurityExpressionHandler expressionHandler) {
            this.manager.setExpressionHandler(expressionHandler);
        }

        public void setObservationRegistry(ObservationRegistry registry) {
            this.observationRegistry = registry;
        }
    }

    public static final class PostAuthorizeAuthorizationMethodInterceptor
    implements FactoryBean<AuthorizationManagerAfterMethodInterceptor> {
        private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
        private final PostAuthorizeAuthorizationManager manager = new PostAuthorizeAuthorizationManager();

        public AuthorizationManagerAfterMethodInterceptor getObject() {
            PostAuthorizeAuthorizationManager manager = this.manager;
            if (!this.observationRegistry.isNoop()) {
                manager = new ObservationAuthorizationManager(this.observationRegistry, (AuthorizationManager)this.manager);
            }
            AuthorizationManagerAfterMethodInterceptor interceptor = AuthorizationManagerAfterMethodInterceptor.postAuthorize((AuthorizationManager)manager);
            interceptor.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
            return interceptor;
        }

        public Class<?> getObjectType() {
            return AuthorizationManagerAfterMethodInterceptor.class;
        }

        public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
            this.securityContextHolderStrategy = securityContextHolderStrategy;
        }

        public void setExpressionHandler(MethodSecurityExpressionHandler expressionHandler) {
            this.manager.setExpressionHandler(expressionHandler);
        }

        public void setObservationRegistry(ObservationRegistry registry) {
            this.observationRegistry = registry;
        }
    }

    public static final class MethodSecurityExpressionHandlerBean
    implements FactoryBean<MethodSecurityExpressionHandler>,
    ApplicationContextAware {
        private final DefaultMethodSecurityExpressionHandler expressionHandler = new DefaultMethodSecurityExpressionHandler();

        public MethodSecurityExpressionHandler getObject() {
            return this.expressionHandler;
        }

        public Class<?> getObjectType() {
            return MethodSecurityExpressionHandler.class;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            String[] grantedAuthorityDefaultsBeanNames = applicationContext.getBeanNamesForType(GrantedAuthorityDefaults.class);
            if (grantedAuthorityDefaultsBeanNames.length == 1) {
                GrantedAuthorityDefaults grantedAuthorityDefaults = (GrantedAuthorityDefaults)applicationContext.getBean(grantedAuthorityDefaultsBeanNames[0], GrantedAuthorityDefaults.class);
                this.expressionHandler.setDefaultRolePrefix(grantedAuthorityDefaults.getRolePrefix());
            }
        }
    }

    public static final class SecuredAuthorizationMethodInterceptor
    implements FactoryBean<AuthorizationManagerBeforeMethodInterceptor> {
        private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
        private final SecuredAuthorizationManager manager = new SecuredAuthorizationManager();

        public AuthorizationManagerBeforeMethodInterceptor getObject() {
            SecuredAuthorizationManager manager = this.manager;
            if (!this.observationRegistry.isNoop()) {
                manager = new ObservationAuthorizationManager(this.observationRegistry, (AuthorizationManager)this.manager);
            }
            AuthorizationManagerBeforeMethodInterceptor interceptor = AuthorizationManagerBeforeMethodInterceptor.secured((AuthorizationManager)manager);
            interceptor.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
            return interceptor;
        }

        public Class<?> getObjectType() {
            return AuthorizationManagerBeforeMethodInterceptor.class;
        }

        public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
            this.securityContextHolderStrategy = securityContextHolderStrategy;
        }

        public void setObservationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
        }
    }

    public static final class Jsr250AuthorizationMethodInterceptor
    implements FactoryBean<AuthorizationManagerBeforeMethodInterceptor>,
    ApplicationContextAware {
        private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
        private final Jsr250AuthorizationManager manager = new Jsr250AuthorizationManager();

        public AuthorizationManagerBeforeMethodInterceptor getObject() {
            Jsr250AuthorizationManager manager = this.manager;
            if (!this.observationRegistry.isNoop()) {
                manager = new ObservationAuthorizationManager(this.observationRegistry, (AuthorizationManager)this.manager);
            }
            AuthorizationManagerBeforeMethodInterceptor interceptor = AuthorizationManagerBeforeMethodInterceptor.jsr250((AuthorizationManager)manager);
            interceptor.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
            return interceptor;
        }

        public Class<?> getObjectType() {
            return AuthorizationManagerBeforeMethodInterceptor.class;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            String[] grantedAuthorityDefaultsBeanNames = applicationContext.getBeanNamesForType(GrantedAuthorityDefaults.class);
            if (grantedAuthorityDefaultsBeanNames.length == 1) {
                GrantedAuthorityDefaults grantedAuthorityDefaults = (GrantedAuthorityDefaults)applicationContext.getBean(grantedAuthorityDefaultsBeanNames[0], GrantedAuthorityDefaults.class);
                this.manager.setRolePrefix(grantedAuthorityDefaults.getRolePrefix());
            }
        }

        public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
            this.securityContextHolderStrategy = securityContextHolderStrategy;
        }

        public void setObservationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
        }
    }

    static class ObservationRegistryFactory
    implements FactoryBean<ObservationRegistry> {
        ObservationRegistryFactory() {
        }

        public ObservationRegistry getObject() throws Exception {
            return ObservationRegistry.NOOP;
        }

        public Class<?> getObjectType() {
            return ObservationRegistry.class;
        }
    }

    static class SecurityContextHolderStrategyFactory
    implements FactoryBean<SecurityContextHolderStrategy> {
        SecurityContextHolderStrategyFactory() {
        }

        public SecurityContextHolderStrategy getObject() throws Exception {
            return SecurityContextHolder.getContextHolderStrategy();
        }

        public Class<?> getObjectType() {
            return SecurityContextHolderStrategy.class;
        }
    }
}

