/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.event.AfterLinkDeleteEvent;
import org.springframework.data.rest.core.event.AfterLinkSaveEvent;
import org.springframework.data.rest.core.event.BeforeLinkDeleteEvent;
import org.springframework.data.rest.core.event.BeforeLinkSaveEvent;
import org.springframework.data.rest.core.invoke.RepositoryInvoker;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.util.Function;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.support.BackendId;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RepositoryRestController
class RepositoryPropertyReferenceController
extends AbstractRepositoryRestController
implements ApplicationEventPublisherAware {
    private static final String BASE_MAPPING = "/{repository}/{id}/{property}";
    private final Repositories repositories;
    private final ConversionService conversionService;
    private ApplicationEventPublisher publisher;

    @Autowired
    public RepositoryPropertyReferenceController(Repositories repositories, @Qualifier(value="defaultConversionService") ConversionService conversionService, PagedResourcesAssembler<Object> assembler) {
        super(assembler);
        this.repositories = repositories;
        this.conversionService = conversionService;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.GET})
    public ResponseEntity<ResourceSupport> followPropertyReference(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, final PersistentEntityResourceAssembler assembler) throws Exception {
        final HttpHeaders headers = new HttpHeaders();
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public ResourceSupport apply(ReferencedProperty prop) {
                if (null == prop.propertyValue) {
                    throw new ResourceNotFoundException();
                }
                if (prop.property.isCollectionLike()) {
                    ArrayList<PersistentEntityResource> resources = new ArrayList<PersistentEntityResource>();
                    for (Object obj : (Iterable)prop.propertyValue) {
                        resources.add(assembler.toResource(obj));
                    }
                    return new Resources(resources, new Link[0]);
                }
                if (prop.property.isMap()) {
                    HashMap resources = new HashMap();
                    for (Map.Entry entry : ((Map)prop.propertyValue).entrySet()) {
                        resources.put(entry.getKey(), assembler.toResource(entry.getValue()));
                    }
                    return new Resource(resources, new Link[0]);
                }
                PersistentEntityResource resource = assembler.toResource(prop.propertyValue);
                headers.set("Content-Location", resource.getId().getHref());
                return resource;
            }
        };
        ResourceSupport responseResource = this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.GET);
        return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, responseResource);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.DELETE})
    public ResponseEntity<? extends ResourceSupport> deletePropertyReference(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property) throws Exception {
        final RepositoryInvoker repoMethodInvoker = repoRequest.getInvoker();
        if (!repoMethodInvoker.exposesDelete()) {
            return new ResponseEntity(HttpStatus.METHOD_NOT_ALLOWED);
        }
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public Resource<?> apply(ReferencedProperty prop) throws HttpRequestMethodNotSupportedException {
                if (null == prop.propertyValue) {
                    return null;
                }
                if (prop.property.isCollectionLike()) {
                    throw new HttpRequestMethodNotSupportedException("DELETE");
                }
                if (prop.property.isMap()) {
                    throw new HttpRequestMethodNotSupportedException("DELETE");
                }
                prop.wrapper.setProperty(prop.property, null);
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new BeforeLinkDeleteEvent(prop.wrapper.getBean(), prop.propertyValue));
                Object result = repoMethodInvoker.invokeSave(prop.wrapper.getBean());
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new AfterLinkDeleteEvent(result, prop.propertyValue));
                return null;
            }
        };
        this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.DELETE);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{propertyId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResourceSupport> followPropertyReference(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, final @PathVariable String propertyId, final PersistentEntityResourceAssembler assembler) throws Exception {
        final HttpHeaders headers = new HttpHeaders();
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public ResourceSupport apply(ReferencedProperty prop) {
                if (null == prop.propertyValue) {
                    throw new ResourceNotFoundException();
                }
                if (prop.property.isCollectionLike()) {
                    for (Object obj : (Iterable)prop.propertyValue) {
                        BeanWrapper propValWrapper = BeanWrapper.create(obj, null);
                        String sId = propValWrapper.getProperty(prop.entity.getIdProperty()).toString();
                        if (!propertyId.equals(sId)) continue;
                        PersistentEntityResource resource = assembler.toResource(obj);
                        headers.set("Content-Location", resource.getId().getHref());
                        return resource;
                    }
                } else if (prop.property.isMap()) {
                    for (Map.Entry entry : ((Map)prop.propertyValue).entrySet()) {
                        BeanWrapper propValWrapper = BeanWrapper.create(entry.getValue(), null);
                        String sId = propValWrapper.getProperty(prop.entity.getIdProperty()).toString();
                        if (!propertyId.equals(sId)) continue;
                        PersistentEntityResource resource = assembler.toResource(entry.getValue());
                        headers.set("Content-Location", resource.getId().getHref());
                        return resource;
                    }
                } else {
                    return new Resource(prop.propertyValue, new Link[0]);
                }
                throw new ResourceNotFoundException();
            }
        };
        ResourceSupport responseResource = this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.GET);
        return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, responseResource);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json", "text/uri-list"})
    public ResponseEntity<ResourceSupport> followPropertyReferenceCompact(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, PersistentEntityResourceAssembler assembler) throws Exception {
        ResponseEntity<ResourceSupport> response = this.followPropertyReference(repoRequest, id, property, assembler);
        if (response.getStatusCode() != HttpStatus.OK) {
            return response;
        }
        ResourceMetadata repoMapping = repoRequest.getResourceMetadata();
        PersistentProperty persistentProp = repoRequest.getPersistentEntity().getPersistentProperty(property);
        ResourceMapping propertyMapping = repoMapping.getMappingFor(persistentProp);
        ResourceSupport resource = (ResourceSupport)response.getBody();
        ArrayList<Link> links = new ArrayList<Link>();
        ControllerLinkBuilder linkBuilder = ControllerLinkBuilder.linkTo(((RepositoryPropertyReferenceController)ControllerLinkBuilder.methodOn(RepositoryPropertyReferenceController.class, (Object[])new Object[0])).followPropertyReference(repoRequest, id, property, assembler));
        if (resource instanceof Resource) {
            Object content = ((Resource)resource).getContent();
            if (content instanceof Iterable) {
                for (Resource res : (Iterable)content) {
                    links.add(linkBuilder.withRel(propertyMapping.getRel()));
                }
            } else if (content instanceof Map) {
                Map map = (Map)content;
                for (Map.Entry entry : map.entrySet()) {
                    Link l = new Link(((Resource)entry.getValue()).getLink("self").getHref(), entry.getKey().toString());
                    links.add(l);
                }
            }
        } else {
            links.add(linkBuilder.withRel(propertyMapping.getRel()));
        }
        return ControllerUtils.toResponseEntity(HttpStatus.OK, null, new Resource(ControllerUtils.EMPTY_RESOURCE_LIST, links));
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.PATCH, RequestMethod.PUT}, consumes={"application/json", "application/x-spring-data-compact+json", "text/uri-list"})
    @ResponseBody
    public ResponseEntity<? extends ResourceSupport> createPropertyReference(RootResourceInformation resourceInformation, final HttpMethod requestMethod, final @RequestBody(required=false) Resources<Object> incoming, @BackendId Serializable id, @PathVariable String property) throws Exception {
        final Resources source = incoming == null ? new Resources(Collections.emptyList(), new Link[0]) : incoming;
        final RepositoryInvoker invoker = resourceInformation.getInvoker();
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public ResourceSupport apply(ReferencedProperty prop) throws HttpRequestMethodNotSupportedException {
                Class propertyType = prop.property.getType();
                if (prop.property.isCollectionLike()) {
                    Collection coll = CollectionFactory.createCollection((Class)propertyType, (int)0);
                    if (HttpMethod.PATCH.equals((Object)requestMethod)) {
                        coll = (Collection)prop.propertyValue;
                    }
                    for (Link l : source.getLinks()) {
                        Object propVal = RepositoryPropertyReferenceController.this.loadPropertyValue(prop.propertyType, l);
                        coll.add(propVal);
                    }
                    prop.wrapper.setProperty(prop.property, (Object)coll);
                } else if (prop.property.isMap()) {
                    Map m = CollectionFactory.createMap((Class)propertyType, (int)0);
                    if (HttpMethod.PATCH.equals((Object)requestMethod)) {
                        m = (Map)prop.propertyValue;
                    }
                    for (Link l : source.getLinks()) {
                        Object propVal = RepositoryPropertyReferenceController.this.loadPropertyValue(prop.propertyType, l);
                        m.put(l.getRel(), propVal);
                    }
                    prop.wrapper.setProperty(prop.property, (Object)m);
                } else {
                    if (HttpMethod.PATCH.equals((Object)requestMethod)) {
                        throw new HttpRequestMethodNotSupportedException(HttpMethod.PATCH.name(), new String[]{"PATCH"}, "Cannot PATCH a reference to this singular property since the property type is not a List or a Map.");
                    }
                    if (source.getLinks().size() != 1) {
                        throw new IllegalArgumentException("Must send only 1 link to update a property reference that isn't a List or a Map.");
                    }
                    Object propVal = RepositoryPropertyReferenceController.this.loadPropertyValue(prop.propertyType, (Link)incoming.getLinks().get(0));
                    prop.wrapper.setProperty(prop.property, propVal);
                }
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new BeforeLinkSaveEvent(prop.wrapper.getBean(), prop.propertyValue));
                Object result = invoker.invokeSave(prop.wrapper.getBean());
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new AfterLinkSaveEvent(result, prop.propertyValue));
                return null;
            }
        };
        this.doWithReferencedProperty(resourceInformation, id, property, handler, requestMethod);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{propertyId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<ResourceSupport> deletePropertyReferenceId(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, final @PathVariable String propertyId) throws Exception {
        final RepositoryInvoker invoker = repoRequest.getInvoker();
        if (!invoker.exposesSave()) {
            throw new HttpRequestMethodNotSupportedException(HttpMethod.DELETE.name());
        }
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public ResourceSupport apply(ReferencedProperty prop) {
                if (null == prop.propertyValue) {
                    return null;
                }
                if (prop.property.isCollectionLike()) {
                    Collection coll = (Collection)prop.propertyValue;
                    Iterator itr = coll.iterator();
                    while (itr.hasNext()) {
                        Object obj = itr.next();
                        BeanWrapper propValWrapper = BeanWrapper.create(obj, null);
                        String s = propValWrapper.getProperty(prop.entity.getIdProperty()).toString();
                        if (!propertyId.equals(s)) continue;
                        itr.remove();
                    }
                } else if (prop.property.isMap()) {
                    Map m = (Map)prop.propertyValue;
                    Iterator itr = m.keySet().iterator();
                    while (itr.hasNext()) {
                        Object key = itr.next();
                        BeanWrapper propValWrapper = BeanWrapper.create(m.get(key), null);
                        String s = propValWrapper.getProperty(prop.entity.getIdProperty()).toString();
                        if (!propertyId.equals(s)) continue;
                        itr.remove();
                    }
                } else {
                    prop.wrapper.setProperty(prop.property, null);
                }
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new BeforeLinkDeleteEvent(prop.wrapper.getBean(), prop.propertyValue));
                Object result = invoker.invokeSave(prop.wrapper.getBean());
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new AfterLinkDeleteEvent(result, prop.propertyValue));
                return null;
            }
        };
        this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.DELETE);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    private Object loadPropertyValue(Class<?> type, Link link) {
        String href = link.expand(new Object[0]).getHref();
        String id = href.substring(href.lastIndexOf(47) + 1);
        return this.conversionService.convert((Object)id, type);
    }

    private ResourceSupport doWithReferencedProperty(RootResourceInformation repoRequest, Serializable id, String propertyPath, Function<ReferencedProperty, ResourceSupport> handler, HttpMethod method) throws Exception {
        RepositoryInvoker invoker = repoRequest.getInvoker();
        if (!invoker.exposesFindOne()) {
            throw new HttpRequestMethodNotSupportedException(method.name());
        }
        Object domainObj = invoker.invokeFindOne(id);
        if (null == domainObj) {
            throw new ResourceNotFoundException();
        }
        PersistentProperty prop = repoRequest.getPersistentEntity().getPersistentProperty(propertyPath);
        if (null == prop) {
            throw new ResourceNotFoundException();
        }
        BeanWrapper wrapper = BeanWrapper.create((Object)domainObj, null);
        Object propVal = wrapper.getProperty(prop);
        return (ResourceSupport)handler.apply((Object)new ReferencedProperty(prop, propVal, wrapper));
    }

    private class ReferencedProperty {
        final PersistentEntity<?, ?> entity;
        final PersistentProperty<?> property;
        final Class<?> propertyType;
        final Object propertyValue;
        final BeanWrapper<?> wrapper;

        private ReferencedProperty(PersistentProperty<?> property, Object propertyValue, BeanWrapper<?> wrapper) {
            this.property = property;
            this.propertyValue = propertyValue;
            this.wrapper = wrapper;
            this.propertyType = property.getActualType();
            this.entity = RepositoryPropertyReferenceController.this.repositories.getPersistentEntity(this.propertyType);
        }
    }
}

