/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.sync.BaseRedisCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.SlotHash;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.ClusterNodeResourceProvider;
import org.springframework.data.redis.connection.ClusterTopologyProvider;
import org.springframework.data.redis.connection.DefaultedRedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisClusterServerCommands;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.ClusterConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceClusterGeoCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterHashCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterHyperLogLogCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterKeyCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterListCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterServerCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterStringCommands;
import org.springframework.data.redis.connection.lettuce.LettuceClusterTopologyProvider;
import org.springframework.data.redis.connection.lettuce.LettuceClusterZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceExceptionConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class LettuceClusterConnection
extends LettuceConnection
implements DefaultedRedisClusterConnection {
    static final ExceptionTranslationStrategy exceptionConverter = new PassThroughExceptionTranslationStrategy(new LettuceExceptionConverter());
    private final Log log = LogFactory.getLog(this.getClass());
    private ClusterCommandExecutor clusterCommandExecutor;
    private ClusterTopologyProvider topologyProvider;
    private boolean disposeClusterCommandExecutorOnClose;

    public LettuceClusterConnection(RedisClusterClient clusterClient) {
        this(new ClusterConnectionProvider(clusterClient, CODEC));
    }

    public LettuceClusterConnection(RedisClusterClient clusterClient, ClusterCommandExecutor executor) {
        this(clusterClient, executor, RedisURI.DEFAULT_TIMEOUT_DURATION);
    }

    public LettuceClusterConnection(RedisClusterClient clusterClient, ClusterCommandExecutor executor, Duration timeout) {
        this(new ClusterConnectionProvider(clusterClient, CODEC), executor, timeout);
    }

    public LettuceClusterConnection(LettuceConnectionProvider connectionProvider) {
        super(null, connectionProvider, RedisURI.DEFAULT_TIMEOUT_DURATION.toMillis(), 0);
        this.topologyProvider = new LettuceClusterTopologyProvider(this.getClient());
        this.clusterCommandExecutor = new ClusterCommandExecutor(this.topologyProvider, new LettuceClusterNodeResourceProvider(this.getConnectionProvider()), exceptionConverter);
        this.disposeClusterCommandExecutorOnClose = true;
    }

    public LettuceClusterConnection(LettuceConnectionProvider connectionProvider, ClusterCommandExecutor executor) {
        this(connectionProvider, executor, RedisURI.DEFAULT_TIMEOUT_DURATION);
    }

    public LettuceClusterConnection(LettuceConnectionProvider connectionProvider, ClusterCommandExecutor executor, Duration timeout) {
        super(null, connectionProvider, timeout.toMillis(), 0);
        Assert.notNull((Object)executor, (String)"ClusterCommandExecutor must not be null.");
        this.topologyProvider = new LettuceClusterTopologyProvider(this.getClient());
        this.clusterCommandExecutor = executor;
        this.disposeClusterCommandExecutorOnClose = false;
    }

    private RedisClusterClient getClient() {
        return ((ClusterConnectionProvider)this.getConnectionProvider()).getClient();
    }

    @Override
    public RedisGeoCommands geoCommands() {
        return new LettuceClusterGeoCommands(this);
    }

    @Override
    public RedisHashCommands hashCommands() {
        return new LettuceClusterHashCommands(this);
    }

    @Override
    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return new LettuceClusterHyperLogLogCommands(this);
    }

    @Override
    public RedisKeyCommands keyCommands() {
        return this.doGetClusterKeyCommands();
    }

    private LettuceClusterKeyCommands doGetClusterKeyCommands() {
        return new LettuceClusterKeyCommands(this);
    }

    @Override
    public RedisListCommands listCommands() {
        return new LettuceClusterListCommands(this);
    }

    @Override
    public RedisStringCommands stringCommands() {
        return new LettuceClusterStringCommands(this);
    }

    @Override
    public RedisSetCommands setCommands() {
        return new LettuceClusterSetCommands(this);
    }

    @Override
    public RedisZSetCommands zSetCommands() {
        return new LettuceClusterZSetCommands(this);
    }

    @Override
    public RedisClusterServerCommands serverCommands() {
        return new LettuceClusterServerCommands(this);
    }

    public Set<RedisClusterNode> clusterGetSlaves(RedisClusterNode master) {
        Assert.notNull((Object)master, (String)"Master must not be null!");
        RedisClusterNode nodeToUse = this.topologyProvider.getTopology().lookup(master);
        return (Set)this.clusterCommandExecutor.executeCommandOnSingleNode(client -> LettuceConverters.toSetOfRedisClusterNodes(client.clusterSlaves(nodeToUse.getId())), master).getValue();
    }

    @Override
    public Integer clusterGetSlotForKey(byte[] key) {
        return SlotHash.getSlot((byte[])key);
    }

    @Override
    public RedisClusterNode clusterGetNodeForSlot(int slot) {
        return LettuceConverters.toRedisClusterNode(this.getClient().getPartitions().getPartitionBySlot(slot));
    }

    @Override
    public RedisClusterNode clusterGetNodeForKey(byte[] key) {
        return this.clusterGetNodeForSlot(this.clusterGetSlotForKey(key));
    }

    @Override
    public ClusterInfo clusterGetClusterInfo() {
        return (ClusterInfo)this.clusterCommandExecutor.executeCommandOnArbitraryNode(client -> new ClusterInfo(LettuceConverters.toProperties(client.clusterInfo()))).getValue();
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, int ... slots) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(client -> client.clusterAddSlots(slots), node);
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)range, (String)"Range must not be null.");
        this.clusterAddSlots(node, range.getSlotsArray());
    }

    @Override
    public void clusterDeleteSlots(RedisClusterNode node, int ... slots) {
        this.clusterCommandExecutor.executeCommandOnSingleNode(client -> client.clusterDelSlots(slots), node);
    }

    @Override
    public void clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)range, (String)"Range must not be null.");
        this.clusterDeleteSlots(node, range.getSlotsArray());
    }

    @Override
    public void clusterForget(RedisClusterNode node) {
        ArrayList<RedisClusterNode> nodes = new ArrayList<RedisClusterNode>((Collection<RedisClusterNode>)this.clusterGetNodes());
        RedisClusterNode nodeToRemove = this.topologyProvider.getTopology().lookup(node);
        nodes.remove(nodeToRemove);
        this.clusterCommandExecutor.executeCommandAsyncOnNodes(client -> client.clusterForget(nodeToRemove.getId()), nodes);
    }

    @Override
    public void clusterMeet(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"Cluster node must not be null for CLUSTER MEET command!");
        Assert.hasText((String)node.getHost(), (String)"Node to meet cluster must have a host!");
        Assert.isTrue((node.getPort() > 0 ? 1 : 0) != 0, (String)"Node to meet cluster must have a port greater 0!");
        this.clusterCommandExecutor.executeCommandOnAllNodes(client -> client.clusterMeet(node.getHost(), node.getPort().intValue()));
    }

    @Override
    public void clusterSetSlot(RedisClusterNode node, int slot, RedisClusterCommands.AddSlots mode) {
        Assert.notNull((Object)node, (String)"Node must not be null.");
        Assert.notNull((Object)((Object)mode), (String)"AddSlots mode must not be null.");
        RedisClusterNode nodeToUse = this.topologyProvider.getTopology().lookup(node);
        String nodeId = nodeToUse.getId();
        this.clusterCommandExecutor.executeCommandOnSingleNode(client -> {
            switch (mode) {
                case MIGRATING: {
                    return client.clusterSetSlotMigrating(slot, nodeId);
                }
                case IMPORTING: {
                    return client.clusterSetSlotImporting(slot, nodeId);
                }
                case NODE: {
                    return client.clusterSetSlotNode(slot, nodeId);
                }
                case STABLE: {
                    return client.clusterSetSlotStable(slot);
                }
            }
            throw new InvalidDataAccessApiUsageException("Invalid import mode for cluster slot: " + slot);
        }, node);
    }

    @Override
    public List<byte[]> clusterGetKeysInSlot(int slot, Integer count) {
        try {
            return this.getConnection().clusterGetKeysInSlot(slot, count.intValue());
        }
        catch (Exception ex) {
            throw exceptionConverter.translate(ex);
        }
    }

    @Override
    public Long clusterCountKeysInSlot(int slot) {
        try {
            return this.getConnection().clusterCountKeysInSlot(slot);
        }
        catch (Exception ex) {
            throw exceptionConverter.translate(ex);
        }
    }

    @Override
    public void clusterReplicate(RedisClusterNode master, RedisClusterNode slave) {
        RedisClusterNode masterNode = this.topologyProvider.getTopology().lookup(master);
        this.clusterCommandExecutor.executeCommandOnSingleNode(client -> client.clusterReplicate(masterNode.getId()), slave);
    }

    @Override
    public String ping() {
        List ping = this.clusterCommandExecutor.executeCommandOnAllNodes(BaseRedisCommands::ping).resultsAsList();
        for (String result : ping) {
            if (ObjectUtils.nullSafeEquals((Object)"PONG", (Object)result)) continue;
            return "";
        }
        return "PONG";
    }

    @Override
    public String ping(RedisClusterNode node) {
        return (String)this.clusterCommandExecutor.executeCommandOnSingleNode(BaseRedisCommands::ping, node).getValue();
    }

    @Override
    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        return this.doGetClusterKeyCommands().keys(node, pattern);
    }

    @Override
    public byte[] randomKey(RedisClusterNode node) {
        return this.doGetClusterKeyCommands().randomKey(node);
    }

    @Override
    public void select(int dbIndex) {
        if (dbIndex != 0) {
            throw new InvalidDataAccessApiUsageException("Cannot SELECT non zero index in cluster mode.");
        }
    }

    public List<RedisClusterNode> clusterGetNodes() {
        return LettuceConverters.partitionsToClusterNodes(this.getClient().getPartitions());
    }

    @Override
    public void watch(byte[] ... keys) {
        throw new InvalidDataAccessApiUsageException("WATCH is currently not supported in cluster mode.");
    }

    @Override
    public void unwatch() {
        throw new InvalidDataAccessApiUsageException("UNWATCH is currently not supported in cluster mode.");
    }

    @Override
    public void multi() {
        throw new InvalidDataAccessApiUsageException("MULTI is currently not supported in cluster mode.");
    }

    @Override
    public Map<RedisClusterNode, Collection<RedisClusterNode>> clusterGetMasterSlaveMap() {
        List nodeResults = this.clusterCommandExecutor.executeCommandAsyncOnNodes(client -> Converters.toSetOfRedisClusterNodes(client.clusterSlaves(client.clusterMyId())), this.topologyProvider.getTopology().getActiveMasterNodes()).getResults();
        LinkedHashMap<RedisClusterNode, Collection<RedisClusterNode>> result = new LinkedHashMap<RedisClusterNode, Collection<RedisClusterNode>>();
        for (ClusterCommandExecutor.NodeResult nodeResult : nodeResults) {
            result.put(nodeResult.getNode(), (Collection<RedisClusterNode>)nodeResult.getValue());
        }
        return result;
    }

    public ClusterCommandExecutor getClusterCommandExecutor() {
        return this.clusterCommandExecutor;
    }

    @Override
    public void close() throws DataAccessException {
        if (!this.isClosed() && this.disposeClusterCommandExecutorOnClose) {
            try {
                this.clusterCommandExecutor.destroy();
            }
            catch (Exception ex) {
                this.log.warn((Object)"Cannot properly close cluster command executor", (Throwable)ex);
            }
        }
        super.close();
    }

    static class LettuceClusterNodeResourceProvider
    implements ClusterNodeResourceProvider,
    DisposableBean {
        private final LettuceConnectionProvider connectionProvider;
        @Nullable
        private volatile StatefulRedisClusterConnection<byte[], byte[]> connection;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RedisClusterCommands<byte[], byte[]> getResourceForSpecificNode(RedisClusterNode node) {
            Assert.notNull((Object)node, (String)"Node must not be null!");
            if (this.connection == null) {
                LettuceClusterNodeResourceProvider lettuceClusterNodeResourceProvider = this;
                synchronized (lettuceClusterNodeResourceProvider) {
                    if (this.connection == null) {
                        this.connection = this.connectionProvider.getConnection(StatefulRedisClusterConnection.class);
                    }
                }
            }
            try {
                return this.connection.getConnection(node.getHost(), node.getPort().intValue()).sync();
            }
            catch (RedisException e) {
                throw new DataAccessResourceFailureException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void returnResourceForSpecificNode(RedisClusterNode node, Object resource) {
        }

        public void destroy() throws Exception {
            if (this.connection != null) {
                this.connectionProvider.release((StatefulConnection<?, ?>)this.connection);
            }
        }

        public LettuceClusterNodeResourceProvider(LettuceConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }
    }

    protected static interface LettuceMultiKeyClusterCommandCallback<T>
    extends ClusterCommandExecutor.MultiKeyClusterCommandCallback<RedisClusterCommands<byte[], byte[]>, T> {
    }

    protected static interface LettuceClusterCommandCallback<T>
    extends ClusterCommandExecutor.ClusterCommandCallback<RedisClusterCommands<byte[], byte[]>, T> {
    }
}

