/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mapjoin;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.text.NumberFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mapjoin.MapJoinMemoryExhaustionException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class MapJoinMemoryExhaustionHandler {
    private static final Log LOG = LogFactory.getLog(MapJoinMemoryExhaustionHandler.class);
    public final MemoryMXBean memoryMXBean;
    private final double maxMemoryUsage;
    private final long maxHeapSize;
    private final SessionState.LogHelper console;
    private final NumberFormat percentageNumberFormat;

    public MapJoinMemoryExhaustionHandler(SessionState.LogHelper console, double maxMemoryUsage) {
        this.console = console;
        this.maxMemoryUsage = maxMemoryUsage;
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.maxHeapSize = MapJoinMemoryExhaustionHandler.getMaxHeapSize(this.memoryMXBean);
        this.percentageNumberFormat = NumberFormat.getInstance();
        this.percentageNumberFormat.setMinimumFractionDigits(2);
        LOG.info((Object)("JVM Max Heap Size: " + this.maxHeapSize));
    }

    public static long getMaxHeapSize() {
        return MapJoinMemoryExhaustionHandler.getMaxHeapSize(ManagementFactory.getMemoryMXBean());
    }

    private static long getMaxHeapSize(MemoryMXBean bean) {
        long maxHeapSize = bean.getHeapMemoryUsage().getMax();
        if (maxHeapSize == -1L) {
            LOG.warn((Object)"MemoryMXBean.getHeapMemoryUsage().getMax() returned -1, defaulting maxHeapSize to 200MB");
            return 0xC800000L;
        }
        return maxHeapSize;
    }

    public void checkMemoryStatus(long tableContainerSize, long numRows) throws MapJoinMemoryExhaustionException {
        long usedMemory = this.memoryMXBean.getHeapMemoryUsage().getUsed();
        double percentage = (double)usedMemory / (double)this.maxHeapSize;
        String msg = Utilities.now() + "\tProcessing rows:\t" + numRows + "\tHashtable size:\t" + tableContainerSize + "\tMemory usage:\t" + usedMemory + "\tpercentage:\t" + this.percentageNumberFormat.format(percentage);
        this.console.printInfo(msg);
        if (percentage > this.maxMemoryUsage) {
            throw new MapJoinMemoryExhaustionException(msg);
        }
    }
}

