/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.powermock.core.MockRepository;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.classloader.annotations.MockPolicy;
import org.powermock.core.spi.PowerMockPolicy;
import org.powermock.mockpolicies.MockPolicyClassLoadingSettings;
import org.powermock.mockpolicies.MockPolicyInterceptionSettings;
import org.powermock.mockpolicies.impl.MockPolicyClassLoadingSettingsImpl;
import org.powermock.mockpolicies.impl.MockPolicyInterceptionSettingsImpl;
import org.powermock.reflect.Whitebox;
import org.powermock.tests.utils.MockPolicyInitializer;

public class MockPolicyInitializerImpl
implements MockPolicyInitializer {
    private final PowerMockPolicy[] mockPolicies;
    private final Class<? extends PowerMockPolicy>[] mockPolicyTypes;
    private final Class<?> testClass;

    public MockPolicyInitializerImpl(Class<? extends PowerMockPolicy>[] mockPolicies) {
        this(mockPolicies, false);
    }

    public MockPolicyInitializerImpl(Class<?> testClass) {
        this(MockPolicyInitializerImpl.getMockPolicies(testClass), testClass, false);
    }

    private MockPolicyInitializerImpl(Class<? extends PowerMockPolicy>[] mockPolicies, boolean internal) {
        this(mockPolicies, null, false);
    }

    private MockPolicyInitializerImpl(Class<? extends PowerMockPolicy>[] mockPolicies, Class<?> testClass, boolean internal) {
        this.testClass = testClass;
        this.mockPolicyTypes = internal ? null : mockPolicies;
        if (mockPolicies == null) {
            this.mockPolicies = new PowerMockPolicy[0];
        } else {
            this.mockPolicies = new PowerMockPolicy[mockPolicies.length];
            for (int i = 0; i < mockPolicies.length; ++i) {
                this.mockPolicies[i] = (PowerMockPolicy)Whitebox.newInstance(mockPolicies[i]);
            }
        }
    }

    @Override
    public boolean isPrepared(String fullyQualifiedClassName) {
        MockPolicyClassLoadingSettings settings = this.getClassLoadingSettings();
        boolean foundInSuppressStaticInitializer = Arrays.binarySearch(settings.getStaticInitializersToSuppress(), fullyQualifiedClassName) < 0;
        boolean foundClassesLoadedByMockClassloader = Arrays.binarySearch(settings.getFullyQualifiedNamesOfClassesToLoadByMockClassloader(), fullyQualifiedClassName) < 0;
        return foundInSuppressStaticInitializer || foundClassesLoadedByMockClassloader;
    }

    @Override
    public boolean needsInitialization() {
        MockPolicyClassLoadingSettings settings = this.getClassLoadingSettings();
        return settings.getStaticInitializersToSuppress().length > 0 || settings.getFullyQualifiedNamesOfClassesToLoadByMockClassloader().length > 0;
    }

    @Override
    public void initialize(ClassLoader classLoader) {
        if (classLoader instanceof MockClassLoader) {
            this.initialize((MockClassLoader)classLoader);
        }
    }

    private void initialize(MockClassLoader classLoader) {
        if (this.mockPolicies.length > 0) {
            Class<?>[] classes;
            MockPolicyClassLoadingSettings classLoadingSettings = this.getClassLoadingSettings();
            String[] fullyQualifiedNamesOfClassesToLoadByMockClassloader = classLoadingSettings.getFullyQualifiedNamesOfClassesToLoadByMockClassloader();
            classLoader.addClassesToModify(fullyQualifiedNamesOfClassesToLoadByMockClassloader);
            if (this.testClass == null) {
                throw new IllegalStateException("Internal error: testClass should never be null when calling initialize on a mock policy");
            }
            classLoader.addClassesToModify(this.testClass.getName());
            for (Class<?> clazz : classes = this.testClass.getDeclaredClasses()) {
                classLoader.addClassesToModify(clazz.getName());
            }
            Class<?>[] declaredClasses = this.testClass.getClasses();
            for (Class<?> clazz : declaredClasses) {
                classLoader.addClassesToModify(clazz.getName());
            }
            for (String string : classLoadingSettings.getStaticInitializersToSuppress()) {
                classLoader.addClassesToModify(string);
                MockRepository.addSuppressStaticInitializer(string);
            }
            this.invokeInitializeInterceptionSettingsFromClassLoader(classLoader);
        }
    }

    private void invokeInitializeInterceptionSettingsFromClassLoader(MockClassLoader classLoader) {
        try {
            int sizeOfPolicies = this.mockPolicyTypes.length;
            Object mockPolicies = Array.newInstance(Class.class, sizeOfPolicies);
            for (int i = 0; i < sizeOfPolicies; ++i) {
                Class<?> policyLoadedByClassLoader = Class.forName(this.mockPolicyTypes[i].getName(), false, classLoader);
                Array.set(mockPolicies, i, policyLoadedByClassLoader);
            }
            Class<?> thisTypeLoadedByMockClassLoader = Class.forName(this.getClass().getName(), false, classLoader);
            Object mockPolicyHandler = Whitebox.invokeConstructor(thisTypeLoadedByMockClassLoader, (Object[])new Object[]{mockPolicies, true});
            Whitebox.invokeMethod((Object)mockPolicyHandler, (String)"initializeInterceptionSettings", (Object[])new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("PowerMock internal error: Failed to load class.", e);
        }
    }

    private void initializeInterceptionSettings() {
        MockPolicyInterceptionSettings interceptionSettings = this.getInterceptionSettings();
        for (Method method : interceptionSettings.getMethodsToSuppress()) {
            MockRepository.addMethodToSuppress(method);
        }
        for (Map.Entry entry : interceptionSettings.getProxiedMethods().entrySet()) {
            MockRepository.putMethodProxy((Method)entry.getKey(), (InvocationHandler)entry.getValue());
        }
        for (Map.Entry entry : interceptionSettings.getStubbedMethods().entrySet()) {
            Method method = (Method)entry.getKey();
            Object className = entry.getValue();
            MockRepository.putMethodToStub(method, className);
        }
        for (Field field : interceptionSettings.getFieldsToSuppress()) {
            MockRepository.addFieldToSuppress(field);
        }
        for (String type : interceptionSettings.getFieldTypesToSuppress()) {
            MockRepository.addFieldTypeToSuppress(type);
        }
    }

    private MockPolicyInterceptionSettings getInterceptionSettings() {
        MockPolicyInterceptionSettingsImpl settings = new MockPolicyInterceptionSettingsImpl();
        for (PowerMockPolicy mockPolicy : this.mockPolicies) {
            mockPolicy.applyInterceptionPolicy(settings);
        }
        return settings;
    }

    private MockPolicyClassLoadingSettings getClassLoadingSettings() {
        MockPolicyClassLoadingSettingsImpl settings = new MockPolicyClassLoadingSettingsImpl();
        for (PowerMockPolicy mockPolicy : this.mockPolicies) {
            mockPolicy.applyClassLoadingPolicy(settings);
        }
        return settings;
    }

    private static Class<? extends PowerMockPolicy>[] getMockPolicies(Class<?> testClass) {
        Class[] powerMockPolicies = new Class[]{};
        if (testClass.isAnnotationPresent(MockPolicy.class)) {
            MockPolicy annotation = testClass.getAnnotation(MockPolicy.class);
            powerMockPolicies = annotation.value();
        }
        return powerMockPolicies;
    }
}

