// Targeted by JavaCPP version 1.4.1: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class FlyCapture2_C extends org.bytedeco.javacpp.presets.FlyCapture2_C {
    static { Loader.load(); }

// Parsed from <FlyCapture2Defs_C.h>

//=============================================================================
// Copyright  2008 Point Grey Research, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of Point
// Grey Research, Inc. ("Confidential Information").  You shall not
// disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with PGR.
//
// PGR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. PGR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
//=============================================================================
// $Id: FlyCapture2Defs_C.h,v 1.74 2010-12-13 23:58:00 mgara Exp $
//=============================================================================

// #ifndef PGR_FC2_FLYCAPTURE2DEFS_C_H
// #define PGR_FC2_FLYCAPTURE2DEFS_C_H

// #include <stdlib.h>

//=============================================================================
// Definitions header file for FlyCapture2 C API.
//
// Holds enumerations, typedefs and structures that are used across the
// FlyCapture2 C API wrapper.
//
// Please see FlyCapture2Defs.h or the API documentation for full details
// of the various enumerations and structures.
//=============================================================================

// #ifdef __cplusplus
// #endif

	/**
	 * \defgroup CTypeDefs TypeDefs
	 */

	/*@{*/

// #ifndef FALSE
public static final int FALSE =               0;
// #endif

// #ifndef TRUE
public static final int TRUE =                1;
// #endif

// #ifndef FULL_32BIT_VALUE
public static final int FULL_32BIT_VALUE = 0x7FFFFFFF;
// #endif

public static final int MAX_STRING_LENGTH =   512;

	/**
	 * A context to the FlyCapture2 C library. It must be created before
	 * performing any calls to the library.
	 */
	@Namespace @Name("void") @Opaque public static class fc2Context extends Pointer {
	    /** Empty constructor. Calls {@code super((Pointer)null)}. */
	    public fc2Context() { super((Pointer)null); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2Context(Pointer p) { super(p); }
	}

	/**
	 * A context to the FlyCapture2 C GUI library. It must be created before
	 * performing any calls to the library.
	 */
	@Namespace @Name("void") @Opaque public static class fc2GuiContext extends Pointer {
	    /** Empty constructor. Calls {@code super((Pointer)null)}. */
	    public fc2GuiContext() { super((Pointer)null); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2GuiContext(Pointer p) { super(p); }
	}

	/**
	 * An internal pointer used in the fc2Image structure.
	 */
	@Namespace @Name("void") @Opaque public static class fc2ImageImpl extends Pointer {
	    /** Empty constructor. Calls {@code super((Pointer)null)}. */
	    public fc2ImageImpl() { super((Pointer)null); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2ImageImpl(Pointer p) { super(p); }
	}

	/**
	 * A context referring to the AVI recorder object.
	 */
	@Namespace @Name("void") @Opaque public static class fc2AVIContext extends Pointer {
	    /** Empty constructor. Calls {@code super((Pointer)null)}. */
	    public fc2AVIContext() { super((Pointer)null); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2AVIContext(Pointer p) { super(p); }
	}

	/**
	 * A context referring to the ImageStatistics object.
	 */
	@Namespace @Name("void") @Opaque public static class fc2ImageStatisticsContext extends Pointer {
	    /** Empty constructor. Calls {@code super((Pointer)null)}. */
	    public fc2ImageStatisticsContext() { super((Pointer)null); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2ImageStatisticsContext(Pointer p) { super(p); }
	}

	/**
	 * A context referring to the TopologyNode object.
	 */
	@Namespace @Name("void") @Opaque public static class fc2TopologyNodeContext extends Pointer {
	    /** Empty constructor. Calls {@code super((Pointer)null)}. */
	    public fc2TopologyNodeContext() { super((Pointer)null); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2TopologyNodeContext(Pointer p) { super(p); }
	}

	/**
	 * A GUID to the camera.  It is used to uniquely identify a camera.
	 */
	public static class fc2PGRGuid extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2PGRGuid() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2PGRGuid(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2PGRGuid(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2PGRGuid position(long position) {
	        return (fc2PGRGuid)super.position(position);
	    }
	
		public native @Cast("unsigned int") int value(int i); public native fc2PGRGuid value(int i, int value);
		@MemberGetter public native @Cast("unsigned int*") IntPointer value();

	}

	/*@}*/

	/**
	 * \defgroup CEnumerations Enumerations
	 */

	/*@{*/

	/** The error types returned by functions. */
	/** enum _fc2Error */
	public static final int
		/** Undefined */
		FC2_ERROR_UNDEFINED = -1,
		/** Function returned with no errors. */
		FC2_ERROR_OK = 0,
		/** General failure. */
		FC2_ERROR_FAILED = 1,
		/** Function has not been implemented. */
		FC2_ERROR_NOT_IMPLEMENTED = 2,
		/** Could not connect to Bus Master. */
		FC2_ERROR_FAILED_BUS_MASTER_CONNECTION = 3,
		/** Camera has not been connected. */
		FC2_ERROR_NOT_CONNECTED = 4,
		/** Initialization failed. */
		FC2_ERROR_INIT_FAILED = 5,
		/** Camera has not been initialized. */
		FC2_ERROR_NOT_INTITIALIZED = 6,
		/** Invalid parameter passed to function. */
		FC2_ERROR_INVALID_PARAMETER = 7,
		/** Setting set to camera is invalid. */
		FC2_ERROR_INVALID_SETTINGS = 8,
		/** Invalid Bus Manager object. */
		FC2_ERROR_INVALID_BUS_MANAGER = 9,
		/** Could not allocate memory. */
		FC2_ERROR_MEMORY_ALLOCATION_FAILED = 10,
		/** Low level error. */
		FC2_ERROR_LOW_LEVEL_FAILURE = 11,
		/** Device not found. */
		FC2_ERROR_NOT_FOUND = 12,
		/** GUID failure. */
		FC2_ERROR_FAILED_GUID = 13,
		/** Packet size set to camera is invalid. */
		FC2_ERROR_INVALID_PACKET_SIZE = 14,
		/** Invalid mode has been passed to function. */
		FC2_ERROR_INVALID_MODE = 15,
		/** Error due to not being in Format7. */
		FC2_ERROR_NOT_IN_FORMAT7 = 16,
		/** This feature is unsupported. */
		FC2_ERROR_NOT_SUPPORTED = 17,
		/** Timeout error. */
		FC2_ERROR_TIMEOUT = 18,
		/** Bus Master Failure. */
		FC2_ERROR_BUS_MASTER_FAILED = 19,
		/** Generation Count Mismatch. */
		FC2_ERROR_INVALID_GENERATION = 20,
		/** Look Up Table failure. */
		FC2_ERROR_LUT_FAILED = 21,
		/** IIDC failure. */
		FC2_ERROR_IIDC_FAILED = 22,
		/** Strobe failure. */
		FC2_ERROR_STROBE_FAILED = 23,
		/** Trigger failure. */
		FC2_ERROR_TRIGGER_FAILED = 24,
		/** Property failure. */
		FC2_ERROR_PROPERTY_FAILED = 25,
		/** Property is not present. */
		FC2_ERROR_PROPERTY_NOT_PRESENT = 26,
		/** Register access failed. */
		FC2_ERROR_REGISTER_FAILED = 27,
		/** Register read failed. */
		FC2_ERROR_READ_REGISTER_FAILED = 28,
		/** Register write failed. */
		FC2_ERROR_WRITE_REGISTER_FAILED = 29,
		/** Isochronous failure. */
		FC2_ERROR_ISOCH_FAILED = 30,
		/** Isochronous transfer has already been started. */
		FC2_ERROR_ISOCH_ALREADY_STARTED = 31,
		/** Isochronous transfer has not been started. */
		FC2_ERROR_ISOCH_NOT_STARTED = 32,
		/** Isochronous start failed. */
		FC2_ERROR_ISOCH_START_FAILED = 33,
		/** Isochronous retrieve buffer failed. */
		FC2_ERROR_ISOCH_RETRIEVE_BUFFER_FAILED = 34,
		/** Isochronous stop failed. */
		FC2_ERROR_ISOCH_STOP_FAILED = 35,
		/** Isochronous image synchronization failed. */
		FC2_ERROR_ISOCH_SYNC_FAILED = 36,
		/** Isochronous bandwidth exceeded. */
		FC2_ERROR_ISOCH_BANDWIDTH_EXCEEDED = 37,
		/** Image conversion failed. */
		FC2_ERROR_IMAGE_CONVERSION_FAILED = 38,
		/** Image library failure. */
		FC2_ERROR_IMAGE_LIBRARY_FAILURE = 39,
		/** Buffer is too small. */
		FC2_ERROR_BUFFER_TOO_SMALL = 40,
		/** There is an image consistency error. */
		FC2_ERROR_IMAGE_CONSISTENCY_ERROR = 41,
		/** The installed driver is not compatible with the library. */
		FC2_ERROR_INCOMPATIBLE_DRIVER = 42,
		FC2_ERROR_FORCE_32BITS = FULL_32BIT_VALUE;

	/** The type of bus callback to register a callback function for. */
	/** enum _fc2BusCallbackType */
	public static final int
		/** Register for all bus events. */
		FC2_BUS_RESET = 0,
		/** Register for arrivals only. */
		FC2_ARRIVAL = 1,
		/** Register for removals only. */
		FC2_REMOVAL = 2,
		FC2_CALLBACK_TYPE_FORCE_32BITS = FULL_32BIT_VALUE;

	/**
	 * The grab strategy employed during image transfer. This type controls
	 * how images that stream off the camera accumulate in a user buffer
	 * for handling.
	 */
	/*
	   @remark Unlike earlier versions of the FlyCapture SDK, it is no longer
	 * necessary to explicitly start the image grabbing process before
	 * specifying an image grabbing mode.
	 */
	/** enum _fc2GrabMode */
	public static final int
		/**
		 * Grabs the newest image in the user buffer each time the
		 * RetrieveBuffer() function is called. Older images are dropped
		 * instead of accumulating in the user buffer. Grabbing blocks if the
		 * camera has not finished transmitting the next available image. If
		 * the camera is transmitting images faster than the application can
		 * grab them, images may be dropped and only the most recent image
		 * is stored for grabbing. Note that this mode is the equivalent of
		 * flycaptureLockLatest in earlier versions of the FlyCapture SDK.
		 */
		FC2_DROP_FRAMES = 0,

		/**
		 * Images accumulate in the user buffer, and the oldest image is
		 * grabbed for handling before being discarded. This member can be
		 * used to guarantee that each image is seen. However, image processing
		 * time must not exceed transmission time from the camera to the
		 * buffer. Grabbing blocks if the camera has not finished transmitting
		 * the next available image. The buffer size is controlled by the
		 * numBuffers parameter in the FC2Config struct. Note that this mode is
		 * the equivalent of flycaptureLockNext in earlier versions of the
		 * FlyCapture SDK.
		 */
		FC2_BUFFER_FRAMES = 1,

		/**
		 * Unspecified grab mode.
		 */
		FC2_UNSPECIFIED_GRAB_MODE = 2,
		FC2_GRAB_MODE_FORCE_32BITS = FULL_32BIT_VALUE;

	/** Timeout options for grabbing images. */
	/** enum _fc2GrabTimeout */
	public static final int
		/** Non-blocking wait. */
		FC2_TIMEOUT_NONE = 0,
		/** Wait indefinitely. */
		FC2_TIMEOUT_INFINITE = -1,
		/** Unspecified timeout setting. */
		FC2_TIMEOUT_UNSPECIFIED = -2,
		FC2_GRAB_TIMEOUT_FORCE_32BITS = FULL_32BIT_VALUE;

	/** Bandwidth allocation options for 1394 devices. */
	/** enum _fc2BandwidthAllocation */
	public static final int
		/** Do not allocate bandwidth. */
		FC2_BANDWIDTH_ALLOCATION_OFF = 0,
		/** Allocate bandwidth. This is the default setting. */
		FC2_BANDWIDTH_ALLOCATION_ON = 1,
		/**
		 * Bandwidth allocation is not supported by either the camera or
		 * operating system.
		 */
		FC2_BANDWIDTH_ALLOCATION_UNSUPPORTED = 2,
		/** Not specified. This leaves the current setting unchanged. */
		FC2_BANDWIDTH_ALLOCATION_UNSPECIFIED = 3,
		FC2_BANDWIDTH_ALLOCATION_FORCE_32BITS = FULL_32BIT_VALUE;

	/** Interfaces that a camera may use to communicate with a host. */
	/** enum _fc2InterfaceType */
	public static final int
		/** IEEE-1394 (Includes 1394a and 1394b). */
		FC2_INTERFACE_IEEE1394 = 0,
		/** USB 2.0. */
		FC2_INTERFACE_USB_2 = 1,
		/** USB 3.0. */
		FC2_INTERFACE_USB_3 = 2,
		/** GigE. */
		FC2_INTERFACE_GIGE = 3,
		/** Unknown interface. */
		FC2_INTERFACE_UNKNOWN = 4,
		FC2_INTERFACE_TYPE_FORCE_32BITS = FULL_32BIT_VALUE;

	/**
	 * Camera properties. Not all properties may be supported, depending
	 * on the camera model.
	 */
	/** enum _fc2PropertyType */
	public static final int
		FC2_BRIGHTNESS = 0,
		FC2_AUTO_EXPOSURE = 1,
		FC2_SHARPNESS = 2,
		FC2_WHITE_BALANCE = 3,
		FC2_HUE = 4,
		FC2_SATURATION = 5,
		FC2_GAMMA = 6,
		FC2_IRIS = 7,
		FC2_FOCUS = 8,
		FC2_ZOOM = 9,
		FC2_PAN = 10,
		FC2_TILT = 11,
		FC2_SHUTTER = 12,
		FC2_GAIN = 13,
		FC2_TRIGGER_MODE = 14,
		FC2_TRIGGER_DELAY = 15,
		FC2_FRAME_RATE = 16,
		FC2_TEMPERATURE = 17,
		FC2_UNSPECIFIED_PROPERTY_TYPE = 18,
		FC2_PROPERTY_TYPE_FORCE_32BITS = FULL_32BIT_VALUE;

	/** Frame rates in frames per second. */
	/** enum _fc2FrameRate */
	public static final int
		/** 1.875 fps. */
		FC2_FRAMERATE_1_875 = 0,
		/** 3.75 fps. */
		FC2_FRAMERATE_3_75 = 1,
		/** 7.5 fps. */
		FC2_FRAMERATE_7_5 = 2,
		/** 15 fps. */
		FC2_FRAMERATE_15 = 3,
		/** 30 fps. */
		FC2_FRAMERATE_30 = 4,
		/** 60 fps. */
		FC2_FRAMERATE_60 = 5,
		/** 120 fps. */
		FC2_FRAMERATE_120 = 6,
		/** 240 fps. */
		FC2_FRAMERATE_240 = 7,
		/** Custom frame rate for Format7 functionality. */
		FC2_FRAMERATE_FORMAT7 = 8,
		/** Number of possible camera frame rates. */
		FC2_NUM_FRAMERATES = 9,
		FC2_FRAMERATE_FORCE_32BITS = FULL_32BIT_VALUE;

	/** DCAM video modes. */
	/** enum _fc2VideoMode */
	public static final int
		/** 160x120 YUV444. */
		FC2_VIDEOMODE_160x120YUV444 = 0,
		/** 320x240 YUV422. */
		FC2_VIDEOMODE_320x240YUV422 = 1,
		/** 640x480 YUV411. */
		FC2_VIDEOMODE_640x480YUV411 = 2,
		/** 640x480 YUV422. */
		FC2_VIDEOMODE_640x480YUV422 = 3,
		/** 640x480 24-bit RGB. */
		FC2_VIDEOMODE_640x480RGB = 4,
		/** 640x480 8-bit. */
		FC2_VIDEOMODE_640x480Y8 = 5,
		/** 640x480 16-bit. */
		FC2_VIDEOMODE_640x480Y16 = 6,
		/** 800x600 YUV422. */
		FC2_VIDEOMODE_800x600YUV422 = 7,
		/** 800x600 RGB. */
		FC2_VIDEOMODE_800x600RGB = 8,
		/** 800x600 8-bit. */
		FC2_VIDEOMODE_800x600Y8 = 9,
		/** 800x600 16-bit. */
		FC2_VIDEOMODE_800x600Y16 = 10,
		/** 1024x768 YUV422. */
		FC2_VIDEOMODE_1024x768YUV422 = 11,
		/** 1024x768 RGB. */
		FC2_VIDEOMODE_1024x768RGB = 12,
		/** 1024x768 8-bit. */
		FC2_VIDEOMODE_1024x768Y8 = 13,
		/** 1024x768 16-bit. */
		FC2_VIDEOMODE_1024x768Y16 = 14,
		/** 1280x960 YUV422. */
		FC2_VIDEOMODE_1280x960YUV422 = 15,
		/** 1280x960 RGB. */
		FC2_VIDEOMODE_1280x960RGB = 16,
		/** 1280x960 8-bit. */
		FC2_VIDEOMODE_1280x960Y8 = 17,
		/** 1280x960 16-bit. */
		FC2_VIDEOMODE_1280x960Y16 = 18,
		/** 1600x1200 YUV422. */
		FC2_VIDEOMODE_1600x1200YUV422 = 19,
		/** 1600x1200 RGB. */
		FC2_VIDEOMODE_1600x1200RGB = 20,
		/** 1600x1200 8-bit. */
		FC2_VIDEOMODE_1600x1200Y8 = 21,
		/** 1600x1200 16-bit. */
		FC2_VIDEOMODE_1600x1200Y16 = 22,
		/** Custom video mode for Format7 functionality. */
		FC2_VIDEOMODE_FORMAT7 = 23,
		/** Number of possible video modes. */
		FC2_NUM_VIDEOMODES = 24,
		FC2_VIDEOMODE_FORCE_32BITS = FULL_32BIT_VALUE;

	/** Camera modes for DCAM formats as well as Format7. */
	/** enum _fc2Mode */
	public static final int
		FC2_MODE_0 = 0,
		FC2_MODE_1 = 1,
		FC2_MODE_2 = 2,
		FC2_MODE_3 = 3,
		FC2_MODE_4 = 4,
		FC2_MODE_5 = 5,
		FC2_MODE_6 = 6,
		FC2_MODE_7 = 7,
		FC2_MODE_8 = 8,
		FC2_MODE_9 = 9,
		FC2_MODE_10 = 10,
		FC2_MODE_11 = 11,
		FC2_MODE_12 = 12,
		FC2_MODE_13 = 13,
		FC2_MODE_14 = 14,
		FC2_MODE_15 = 15,
		FC2_MODE_16 = 16,
		FC2_MODE_17 = 17,
		FC2_MODE_18 = 18,
		FC2_MODE_19 = 19,
		FC2_MODE_20 = 20,
		FC2_MODE_21 = 21,
		FC2_MODE_22 = 22,
		FC2_MODE_23 = 23,
		FC2_MODE_24 = 24,
		FC2_MODE_25 = 25,
		FC2_MODE_26 = 26,
		FC2_MODE_27 = 27,
		FC2_MODE_28 = 28,
		FC2_MODE_29 = 29,
		FC2_MODE_30 = 30,
		FC2_MODE_31 = 31,
		/** Number of modes */
		FC2_NUM_MODES = 32,
		FC2_MODE_FORCE_32BITS = FULL_32BIT_VALUE;

	/** Pixel formats available for Format7 modes. */
	/** enum _fc2PixelFormat */
	public static final int
		/** 8 bits of mono information. */
		FC2_PIXEL_FORMAT_MONO8			 = 0x80000000,
		/** YUV 4:1:1. */
		FC2_PIXEL_FORMAT_411YUV8		 = 0x40000000,
		/** YUV 4:2:2. */
		FC2_PIXEL_FORMAT_422YUV8		 = 0x20000000,
		/** YUV 4:4:4. */
		FC2_PIXEL_FORMAT_444YUV8		 = 0x10000000,
		/** R = G = B = 8 bits. */
		FC2_PIXEL_FORMAT_RGB8			 = 0x08000000,
		/** 16 bits of mono information. */
		FC2_PIXEL_FORMAT_MONO16			 = 0x04000000,
		/** R = G = B = 16 bits. */
		FC2_PIXEL_FORMAT_RGB16			 = 0x02000000,
		/** 16 bits of signed mono information. */
		FC2_PIXEL_FORMAT_S_MONO16		 = 0x01000000,
		/** R = G = B = 16 bits signed. */
		FC2_PIXEL_FORMAT_S_RGB16		 = 0x00800000,
		/** 8 bit raw data output of sensor. */
		FC2_PIXEL_FORMAT_RAW8			 = 0x00400000,
		/** 16 bit raw data output of sensor. */
		FC2_PIXEL_FORMAT_RAW16			 = 0x00200000,
		/** 12 bits of mono information. */
		FC2_PIXEL_FORMAT_MONO12			 = 0x00100000,
		/** 12 bit raw data output of sensor. */
		FC2_PIXEL_FORMAT_RAW12			 = 0x00080000,
		/** 24 bit BGR. */
		FC2_PIXEL_FORMAT_BGR			 = 0x80000008,
		/** 32 bit BGRU. */
		FC2_PIXEL_FORMAT_BGRU			 = 0x40000008,
		/** 24 bit RGB. */
		FC2_PIXEL_FORMAT_RGB			 = FC2_PIXEL_FORMAT_RGB8,
		/** 32 bit RGBU. */
		FC2_PIXEL_FORMAT_RGBU			 = 0x40000002,
		/** R = G = B = 16 bits. */
		FC2_PIXEL_FORMAT_BGR16			 = 0x02000001,
		/** 64 bit BGRU. */
		FC2_PIXEL_FORMAT_BGRU16			 = 0x02000002,
		/** JPEG compressed stream. */
		FC2_PIXEL_FORMAT_422YUV8_JPEG	 = 0x40000001,
		/** Number of pixel formats. */
		FC2_NUM_PIXEL_FORMATS			 = 20,
		/** Unspecified pixel format. */
		FC2_UNSPECIFIED_PIXEL_FORMAT	 = 0;

	/** Bus speeds. */
	/** enum _fc2BusSpeed */
	public static final int
		/** 100Mbits/sec. */
		FC2_BUSSPEED_S100 = 0,
		/** 200Mbits/sec. */
		FC2_BUSSPEED_S200 = 1,
		/** 400Mbits/sec. */
		FC2_BUSSPEED_S400 = 2,
		/** 480Mbits/sec. Only for USB2 cameras. */
		FC2_BUSSPEED_S480 = 3,
		/** 800Mbits/sec. */
		FC2_BUSSPEED_S800 = 4,
		/** 1600Mbits/sec. */
		FC2_BUSSPEED_S1600 = 5,
		/** 3200Mbits/sec. */
		FC2_BUSSPEED_S3200 = 6,
		/** 5000Mbits/sec. Only for USB3 cameras. */
		FC2_BUSSPEED_S5000 = 7,
		/** 10Base-T. Only for GigE cameras. */
		FC2_BUSSPEED_10BASE_T = 8,
		/** 100Base-T.  Only for GigE cameras.*/
		FC2_BUSSPEED_100BASE_T = 9,
		/** 1000Base-T (Gigabit Ethernet).  Only for GigE cameras. */
		FC2_BUSSPEED_1000BASE_T = 10,
		/** 10000Base-T.  Only for GigE cameras. */
		FC2_BUSSPEED_10000BASE_T = 11,
		/** The fastest speed available. */
		FC2_BUSSPEED_S_FASTEST = 12,
		/** Any speed that is available. */
		FC2_BUSSPEED_ANY = 13,
		/** Unknown bus speed. */
		FC2_BUSSPEED_SPEED_UNKNOWN = -1,
		FC2_BUSSPEED_FORCE_32BITS = FULL_32BIT_VALUE;

	/** enum _fc2PCIeBusSpeed */
	public static final int
		FC2_PCIE_BUSSPEED_2_5 = 0, /** 2.5 Gb/s */
		FC2_PCIE_BUSSPEED_5_0 = 1, /** 5.0 Gb/s */
		FC2_PCIE_BUSSPEED_UNKNOWN = -1, /** Speed is unknown */
		FC2_PCIE_BUSSPEED_FORCE_32BITS = FULL_32BIT_VALUE;

	/** Types of low level drivers that FlyCapture uses. */
	/** enum _fc2DriverType */
	public static final int
		/** PGRCam.sys. */
		FC2_DRIVER_1394_CAM = 0,
		/** PGR1394.sys. */
		FC2_DRIVER_1394_PRO = 1,
		/** firewire_core. */
		FC2_DRIVER_1394_JUJU = 2,
		/** video1394. */
		FC2_DRIVER_1394_VIDEO1394 = 3,
		/** raw1394. */
		FC2_DRIVER_1394_RAW1394 = 4,
		/** No usb driver used just BSD stack. (Linux only) */
		FC2_DRIVER_USB_NONE = 5,
		/** PGRUsbCam.sys. */
		FC2_DRIVER_USB_CAM = 6,
		/** PGRXHCI.sys. */
		FC2_DRIVER_USB3_PRO = 7,
		/** no GigE drivers used, MS/BSD stack. */
		FC2_DRIVER_GIGE_NONE = 8,
		/** PGRGigE.sys. */
		FC2_DRIVER_GIGE_FILTER = 9,
		/** PGRGigEPro.sys. */
		FC2_DRIVER_GIGE_PRO = 10,
		/** PgrLwf.sys. */
		FC2_DRIVER_GIGE_LWF = 11,
		/** Unknown driver type. */
		FC2_DRIVER_UNKNOWN = -1,
		FC2_DRIVER_FORCE_32BITS = FULL_32BIT_VALUE;

	/**
	 * Color processing algorithms. Please refer to our knowledge base at
	 * article at http://www.ptgrey.com/support/kb/index.asp?a=4&q=33 for
	 * complete details for each algorithm.
	 */
	/** enum _fc2ColorProcessingAlgorithm */
	public static final int
		/** Default method. */
		FC2_DEFAULT = 0,
		/** No color processing. */
		FC2_NO_COLOR_PROCESSING = 1,
		/**
		 * Fastest but lowest quality. Equivalent to
		 * FLYCAPTURE_NEAREST_NEIGHBOR_FAST in FlyCapture.
		 */
		FC2_NEAREST_NEIGHBOR_FAST = 2,
		/** Weights surrounding pixels based on localized edge orientation. */
		FC2_EDGE_SENSING = 3,
		/** Well-balanced speed and quality. */
		FC2_HQ_LINEAR = 4,
		/** Slowest but produces good results. */
		FC2_RIGOROUS = 5,
		/** Multithreaded with similar results to edge sensing. */
		FC2_IPP = 6,
		/** Best quality but much faster than rigorous. */
		FC2_DIRECTIONAL = 7,
		FC2_COLOR_PROCESSING_ALGORITHM_FORCE_32BITS = FULL_32BIT_VALUE;

	/** Bayer tile formats. */
	/** enum _fc2BayerTileFormat */
	public static final int
		/** No bayer tile format. */
		FC2_BT_NONE = 0,
		/** Red-Green-Green-Blue. */
		FC2_BT_RGGB = 1,
		/** Green-Red-Blue-Green. */
		FC2_BT_GRBG = 2,
		/** Green-Blue-Red-Green. */
		FC2_BT_GBRG = 3,
		/** Blue-Green-Green-Red. */
		FC2_BT_BGGR = 4,
		FC2_BT_FORCE_32BITS = FULL_32BIT_VALUE;

	/** File formats to be used for saving images to disk. */
	/** enum _fc2ImageFileFormat */
	public static final int
		/** Determine file format from file extension. */
		FC2_FROM_FILE_EXT = -1,
		/** Portable gray map. */
		FC2_PGM = 0,
		/** Portable pixmap. */
		FC2_PPM = 1,
		/** Bitmap. */
		FC2_BMP = 2,
		/** JPEG. */
		FC2_JPEG = 3,
		/** JPEG 2000. */
		FC2_JPEG2000 = 4,
		/** Tagged image file format. */
		FC2_TIFF = 5,
		/** Portable network graphics. */
		FC2_PNG = 6,
		/** Raw data. */
		FC2_RAW = 7,
		FC2_IMAGE_FILE_FORMAT_FORCE_32BITS = FULL_32BIT_VALUE;

	/*@}*/

	/**
	 * \defgroup CGigEEnums GigE specific enumerations
	 *
	 * These enumerations are specific to GigE camera operation only.
	 */

	/*@{*/

	/** Possible properties that can be queried from the camera. */
	/** enum _fc2GigEPropertyType */
	public static final int
		FC2_HEARTBEAT = 0,
		FC2_HEARTBEAT_TIMEOUT = 1,
		PACKET_SIZE = 2,
		PACKET_DELAY = 3;

	/*@}*/

	/**
	 * Channels that allow statistics to be calculated.
	 */
	/** enum _fc2StatisticsChannel */
	public static final int
		FC2_STATISTICS_GREY = 0,
		FC2_STATISTICS_RED = 1,
		FC2_STATISTICS_GREEN = 2,
		FC2_STATISTICS_BLUE = 3,
		FC2_STATISTICS_HUE = 4,
		FC2_STATISTICS_SATURATION = 5,
		FC2_STATISTICS_LIGHTNESS = 6,
		FC2_STATISTICS_FORCE_32BITS = FULL_32BIT_VALUE;

	/** Possible operating systems. */
	/** enum _fc2OSType */
	public static final int
		/** All Windows 32-bit variants. */
		FC2_WINDOWS_X86 = 0,
		/** All Windows 64-bit variants. */
		FC2_WINDOWS_X64 = 1,
		/** All Linux 32-bit variants. */
		FC2_LINUX_X86 = 2,
		/** All Linux 32-bit variants. */
		FC2_LINUX_X64 = 3,
		/** Mac OSX. */
		FC2_MAC = 4,
		/** Unknown operating system. */
		FC2_UNKNOWN_OS = 5,
		FC2_OSTYPE_FORCE_32BITS = FULL_32BIT_VALUE;

	/** Possible byte orders. */
	/** enum _fc2ByteOrder */
	public static final int
		FC2_BYTE_ORDER_LITTLE_ENDIAN = 0,
		FC2_BYTE_ORDER_BIG_ENDIAN = 1,
		FC2_BYTE_ORDER_FORCE_32BITS = FULL_32BIT_VALUE;

	/**
	 * Possible states of a port on a node.
	 */
	/** enum _fc2PortType */
	public static final int
		NOT_CONNECTED = 1,
		CONNECTED_TO_PARENT = 2,
		CONNECTED_TO_CHILD = 3;

	/**
	 * Type of node.
	 */
	/** enum _fc2NodeType */
	public static final int
		COMPUTER = 0,
		BUS = 1,
		CAMERA = 2,
		NODE = 3;

	/**
	 * \defgroup CStructures Structures
	 */

	/*@{*/

	//
	// Description:
	//	 An image. It is comparable to the Image class in the C++ library.
	//   The fields in this structure should be considered read only.
	//
	public static class fc2Image extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2Image() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2Image(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2Image(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2Image position(long position) {
	        return (fc2Image)super.position(position);
	    }
	
		public native @Cast("unsigned int") int rows(); public native fc2Image rows(int rows);
		public native @Cast("unsigned int") int cols(); public native fc2Image cols(int cols);
		public native @Cast("unsigned int") int stride(); public native fc2Image stride(int stride);
		public native @Cast("unsigned char*") BytePointer pData(); public native fc2Image pData(BytePointer pData);
		public native @Cast("unsigned int") int dataSize(); public native fc2Image dataSize(int dataSize);
		public native @Cast("unsigned int") int receivedDataSize(); public native fc2Image receivedDataSize(int receivedDataSize);
		public native @Cast("fc2PixelFormat") int format(); public native fc2Image format(int format);
		public native @Cast("fc2BayerTileFormat") int bayerFormat(); public native fc2Image bayerFormat(int bayerFormat);

		public native fc2ImageImpl imageImpl(); public native fc2Image imageImpl(fc2ImageImpl imageImpl);

	}

	/** Description of the system. */
	public static class fc2SystemInfo extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2SystemInfo() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2SystemInfo(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2SystemInfo(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2SystemInfo position(long position) {
	        return (fc2SystemInfo)super.position(position);
	    }
	
		/** Operating system type as described by OSType. */
		public native @Cast("fc2OSType") int osType(); public native fc2SystemInfo osType(int osType);

		/** Detailed description of the operating system. */
		public native @Cast("char") byte osDescription(int i); public native fc2SystemInfo osDescription(int i, byte osDescription);
		@MemberGetter public native @Cast("char*") BytePointer osDescription();

		/** Byte order of the system. */
		public native @Cast("fc2ByteOrder") int byteOrder(); public native fc2SystemInfo byteOrder(int byteOrder);

		/** Amount of memory available on the system. */
		public native @Cast("size_t") long sysMemSize(); public native fc2SystemInfo sysMemSize(long sysMemSize);

		/** Detailed description of the CPU. */
		public native @Cast("char") byte cpuDescription(int i); public native fc2SystemInfo cpuDescription(int i, byte cpuDescription);
		@MemberGetter public native @Cast("char*") BytePointer cpuDescription();

		/** Number of cores on all CPUs on the system. */
		public native @Cast("size_t") long numCpuCores(); public native fc2SystemInfo numCpuCores(long numCpuCores);

		/** List of drivers used. */
		public native @Cast("char") byte driverList(int i); public native fc2SystemInfo driverList(int i, byte driverList);
		@MemberGetter public native @Cast("char*") BytePointer driverList();

		/** List of libraries used. */
		public native @Cast("char") byte libraryList(int i); public native fc2SystemInfo libraryList(int i, byte libraryList);
		@MemberGetter public native @Cast("char*") BytePointer libraryList();

		/** Detailed description of the GPU. */
		public native @Cast("char") byte gpuDescription(int i); public native fc2SystemInfo gpuDescription(int i, byte gpuDescription);
		@MemberGetter public native @Cast("char*") BytePointer gpuDescription();

		/** Screen resolution width in pixels. */
		public native @Cast("size_t") long screenWidth(); public native fc2SystemInfo screenWidth(long screenWidth);

		/** Screen resolution height in pixels. */
		public native @Cast("size_t") long screenHeight(); public native fc2SystemInfo screenHeight(long screenHeight);

		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2SystemInfo reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** The current version of the library. */
	public static class fc2Version extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2Version() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2Version(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2Version(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2Version position(long position) {
	        return (fc2Version)super.position(position);
	    }
	
		/** Major version number. */
		public native @Cast("unsigned int") int major(); public native fc2Version major(int major);
		/** Minor version number. */
		public native @Cast("unsigned int") int minor(); public native fc2Version minor(int minor);
		/** Type version number. */
		public native @Cast("unsigned int") int type(); public native fc2Version type(int type);
		/** Build version number. */
		public native @Cast("unsigned int") int build(); public native fc2Version build(int build);
	}

	/**
	 * \defgroup CGigEStructures GigE specific structures
	 *
	 * These structures are specific to GigE camera operation only.
	 */

	/*@{*/

	/** IPv4 address. */
	public static class fc2IPAddress extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2IPAddress() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2IPAddress(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2IPAddress(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2IPAddress position(long position) {
	        return (fc2IPAddress)super.position(position);
	    }
	
		public native @Cast("unsigned char") byte octets(int i); public native fc2IPAddress octets(int i, byte octets);
		@MemberGetter public native @Cast("unsigned char*") BytePointer octets();
	}

	/** MAC address. */
	public static class fc2MACAddress extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2MACAddress() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2MACAddress(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2MACAddress(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2MACAddress position(long position) {
	        return (fc2MACAddress)super.position(position);
	    }
	
		public native @Cast("unsigned char") byte octets(int i); public native fc2MACAddress octets(int i, byte octets);
		@MemberGetter public native @Cast("unsigned char*") BytePointer octets();
	}

	/** A GigE property. */
	public static class fc2GigEProperty extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2GigEProperty() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2GigEProperty(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2GigEProperty(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2GigEProperty position(long position) {
	        return (fc2GigEProperty)super.position(position);
	    }
	
		/** The type of property. */
		public native @Cast("fc2GigEPropertyType") int propType(); public native fc2GigEProperty propType(int propType);
		/**
		 * Whether the property is readable. If this is false, then
		 * no other value in this structure is valid.
		 */
		public native @Cast("BOOL") int isReadable(); public native fc2GigEProperty isReadable(int isReadable);
		/** Whether the property is writable. */
		public native @Cast("BOOL") int isWritable(); public native fc2GigEProperty isWritable(int isWritable);
		/** Minimum value. */
		public native @Cast("unsigned int") int min(); public native fc2GigEProperty min(int min);
		/** Maximum value. */
		public native @Cast("unsigned int") int max(); public native fc2GigEProperty max(int max);
		/** Current value. */
		public native @Cast("unsigned int") int value(); public native fc2GigEProperty value(int value);

		public native @Cast("unsigned int") int reserved(int i); public native fc2GigEProperty reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
	}

	/** Information about a single GigE stream channel. */
	public static class fc2GigEStreamChannel extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2GigEStreamChannel() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2GigEStreamChannel(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2GigEStreamChannel(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2GigEStreamChannel position(long position) {
	        return (fc2GigEStreamChannel)super.position(position);
	    }
	
		/** Network interface index used (or to use). */
		public native @Cast("unsigned int") int networkInterfaceIndex(); public native fc2GigEStreamChannel networkInterfaceIndex(int networkInterfaceIndex);
		/** Host port on the PC where the camera will send the data stream. */
		public native @Cast("unsigned int") int hostPort(); public native fc2GigEStreamChannel hostPort(int hostPort);
		/** Disable IP fragmentation of packets. */
		public native @Cast("BOOL") int doNotFragment(); public native fc2GigEStreamChannel doNotFragment(int doNotFragment);
		/** Packet size, in bytes. */
		public native @Cast("unsigned int") int packetSize(); public native fc2GigEStreamChannel packetSize(int packetSize);
		/** Inter packet delay, in timestamp counter units. */
		public native @Cast("unsigned int") int interPacketDelay(); public native fc2GigEStreamChannel interPacketDelay(int interPacketDelay);
		/** Destination IP address. It can be a multicast or unicast address. */
		public native @ByRef fc2IPAddress destinationIpAddress(); public native fc2GigEStreamChannel destinationIpAddress(fc2IPAddress destinationIpAddress);
		/** Source UDP port of the stream channel. Read only. */
		public native @Cast("unsigned int") int sourcePort(); public native fc2GigEStreamChannel sourcePort(int sourcePort);

		public native @Cast("unsigned int") int reserved(int i); public native fc2GigEStreamChannel reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
	}

	/**
	 * Configuration for a GigE camera.  These options are options that are
	 * generally should be set before starting isochronous transfer.
	 */
	public static class fc2GigEConfig extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2GigEConfig() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2GigEConfig(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2GigEConfig(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2GigEConfig position(long position) {
	        return (fc2GigEConfig)super.position(position);
	    }
	
		/** Turn on/off packet resend functionality */
		public native @Cast("BOOL") int enablePacketResend(); public native fc2GigEConfig enablePacketResend(int enablePacketResend);

		/**
		 * Number of retries to perform when a register read/write timeout
		 * is received by the library. The default value is 0.
		 */
		public native @Cast("unsigned int") int registerTimeoutRetries(); public native fc2GigEConfig registerTimeoutRetries(int registerTimeoutRetries);

		/**
		 * Register read/write timeout value, in microseconds.
		 * The default value is dependent on the interface type.
		 */
		public native @Cast("unsigned int") int registerTimeout(); public native fc2GigEConfig registerTimeout(int registerTimeout);

		public native @Cast("unsigned int") int reserved(int i); public native fc2GigEConfig reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
	}

	/** Format 7 information for a single mode. */
	public static class fc2GigEImageSettingsInfo extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2GigEImageSettingsInfo() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2GigEImageSettingsInfo(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2GigEImageSettingsInfo(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2GigEImageSettingsInfo position(long position) {
	        return (fc2GigEImageSettingsInfo)super.position(position);
	    }
	
		/** Maximum image width. */
		public native @Cast("unsigned int") int maxWidth(); public native fc2GigEImageSettingsInfo maxWidth(int maxWidth);
		/** Maximum image height. */
		public native @Cast("unsigned int") int maxHeight(); public native fc2GigEImageSettingsInfo maxHeight(int maxHeight);
		/** Horizontal step size for the offset. */
		public native @Cast("unsigned int") int offsetHStepSize(); public native fc2GigEImageSettingsInfo offsetHStepSize(int offsetHStepSize);
		/** Vertical step size for the offset. */
		public native @Cast("unsigned int") int offsetVStepSize(); public native fc2GigEImageSettingsInfo offsetVStepSize(int offsetVStepSize);
		/** Horizontal step size for the image. */
		public native @Cast("unsigned int") int imageHStepSize(); public native fc2GigEImageSettingsInfo imageHStepSize(int imageHStepSize);
		/** Vertical step size for the image. */
		public native @Cast("unsigned int") int imageVStepSize(); public native fc2GigEImageSettingsInfo imageVStepSize(int imageVStepSize);
		/** Supported pixel formats in a bit field. */
		public native @Cast("unsigned int") int pixelFormatBitField(); public native fc2GigEImageSettingsInfo pixelFormatBitField(int pixelFormatBitField);
		/** Vendor unique pixel formats in a bit field. */
		public native @Cast("unsigned int") int vendorPixelFormatBitField(); public native fc2GigEImageSettingsInfo vendorPixelFormatBitField(int vendorPixelFormatBitField);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2GigEImageSettingsInfo reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
	}

	/** Image settings for a GigE camera. */
	public static class fc2GigEImageSettings extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2GigEImageSettings() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2GigEImageSettings(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2GigEImageSettings(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2GigEImageSettings position(long position) {
	        return (fc2GigEImageSettings)super.position(position);
	    }
	
		/** Horizontal image offset. */
		public native @Cast("unsigned int") int offsetX(); public native fc2GigEImageSettings offsetX(int offsetX);
		/** Vertical image offset. */
		public native @Cast("unsigned int") int offsetY(); public native fc2GigEImageSettings offsetY(int offsetY);
		/** Width of image. */
		public native @Cast("unsigned int") int width(); public native fc2GigEImageSettings width(int width);
		/** Height of image. */
		public native @Cast("unsigned int") int height(); public native fc2GigEImageSettings height(int height);
		/** Pixel format of image. */
		public native @Cast("fc2PixelFormat") int pixelFormat(); public native fc2GigEImageSettings pixelFormat(int pixelFormat);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2GigEImageSettings reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
	}

	/*@}*/

	/**
	 * \defgroup CIIDCStructures IIDC specific structures
	 *
	 * These structures are specific to IIDC camera operation only.
	 */

	/*@{*/

	/** Format 7 image settings. */
	public static class fc2Format7ImageSettings extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2Format7ImageSettings() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2Format7ImageSettings(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2Format7ImageSettings(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2Format7ImageSettings position(long position) {
	        return (fc2Format7ImageSettings)super.position(position);
	    }
	
		/** Format 7 mode. */
		public native @Cast("fc2Mode") int mode(); public native fc2Format7ImageSettings mode(int mode);
		/** Horizontal image offset. */
		public native @Cast("unsigned int") int offsetX(); public native fc2Format7ImageSettings offsetX(int offsetX);
		/** Vertical image offset. */
		public native @Cast("unsigned int") int offsetY(); public native fc2Format7ImageSettings offsetY(int offsetY);
		/** Width of image. */
		public native @Cast("unsigned int") int width(); public native fc2Format7ImageSettings width(int width);
		/** Height of image. */
		public native @Cast("unsigned int") int height(); public native fc2Format7ImageSettings height(int height);
		/** Pixel format of image. */
		public native @Cast("fc2PixelFormat") int pixelFormat(); public native fc2Format7ImageSettings pixelFormat(int pixelFormat);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2Format7ImageSettings reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Format 7 information for a single mode. */
	public static class fc2Format7Info extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2Format7Info() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2Format7Info(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2Format7Info(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2Format7Info position(long position) {
	        return (fc2Format7Info)super.position(position);
	    }
	
		/** Format 7 mode. */
		public native @Cast("fc2Mode") int mode(); public native fc2Format7Info mode(int mode);

		/** Maximum image width. */
		public native @Cast("unsigned int") int maxWidth(); public native fc2Format7Info maxWidth(int maxWidth);
		/** Maximum image height. */
		public native @Cast("unsigned int") int maxHeight(); public native fc2Format7Info maxHeight(int maxHeight);
		/** Horizontal step size for the offset. */
		public native @Cast("unsigned int") int offsetHStepSize(); public native fc2Format7Info offsetHStepSize(int offsetHStepSize);
		/** Vertical step size for the offset. */
		public native @Cast("unsigned int") int offsetVStepSize(); public native fc2Format7Info offsetVStepSize(int offsetVStepSize);
		/** Horizontal step size for the image. */
		public native @Cast("unsigned int") int imageHStepSize(); public native fc2Format7Info imageHStepSize(int imageHStepSize);
		/** Vertical step size for the image. */
		public native @Cast("unsigned int") int imageVStepSize(); public native fc2Format7Info imageVStepSize(int imageVStepSize);
		/** Supported pixel formats in a bit field. */
		public native @Cast("unsigned int") int pixelFormatBitField(); public native fc2Format7Info pixelFormatBitField(int pixelFormatBitField);
		/** Vendor unique pixel formats in a bit field. */
		public native @Cast("unsigned int") int vendorPixelFormatBitField(); public native fc2Format7Info vendorPixelFormatBitField(int vendorPixelFormatBitField);
		/** Current packet size in bytes. */
		public native @Cast("unsigned int") int packetSize(); public native fc2Format7Info packetSize(int packetSize);
		/** Minimum packet size in bytes for current mode. */
		public native @Cast("unsigned int") int minPacketSize(); public native fc2Format7Info minPacketSize(int minPacketSize);
		/** Maximum packet size in bytes for current mode. */
		public native @Cast("unsigned int") int maxPacketSize(); public native fc2Format7Info maxPacketSize(int maxPacketSize);
		/** Current packet size as a percentage of maximum packet size. */
		public native float percentage(); public native fc2Format7Info percentage(float percentage);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2Format7Info reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Format 7 packet information. */
	public static class fc2Format7PacketInfo extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2Format7PacketInfo() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2Format7PacketInfo(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2Format7PacketInfo(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2Format7PacketInfo position(long position) {
	        return (fc2Format7PacketInfo)super.position(position);
	    }
	
		/** Recommended bytes per packet. */
		public native @Cast("unsigned int") int recommendedBytesPerPacket(); public native fc2Format7PacketInfo recommendedBytesPerPacket(int recommendedBytesPerPacket);
		/** Maximum bytes per packet. */
		public native @Cast("unsigned int") int maxBytesPerPacket(); public native fc2Format7PacketInfo maxBytesPerPacket(int maxBytesPerPacket);
		/** Minimum bytes per packet. */
		public native @Cast("unsigned int") int unitBytesPerPacket(); public native fc2Format7PacketInfo unitBytesPerPacket(int unitBytesPerPacket);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2Format7PacketInfo reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/*@}*/

	/**
	 * Configuration for a camera. These options are options that are
	 * generally should be set before starting isochronous transfer.
	 */
	public static class fc2Config extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2Config() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2Config(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2Config(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2Config position(long position) {
	        return (fc2Config)super.position(position);
	    }
	
		/** Number of buffers used by the FlyCapture2 library to grab images. */
		public native @Cast("unsigned int") int numBuffers(); public native fc2Config numBuffers(int numBuffers);

		/**
		 * Number of notifications per image. This value should only be set
		 * after the image settings to be used is set to the camera.
		 * The default number of notifications is 1.
		 *
		 * There are 4 general scenarios:
		 * - 1 notification - End of image
		 * - 2 notifications - After first packet and end of image
		 * - 3 notifications - After first packet, middle of image, end of image
		 * - x notifications - After first packet, (x -2) spread evenly, end of image
		 *
		 * Specifying zero for the number of notifications will be ignored (the current value
		 * will not be modified).
		 *
		 * Note that the event numbers start at 0. Ex. when 3 notifications are
		 * used, the three events will be 0, 1 and 2.
		 */
		public native @Cast("unsigned int") int numImageNotifications(); public native fc2Config numImageNotifications(int numImageNotifications);

		/**
		 *  Minimum number of notifications needed for the current image
		 *  settings on the camera. Read-only value.
		 */
		public native @Cast("unsigned int") int minNumImageNotifications(); public native fc2Config minNumImageNotifications(int minNumImageNotifications);

		/**
		 * Time in milliseconds that RetrieveBuffer() and WaitForBufferEvent()
		 * will wait for an image before timing out and returning.
		 */
		public native int grabTimeout(); public native fc2Config grabTimeout(int grabTimeout);

		/** Grab mode for the camera. The default is DROP_FRAMES. */
		public native @Cast("fc2GrabMode") int grabMode(); public native fc2Config grabMode(int grabMode);

		/** This parameter enables RetrieveBuffer to run in high
		 *	performance mode.  This means that any interaction
		 *  with the camera, other than grabbing the image is disabled.
		 *	Currently Retrieve buffer reads registers on the camera to
		 *	determine which embedded image information settings have been
		 *	enabled, and it reads what the bayer tile is currently set to.
		 *	When High Performance mode is on, these reads are disabled.  This
		 *	means that any changes to the Bayer Tile or to the Embedded image
		 *	info after StartCapture() will not be tracked when made using
		 *	direct register writes.  If the corresponding SetEmbededImageInfo()
		 *	and GetEmbededImageInfo() calls are used then the changes will be
		 *	appropriately reflected.  This also means that changes to embedded
		 *	image info from other processes will not be updated either. */
		public native @Cast("BOOL") int highPerformanceRetrieveBuffer(); public native fc2Config highPerformanceRetrieveBuffer(int highPerformanceRetrieveBuffer);

		/** Isochronous bus speed. */
		public native @Cast("fc2BusSpeed") int isochBusSpeed(); public native fc2Config isochBusSpeed(int isochBusSpeed);

		/** Asynchronous bus speed. */
		public native @Cast("fc2BusSpeed") int asyncBusSpeed(); public native fc2Config asyncBusSpeed(int asyncBusSpeed);

		/**
		 * Bandwidth allocation flag that tells the camera the bandwidth
		 * allocation strategy to employ.
		 */
		public native @Cast("fc2BandwidthAllocation") int bandwidthAllocation(); public native fc2Config bandwidthAllocation(int bandwidthAllocation);

		/**
		 * Number of retries to perform when a register read/write timeout
		 * is received by the library. The default value is 0.
		 */
		public native @Cast("unsigned int") int registerTimeoutRetries(); public native fc2Config registerTimeoutRetries(int registerTimeoutRetries);

		/**
		 * Register read/write timeout value, in microseconds.
		 * The default value is dependent on the interface type.
		 */
		public native @Cast("unsigned int") int registerTimeout(); public native fc2Config registerTimeout(int registerTimeout);

		/** Reserved for future use */
		public native @Cast("unsigned int") int reserved(int i); public native fc2Config reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/**
	 * Information about a specific camera property. This structure is also
	 * also used as the TriggerDelayInfo structure.
	 */
	public static class fc2PropertyInfo extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2PropertyInfo() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2PropertyInfo(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2PropertyInfo(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2PropertyInfo position(long position) {
	        return (fc2PropertyInfo)super.position(position);
	    }
	
		/** Property info type. */
		public native @Cast("fc2PropertyType") int type(); public native fc2PropertyInfo type(int type);
		/** Flag indicating if the property is present. */
		public native @Cast("BOOL") int present(); public native fc2PropertyInfo present(int present);
		/** Flag indicating if auto is supported. */
		public native @Cast("BOOL") int autoSupported(); public native fc2PropertyInfo autoSupported(int autoSupported);
		/** Flag indicating if manual is supported. */
		public native @Cast("BOOL") int manualSupported(); public native fc2PropertyInfo manualSupported(int manualSupported);
		/** Flag indicating if on/off is supported. */
		public native @Cast("BOOL") int onOffSupported(); public native fc2PropertyInfo onOffSupported(int onOffSupported);
		/** Flag indicating if one push is supported. */
		public native @Cast("BOOL") int onePushSupported(); public native fc2PropertyInfo onePushSupported(int onePushSupported);
		/** Flag indicating if absolute mode is supported. */
		public native @Cast("BOOL") int absValSupported(); public native fc2PropertyInfo absValSupported(int absValSupported);
		/** Flag indicating if property value can be read out. */
		public native @Cast("BOOL") int readOutSupported(); public native fc2PropertyInfo readOutSupported(int readOutSupported);
		/** Minimum value (as an integer). */
		public native @Cast("unsigned int") int min(); public native fc2PropertyInfo min(int min);
		/** Maximum value (as an integer). */
		public native @Cast("unsigned int") int max(); public native fc2PropertyInfo max(int max);
		/** Minimum value (as a floating point value). */
		public native float absMin(); public native fc2PropertyInfo absMin(float absMin);
		/** Maximum value (as a floating point value). */
		public native float absMax(); public native fc2PropertyInfo absMax(float absMax);
		/** Textual description of units. */
		public native @Cast("char") byte pUnits(int i); public native fc2PropertyInfo pUnits(int i, byte pUnits);
		@MemberGetter public native @Cast("char*") BytePointer pUnits();
		/** Abbreviated textual description of units. */
		public native @Cast("char") byte pUnitAbbr(int i); public native fc2PropertyInfo pUnitAbbr(int i, byte pUnitAbbr);
		@MemberGetter public native @Cast("char*") BytePointer pUnitAbbr();
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2PropertyInfo reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/**
	 * A specific camera property. \n
	 * For example, to set the gain to 12dB, set the following values:
	 * - \a type - \c GAIN
	 * - \a absControl - \c true
	 * - \a onePush - \c false
	 * - \a onOff - \c true
	 * - \a autoManualMode - \c false
	 * - \a absValue - \c 12.0
	 */
	public static class fc2Property extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2Property() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2Property(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2Property(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2Property position(long position) {
	        return (fc2Property)super.position(position);
	    }
	
		/** Property info type. */
		public native @Cast("fc2PropertyType") int type(); public native fc2Property type(int type);
		/** Flag indicating if the property is present. */
		public native @Cast("BOOL") int present(); public native fc2Property present(int present);
		/**
         * Flag controlling absolute mode (real world units)
         * or non-absolute mode (camera internal units).
         */
		public native @Cast("BOOL") int absControl(); public native fc2Property absControl(int absControl);
		/** Flag controlling one push. */
		public native @Cast("BOOL") int onePush(); public native fc2Property onePush(int onePush);
		/** Flag controlling on/off. */
		public native @Cast("BOOL") int onOff(); public native fc2Property onOff(int onOff);
		/** Flag controlling auto. */
		public native @Cast("BOOL") int autoManualMode(); public native fc2Property autoManualMode(int autoManualMode);
		/**
         * Value A (integer).
         * Used to configure properties in non-absolute mode.
         */
		public native @Cast("unsigned int") int valueA(); public native fc2Property valueA(int valueA);
		/**
         * Value B (integer). For white balance, value B applies to the blue value and
         * value A applies to the red value.
         */
		public native @Cast("unsigned int") int valueB(); public native fc2Property valueB(int valueB);
		/**
		* Floating point value.
		* Used to configure properties in absolute mode.
		*/
		public native float absValue(); public native fc2Property absValue(float absValue);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2Property reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

		// For convenience, trigger delay is the same structure
		// used in a separate function along with trigger mode.

	}

	/** Information about a camera trigger property. */
	public static class fc2TriggerModeInfo extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2TriggerModeInfo() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2TriggerModeInfo(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2TriggerModeInfo(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2TriggerModeInfo position(long position) {
	        return (fc2TriggerModeInfo)super.position(position);
	    }
	
		/** Presence of trigger mode. */
		public native @Cast("BOOL") int present(); public native fc2TriggerModeInfo present(int present);
		/** Flag indicating if trigger value can be read out. */
		public native @Cast("BOOL") int readOutSupported(); public native fc2TriggerModeInfo readOutSupported(int readOutSupported);
		/** Flag indicating if on/off is supported. */
		public native @Cast("BOOL") int onOffSupported(); public native fc2TriggerModeInfo onOffSupported(int onOffSupported);
		/** Flag indicating if polarity is supported. */
		public native @Cast("BOOL") int polaritySupported(); public native fc2TriggerModeInfo polaritySupported(int polaritySupported);
		/** Flag indicating if the value is readable. */
		public native @Cast("BOOL") int valueReadable(); public native fc2TriggerModeInfo valueReadable(int valueReadable);
		/** Source mask. */
		public native @Cast("unsigned int") int sourceMask(); public native fc2TriggerModeInfo sourceMask(int sourceMask);
		/** Flag indicating if software trigger is supported. */
		public native @Cast("BOOL") int softwareTriggerSupported(); public native fc2TriggerModeInfo softwareTriggerSupported(int softwareTriggerSupported);
		/** Mode mask. */
		public native @Cast("unsigned int") int modeMask(); public native fc2TriggerModeInfo modeMask(int modeMask);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2TriggerModeInfo reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** A camera trigger. */
	public static class fc2TriggerMode extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2TriggerMode() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2TriggerMode(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2TriggerMode(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2TriggerMode position(long position) {
	        return (fc2TriggerMode)super.position(position);
	    }
	
		/** Flag controlling on/off. */
		public native @Cast("BOOL") int onOff(); public native fc2TriggerMode onOff(int onOff);
		/** Polarity value. */
		public native @Cast("unsigned int") int polarity(); public native fc2TriggerMode polarity(int polarity);
		/** Source value. */
		public native @Cast("unsigned int") int source(); public native fc2TriggerMode source(int source);
		/** Mode value. */
		public native @Cast("unsigned int") int mode(); public native fc2TriggerMode mode(int mode);
		/** Parameter value. */
		public native @Cast("unsigned int") int parameter(); public native fc2TriggerMode parameter(int parameter);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2TriggerMode reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** A camera strobe property. */
	public static class fc2StrobeInfo extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2StrobeInfo() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2StrobeInfo(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2StrobeInfo(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2StrobeInfo position(long position) {
	        return (fc2StrobeInfo)super.position(position);
	    }
	
		/** Source value. */
		public native @Cast("unsigned int") int source(); public native fc2StrobeInfo source(int source);
		/** Presence of strobe. */
		public native @Cast("BOOL") int present(); public native fc2StrobeInfo present(int present);
		/** Flag indicating if strobe value can be read out. */
		public native @Cast("BOOL") int readOutSupported(); public native fc2StrobeInfo readOutSupported(int readOutSupported);
		/** Flag indicating if on/off is supported. */
		public native @Cast("BOOL") int onOffSupported(); public native fc2StrobeInfo onOffSupported(int onOffSupported);
		/** Flag indicating if polarity is supported. */
		public native @Cast("BOOL") int polaritySupported(); public native fc2StrobeInfo polaritySupported(int polaritySupported);
		/** Minimum value. */
		public native float minValue(); public native fc2StrobeInfo minValue(float minValue);
		/** Maximum value. */
		public native float maxValue(); public native fc2StrobeInfo maxValue(float maxValue);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2StrobeInfo reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** A camera strobe. */
	public static class fc2StrobeControl extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2StrobeControl() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2StrobeControl(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2StrobeControl(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2StrobeControl position(long position) {
	        return (fc2StrobeControl)super.position(position);
	    }
	
		/** Source value. */
		public native @Cast("unsigned int") int source(); public native fc2StrobeControl source(int source);
		/** Flag controlling on/off. */
		public native @Cast("BOOL") int onOff(); public native fc2StrobeControl onOff(int onOff);
		/** Signal polarity. */
		public native @Cast("unsigned int") int polarity(); public native fc2StrobeControl polarity(int polarity);
		/** Signal delay (in ms). */
		public native float delay(); public native fc2StrobeControl delay(float delay);
		/** Signal duration (in ms). */
		public native float duration(); public native fc2StrobeControl duration(float duration);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2StrobeControl reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Timestamp information. */
	public static class fc2TimeStamp extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2TimeStamp() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2TimeStamp(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2TimeStamp(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2TimeStamp position(long position) {
	        return (fc2TimeStamp)super.position(position);
	    }
	
		/** Seconds. */
		public native long seconds(); public native fc2TimeStamp seconds(long seconds);
		/** Microseconds. */
		public native @Cast("unsigned int") int microSeconds(); public native fc2TimeStamp microSeconds(int microSeconds);
		/** 1394 cycle time seconds. */
		public native @Cast("unsigned int") int cycleSeconds(); public native fc2TimeStamp cycleSeconds(int cycleSeconds);
		/** 1394 cycle time count. */
		public native @Cast("unsigned int") int cycleCount(); public native fc2TimeStamp cycleCount(int cycleCount);
		/** 1394 cycle time offset. */
		public native @Cast("unsigned int") int cycleOffset(); public native fc2TimeStamp cycleOffset(int cycleOffset);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2TimeStamp reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Camera configuration ROM. */
	public static class fc2ConfigROM extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2ConfigROM() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2ConfigROM(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2ConfigROM(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2ConfigROM position(long position) {
	        return (fc2ConfigROM)super.position(position);
	    }
	
		/** Vendor ID of a node. */
		public native @Cast("unsigned int") int nodeVendorId(); public native fc2ConfigROM nodeVendorId(int nodeVendorId);
		/** Chip ID (high part). */
		public native @Cast("unsigned int") int chipIdHi(); public native fc2ConfigROM chipIdHi(int chipIdHi);
		/** Chip ID (low part). */
		public native @Cast("unsigned int") int chipIdLo(); public native fc2ConfigROM chipIdLo(int chipIdLo);
		/** Unit Spec ID, usually 0xa02d. */
		public native @Cast("unsigned int") int unitSpecId(); public native fc2ConfigROM unitSpecId(int unitSpecId);
		/** Unit software version. */
		public native @Cast("unsigned int") int unitSWVer(); public native fc2ConfigROM unitSWVer(int unitSWVer);
		/** Unit sub software version. */
		public native @Cast("unsigned int") int unitSubSWVer(); public native fc2ConfigROM unitSubSWVer(int unitSubSWVer);
		/** Vendor unique info 0. */
		public native @Cast("unsigned int") int vendorUniqueInfo_0(); public native fc2ConfigROM vendorUniqueInfo_0(int vendorUniqueInfo_0);
		/** Vendor unique info 1. */
		public native @Cast("unsigned int") int vendorUniqueInfo_1(); public native fc2ConfigROM vendorUniqueInfo_1(int vendorUniqueInfo_1);
		/** Vendor unique info 2. */
		public native @Cast("unsigned int") int vendorUniqueInfo_2(); public native fc2ConfigROM vendorUniqueInfo_2(int vendorUniqueInfo_2);
		/** Vendor unique info 3. */
		public native @Cast("unsigned int") int vendorUniqueInfo_3(); public native fc2ConfigROM vendorUniqueInfo_3(int vendorUniqueInfo_3);
		/** Keyword. */
		public native @Cast("char") byte pszKeyword(int i); public native fc2ConfigROM pszKeyword(int i, byte pszKeyword);
		@MemberGetter public native @Cast("char*") BytePointer pszKeyword();
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2ConfigROM reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Camera information. */
	public static class fc2CameraInfo extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2CameraInfo() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2CameraInfo(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2CameraInfo(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2CameraInfo position(long position) {
	        return (fc2CameraInfo)super.position(position);
	    }
	
		/** Device serial number. */
		public native @Cast("unsigned int") int serialNumber(); public native fc2CameraInfo serialNumber(int serialNumber);
		/** Interface type. */
		public native @Cast("fc2InterfaceType") int interfaceType(); public native fc2CameraInfo interfaceType(int interfaceType);
		/** Driver type. */
		public native @Cast("fc2DriverType") int driverType(); public native fc2CameraInfo driverType(int driverType);
		/** Flag indicating if this is a color camera. */
		public native @Cast("BOOL") int isColorCamera(); public native fc2CameraInfo isColorCamera(int isColorCamera);
		/** Device model name. */
		public native @Cast("char") byte modelName(int i); public native fc2CameraInfo modelName(int i, byte modelName);
		@MemberGetter public native @Cast("char*") BytePointer modelName();
		/** Device vendor name. */
		public native @Cast("char") byte vendorName(int i); public native fc2CameraInfo vendorName(int i, byte vendorName);
		@MemberGetter public native @Cast("char*") BytePointer vendorName();
		/** String detailing the sensor information. */
		public native @Cast("char") byte sensorInfo(int i); public native fc2CameraInfo sensorInfo(int i, byte sensorInfo);
		@MemberGetter public native @Cast("char*") BytePointer sensorInfo();
		/** String providing the sensor resolution. */
		public native @Cast("char") byte sensorResolution(int i); public native fc2CameraInfo sensorResolution(int i, byte sensorResolution);
		@MemberGetter public native @Cast("char*") BytePointer sensorResolution();
		/** Driver name of driver being used. */
		public native @Cast("char") byte driverName(int i); public native fc2CameraInfo driverName(int i, byte driverName);
		@MemberGetter public native @Cast("char*") BytePointer driverName();
		/** Firmware version of camera. */
		public native @Cast("char") byte firmwareVersion(int i); public native fc2CameraInfo firmwareVersion(int i, byte firmwareVersion);
		@MemberGetter public native @Cast("char*") BytePointer firmwareVersion();
		/** Firmware build time. */
		public native @Cast("char") byte firmwareBuildTime(int i); public native fc2CameraInfo firmwareBuildTime(int i, byte firmwareBuildTime);
		@MemberGetter public native @Cast("char*") BytePointer firmwareBuildTime();
		/** Maximum bus speed. */
		public native @Cast("fc2BusSpeed") int maximumBusSpeed(); public native fc2CameraInfo maximumBusSpeed(int maximumBusSpeed);
		/** Bayer tile format. */
		public native @Cast("fc2BayerTileFormat") int bayerTileFormat(); public native fc2CameraInfo bayerTileFormat(int bayerTileFormat);
		/** Bus number, set to 0 for GigE and USB cameras **/
		public native @Cast("fc2PCIeBusSpeed") int pcieBusSpeed(); public native fc2CameraInfo pcieBusSpeed(int pcieBusSpeed);
		/** ieee1394 Node number, set to 0 for GigE and USB cameras **/
		public native @Cast("unsigned short") short nodeNumber(); public native fc2CameraInfo nodeNumber(short nodeNumber);
		/** PCIe Bus Speed, set to PCIE_BUSSPEED_UNKNOWN for unsupported drivers **/
		public native @Cast("unsigned short") short busNumber(); public native fc2CameraInfo busNumber(short busNumber);

		/** \name IIDC specific information */
		/*@{*/
		/** DCAM version. */
		public native @Cast("unsigned int") int iidcVer(); public native fc2CameraInfo iidcVer(int iidcVer);
		/** Configuration ROM data. */
		public native @ByRef fc2ConfigROM configROM(); public native fc2CameraInfo configROM(fc2ConfigROM configROM);
		/*@}*/

		/** \name GigE specific information */
		/*@{*/
		/** GigE Vision version. */
		public native @Cast("unsigned int") int gigEMajorVersion(); public native fc2CameraInfo gigEMajorVersion(int gigEMajorVersion);
		/** GigE Vision minor version. */
		public native @Cast("unsigned int") int gigEMinorVersion(); public native fc2CameraInfo gigEMinorVersion(int gigEMinorVersion);
		/** User defined name. */
		public native @Cast("char") byte userDefinedName(int i); public native fc2CameraInfo userDefinedName(int i, byte userDefinedName);
		@MemberGetter public native @Cast("char*") BytePointer userDefinedName();
		/** XML URL 1. */
		public native @Cast("char") byte xmlURL1(int i); public native fc2CameraInfo xmlURL1(int i, byte xmlURL1);
		@MemberGetter public native @Cast("char*") BytePointer xmlURL1();
		/** XML URL 2. */
		public native @Cast("char") byte xmlURL2(int i); public native fc2CameraInfo xmlURL2(int i, byte xmlURL2);
		@MemberGetter public native @Cast("char*") BytePointer xmlURL2();
		/** MAC address */
		public native @ByRef fc2MACAddress macAddress(); public native fc2CameraInfo macAddress(fc2MACAddress macAddress);
		/** IP address. */
		public native @ByRef fc2IPAddress ipAddress(); public native fc2CameraInfo ipAddress(fc2IPAddress ipAddress);
		/** Subnet mask. */
		public native @ByRef fc2IPAddress subnetMask(); public native fc2CameraInfo subnetMask(fc2IPAddress subnetMask);
		/** Default gateway. */
		public native @ByRef fc2IPAddress defaultGateway(); public native fc2CameraInfo defaultGateway(fc2IPAddress defaultGateway);
		/** Status/Content of CCP register */
		public native @Cast("unsigned int") int ccpStatus(); public native fc2CameraInfo ccpStatus(int ccpStatus);
		/** Local Application IP Address. */
		public native @Cast("unsigned int") int applicationIPAddress(); public native fc2CameraInfo applicationIPAddress(int applicationIPAddress);
		/** Local Application port. */
		public native @Cast("unsigned int") int applicationPort(); public native fc2CameraInfo applicationPort(int applicationPort);
		/*@}*/

		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2CameraInfo reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Properties of a single embedded image info property. */
	public static class fc2EmbeddedImageInfoProperty extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2EmbeddedImageInfoProperty() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2EmbeddedImageInfoProperty(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2EmbeddedImageInfoProperty(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2EmbeddedImageInfoProperty position(long position) {
	        return (fc2EmbeddedImageInfoProperty)super.position(position);
	    }
	
		/** Whether this property is available. */
		public native @Cast("BOOL") int available(); public native fc2EmbeddedImageInfoProperty available(int available);
		/** Whether this property is on or off. */
		public native @Cast("BOOL") int onOff(); public native fc2EmbeddedImageInfoProperty onOff(int onOff);

	}

	/** Properties of the possible embedded image information. */
	public static class fc2EmbeddedImageInfo extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2EmbeddedImageInfo() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2EmbeddedImageInfo(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2EmbeddedImageInfo(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2EmbeddedImageInfo position(long position) {
	        return (fc2EmbeddedImageInfo)super.position(position);
	    }
	
		public native @ByRef fc2EmbeddedImageInfoProperty timestamp(); public native fc2EmbeddedImageInfo timestamp(fc2EmbeddedImageInfoProperty timestamp);
		public native @ByRef fc2EmbeddedImageInfoProperty gain(); public native fc2EmbeddedImageInfo gain(fc2EmbeddedImageInfoProperty gain);
		public native @ByRef fc2EmbeddedImageInfoProperty shutter(); public native fc2EmbeddedImageInfo shutter(fc2EmbeddedImageInfoProperty shutter);
		public native @ByRef fc2EmbeddedImageInfoProperty brightness(); public native fc2EmbeddedImageInfo brightness(fc2EmbeddedImageInfoProperty brightness);
		public native @ByRef fc2EmbeddedImageInfoProperty exposure(); public native fc2EmbeddedImageInfo exposure(fc2EmbeddedImageInfoProperty exposure);
		public native @ByRef fc2EmbeddedImageInfoProperty whiteBalance(); public native fc2EmbeddedImageInfo whiteBalance(fc2EmbeddedImageInfoProperty whiteBalance);
		public native @ByRef fc2EmbeddedImageInfoProperty frameCounter(); public native fc2EmbeddedImageInfo frameCounter(fc2EmbeddedImageInfoProperty frameCounter);
		public native @ByRef fc2EmbeddedImageInfoProperty strobePattern(); public native fc2EmbeddedImageInfo strobePattern(fc2EmbeddedImageInfoProperty strobePattern);
		public native @ByRef fc2EmbeddedImageInfoProperty GPIOPinState(); public native fc2EmbeddedImageInfo GPIOPinState(fc2EmbeddedImageInfoProperty GPIOPinState);
		public native @ByRef fc2EmbeddedImageInfoProperty ROIPosition(); public native fc2EmbeddedImageInfo ROIPosition(fc2EmbeddedImageInfoProperty ROIPosition);

	}

	/** Metadata related to an image. */
	public static class fc2ImageMetadata extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2ImageMetadata() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2ImageMetadata(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2ImageMetadata(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2ImageMetadata position(long position) {
	        return (fc2ImageMetadata)super.position(position);
	    }
	
		/** Embedded timestamp. */
		public native @Cast("unsigned int") int embeddedTimeStamp(); public native fc2ImageMetadata embeddedTimeStamp(int embeddedTimeStamp);
		/** Embedded gain. */
		public native @Cast("unsigned int") int embeddedGain(); public native fc2ImageMetadata embeddedGain(int embeddedGain);
		/** Embedded shutter. */
		public native @Cast("unsigned int") int embeddedShutter(); public native fc2ImageMetadata embeddedShutter(int embeddedShutter);
		/** Embedded brightness. */
		public native @Cast("unsigned int") int embeddedBrightness(); public native fc2ImageMetadata embeddedBrightness(int embeddedBrightness);
		/** Embedded exposure. */
		public native @Cast("unsigned int") int embeddedExposure(); public native fc2ImageMetadata embeddedExposure(int embeddedExposure);
		/** Embedded white balance. */
		public native @Cast("unsigned int") int embeddedWhiteBalance(); public native fc2ImageMetadata embeddedWhiteBalance(int embeddedWhiteBalance);
		/** Embedded frame counter. */
		public native @Cast("unsigned int") int embeddedFrameCounter(); public native fc2ImageMetadata embeddedFrameCounter(int embeddedFrameCounter);
		/** Embedded strobe pattern. */
		public native @Cast("unsigned int") int embeddedStrobePattern(); public native fc2ImageMetadata embeddedStrobePattern(int embeddedStrobePattern);
		/** Embedded GPIO pin state. */
		public native @Cast("unsigned int") int embeddedGPIOPinState(); public native fc2ImageMetadata embeddedGPIOPinState(int embeddedGPIOPinState);
		/** Embedded ROI position. */
		public native @Cast("unsigned int") int embeddedROIPosition(); public native fc2ImageMetadata embeddedROIPosition(int embeddedROIPosition);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2ImageMetadata reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Information about the camera's look up table. */
	public static class fc2LUTData extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2LUTData() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2LUTData(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2LUTData(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2LUTData position(long position) {
	        return (fc2LUTData)super.position(position);
	    }
	
		/** Flag indicating if LUT is supported. */
		public native @Cast("BOOL") int supported(); public native fc2LUTData supported(int supported);
		/** Flag indicating if LUT is enabled. */
		public native @Cast("BOOL") int enabled(); public native fc2LUTData enabled(int enabled);
		/** The number of LUT banks available (Always 1 for PGR LUT). */
		public native @Cast("unsigned int") int numBanks(); public native fc2LUTData numBanks(int numBanks);
		/** The number of LUT channels per bank available. */
		public native @Cast("unsigned int") int numChannels(); public native fc2LUTData numChannels(int numChannels);
		/** The input bit depth of the LUT. */
		public native @Cast("unsigned int") int inputBitDepth(); public native fc2LUTData inputBitDepth(int inputBitDepth);
		/** The output bit depth of the LUT. */
		public native @Cast("unsigned int") int outputBitDepth(); public native fc2LUTData outputBitDepth(int outputBitDepth);
		/** The number of entries in the LUT. */
		public native @Cast("unsigned int") int numEntries(); public native fc2LUTData numEntries(int numEntries);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2LUTData reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Camera diagnostic information. */
	public static class fc2CameraStats extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2CameraStats() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2CameraStats(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2CameraStats(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2CameraStats position(long position) {
	        return (fc2CameraStats)super.position(position);
	    }
	
		/* Number of dropped images in DROP_IMAGE mode */
		public native @Cast("unsigned int") int imageDropped(); public native fc2CameraStats imageDropped(int imageDropped);
		/* Number of corrupt images, such as missing packet, zero packet */
		public native @Cast("unsigned int") int imageCorrupt(); public native fc2CameraStats imageCorrupt(int imageCorrupt);
		/* Number of transmissions failed of camera */
		public native @Cast("unsigned int") int imageXmitFailed(); public native fc2CameraStats imageXmitFailed(int imageXmitFailed);
		/* Number of images dropped in driver */
		public native @Cast("unsigned int") int imageDriverDropped(); public native fc2CameraStats imageDriverDropped(int imageDriverDropped);
		/* Errors of register reading */
		public native @Cast("unsigned int") int regReadFailed(); public native fc2CameraStats regReadFailed(int regReadFailed);
		/* Errors of register writing */
		public native @Cast("unsigned int") int regWriteFailed(); public native fc2CameraStats regWriteFailed(int regWriteFailed);
		/* Port errors */
		public native @Cast("unsigned int") int portErrors(); public native fc2CameraStats portErrors(int portErrors);

		/* The value of the camera power register.
		 * false: Camera is powered down.
		 * true: Camera is powered up.
		 */
		public native @Cast("BOOL") int cameraPowerUp(); public native fc2CameraStats cameraPowerUp(int cameraPowerUp);

		/* The voltage values of the various voltage registers
		 * supported by the camera.
		 */
		public native float cameraVoltages(int i); public native fc2CameraStats cameraVoltages(int i, float cameraVoltages);
		@MemberGetter public native FloatPointer cameraVoltages();

		/** The number of voltage registers available.
		 * 0: the values in cameraVoltages[] are invalid.
		 */
		public native @Cast("unsigned int") int numVoltages(); public native fc2CameraStats numVoltages(int numVoltages);

		/* The current values of the various current registers
		 * supported by the camera.
		 */
		public native float cameraCurrents(int i); public native fc2CameraStats cameraCurrents(int i, float cameraCurrents);
		@MemberGetter public native FloatPointer cameraCurrents();

		/** The number of current registers available.
		 * 0: the values in cameraCurrents[] are invalid.
		 */
		public native @Cast("unsigned int") int numCurrents(); public native fc2CameraStats numCurrents(int numCurrents);

		/* The temperature of the camera board-level components. The value is
		 * in kelvins (0C = 273.15K) and are in one-tenths (0.1) of a kelvin.
		 */
		public native @Cast("unsigned int") int temperature(); public native fc2CameraStats temperature(int temperature);

		/* Time in seconds since the camera was initialized. */
		public native @Cast("unsigned int") int timeSinceInitialization(); public native fc2CameraStats timeSinceInitialization(int timeSinceInitialization);
		/* Time in seconds since the camera detected a bus reset. */
		public native @Cast("unsigned int") int timeSinceBusReset(); public native fc2CameraStats timeSinceBusReset(int timeSinceBusReset);
		/* Time stamp */
		public native @ByRef fc2TimeStamp timeStamp(); public native fc2CameraStats timeStamp(fc2TimeStamp timeStamp);
		/* Number of packets requested for resend */
		public native @Cast("unsigned int") int numResendPacketsRequested(); public native fc2CameraStats numResendPacketsRequested(int numResendPacketsRequested);
		/* Number of packet-resend packets received */
		public native @Cast("unsigned int") int numResendPacketsReceived(); public native fc2CameraStats numResendPacketsReceived(int numResendPacketsReceived);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2CameraStats reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/**
	 * \defgroup CImageSaveStructures Image saving structures.
	 *
	 * These structures define various parameters used for saving images.
	 */

	/*@{*/

	/** Options for saving PNG images. */
	public static class fc2PNGOption extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2PNGOption() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2PNGOption(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2PNGOption(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2PNGOption position(long position) {
	        return (fc2PNGOption)super.position(position);
	    }
	
		/** Whether to save the PNG as interlaced. */
		public native @Cast("BOOL") int interlaced(); public native fc2PNGOption interlaced(int interlaced);
		/** Compression level (0-9). 0 is no compression, 9 is best compression. */
		public native @Cast("unsigned int") int compressionLevel(); public native fc2PNGOption compressionLevel(int compressionLevel);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2PNGOption reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Options for saving PPM images. */
	 public static class fc2PPMOption extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2PPMOption() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2PPMOption(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2PPMOption(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2PPMOption position(long position) {
	        return (fc2PPMOption)super.position(position);
	    }
	
		/** Whether to save the PPM as a binary file. */
		public native @Cast("BOOL") int binaryFile(); public native fc2PPMOption binaryFile(int binaryFile);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2PPMOption reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	} 

	/** Options for saving PGM images. */
	public static class fc2PGMOption extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2PGMOption() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2PGMOption(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2PGMOption(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2PGMOption position(long position) {
	        return (fc2PGMOption)super.position(position);
	    }
	
		/** Whether to save the PPM as a binary file. */
		public native @Cast("BOOL") int binaryFile(); public native fc2PGMOption binaryFile(int binaryFile);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2PGMOption reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** enum _fc2TIFFCompressionMethod */
	public static final int
		/** Save without any compression. */
		FC2_TIFF_NONE = 1,
		/** Save using PACKBITS compression. */
		FC2_TIFF_PACKBITS = 2,
		/** Save using DEFLATE compression (ZLIB compression). */
		FC2_TIFF_DEFLATE = 3,
		/** Save using ADOBE DEFLATE compression */
		FC2_TIFF_ADOBE_DEFLATE = 4,
		/**
		 * Save using CCITT Group 3 fax encoding. This is only valid for
		 * 1-bit images only. Default to LZW for other bit depths.
		 */
		FC2_TIFF_CCITTFAX3 = 5,
		/**
		 * Save using CCITT Group 4 fax encoding. This is only valid for
		 * 1-bit images only. Default to LZW for other bit depths.
		 */
		FC2_TIFF_CCITTFAX4 = 6,
		/** Save using LZW compression. */
		FC2_TIFF_LZW = 7,
		/**
		 * Save using JPEG compression. This is only valid for 8-bit
		 * greyscale and 24-bit only. Default to LZW for other bit depths.
		 */
		FC2_TIFF_JPEG = 8;

	/** Options for saving TIFF images. */
	public static class fc2TIFFOption extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2TIFFOption() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2TIFFOption(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2TIFFOption(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2TIFFOption position(long position) {
	        return (fc2TIFFOption)super.position(position);
	    }
	
		/** Compression method to use for encoding TIFF images. */
		public native @Cast("fc2TIFFCompressionMethod") int compression(); public native fc2TIFFOption compression(int compression);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2TIFFOption reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Options for saving JPEG image. */
	public static class fc2JPEGOption extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2JPEGOption() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2JPEGOption(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2JPEGOption(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2JPEGOption position(long position) {
	        return (fc2JPEGOption)super.position(position);
	    }
	
		/** Whether to save as a progressive JPEG file. */
		public native @Cast("BOOL") int progressive(); public native fc2JPEGOption progressive(int progressive);
		/**
		 * JPEG image quality in range (0-100).
		 * - 100 - Superb quality.
		 * - 75  - Good quality.
		 * - 50  - Normal quality.
		 * - 10  - Poor quality.
		 */
		public native @Cast("unsigned int") int quality(); public native fc2JPEGOption quality(int quality);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2JPEGOption reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Options for saving JPEG2000 image. */
	public static class fc2JPG2Option extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2JPG2Option() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2JPG2Option(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2JPG2Option(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2JPG2Option position(long position) {
	        return (fc2JPG2Option)super.position(position);
	    }
	
		/** JPEG saving quality in range (1-512). */
		public native @Cast("unsigned int") int quality(); public native fc2JPG2Option quality(int quality);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2JPG2Option reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
	}

	/** Options for saving Bitmap image. */
	public static class fc2BMPOption extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2BMPOption() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2BMPOption(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2BMPOption(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2BMPOption position(long position) {
	        return (fc2BMPOption)super.position(position);
	    }
	
		public native @Cast("BOOL") int indexedColor_8bit(); public native fc2BMPOption indexedColor_8bit(int indexedColor_8bit);
		/** Reserved for future use. */
		public native @Cast("unsigned int") int reserved(int i); public native fc2BMPOption reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
	}

	/** Options for saving MJPG files. */
	public static class fc2MJPGOption extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2MJPGOption() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2MJPGOption(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2MJPGOption(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2MJPGOption position(long position) {
	        return (fc2MJPGOption)super.position(position);
	    }
	
		/** Frame rate of the stream */
		public native float frameRate(); public native fc2MJPGOption frameRate(float frameRate);
		/** Image quality (1-100) */
		public native @Cast("unsigned int") int quality(); public native fc2MJPGOption quality(int quality);
		public native @Cast("unsigned int") int reserved(int i); public native fc2MJPGOption reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Options for saving H264 files. */
	public static class fc2H264Option extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2H264Option() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2H264Option(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2H264Option(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2H264Option position(long position) {
	        return (fc2H264Option)super.position(position);
	    }
	
		/** Frame rate of the stream */
		public native float frameRate(); public native fc2H264Option frameRate(float frameRate);
		/** Width of source image */
		public native @Cast("unsigned int") int width(); public native fc2H264Option width(int width);
		/** Height of source image */
		public native @Cast("unsigned int") int height(); public native fc2H264Option height(int height);
		/** Bitrate to encode at */
		public native @Cast("unsigned int") int bitrate(); public native fc2H264Option bitrate(int bitrate);
		/** Reserved for future use */
		public native @Cast("unsigned int") int reserved(int i); public native fc2H264Option reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

	}

	/** Options for saving AVI files. */
	public static class fc2AVIOption extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2AVIOption() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2AVIOption(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2AVIOption(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2AVIOption position(long position) {
	        return (fc2AVIOption)super.position(position);
	    }
	
		/** Frame rate of the stream */
		public native float frameRate(); public native fc2AVIOption frameRate(float frameRate);
		/** Reserved for future use */
		public native @Cast("unsigned int") int reserved(int i); public native fc2AVIOption reserved(int i, int reserved);
		@MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
	}

	//=============================================================================
	// Callbacks
	//=============================================================================

	@Namespace @Name("void") @Opaque public static class fc2CallbackHandle extends Pointer {
	    /** Empty constructor. Calls {@code super((Pointer)null)}. */
	    public fc2CallbackHandle() { super((Pointer)null); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2CallbackHandle(Pointer p) { super(p); }
	}
	public static class fc2BusEventCallback extends FunctionPointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public    fc2BusEventCallback(Pointer p) { super(p); }
	    protected fc2BusEventCallback() { allocate(); }
	    private native void allocate();
	    public native void call( Pointer pParameter, @Cast("unsigned int") int serialNumber );
	}
	public static class fc2ImageEventCallback extends FunctionPointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public    fc2ImageEventCallback(Pointer p) { super(p); }
	    protected fc2ImageEventCallback() { allocate(); }
	    private native void allocate();
	    public native void call( fc2Image image, Pointer pCallbackData );
	}
	public static class fc2AsyncCommandCallback extends FunctionPointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public    fc2AsyncCommandCallback(Pointer p) { super(p); }
	    protected fc2AsyncCommandCallback() { allocate(); }
	    private native void allocate();
	    public native void call( @Cast("fc2Error") int retError, Pointer pUserData );
	}
	public static class fc2CameraEventCallback extends FunctionPointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public    fc2CameraEventCallback(Pointer p) { super(p); }
	    protected fc2CameraEventCallback() { allocate(); }
	    private native void allocate();
	    public native void call( Pointer pCallbackData );
	}

	/*******************************************************************************
	 * Camera event data types
	 ******************************************************************************/
	/** Options for enabling device event registration. */
	public static class fc2EventOptions extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2EventOptions() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2EventOptions(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2EventOptions(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2EventOptions position(long position) {
	        return (fc2EventOptions)super.position(position);
	    }
	
		/** Callback function pointer */
		public native fc2CameraEventCallback EventCallbackFcn(); public native fc2EventOptions EventCallbackFcn(fc2CameraEventCallback EventCallbackFcn);

		/** Event name to register */
		@MemberGetter public native @Cast("const char*") BytePointer EventName();

		/** Pointer to callback data to be passed to the callback function */
		@MemberGetter public native @Const Pointer EventUserData();

		/** Size of the underlying struct passed as eventCallbackData for sanity checks */
		public native @Cast("size_t") long EventUserDataSize(); public native fc2EventOptions EventUserDataSize(long EventUserDataSize);
	}


	/* Callback data passed to the callback function provided when using
	 * RegisterEvent() or RegisterAllEvents().
	 */
	public static class fc2EventCallbackData extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public fc2EventCallbackData() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public fc2EventCallbackData(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public fc2EventCallbackData(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public fc2EventCallbackData position(long position) {
	        return (fc2EventCallbackData)super.position(position);
	    }
	
		/** Pointer to the user-supplied data struct */
		public native Pointer EventUserData(); public native fc2EventCallbackData EventUserData(Pointer EventUserData);

		/** Size of the user data supplied to the RegisterEvent()
		 * function.
		 */
		public native @Cast("size_t") long EventUserDataSize(); public native fc2EventCallbackData EventUserDataSize(long EventUserDataSize);

		/** The event name used to register the event. Provided so the user
		 * knows which event triggered the callback.
		 */
		@MemberGetter public native @Cast("const char*") BytePointer EventName();

		/** The device register which EventName maps to. Provides an alternate
		 * means of indexing into different event types.
		 */
		public native @Cast("unsigned long long") long EventID(); public native fc2EventCallbackData EventID(long EventID);

		/** Timestamp indicated the time (as reported by the camera) at which
		 * the camera exposure operation completed. This can be compared with
		 * image timestamps if there is a need to map event timestamps to
		 * specific images, if applicable.
		 */
		public native @Cast("unsigned long long") long EventTimestamp(); public native fc2EventCallbackData EventTimestamp(long EventTimestamp);

		/** A pointer to additional data pertaining to the event which just
		 * trigger the callback function. The data may be of difference sizes
		 * or may not even be allocated, depending on the type of event which
		 * triggered the callback.
		 */
		public native Pointer EventData(); public native fc2EventCallbackData EventData(Pointer EventData);

		/** The size of the structure pointed to by EventData. This value should
		 * be checked, especially if there are events which can trigger variable-
		 * length event data to be returned to the user when the callback function
		 * is issued.
		 */
		public native @Cast("size_t") long EventDataSize(); public native fc2EventCallbackData EventDataSize(long EventDataSize);
	}

	/*@}*/

	/*@}*/

// #ifdef __cplusplus
// #endif

// #endif // PGR_FC2_FLYCAPTURE2DEFS_C_H

// Parsed from <FlyCapture2_C.h>

//=============================================================================
// Copyright  2008 Point Grey Research, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of Point
// Grey Research, Inc. ("Confidential Information").  You shall not
// disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with PGR.
//
// PGR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. PGR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
//=============================================================================
// $Id: FlyCapture2_C.h,v 1.69 2010-12-13 23:58:00 mgara Exp $
//=============================================================================

// #ifndef PGR_FC2_FLYCAPTURE2_C_H
// #define PGR_FC2_FLYCAPTURE2_C_H

//=============================================================================
// Global C header file for FlyCapture2.
//
// This file defines the C API for FlyCapture2
//=============================================================================

// #include "FlyCapture2Platform_C.h"
// #include "FlyCapture2Defs_C.h"

// #ifdef __cplusplus
// #endif

	/**
	 * Create a FC2 context for IIDC camera.
	 * This call must be made before any other calls that use a context
	 * will succeed.
	 *
	 * @see fc2DestroyContext()
	 *
	 * @param pContext A pointer to the fc2Context to be created.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2CreateContext(
					@Cast("fc2Context*") @ByPtrPtr fc2Context pContext );

	/**
	 * Create a FC2 context for a GigE Vision camera.
	 * This call must be made before any other calls that use a context
	 * will succeed.
	 *
	 * @see fc2DestroyContext()
	 *
	 * @param pContext A pointer to the fc2Context to be created.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2CreateGigEContext(
					@Cast("fc2Context*") @ByPtrPtr fc2Context pContext );

	/**
	 * Destroy the FC2 context. This must be called when the user is finished
	 * with the context in order to prevent memory leaks.
	 *
	 * @see fc2CreateContext()
	 *
	 * @param context The context to be destroyed.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2DestroyContext(
					fc2Context context );

	/**
	* \defgroup CBusManager Bus Manager Operation
	*
	* \brief The functions in this section provide access to BusManager
	* operations
	*/
	/*@{*/

	/**
	 * Fire a bus reset. The actual bus reset is only fired for the
	 * specified 1394 bus, but it will effectively cause a global bus
	 * reset for the library.
	 *
	 * @param context The fc2Context to be used.
	 * @param pGuid PGRGuid of the camera or the device to cause bus reset.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2FireBusReset(
					fc2Context context,
					fc2PGRGuid pGuid);

	/**
	 * Gets the number of cameras attached to the PC.
	 *
	 * @param context The fc2Context to be used.
	 * @param pNumCameras Number of cameras detected.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetNumOfCameras(
					fc2Context context,
					@Cast("unsigned int*") IntPointer pNumCameras );
	public static native @Cast("fc2Error") int fc2GetNumOfCameras(
					fc2Context context,
					@Cast("unsigned int*") IntBuffer pNumCameras );
	public static native @Cast("fc2Error") int fc2GetNumOfCameras(
					fc2Context context,
					@Cast("unsigned int*") int[] pNumCameras );

	/**
	* Gets the PGRGuid for a camera with the specified IPv4 address.
	*
	* @param context The fc2Context to be used.
	* @param ipAddress IP address to get GUID for.
	* @param pGuid Unique PGRGuid for the camera.
	*
	* @return A fc2Error indicating the success or failure of the function.
	*/
	public static native @Cast("fc2Error") int fc2GetCameraFromIPAddress(
				fc2Context context,
				@ByVal fc2IPAddress ipAddress,
				fc2PGRGuid pGuid);

	/**
	* Gets the PGRGuid for a camera on the PC. It uniquely identifies
	* the camera specified by the index and is used to identify the camera
	* during a fc2Connect() call.
	*
	* @param context The fc2Context to be used.
	* @param index Zero based index of camera.
	* @param pGuid Unique PGRGuid for the camera.
	*
	* @return A fc2Error indicating the success or failure of the function.
	*/
	public static native @Cast("fc2Error") int fc2GetCameraFromIndex(
				fc2Context context,
				@Cast("unsigned int") int index,
				fc2PGRGuid pGuid);

	/**
	 * Gets the PGRGuid for a camera on the PC. It uniquely identifies
	 * the camera specified by the serial number and is used to identify the camera
	 * during a fc2Connect() call.
	 *
	 * @param context The fc2Context to be used.
	 * @param serialNumber Serial number of camera.
	 * @param pGuid Unique PGRGuid for the camera.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetCameraFromSerialNumber(
					fc2Context context,
					@Cast("unsigned int") int serialNumber,
					fc2PGRGuid pGuid );

	/**
	 * Gets the serial number of the camera with the specified index.
	 *
	 * @param context The fc2Context to be used.
	 * @param index Zero based index of desired camera.
	 * @param pSerialNumber Serial number of camera.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetCameraSerialNumberFromIndex(
					fc2Context context,
					@Cast("unsigned int") int index,
					@Cast("unsigned int*") IntPointer pSerialNumber );
	public static native @Cast("fc2Error") int fc2GetCameraSerialNumberFromIndex(
					fc2Context context,
					@Cast("unsigned int") int index,
					@Cast("unsigned int*") IntBuffer pSerialNumber );
	public static native @Cast("fc2Error") int fc2GetCameraSerialNumberFromIndex(
					fc2Context context,
					@Cast("unsigned int") int index,
					@Cast("unsigned int*") int[] pSerialNumber );

	/**
	 * Gets the interface type associated with a PGRGuid. This is useful
	 * in situations where there is a need to enumerate all cameras
	 * for a particular interface.
	 *
	 * @param context The fc2Context to be used.
	 * @param pGuid The PGRGuid to get the interface for.
	 * @param pInterfaceType The interface type of the PGRGuid.
	 *
	 * @return
	 */
	public static native @Cast("fc2Error") int fc2GetInterfaceTypeFromGuid(
					fc2Context context,
					fc2PGRGuid pGuid,
					@Cast("fc2InterfaceType*") IntPointer pInterfaceType );
	public static native @Cast("fc2Error") int fc2GetInterfaceTypeFromGuid(
					fc2Context context,
					fc2PGRGuid pGuid,
					@Cast("fc2InterfaceType*") IntBuffer pInterfaceType );
	public static native @Cast("fc2Error") int fc2GetInterfaceTypeFromGuid(
					fc2Context context,
					fc2PGRGuid pGuid,
					@Cast("fc2InterfaceType*") int[] pInterfaceType );

	/**
	 * Gets the number of devices. This may include hubs, host controllers
	 * and other hardware devices (including cameras).
	 *
	 * @param context The fc2Context to be used.
	 * @param pNumDevices The number of devices found.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetNumOfDevices(
					fc2Context context,
					@Cast("unsigned int*") IntPointer pNumDevices );
	public static native @Cast("fc2Error") int fc2GetNumOfDevices(
					fc2Context context,
					@Cast("unsigned int*") IntBuffer pNumDevices );
	public static native @Cast("fc2Error") int fc2GetNumOfDevices(
					fc2Context context,
					@Cast("unsigned int*") int[] pNumDevices );

	/**
	 * Gets the PGRGuid for a device. It uniquely identifies the device
	 * specified by the index.
	 *
	 * @param context The fc2Context to be used.
	 * @param index Zero based index of device.
	 * @param pGuid Unique PGRGuid for the device.
	 *
	 * @see fc2GetNumOfDevices()
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetDeviceFromIndex(
					fc2Context context,
					@Cast("unsigned int") int index,
					fc2PGRGuid pGuid );

	/**
		* Read a phy register on the specified device. The full address
		* to be read from is determined by the page, port and address.
		*
		* @param context The fc2Context to be used.
		* @param guid Unique PGRGuid for the device.
		* @param page Page to read from.
		* @param port Port to read from.
		* @param address Address to read from.
		* @param pValue Value read from the phy register.
		*
		* @return An Error indicating the success or failure of the function.
		*/
	public static native @Cast("fc2Error") int fc2ReadPhyRegister(
				fc2Context context,
				@ByVal fc2PGRGuid guid,
				@Cast("unsigned int") int page,
				@Cast("unsigned int") int port,
				@Cast("unsigned int") int address,
				@Cast("unsigned int*") IntPointer pValue );
	public static native @Cast("fc2Error") int fc2ReadPhyRegister(
				fc2Context context,
				@ByVal fc2PGRGuid guid,
				@Cast("unsigned int") int page,
				@Cast("unsigned int") int port,
				@Cast("unsigned int") int address,
				@Cast("unsigned int*") IntBuffer pValue );
	public static native @Cast("fc2Error") int fc2ReadPhyRegister(
				fc2Context context,
				@ByVal fc2PGRGuid guid,
				@Cast("unsigned int") int page,
				@Cast("unsigned int") int port,
				@Cast("unsigned int") int address,
				@Cast("unsigned int*") int[] pValue );

	/**
	 * Write a phy register on the specified device. The full address
	 * to be written to is determined by the page, port and address.
	 *
	 * @param context The fc2Context to be used.
	 * @param guid Unique PGRGuid for the device.
	 * @param page Page to write to.
	 * @param port Port to write to.
	 * @param address Address to write to.
	 * @param value Value to write to phy register.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2WritePhyRegister(
				fc2Context context,
				@ByVal fc2PGRGuid guid,
				@Cast("unsigned int") int page,
				@Cast("unsigned int") int port,
				@Cast("unsigned int") int address,
				@Cast("unsigned int") int value );

	/**
	 * Read usb link info for the port that the specified device is connected to.
	 *
	 * @param context The fc2Context to be used.
	 * @param guid Unique PGRGuid for the device.
	 * @param pValue Value read from the card register.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetUsbLinkInfo(
				fc2Context context,
				@ByVal fc2PGRGuid guid,
				@Cast("unsigned int*") IntPointer pValue );
	public static native @Cast("fc2Error") int fc2GetUsbLinkInfo(
				fc2Context context,
				@ByVal fc2PGRGuid guid,
				@Cast("unsigned int*") IntBuffer pValue );
	public static native @Cast("fc2Error") int fc2GetUsbLinkInfo(
				fc2Context context,
				@ByVal fc2PGRGuid guid,
				@Cast("unsigned int*") int[] pValue );

	/**
	 * Read usb port status for the port that the specified device is connected to.
	 *
	 * @param context The fc2Context to be used.
	 * @param guid Unique PGRGuid for the device.
	 * @param pValue Value read from the card register.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetUsbPortStatus(
				fc2Context context,
				@ByVal fc2PGRGuid guid,
				@Cast("unsigned int*") IntPointer pValue );
	public static native @Cast("fc2Error") int fc2GetUsbPortStatus(
				fc2Context context,
				@ByVal fc2PGRGuid guid,
				@Cast("unsigned int*") IntBuffer pValue );
	public static native @Cast("fc2Error") int fc2GetUsbPortStatus(
				fc2Context context,
				@ByVal fc2PGRGuid guid,
				@Cast("unsigned int*") int[] pValue );

	/**
	 * Gets the topology information for the PC.
	 *
	 * @param context The fc2Context to be used.
	 * @param pTopologyNodeContext A Topology Node context that will contain
	 *							   the topology information
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetTopology(
				fc2Context context,
				@ByPtrPtr fc2TopologyNodeContext pTopologyNodeContext );

	/**
	 * Register a callback function that will be called when the
	 * specified callback event occurs.
	 *
	 * @param context The fc2Context to be used.
	 * @param enumCallback Pointer to function that will receive the callback.
	 * @param callbackType Type of callback to register for.
	 * @param pParameter Callback parameter to be passed to callback.
	 * @param pCallbackHandle Unique callback handle used for unregistering
	 *                        callback.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2RegisterCallback(
					fc2Context context,
					fc2BusEventCallback enumCallback,
					@Cast("fc2BusCallbackType") int callbackType,
					Pointer pParameter,
					@ByPtrPtr fc2CallbackHandle pCallbackHandle );

	/**
	 * Unregister a callback function.
	 *
	 * @param context The fc2Context to be used.
	 * @param callbackHandle Unique callback handle.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2UnregisterCallback(
					fc2Context context,
					fc2CallbackHandle callbackHandle );

	/**
	 * Force a rescan of the buses. This does not trigger a bus reset.
	 * However, any current connections to a Camera object will be
	 * invalidated.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2RescanBus( fc2Context context);

	/**
	 * Force the camera with the specific MAC address to the specified
	 * IP address, subnet mask and default gateway. This is useful in
	 * situations where a GigE Vision camera is using Persistent IP and the
	 * application's subnet is different from the device subnet.
	 *
	 * @param context The fc2Context to be used.
	 * @param macAddress MAC address of the camera.
	 * @param ipAddress IP address to set on the camera.
	 * @param subnetMask Subnet mask to set on the camera.
	 * @param defaultGateway Default gateway to set on the camera.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ForceIPAddressToCamera(
					fc2Context context,
					@ByVal fc2MACAddress macAddress,
					@ByVal fc2IPAddress ipAddress,
					@ByVal fc2IPAddress subnetMask,
					@ByVal fc2IPAddress defaultGateway );

	/**
	 * Force all cameras on the network to be assigned sequential IP addresses
	 * on the same subnet as the network adapters that they are connected to.
	 * This is useful in situations where a GigE Vision cameras are using
	 * Persistent IP addresses and the application's subnet is different from
	 * the devices.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ForceAllIPAddressesAutomatically();

	/**
	 * Force cameras on the network to be assigned sequential IP addresses
	 * on the same subnet as the network adapters that it is connected to.
	 * This is useful in situations where a GigE Vision cameras is using
	 * Persistent IP addresses and the application's subnet is different from
	 * the device.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ForceIPAddressAutomatically(@Cast("unsigned int") int serialNumber);

	/**
	 * Discover all cameras connected to the network even if they reside
	 * on a different subnet. This is useful in situations where a GigE
	 * camera is using Persistent IP and the application's subnet is
	 * different from the device subnet. After discovering the camera,
	 * it is easy to use ForceIPAddressToCamera() to set a different IP
	 * configuration.
	 *
	 * @param context The fc2Context to be used.
	 * @param gigECameras Pointer to an array of CameraInfo structures.
	 * @param arraySize Size of the array. Number of discovered cameras
	 *                  is returned in the same value.
	 *
	 * @return An Error indicating the success or failure of the function.
	 *         If the error is PGRERROR_BUFFER_TOO_SMALL then arraySize will
	 *         contain the minimum size needed for gigECameras array.
	 */
	public static native @Cast("fc2Error") int fc2DiscoverGigECameras(
					fc2Context context,
					fc2CameraInfo gigECameras,
					@Cast("unsigned int*") IntPointer arraySize  );
	public static native @Cast("fc2Error") int fc2DiscoverGigECameras(
					fc2Context context,
					fc2CameraInfo gigECameras,
					@Cast("unsigned int*") IntBuffer arraySize  );
	public static native @Cast("fc2Error") int fc2DiscoverGigECameras(
					fc2Context context,
					fc2CameraInfo gigECameras,
					@Cast("unsigned int*") int[] arraySize  );

	/**
	* Query whether a GigE camera is controllable.
	*
	* @param context The fc2Context to be used.
	* @param pGuid Unique PGRGuid for the camera.
	* @param pControllable True indicates camera is controllable
	*
	* @return A fc2Error indicating the success or failure of the function.
	*/
	public static native @Cast("fc2Error") int fc2IsCameraControlable(
				fc2Context context,
				fc2PGRGuid pGuid,
				@Cast("BOOL*") IntPointer pControlable);
	public static native @Cast("fc2Error") int fc2IsCameraControlable(
				fc2Context context,
				fc2PGRGuid pGuid,
				@Cast("BOOL*") IntBuffer pControlable);
	public static native @Cast("fc2Error") int fc2IsCameraControlable(
				fc2Context context,
				fc2PGRGuid pGuid,
				@Cast("BOOL*") int[] pControlable);
	/*@}*/

	/**
	* \defgroup CConnectionAndImage Connection and Image Retrieval
	*
	* \brief These functions deal with connections and image retrieval from
	* the camera.
	*/
	/*@{*/

	/**
	 * Connects the fc2Context to the camera specified by the GUID.
	 *
	 * @param context The fc2Context to be used.
	 * @param guid The unique identifier for a specific camera on the PC.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2Connect(
					fc2Context context,
					fc2PGRGuid guid );

	/**
	 * Disconnects the fc2Context from the camera. This allows another physical
	 * camera specified by a GUID to be connected to the fc2Context.
	 *
	 * @see fc2Connect()
	 *
	 * @param context The fc2Context to be used.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2Disconnect(
					fc2Context context );

	/**
	* Checks if the fc2Context is connected to a physical camera
	* specified by a GUID.	
	*
	* @see fc2Connect()
	* @see fc2Disconnect()
	*
	* @param context The fc2Context to be used.
	*
	* @return Whether fc2Connect() was called on the fc2Context.
	*/
	public static native @Cast("BOOL") int fc2IsConnected(
					fc2Context context );

	/**
	 * Sets the callback data to be used on completion of image transfer.
	 * To clear the current stored callback data, pass in NULL for both
	 * callback arguments.
	 *
	 * @see fc2StartCapture()
	 *
	 * @param context The fc2Context to be used.
	 * @param pCallbackFn A function to be called when a new image is received.
	 * @param pCallbackData A pointer to data that can be passed to the
	 *                      callback function.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetCallback(
					fc2Context context,
					fc2ImageEventCallback pCallbackFn,
					Pointer pCallbackData);

	/**
	 * Starts isochronous image capture. It will use either the current
	 * video mode or the most recently set video mode of the camera.
	 *
	 * @see fc2RetrieveBuffer()
	 * @see fc2StartSyncCapture()
	 * @see fc2StopCapture()
	 *
	 * @param context The fc2Context to be used.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2StartCapture(
					fc2Context context );

	/**
	 * Starts isochronous image capture. It will use either the current
	 * video mode or the most recently set video mode of the camera. The callback
	 * function is called when a new image is received from the camera.
	 *
	 * @see fc2RetrieveBuffer()
	 * @see fc2StartSyncCapture()
	 * @see fc2StopCapture()
	 *
	 * @param context The fc2Context to be used.
	 * @param pCallbackFn A function to be called when a new image is received.
	 * @param pCallbackData A pointer to data that can be passed to the
	 *                      callback function. A NULL pointer is acceptable.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2StartCaptureCallback(
					fc2Context context,
					fc2ImageEventCallback pCallbackFn,
					Pointer pCallbackData);

	/**
	 * Starts synchronized isochronous image capture on multiple cameras.
	 *
	 * @see fc2RetrieveBuffer()
	 * @see fc2StartCapture()
	 * @see fc2StopCapture()
	 *
	 * @param numCameras Number of fc2Contexts in the ppCameras array.
	 * @param pContexts Array of fc2Contexts.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2StartSyncCapture(
					@Cast("unsigned int") int numCameras,
					@Cast("fc2Context*") @ByPtrPtr fc2Context pContexts );

	/**
	 * Starts synchronized isochronous image capture on multiple cameras.
	 *
	 * @see fc2RetrieveBuffer()
	 * @see fc2StartCapture()
	 * @see fc2StopCapture()
	 *
	 * @param numCameras Number of fc2Contexts in the ppCameras array.
	 * @param pContexts Array of fc2Contexts.
	 * @param pCallbackFns Array of callback functions for each camera.
	 * @param pCallbackDataArray Array of callback data pointers.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2StartSyncCaptureCallback(
					@Cast("unsigned int") int numCameras,
					@Cast("fc2Context*") @ByPtrPtr fc2Context pContexts,
					@Cast("fc2ImageEventCallback*") @ByPtrPtr fc2ImageEventCallback pCallbackFns,
					@Cast("void**") PointerPointer pCallbackDataArray);
	public static native @Cast("fc2Error") int fc2StartSyncCaptureCallback(
					@Cast("unsigned int") int numCameras,
					@Cast("fc2Context*") @ByPtrPtr fc2Context pContexts,
					@Cast("fc2ImageEventCallback*") @ByPtrPtr fc2ImageEventCallback pCallbackFns,
					@Cast("void**") @ByPtrPtr Pointer pCallbackDataArray);

	/**
	 * Retrieves the next image object containing the next image.
	 *
	 * @see fc2StartCapture()
	 * @see fc2StopCapture()
	 *
	 * @param context The fc2Context to be used.
	 * @param pImage Pointer to fc2Image to store image data.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2RetrieveBuffer(
					fc2Context context,
					fc2Image pImage );

	/**
	 * Stops isochronous image transfer and cleans up all associated
	 * resources.
	 *
	 * @see fc2StartCapture()
	 * @see fc2RetrieveBuffer()
	 *
	 * @param context The fc2Context to be used.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2StopCapture(
					fc2Context context );

	/**
	 * Retrieves the next image event containing the next part of the image.
	 *
	 * @see fc2StartCapture()
	 * @see fc2RetrieveBuffer()
	 * @see fc2StopCapture()
	 *
	 * @param context The fc2Context to be used.
	 * @param pImage Pointer to fc2Image to store image data.
	 * @param eventNumber The event number to wait for.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2WaitForBufferEvent(
				fc2Context context,
				fc2Image pImage,
				@Cast("unsigned int") int eventNumber );

	/**
	 * Specify user allocated buffers to use as image data buffers.
	 * To prevent image tearing, the size of each buffer should be equal to
	 * ((unsigned int)(bufferSize + packetSize - 1)/packetSize) * packetSize.
	 * The total size should be (size * numBuffers) or larger.
	 * The packet Size that should be used differs between interfaces:
	 *	Firewire:	Use the Format7 packet size.
	 *  Usb2:		First round to Format7 packet size then round to 512 bytes.
	 *  Usb3:		Use a packet size of 1024 bytes.
	 *  GigE:		No need to do any rounding on GigE
	 *
	 * @see fc2StartCapture()
	 * @see fc2RetrieveBuffer()
	 * @see fc2StopCapture()
	 *
	 * @param context The fc2Context to be used.
	 * @param ppMemBuffers Pointer to memory buffers to be written to. The
	 *                     size of the data should be equal to
	 *                     (size * numBuffers) or larger.
	 * @param size The size of each buffer (in bytes).
	 * @param nNumBuffers Number of buffers in the array.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetUserBuffers(
					fc2Context context,
					@Cast("unsigned char*const") BytePointer ppMemBuffers,
					int size,
					int nNumBuffers );
	public static native @Cast("fc2Error") int fc2SetUserBuffers(
					fc2Context context,
					@Cast("unsigned char*const") ByteBuffer ppMemBuffers,
					int size,
					int nNumBuffers );
	public static native @Cast("fc2Error") int fc2SetUserBuffers(
					fc2Context context,
					@Cast("unsigned char*const") byte[] ppMemBuffers,
					int size,
					int nNumBuffers );

	/**
	 * Get the configuration associated with the camera.
	 *
	 * @see fc2SetConfiguration()
	 *
	 * @param context The fc2Context to be used.
	 * @param config Pointer to the configuration structure to be filled.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetConfiguration(
					fc2Context context,
					fc2Config config );

	/**
	 * Set the configuration associated with the camera.
	 *
	 * @see fc2GetConfiguration()
	 *
	 * @param context The fc2Context to be used.
	 * @param config Pointer to the configuration structure to be used.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetConfiguration(
					fc2Context context,
					fc2Config config );
	/*@}*/

	/**
	* \defgroup CInformationProperties Information and Properties
	*
	* \brief These functions deal with information and properties can be
	* retrieved from the camera.
	*/
	/*@{*/

	/**
	 * Retrieves information from the camera such as serial number, model
	 * name and other camera information.
	 *
	 * @param context The fc2Context to be used.
	 * @param pCameraInfo Pointer to the camera information structure
	 *                    to be filled.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetCameraInfo(
					fc2Context context,
					fc2CameraInfo pCameraInfo );

	/**
	 * Retrieves information about the specified camera property. The
	 * property type must be specified in the fc2PropertyInfo structure
	 * passed into the function in order for the function to succeed.
	 *
	 * @see fc2GetProperty()
	 * @see fc2SetProperty()
	 *
	 * @param context The fc2Context to be used.
	 * @param propInfo Pointer to the PropertyInfo structure to be filled.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetPropertyInfo(
					fc2Context context,
					fc2PropertyInfo propInfo );

	/**
	 * Reads the settings for the specified property from the camera. The
	 * property type must be specified in the fc2Property structure passed
	 * into the function in order for the function to succeed. If auto
	 * is on, the integer and abs values returned may not be consistent
	 * with each other.
	 *
	 * @see fc2GetPropertyInfo()
	 * @see fc2SetProperty()
	 *
	 * @param context The fc2Context to be used.
	 * @param prop Pointer to the Property structure to be filled.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetProperty(
					fc2Context context,
					fc2Property prop );

	/**
	 * Writes the settings for the specified property to the camera. The
	 * property type must be specified in the Property structure passed
	 * into the function in order for the function to succeed.
	 * The absControl flag controls whether the absolute or integer value
	 * is written to the camera. Use fc2GetPropertyInfo() to query which
	 * options are available for a specific property.
	 *
	 * @see fc2GetPropertyInfo()
	 * @see fc2GetProperty()
	 *
	 * @param context The fc2Context to be used.
	 * @param prop Pointer to the Property structure to be used.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetProperty(
					fc2Context context,
					fc2Property prop );

	/**
	 * Writes the settings for the specified property to the camera. The
	 * property type must be specified in the Property structure passed
	 * into the function in order for the function to succeed.
	 * The absControl flag controls whether the absolute or integer value
	 * is written to the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param prop Pointer to the Property structure to be used.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetPropertyBroadcast(
					fc2Context context,
					fc2Property prop );
	/*@}*/

	/**
	* \defgroup CGeneralPurposeIO General Purpose Input / Output
	*
	* \brief These functions deal with general GPIO pin control on the camera.
	*/
	/*@{*/

	/**
	 * Get the GPIO pin direction for the specified pin. This is not a
	 * required call when using the trigger or strobe functions as
	 * the pin direction is set automatically internally.
	 *
	 * @see fc2SetGPIOPinDirection()
	 * @see fc2SetGPIOPinDirectionBroadcast()
	 *
	 * @param context The fc2Context to be used.
	 * @param pin Pin to get the direction for.
	 * @param pDirection Direction of the pin. 0 for input, 1 for output.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetGPIOPinDirection(
					fc2Context context,
					@Cast("unsigned int") int pin,
					@Cast("unsigned int*") IntPointer pDirection );
	public static native @Cast("fc2Error") int fc2GetGPIOPinDirection(
					fc2Context context,
					@Cast("unsigned int") int pin,
					@Cast("unsigned int*") IntBuffer pDirection );
	public static native @Cast("fc2Error") int fc2GetGPIOPinDirection(
					fc2Context context,
					@Cast("unsigned int") int pin,
					@Cast("unsigned int*") int[] pDirection );

	/**
	 * Set the GPIO pin direction for the specified pin. This is useful if
	 * there is a need to set the pin into an input pin (i.e. to read the
	 * voltage) off the pin without setting it as a trigger source. This
	 * is not a required call when using the trigger or strobe functions as
	 * the pin direction is set automatically internally.
	 *
	 * @see fc2GetGPIOPinDirection()
	 * @see fc2SetGPIOPinDirectionBroadcast()
	 *
	 * @param context The fc2Context to be used.
	 * @param pin Pin to get the direction for.
	 * @param direction Direction of the pin. 0 for input, 1 for output.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetGPIOPinDirection(
					fc2Context context,
					@Cast("unsigned int") int pin,
					@Cast("unsigned int") int direction);

	/**
	 * Set the GPIO pin direction for the specified pin. This is useful if
	 * there is a need to set the pin into an input pin (i.e. to read the
	 * voltage) off the pin without setting it as a trigger source. This
	 * is not a required call when using the trigger or strobe functions as
	 * the pin direction is set automatically internally.
	 *
	 * @see fc2GetGPIOPinDirection()
	 *
	 * @param context The fc2Context to be used.
	 * @param pin Pin to get the direction for.
	 * @param direction Direction of the pin. 0 for input, 1 for output.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetGPIOPinDirectionBroadcast(
					fc2Context context,
					@Cast("unsigned int") int pin,
					@Cast("unsigned int") int direction);
	/*@}*/

	/**
	* \defgroup CTrigger Trigger
	*
	* \brief These functions deal with trigger control on the camera.
	*/
	/*@{*/

	/**
	 * Retrieve trigger information from the camera.
	 *
	 * @see fc2GetTriggerMode()
	 * @see fc2SetTriggerMode()
	 * @see fc2SetTriggerModeBroadcast()
	 * @see fc2GetTriggerDelayInfo()
	 * @see fc2GetTriggerDelay()
	 * @see fc2SetTriggerDelay()
	 *
	 * @param context The fc2Context to be used.
	 * @param triggerModeInfo Structure to receive trigger information.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetTriggerModeInfo(
					fc2Context context,
					fc2TriggerModeInfo triggerModeInfo );

	/**
	 * Retrieve current trigger settings from the camera.
	 *
	 * @see fc2GetTriggerModeInfo()
	 * @see fc2SetTriggerMode()
	 * @see fc2SetTriggerModeBroadcast()
	 * @see fc2GetTriggerDelayInfo()
	 * @see fc2GetTriggerDelay()
	 * @see fc2SetTriggerDelay()
	 *
	 * @param context The fc2Context to be used.
	 * @param triggerMode Structure to receive trigger mode settings.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetTriggerMode(
					fc2Context context,
					fc2TriggerMode triggerMode );

	/**
	 * Set the specified trigger settings to the camera.
	 *
	 * @see fc2GetTriggerModeInfo()
	 * @see fc2GetTriggerMode()
	 * @see fc2GetTriggerDelayInfo()
	 * @see fc2GetTriggerDelay()
	 * @see fc2SetTriggerDelay()
	 * @see fc2SetTriggerModeBroadcast()
	 *
	 * @param context The fc2Context to be used.
	 * @param triggerMode Structure providing trigger mode settings.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetTriggerMode(
					fc2Context context,
					fc2TriggerMode triggerMode );

	/**
	 * Set the specified trigger settings to the camera.
	 *
	 * @see fc2GetTriggerModeInfo()
	 * @see fc2GetTriggerMode()
	 * @see fc2GetTriggerDelayInfo()
	 * @see fc2GetTriggerDelay()
	 * @see fc2SetTriggerDelay()
	 * @see fc2SetTriggerMode()
	 *
	 * @param context The fc2Context to be used.
	 * @param triggerMode Structure providing trigger mode settings.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetTriggerModeBroadcast(
					fc2Context context,
					fc2TriggerMode triggerMode );

	/**
	 * Fire the software trigger according to the DCAM specifications.
	 *
	 * @param context The fc2Context to be used.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2FireSoftwareTrigger(
					fc2Context context );

	/**
	 * Fire the software trigger according to the DCAM specifications.
	 *
	 * @param context The fc2Context to be used.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2FireSoftwareTriggerBroadcast(
					fc2Context context );

	/**
	 * Retrieve trigger delay information from the camera.
	 *
	 * @see fc2GetTriggerModeInfo()
	 * @see fc2GetTriggerMode()
	 * @see fc2SetTriggerMode()
	 * @see fc2GetTriggerDelay()
	 * @see fc2SetTriggerDelay()
	 * @see fc2SetTriggerDelayBroadcast()
	 *
	 * @param context The fc2Context to be used.
	 * @param triggerDelayInfo Structure to receive trigger delay information.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetTriggerDelayInfo(
					fc2Context context,
					@Cast("fc2TriggerDelayInfo*") fc2PropertyInfo triggerDelayInfo );

	/**
	 * Retrieve current trigger delay settings from the camera.
	 *
	 * @see fc2GetTriggerModeInfo()
	 * @see fc2GetTriggerMode()
	 * @see fc2SetTriggerMode()
	 * @see fc2GetTriggerDelayInfo()
	 * @see fc2SetTriggerDelay()
	 * @see fc2SetTriggerDelayBroadcast()
	 *
	 * @param context The fc2Context to be used.
	 * @param triggerDelay Structure to receive trigger delay settings.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetTriggerDelay(
					fc2Context context,
					@Cast("fc2TriggerDelay*") fc2Property triggerDelay );

	/**
	 * Set the specified trigger delay settings to the camera.
	 *
	 * @see fc2GetTriggerModeInfo()
	 * @see fc2GetTriggerMode()
	 * @see fc2SetTriggerMode()
	 * @see fc2GetTriggerDelayInfo()
	 * @see fc2GetTriggerDelay()
	 * @see fc2SetTriggerDelayBroadcast()
	 *
	 * @param context The fc2Context to be used.
	 * @param triggerDelay Structure providing trigger delay settings.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetTriggerDelay(
					fc2Context context,
					@Cast("fc2TriggerDelay*") fc2Property triggerDelay );

	/**
	 * Set the specified trigger delay settings to the camera.
	 *
	 * @see fc2GetTriggerModeInfo()
	 * @see fc2GetTriggerMode()
	 * @see fc2SetTriggerMode()
	 * @see fc2GetTriggerDelayInfo()
	 * @see fc2GetTriggerDelay()
	 * @see fc2SetTriggerDelay()
	 *
	 * @param context The fc2Context to be used.
	 * @param triggerDelay Structure providing trigger delay settings.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetTriggerDelayBroadcast(
					fc2Context context,
					@Cast("fc2TriggerDelay*") fc2Property triggerDelay );
	/*@}*/

	/**
	* \defgroup CStrobe Strobe
	*
	* \brief These functions deal with strobe control on the camera.
	*/
	/*@{*/

	/**
	 * Retrieve strobe information from the camera.
	 *
	 * @see fc2GetStrobe()
	 * @see fc2SetStrobe()
	 * @see fc2SetStrobeBroadcast()
	 *
	 * @param context The fc2Context to be used.
	 * @param strobeInfo Structure to receive strobe information.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetStrobeInfo(
					fc2Context context,
					fc2StrobeInfo strobeInfo );

	/**
	 * Retrieve current strobe settings from the camera. The strobe pin
	 * must be specified in the structure before being passed in to
	 * the function.
	 *
	 * @see fc2GetStrobeInfo()
	 * @see fc2SetStrobe()
	 * @see fc2SetStrobeBroadcast()
	 *
	 * @param context The fc2Context to be used.
	 * @param strobeControl Structure to receive strobe settings.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetStrobe(
					fc2Context context,
					fc2StrobeControl strobeControl );

	/**
	 * Set current strobe settings to the camera. The strobe pin
	 * must be specified in the structure before being passed in to
	 * the function.
	 *
	 * @see fc2GetStrobeInfo()
	 * @see fc2GetStrobe()
	 * @see fc2SetStrobeBroadcast()
	 *
	 * @param context The fc2Context to be used.
	 * @param strobeControl Structure providing strobe settings.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetStrobe(
					fc2Context context,
					fc2StrobeControl strobeControl );

	/**
	 * Set current strobe settings to the camera. The strobe pin
	 * must be specified in the structure before being passed in to
	 * the function.
	 *
	 * @see fc2GetStrobeInfo()
	 * @see fc2GetStrobe()
	 * @see fc2SetStrobe()
	 *
	 * @param context The fc2Context to be used.
	 * @param strobeControl Structure providing strobe settings.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetStrobeBroadcast(
					fc2Context context,
					fc2StrobeControl strobeControl );
	/*@}*/

	/**
	* \defgroup CLookUp Look Up Table
	*
	* \brief These functions deal with Look Up Table control on the camera.
	*/
	/*@{*/

	/**
	 * Query if LUT support is available on the camera. Note that some cameras
	 * may report support for the LUT and return an inputBitDepth of 0. In these
	 * cases use log2(numEntries) for the inputBitDepth.
	 *
	 * @see fc2EnableLUT()
	 * @see fc2GetLUTChannel()
	 * @see fc2SetLUTChannel()
	 *
	 * @param context The fc2Context to be used.
	 * @param pData The LUT structure to be filled.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetLUTInfo(
					fc2Context context,
					fc2LUTData pData );

	/**
	 * Query the read/write status of a single LUT bank.
	 *
	 * @param context The fc2Context to be used.
	 * @param bank The bank to query.
	 * @param pReadSupported Whether reading from the bank is supported.
	 * @param pWriteSupported Whether writing to the bank is supported.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetLUTBankInfo(
					fc2Context context,
					@Cast("unsigned int") int bank,
					@Cast("BOOL*") IntPointer pReadSupported,
					@Cast("BOOL*") IntPointer pWriteSupported );
	public static native @Cast("fc2Error") int fc2GetLUTBankInfo(
					fc2Context context,
					@Cast("unsigned int") int bank,
					@Cast("BOOL*") IntBuffer pReadSupported,
					@Cast("BOOL*") IntBuffer pWriteSupported );
	public static native @Cast("fc2Error") int fc2GetLUTBankInfo(
					fc2Context context,
					@Cast("unsigned int") int bank,
					@Cast("BOOL*") int[] pReadSupported,
					@Cast("BOOL*") int[] pWriteSupported );

	/**
	 * Get the LUT bank that is currently being used. For cameras with
	 * PGR LUT, the active bank is always 0.
	 *
	 * @param context The fc2Context to be used.
	 * @param pActiveBank The currently active bank.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetActiveLUTBank(
					fc2Context context,
					@Cast("unsigned int*") IntPointer pActiveBank );
	public static native @Cast("fc2Error") int fc2GetActiveLUTBank(
					fc2Context context,
					@Cast("unsigned int*") IntBuffer pActiveBank );
	public static native @Cast("fc2Error") int fc2GetActiveLUTBank(
					fc2Context context,
					@Cast("unsigned int*") int[] pActiveBank );

	/**
	 * Set the LUT bank that will be used.
	 *
	 * @param context The fc2Context to be used.
	 * @param activeBank The bank to be set as active.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetActiveLUTBank(
					fc2Context context,
					@Cast("unsigned int") int activeBank );

	/**
	 * Enable or disable LUT functionality on the camera.
	 *
	 * @see fc2GetLUTInfo()
	 * @see fc2GetLUTChannel()
	 * @see fc2SetLUTChannel()
	 *
	 * @param context The fc2Context to be used.
	 * @param on Whether to enable or disable LUT.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2EnableLUT(
					fc2Context context,
					@Cast("BOOL") int on );

	/**
	 * Get the LUT channel settings from the camera.
	 *
	 * @see fc2GetLUTInfo()
	 * @see fc2EnableLUT()
	 * @see fc2SetLUTChannel()
	 *
	 * @param context The fc2Context to be used.
	 * @param bank Bank to retrieve.
	 * @param channel Channel to retrieve.
	 * @param sizeEntries Number of entries in LUT table to read.
	 * @param pEntries Array to store LUT entries.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetLUTChannel(
					fc2Context context,
					@Cast("unsigned int") int bank,
					@Cast("unsigned int") int channel,
					@Cast("unsigned int") int sizeEntries,
					@Cast("unsigned int*") IntPointer pEntries );
	public static native @Cast("fc2Error") int fc2GetLUTChannel(
					fc2Context context,
					@Cast("unsigned int") int bank,
					@Cast("unsigned int") int channel,
					@Cast("unsigned int") int sizeEntries,
					@Cast("unsigned int*") IntBuffer pEntries );
	public static native @Cast("fc2Error") int fc2GetLUTChannel(
					fc2Context context,
					@Cast("unsigned int") int bank,
					@Cast("unsigned int") int channel,
					@Cast("unsigned int") int sizeEntries,
					@Cast("unsigned int*") int[] pEntries );

	/**
	 * Set the LUT channel settings to the camera.
	 *
	 * @see fc2GetLUTInfo()
	 * @see fc2EnableLUT()
	 * @see fc2GetLUTChannel()
	 *
	 * @param context The fc2Context to be used.
	 * @param bank Bank to set.
	 * @param channel Channel to set.
	 * @param sizeEntries Number of entries in LUT table to write. This must be the
	 *					  same size as numEntries returned by GetLutInfo().
	 * @param pEntries Array containing LUT entries to write.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetLUTChannel(
					fc2Context context,
					@Cast("unsigned int") int bank,
					@Cast("unsigned int") int channel,
					@Cast("unsigned int") int sizeEntries,
					@Cast("unsigned int*") IntPointer pEntries );
	public static native @Cast("fc2Error") int fc2SetLUTChannel(
					fc2Context context,
					@Cast("unsigned int") int bank,
					@Cast("unsigned int") int channel,
					@Cast("unsigned int") int sizeEntries,
					@Cast("unsigned int*") IntBuffer pEntries );
	public static native @Cast("fc2Error") int fc2SetLUTChannel(
					fc2Context context,
					@Cast("unsigned int") int bank,
					@Cast("unsigned int") int channel,
					@Cast("unsigned int") int sizeEntries,
					@Cast("unsigned int*") int[] pEntries );
	/*@}*/

	/**
	* \defgroup CMemoryChannel Memory Channels
	*
	* \brief These functions deal with memory channel control on the camera.
	*/
	/*@{*/

	/**
	 * Retrieve the current memory channel from the camera.
	 *
	 * @see fc2SaveToMemoryChannel()
	 * @see fc2RestoreFromMemoryChannel()
	 * @see fc2GetMemoryChannelInfo()
	 *
	 * @param context The fc2Context to be used.
	 * @param pCurrentChannel Current memory channel.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetMemoryChannel(
					fc2Context context,
					@Cast("unsigned int*") IntPointer pCurrentChannel );
	public static native @Cast("fc2Error") int fc2GetMemoryChannel(
					fc2Context context,
					@Cast("unsigned int*") IntBuffer pCurrentChannel );
	public static native @Cast("fc2Error") int fc2GetMemoryChannel(
					fc2Context context,
					@Cast("unsigned int*") int[] pCurrentChannel );

	/**
	 * Save the current settings to the specified current memory channel.
	 *
	 * @see fc2GetMemoryChannel()
	 * @see fc2RestoreFromMemoryChannel()
	 * @see fc2GetMemoryChannelInfo()
	 *
	 * @param context The fc2Context to be used.
	 * @param channel Memory channel to save to.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SaveToMemoryChannel(
					fc2Context context,
					@Cast("unsigned int") int channel );

	/**
	 * Restore the specified current memory channel.
	 *
	 * @see fc2GetMemoryChannel()
	 * @see fc2SaveToMemoryChannel()
	 * @see fc2GetMemoryChannelInfo()
	 *
	 * @param context The fc2Context to be used.
	 * @param channel Memory channel to restore from.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2RestoreFromMemoryChannel(
					fc2Context context,
					@Cast("unsigned int") int channel );

	/**
	 * Query the camera for memory channel support. If the number of
	 * channels are 0, then memory channel support is not available.
	 *
	 * @see fc2GetMemoryChannel()
	 * @see fc2SaveToMemoryChannel()
	 * @see fc2RestoreFromMemoryChannel()
	 *
	 * @param context The fc2Context to be used.
	 * @param pNumChannels Number of memory channels supported.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetMemoryChannelInfo(
					fc2Context context,
					@Cast("unsigned int*") IntPointer pNumChannels );
	public static native @Cast("fc2Error") int fc2GetMemoryChannelInfo(
					fc2Context context,
					@Cast("unsigned int*") IntBuffer pNumChannels );
	public static native @Cast("fc2Error") int fc2GetMemoryChannelInfo(
					fc2Context context,
					@Cast("unsigned int*") int[] pNumChannels );

	/**
	 * Get the current status of the embedded image information register,
	 * as well as the availability of each embedded property.
	 *
	 * @see fc2SetEmbeddedImageInfo()
	 *
	 * @param context The fc2Context to be used.
	 * @param pInfo Structure to be filled.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetEmbeddedImageInfo(
					fc2Context context,
					fc2EmbeddedImageInfo pInfo );

	/**
	 * Sets the on/off values of the embedded image information structure
	 * to the camera.
	 *
	 * @see fc2GetEmbeddedImageInfo()
	 *
	 * @param context The fc2Context to be used.
	 * @param pInfo Structure to be used.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetEmbeddedImageInfo(
					fc2Context context,
					fc2EmbeddedImageInfo pInfo );
	/*@}*/

	/**
	* \defgroup CRegister Register Operation
	*
	* \brief These functions deal with register operation on the camera.
	*/
	/*@{*/

	/**
	 * Write to the specified register on the camera.
	 *
	 * @see fc2ReadRegister()
	 *
	 * @param context The fc2Context to be used.
	 * @param address DCAM address to be written to.
	 * @param value The value to be written.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2WriteRegister(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int") int value);

	/**
	 * Read the specified register from the camera.
	 *
	 * @see fc2WriteRegister()
	 *
	 * @param context The fc2Context to be used.
	 * @param address DCAM address to be read from.
	 * @param pValue The value that is read.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ReadRegister(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int*") IntPointer pValue );
	public static native @Cast("fc2Error") int fc2ReadRegister(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int*") IntBuffer pValue );
	public static native @Cast("fc2Error") int fc2ReadRegister(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int*") int[] pValue );

	/**
	 * Write to the specified register on the camera with broadcast.
	 *
	 * @see fc2ReadRegisterBlock()
	 *
	 * @param context The fc2Context to be used.
	 * @param address DCAM address to be written to.
	 * @param value The value to be written.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2WriteRegisterBroadcast(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int") int value);

	/**
	 * Write to the specified register block on the camera.
	 *
	 * @see fc2ReadRegisterBlock()
	 *
	 * @param context The fc2Context to be used.
	 * @param addressHigh Top 16 bits of the 48-bit absolute address to write to.
	 * @param addressLow Bottom 32 bits of the 48 bits absolute address to write to.
	 * @param pBuffer Array containing data to be written.
	 * @param length Size of array, in quadlets.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2WriteRegisterBlock(
					fc2Context context,
					@Cast("unsigned short") short addressHigh,
					@Cast("unsigned int") int addressLow,
					@Cast("const unsigned int*") IntPointer pBuffer,
					@Cast("unsigned int") int length );
	public static native @Cast("fc2Error") int fc2WriteRegisterBlock(
					fc2Context context,
					@Cast("unsigned short") short addressHigh,
					@Cast("unsigned int") int addressLow,
					@Cast("const unsigned int*") IntBuffer pBuffer,
					@Cast("unsigned int") int length );
	public static native @Cast("fc2Error") int fc2WriteRegisterBlock(
					fc2Context context,
					@Cast("unsigned short") short addressHigh,
					@Cast("unsigned int") int addressLow,
					@Cast("const unsigned int*") int[] pBuffer,
					@Cast("unsigned int") int length );

	/**
	 * Write to the specified register block on the camera.
	 *
	 * @see fc2WriteRegisterBlock()
	 *
	 * @param context The fc2Context to be used.
	 * @param addressHigh Top 16 bits of the 48-bit absolute address to read from.
	 * @param addressLow Bottom 32 bits of the 48 bits absolute address to read from.
	 * @param pBuffer Array to store read data.
	 * @param length Size of array, in quadlets.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ReadRegisterBlock(
					fc2Context context,
					@Cast("unsigned short") short addressHigh,
					@Cast("unsigned int") int addressLow,
					@Cast("unsigned int*") IntPointer pBuffer,
					@Cast("unsigned int") int length );
	public static native @Cast("fc2Error") int fc2ReadRegisterBlock(
					fc2Context context,
					@Cast("unsigned short") short addressHigh,
					@Cast("unsigned int") int addressLow,
					@Cast("unsigned int*") IntBuffer pBuffer,
					@Cast("unsigned int") int length );
	public static native @Cast("fc2Error") int fc2ReadRegisterBlock(
					fc2Context context,
					@Cast("unsigned short") short addressHigh,
					@Cast("unsigned int") int addressLow,
					@Cast("unsigned int*") int[] pBuffer,
					@Cast("unsigned int") int length );

	/**
	 * Returns a text representation of the register value.
	 *
	 * @param registerVal The register value to query.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("const char*") BytePointer fc2GetRegisterString(
					@Cast("unsigned int") int registerVal);
	/*@}*/

	/**
	 * Get cycle time from camera
	 *
	 * @param context The fc2Context to be used.
	 * @param Timestamp struct.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetCycleTime( fc2Context context, fc2TimeStamp pTimeStamp );

	/**
	 * Returns the camera diagnostic information.
	 *
	 * @param context The fc2Context to be used.
	 * @param pCameraStats Pointer to the fc2CameraStats structure.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetStats( fc2Context context, fc2CameraStats pCameraStats );

	/*
	 * Reset the camera diagnostic information.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	

	/**
	 * Register the camera to issue a custom callback function call for a
	 * specific device event.
	 *
	 * @param context The fc2Context to be used.
	 * @param pOpts Pointer to the EventOptions structure which defines the
	 *              callback function to use, the event for which to register
	 *              the device, and a pointer to user data (optional) to be
	 *              passed to the callback function.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2RegisterEvent(
					fc2Context context,
					fc2EventOptions pOpts );

	/**
	 *De-register an event previously registered with the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param pOpts Pointer to the EventOptions structure which defines the
	 *              callback function to use, the event for which to register
	 *              the device, and a pointer to user data (optional) to be
	 *              passed to the callback function. The callback function and
	 *              user data elements of the EventOptions structure are ignored
	 *              in this call, and just the event name within the structure is
	 *              used with this function call.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2DeregisterEvent(
					fc2Context context,
					fc2EventOptions pOpts );

	/**
	 * Register the camera to issue a custom callback function call for a
	 * specific device event.
	 *
	 * @param context The fc2Context to be used.
	 * @param pOpts Pointer to the EventOptions structure which defines the
	 *              callback function to use, the event for which to register
	 *              the device, and a pointer to user data (optional) to be
	 *              passed to the callback function. The event name element of
	 *              the structure is ignored with this function call. If a single
	 *              event has already been registered via RegisterEvent(), this
	 *              call will fail, as the user could accidentally change the
	 *              the internal callback function pointer for a queued event.
	 *              The user will need to de-register all registered events,
	 *              then call this function again.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2RegisterAllEvents(
					fc2Context context,
					fc2EventOptions pOpts );

	/*
	 * De-register all events registered with the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2DeregisterAllEvents(
					fc2Context context);

	/**
	* \defgroup CDCAMFormats DCAM Formats
	*
	* \brief These functions deal with DCAM video mode and frame rate
			 * on the camera.
	*/
	/*@{*/

	/**
	 * Query the camera to determine if the specified video mode and
	 * frame rate is supported.
	 *
	 * @param context The fc2Context to be used.
	 * @param videoMode Video mode to check.
	 * @param frameRate Frame rate to check.
	 * @param pSupported Whether the video mode and frame rate is supported.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetVideoModeAndFrameRateInfo(
					fc2Context context,
					@Cast("fc2VideoMode") int videoMode,
					@Cast("fc2FrameRate") int frameRate,
					@Cast("BOOL*") IntPointer pSupported);
	public static native @Cast("fc2Error") int fc2GetVideoModeAndFrameRateInfo(
					fc2Context context,
					@Cast("fc2VideoMode") int videoMode,
					@Cast("fc2FrameRate") int frameRate,
					@Cast("BOOL*") IntBuffer pSupported);
	public static native @Cast("fc2Error") int fc2GetVideoModeAndFrameRateInfo(
					fc2Context context,
					@Cast("fc2VideoMode") int videoMode,
					@Cast("fc2FrameRate") int frameRate,
					@Cast("BOOL*") int[] pSupported);

	/**
	 * Get the current video mode and frame rate from the camera. If
	 * the camera is in Format7, the video mode will be VIDEOMODE_FORMAT7
	 * and the frame rate will be FRAMERATE_FORMAT7.
	 *
	 * @param context The fc2Context to be used.
	 * @param videoMode Current video mode.
	 * @param frameRate Current frame rate.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetVideoModeAndFrameRate(
					fc2Context context,
					@Cast("fc2VideoMode*") IntPointer videoMode,
					@Cast("fc2FrameRate*") IntPointer frameRate );
	public static native @Cast("fc2Error") int fc2GetVideoModeAndFrameRate(
					fc2Context context,
					@Cast("fc2VideoMode*") IntBuffer videoMode,
					@Cast("fc2FrameRate*") IntBuffer frameRate );
	public static native @Cast("fc2Error") int fc2GetVideoModeAndFrameRate(
					fc2Context context,
					@Cast("fc2VideoMode*") int[] videoMode,
					@Cast("fc2FrameRate*") int[] frameRate );

	/**
	 * Set the specified video mode and frame rate to the camera. It is
	 * not possible to set the camera to VIDEOMODE_FORMAT7 or
	 * FRAMERATE_FORMAT7. Use the Format7 functions to set the camera
	 * into Format7.
	 *
	 * @param context The fc2Context to be used.
	 * @param videoMode Video mode to set to camera.
	 * @param frameRate Frame rate to set to camera.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetVideoModeAndFrameRate(
					fc2Context context,
					@Cast("fc2VideoMode") int videoMode,
					@Cast("fc2FrameRate") int frameRate );
	/*@}*/

	/**
	* \defgroup CFormat7 Format7
	*
	* \brief These functions deal with Format7 custom image control on the camera.
	*/
	/*@{*/

	/**
	 * Retrieve the availability of Format7 custom image mode and the
	 * camera capabilities for the specified Format7 mode. The mode must
	 * be specified in the Format7Info structure in order for the
	 * function to succeed.
	 *
	 * @param context The fc2Context to be used.
	 * @param info Structure to be filled with the capabilities of the specified
	 *             mode and the current state in the specified mode.
	 * @param pSupported Whether the specified mode is supported.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetFormat7Info(
					fc2Context context,
					fc2Format7Info info,
					@Cast("BOOL*") IntPointer pSupported );
	public static native @Cast("fc2Error") int fc2GetFormat7Info(
					fc2Context context,
					fc2Format7Info info,
					@Cast("BOOL*") IntBuffer pSupported );
	public static native @Cast("fc2Error") int fc2GetFormat7Info(
					fc2Context context,
					fc2Format7Info info,
					@Cast("BOOL*") int[] pSupported );

	/**
	 * Validates Format7ImageSettings structure and returns valid packet
	 * size information if the image settings are valid. The current
	 * image settings are cached while validation is taking place. The
	 * cached settings are restored when validation is complete.
	 *
	 * @param context The fc2Context to be used.
	 * @param imageSettings Structure containing the image settings.
	 * @param settingsAreValid Whether the settings are valid.
	 * @param packetInfo Packet size information that can be used to
	 *                   determine a valid packet size.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ValidateFormat7Settings(
					fc2Context context,
					fc2Format7ImageSettings imageSettings,
					@Cast("BOOL*") IntPointer settingsAreValid,
					fc2Format7PacketInfo packetInfo );
	public static native @Cast("fc2Error") int fc2ValidateFormat7Settings(
					fc2Context context,
					fc2Format7ImageSettings imageSettings,
					@Cast("BOOL*") IntBuffer settingsAreValid,
					fc2Format7PacketInfo packetInfo );
	public static native @Cast("fc2Error") int fc2ValidateFormat7Settings(
					fc2Context context,
					fc2Format7ImageSettings imageSettings,
					@Cast("BOOL*") int[] settingsAreValid,
					fc2Format7PacketInfo packetInfo );

	/**
	 * Get the current Format7 configuration from the camera. This call
	 * will only succeed if the camera is already in Format7.
	 *
	 * @param context The fc2Context to be used.
	 * @param imageSettings Current image settings.
	 * @param packetSize Current packet size.
	 * @param percentage Current packet size as a percentage.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetFormat7Configuration(
					fc2Context context,
					fc2Format7ImageSettings imageSettings,
					@Cast("unsigned int*") IntPointer packetSize,
					FloatPointer percentage );
	public static native @Cast("fc2Error") int fc2GetFormat7Configuration(
					fc2Context context,
					fc2Format7ImageSettings imageSettings,
					@Cast("unsigned int*") IntBuffer packetSize,
					FloatBuffer percentage );
	public static native @Cast("fc2Error") int fc2GetFormat7Configuration(
					fc2Context context,
					fc2Format7ImageSettings imageSettings,
					@Cast("unsigned int*") int[] packetSize,
					float[] percentage );

	/**
	 * Set the current Format7 configuration to the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param imageSettings Image settings to be written to the camera.
	 * @param packetSize Packet size to be written to the camera.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetFormat7ConfigurationPacket(
					fc2Context context,
					fc2Format7ImageSettings imageSettings,
					@Cast("unsigned int") int packetSize );

	/**
	 * Set the current Format7 configuration to the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param imageSettings Image settings to be written to the camera.
	 * @param percentSpeed Packet size as a percentage to be written to the camera.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetFormat7Configuration(
					fc2Context context,
					fc2Format7ImageSettings imageSettings,
					float percentSpeed );
	/*@}*/

	/**
	* \defgroup CGVCPRegister GVCP Register Operation
	*
	* \brief These functions deal with GVCP register operation on the camera.
	*/
	/*@{*/

	/**
	 * Write a GVCP register.
	 *
	 * @param context The fc2Context to be used.
	 * @param address GVCP address to be written to.
	 * @param value The value to be written.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2WriteGVCPRegister(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int") int value);

	/**
	 * Write a GVCP register with broadcast
	 *
	 * @param context The fc2Context to be used.
	 * @param address GVCP address to be written to.
	 * @param value The value to be written.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2WriteGVCPRegisterBroadcast(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int") int value);

	/**
	 * Read a GVCP register.
	 *
	 * @param context The fc2Context to be used.
	 * @param address GVCP address to be read from.
	 * @param pValue The value that is read.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ReadGVCPRegister(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int*") IntPointer pValue );
	public static native @Cast("fc2Error") int fc2ReadGVCPRegister(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int*") IntBuffer pValue );
	public static native @Cast("fc2Error") int fc2ReadGVCPRegister(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int*") int[] pValue );

	/**
	 * Write a GVCP register block.
	 *
	 * @param context The fc2Context to be used.
	 * @param address GVCP address to be write to.
	 * @param pBuffer Array containing data to be written.
	 * @param length Size of array, in quadlets.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2WriteGVCPRegisterBlock(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("const unsigned int*") IntPointer pBuffer,
					@Cast("unsigned int") int length );
	public static native @Cast("fc2Error") int fc2WriteGVCPRegisterBlock(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("const unsigned int*") IntBuffer pBuffer,
					@Cast("unsigned int") int length );
	public static native @Cast("fc2Error") int fc2WriteGVCPRegisterBlock(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("const unsigned int*") int[] pBuffer,
					@Cast("unsigned int") int length );

	/**
	 * Read a GVCP register block.
	 *
	 * @param context The fc2Context to be used.
	 * @param address GVCP address to be read from.
	 * @param pBuffer Array containing data to be written.
	 * @param length Size of array, in quadlets.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ReadGVCPRegisterBlock(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int*") IntPointer pBuffer,
					@Cast("unsigned int") int length );
	public static native @Cast("fc2Error") int fc2ReadGVCPRegisterBlock(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int*") IntBuffer pBuffer,
					@Cast("unsigned int") int length );
	public static native @Cast("fc2Error") int fc2ReadGVCPRegisterBlock(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned int*") int[] pBuffer,
					@Cast("unsigned int") int length );

	/**
	 * Write a GVCP memory block.
	 *
	 * @param context The fc2Context to be used.
	 * @param address GVCP address to be write to.
	 * @param pBuffer Array containing data to be written.
	 * @param length Size of array, in quadlets.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2WriteGVCPMemory(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("const unsigned char*") BytePointer pBuffer,
					@Cast("unsigned int") int length );
	public static native @Cast("fc2Error") int fc2WriteGVCPMemory(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("const unsigned char*") ByteBuffer pBuffer,
					@Cast("unsigned int") int length );
	public static native @Cast("fc2Error") int fc2WriteGVCPMemory(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("const unsigned char*") byte[] pBuffer,
					@Cast("unsigned int") int length );

	/**
	 * Read a GVCP memory block.
	 *
	 * @param context The fc2Context to be used.
	 * @param address GVCP address to be read from.
	 * @param pBuffer Array containing data to be written.
	 * @param length Size of array, in quadlets.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ReadGVCPMemory(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned char*") BytePointer pBuffer,
					@Cast("unsigned int") int length );
	public static native @Cast("fc2Error") int fc2ReadGVCPMemory(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned char*") ByteBuffer pBuffer,
					@Cast("unsigned int") int length );
	public static native @Cast("fc2Error") int fc2ReadGVCPMemory(
					fc2Context context,
					@Cast("unsigned int") int address,
					@Cast("unsigned char*") byte[] pBuffer,
					@Cast("unsigned int") int length );
	/*@}*/


	/**
	* \defgroup CGEVProperty GigE property manipulation
	*
	* \brief These functions deal with GigE properties.
	*/
	/*@{*/

	/**
	 * Get the specified GigEProperty. The GigEPropertyType field must
	 * be set in order for this function to succeed.
	 *
	 * @param context The fc2Context to be used.
	 * @param pGigEProp The GigE property to get.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetGigEProperty(
					fc2Context context,
					fc2GigEProperty pGigEProp );

	/**
	 * Set the specified GigEProperty. The GigEPropertyType field must
	 * be set in order for this function to succeed.
	 *
	 * @param context The fc2Context to be used.
	 * @param pGigEProp The GigE property to set.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetGigEProperty(
					fc2Context context,
					@Const fc2GigEProperty pGigEProp );

	/**
	 * Discover the largest packet size that works for the network link
	 * between the PC and the camera. This is useful in cases where
	 * there may be multiple links between the PC and the camera and
	 * there is a possibility of a component not supporting the
	 * recommended jumbo frame packet size of 9000.
	 *
	 * @param context The fc2Context to be used.
	 * @param packetSize The maximum packet size supported by the link.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2DiscoverGigEPacketSize(
				fc2Context context,
				@Cast("unsigned int*") IntPointer packetSize );
	public static native @Cast("fc2Error") int fc2DiscoverGigEPacketSize(
				fc2Context context,
				@Cast("unsigned int*") IntBuffer packetSize );
	public static native @Cast("fc2Error") int fc2DiscoverGigEPacketSize(
				fc2Context context,
				@Cast("unsigned int*") int[] packetSize );
	/*@}*/

	/**
	* \defgroup CGEVImageSettings GigE image settings
	*
	* \brief These functions deal with GigE image setting.
	*/
	/*@{*/

	/**
	 * Check if the particular imaging mode is supported by the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param mode The mode to check.
	 * @param isSupported Whether the mode is supported.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2QueryGigEImagingMode(
					fc2Context context,
					@Cast("fc2Mode") int mode,
					@Cast("BOOL*") IntPointer isSupported );
	public static native @Cast("fc2Error") int fc2QueryGigEImagingMode(
					fc2Context context,
					@Cast("fc2Mode") int mode,
					@Cast("BOOL*") IntBuffer isSupported );
	public static native @Cast("fc2Error") int fc2QueryGigEImagingMode(
					fc2Context context,
					@Cast("fc2Mode") int mode,
					@Cast("BOOL*") int[] isSupported );

	/**
	 * Get the current imaging mode on the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param mode Current imaging mode on the camera.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetGigEImagingMode(
					fc2Context context,
					@Cast("fc2Mode*") IntPointer mode );
	public static native @Cast("fc2Error") int fc2GetGigEImagingMode(
					fc2Context context,
					@Cast("fc2Mode*") IntBuffer mode );
	public static native @Cast("fc2Error") int fc2GetGigEImagingMode(
					fc2Context context,
					@Cast("fc2Mode*") int[] mode );

	/**
	 * Set the current imaging mode to the camera. This should only be
	 * done when the camera is not streaming images.
	 *
	 * @param context The fc2Context to be used.
	 * @param mode Imaging mode to set to the camera.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetGigEImagingMode(
					fc2Context context,
					@Cast("fc2Mode") int mode );

	/**
	 * Get information about the image settings possible on the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param pInfo Image settings information.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetGigEImageSettingsInfo(
					fc2Context context,
					fc2GigEImageSettingsInfo pInfo );

	/**
	 * Get the current image settings on the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param pImageSettings Current image settings on camera.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetGigEImageSettings(
					fc2Context context,
					fc2GigEImageSettings pImageSettings );

	/**
	 * Set the image settings specified to the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param pImageSettings Image settings to set to camera.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetGigEImageSettings(
					fc2Context context,
					@Const fc2GigEImageSettings pImageSettings );
	/*@}*/

	/**
	* \defgroup CGEVImageBinningSettings GigE image binning settings
	*
	* \brief These functions deal with GigE image binning settings.
	*/
	/*@{*/

	/**
	 * Get the current binning settings on the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param horzBinnningValue Current horizontal binning value.
	 * @param vertBinnningValue Current vertical binning value.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetGigEImageBinningSettings(
					fc2Context context,
					@Cast("unsigned int*") IntPointer horzBinnningValue,
					@Cast("unsigned int*") IntPointer vertBinnningValue );
	public static native @Cast("fc2Error") int fc2GetGigEImageBinningSettings(
					fc2Context context,
					@Cast("unsigned int*") IntBuffer horzBinnningValue,
					@Cast("unsigned int*") IntBuffer vertBinnningValue );
	public static native @Cast("fc2Error") int fc2GetGigEImageBinningSettings(
					fc2Context context,
					@Cast("unsigned int*") int[] horzBinnningValue,
					@Cast("unsigned int*") int[] vertBinnningValue );

	/**
	 * Set the specified binning values to the camera. It is recommended
	 * that GetGigEImageSettingsInfo() be called after this function
	 * succeeds to retrieve the new image settings information for
	 * the new binning mode.
	 *
	 * @param context The fc2Context to be used.
	 * @param horzBinnningValue Horizontal binning value.
	 * @param vertBinnningValue Vertical binning value.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetGigEImageBinningSettings(
					fc2Context context,
					@Cast("unsigned int") int horzBinnningValue,
					@Cast("unsigned int") int vertBinnningValue );
	/*@}*/

	/**
	* \defgroup CGEVImageStreamConfig GigE image stream configuration
	*
	* \brief These functions deal with GigE image stream configuration.
	*/
	/*@{*/

	/**
	 * Get the number of stream channels present on the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param numChannels Number of stream channels present.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetNumStreamChannels(
					fc2Context context,
					@Cast("unsigned int*") IntPointer numChannels );
	public static native @Cast("fc2Error") int fc2GetNumStreamChannels(
					fc2Context context,
					@Cast("unsigned int*") IntBuffer numChannels );
	public static native @Cast("fc2Error") int fc2GetNumStreamChannels(
					fc2Context context,
					@Cast("unsigned int*") int[] numChannels );

	/**
	 * Get the stream channel information for the specified channel.
	 *
	 * @param context The fc2Context to be used.
	 * @param channel Channel number to use.
	 * @param pChannel Stream channel information for the specified channel.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetGigEStreamChannelInfo(
					fc2Context context,
					@Cast("unsigned int") int channel,
					fc2GigEStreamChannel pChannel );

	/**
	 * Set the stream channel information for the specified channel.
	 *
	 * Note that the source UDP port of the stream channel is read-only.
	 *
	 * @param context The fc2Context to be used.
	 * @param channel Channel number to use.
	 * @param pChannel Stream channel information to use for the specified channel.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetGigEStreamChannelInfo(
					fc2Context context,
					@Cast("unsigned int") int channel,
					fc2GigEStreamChannel pChannel );

	/**
	 * Get the current gige config on the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param pGigEConfig Current configuration on camera.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetGigEConfig(
					fc2Context context,
					fc2GigEConfig pConfig );

	/**
	 * Set the gige config specified to the camera.
	 *
	 * @param context The fc2Context to be used.
	 * @param pGigEConfig configuration to set to camera.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetGigEConfig(
					fc2Context context,
					@Const fc2GigEConfig pConfig );
	/*@}*/

	/**
	* \defgroup CImage Image Operation
	*
	* \brief The Image operations are used to retrieve images from a camera,
	* convert between multiple pixel formats and save images to disk.
	* Operations on images are not guaranteed to be thread safe. It is
	* recommended that operations on images be protected by thread
	* synchronization constructs such as mutexes.
	*/
	/*@{*/

	/**
	 * Set the default color processing algorithm.  This method will be
	 * used for any image with the DEFAULT algorithm set. The method used
	 * is determined at the time of the Convert() call, therefore the most
	 * recent execution of this function will take precedence. The default
	 * setting is shared within the current process.
	 *
	 * @param defaultMethod The color processing algorithm to set.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetDefaultColorProcessing(
					@Cast("fc2ColorProcessingAlgorithm") int defaultMethod );

	/**
	 * Get the default color processing algorithm.
	 *
	 * @param pDefaultMethod The default color processing algorithm.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetDefaultColorProcessing(
					@Cast("fc2ColorProcessingAlgorithm*") IntPointer pDefaultMethod );
	public static native @Cast("fc2Error") int fc2GetDefaultColorProcessing(
					@Cast("fc2ColorProcessingAlgorithm*") IntBuffer pDefaultMethod );
	public static native @Cast("fc2Error") int fc2GetDefaultColorProcessing(
					@Cast("fc2ColorProcessingAlgorithm*") int[] pDefaultMethod );

	/**
	 * Set the default output pixel format. This format will be used for any
	 * call to Convert() that does not specify an output format. The format
	 * used will be determined at the time of the Convert() call, therefore
	 * the most recent execution of this function will take precedence.
	 * The default is shared within the current process.
	 *
	 * @param format The output pixel format to set.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetDefaultOutputFormat(
					@Cast("fc2PixelFormat") int format );

	/**
	 * Get the default output pixel format.
	 *
	 * @param pFormat The default pixel format.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetDefaultOutputFormat(
					@Cast("fc2PixelFormat*") IntPointer pFormat );
	public static native @Cast("fc2Error") int fc2GetDefaultOutputFormat(
					@Cast("fc2PixelFormat*") IntBuffer pFormat );
	public static native @Cast("fc2Error") int fc2GetDefaultOutputFormat(
					@Cast("fc2PixelFormat*") int[] pFormat );

	/**
	 * Calculate the bits per pixel for the specified pixel format.
	 *
	 * @param format The pixel format.
	 * @param pBitsPerPixel The bits per pixel.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2DetermineBitsPerPixel(
					@Cast("fc2PixelFormat") int format,
					@Cast("unsigned int*") IntPointer pBitsPerPixel );
	public static native @Cast("fc2Error") int fc2DetermineBitsPerPixel(
					@Cast("fc2PixelFormat") int format,
					@Cast("unsigned int*") IntBuffer pBitsPerPixel );
	public static native @Cast("fc2Error") int fc2DetermineBitsPerPixel(
					@Cast("fc2PixelFormat") int format,
					@Cast("unsigned int*") int[] pBitsPerPixel );

	/**
	 * Create a fc2Image. If externally allocated memory is to be used for the
	 * converted image, simply assigning the pData member of the fc2Image structure
	 * is insufficient. fc2SetImageData() should be called in order to populate
	 * the fc2Image structure correctly.
	 *
	 * @see fc2SetImageData()
	 *
	 * @param pImage Pointer to image to be created.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2CreateImage(
					fc2Image pImage );

	/**
	 * Destroy the fc2Image.
	 *
	 * @param image Pointer to image to be destroyed.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2DestroyImage(
					fc2Image image );

	/**
	 * Sets the dimensions of the image object.
	 *
	 * @param pImage The fc2Image to be used.
	 * @param rows Number of rows to set.
	 * @param cols Number of cols to set.
	 * @param stride Stride to set.
	 * @param pixelFormat Pixel format to set.
	 * @param bayerFormat Bayer tile format to set.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetImageDimensions(
					fc2Image pImage,
					@Cast("unsigned int") int rows,
					@Cast("unsigned int") int cols,
					@Cast("unsigned int") int stride,
					@Cast("fc2PixelFormat") int pixelFormat,
					@Cast("fc2BayerTileFormat") int bayerFormat);

	/**
	* Get the image dimensions associated with the image object.
	*
	* @param pImage The fc2Image to be used.
	* @param pRows Number of rows.
	* @param pCols Number of columns.
	* @param pStride The stride.
	* @param pPixelFormat Pixel format.
	* @param pBayerFormat Bayer tile format.
	*/
	public static native @Cast("fc2Error") int fc2GetImageDimensions(
					fc2Image pImage,
					@Cast("unsigned int*") IntPointer pRows,
					@Cast("unsigned int*") IntPointer pCols,
					@Cast("unsigned int*") IntPointer pStride,
					@Cast("fc2PixelFormat*") IntPointer pPixelFormat,
					@Cast("fc2BayerTileFormat*") IntPointer pBayerFormat);
	public static native @Cast("fc2Error") int fc2GetImageDimensions(
					fc2Image pImage,
					@Cast("unsigned int*") IntBuffer pRows,
					@Cast("unsigned int*") IntBuffer pCols,
					@Cast("unsigned int*") IntBuffer pStride,
					@Cast("fc2PixelFormat*") IntBuffer pPixelFormat,
					@Cast("fc2BayerTileFormat*") IntBuffer pBayerFormat);
	public static native @Cast("fc2Error") int fc2GetImageDimensions(
					fc2Image pImage,
					@Cast("unsigned int*") int[] pRows,
					@Cast("unsigned int*") int[] pCols,
					@Cast("unsigned int*") int[] pStride,
					@Cast("fc2PixelFormat*") int[] pPixelFormat,
					@Cast("fc2BayerTileFormat*") int[] pBayerFormat);

	/**
	 * Set the color processing algorithm. This should be set on the
	 * input image object.
	 *
	 * @param pImage The fc2Image to be used.
	 * @param colorProc The color processing algorithm to use.
	 *
	 * @see fc2GetColorProcessing()
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetImageColorProcessing(
					fc2Image pImage,
					@Cast("fc2ColorProcessingAlgorithm") int colorProc);

	/**
	* Get the current color processing algorithm.
	*
	* @param pImage The fc2Image to be used.
	*
	* @see fc2SetColorProcessing()
	*
	* @return The current color processing algorithm.
	*/
	public static native @Cast("fc2Error") int fc2GetImageColorProcessing(
					fc2Image pImage,
					@Cast("fc2ColorProcessingAlgorithm*") IntPointer pColorProc);
	public static native @Cast("fc2Error") int fc2GetImageColorProcessing(
					fc2Image pImage,
					@Cast("fc2ColorProcessingAlgorithm*") IntBuffer pColorProc);
	public static native @Cast("fc2Error") int fc2GetImageColorProcessing(
					fc2Image pImage,
					@Cast("fc2ColorProcessingAlgorithm*") int[] pColorProc);

	/**
	 * Set the data of the Image object.
	 * Ownership of the image buffer is not transferred to the Image object.
	 * It is the user's responsibility to delete the buffer when it is
	 * no longer in use.
	 *
	 * @param pImage The fc2Image to be used.
	 * @param pData Pointer to the image buffer.
	 * @param dataSize Size of the image buffer.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetImageData(
					fc2Image pImage,
					@Cast("const unsigned char*") BytePointer pData,
					@Cast("unsigned int") int dataSize);
	public static native @Cast("fc2Error") int fc2SetImageData(
					fc2Image pImage,
					@Cast("const unsigned char*") ByteBuffer pData,
					@Cast("unsigned int") int dataSize);
	public static native @Cast("fc2Error") int fc2SetImageData(
					fc2Image pImage,
					@Cast("const unsigned char*") byte[] pData,
					@Cast("unsigned int") int dataSize);

	/**
	 * Get a pointer to the data associated with the image. This function
	 * is considered unsafe. The pointer returned could be invalidated if
	 * the buffer is resized or released. The pointer may also be
	 * invalidated if the Image object is passed to fc2RetrieveBuffer().
	 *
	 * @param pImage The fc2Image to be used.
	 * @param ppData A pointer to the image data.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetImageData(
					fc2Image pImage,
					@Cast("unsigned char**") PointerPointer ppData);
	public static native @Cast("fc2Error") int fc2GetImageData(
					fc2Image pImage,
					@Cast("unsigned char**") @ByPtrPtr BytePointer ppData);
	public static native @Cast("fc2Error") int fc2GetImageData(
					fc2Image pImage,
					@Cast("unsigned char**") @ByPtrPtr ByteBuffer ppData);
	public static native @Cast("fc2Error") int fc2GetImageData(
					fc2Image pImage,
					@Cast("unsigned char**") @ByPtrPtr byte[] ppData);

	/**
	 * Get the metadata associated with the image. This includes
	 * embedded image information.
	 *
	 * @param pImage The fc2Image to be used.
	 *
	 * @return Metadata associated with the image.
	 */
	public static native @Cast("fc2Error") int fc2GetImageMetadata(
					fc2Image pImage,
					fc2ImageMetadata pImageMetaData);

	/**
	 * Get the timestamp data associated with the image.
	 *
	 * @param pImage The fc2Image to be used.
	 *
	 * @return Timestamp data associated with the image.
	 */
	public static native @ByVal fc2TimeStamp fc2GetImageTimeStamp(
					fc2Image pImage);

	/**
	 * Save the image to the specified file name with the file format
	 * specified.
	 *
	 * @param pImage The fc2Image to be used.
	 * @param pFilename Filename to save image with.
	 * @param format File format to save in.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SaveImage(
					fc2Image pImage,
					@Cast("const char*") BytePointer pFilename,
					@Cast("fc2ImageFileFormat") int format );
	public static native @Cast("fc2Error") int fc2SaveImage(
					fc2Image pImage,
					String pFilename,
					@Cast("fc2ImageFileFormat") int format );

	/**
	 * Save the image to the specified file name with the file format
	 * specified.
	 *
	 * @param pImage The fc2Image to be used.
	 * @param pFilename Filename to save image with.
	 * @param format File format to save in.
	 * @param pOption Options for saving image.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SaveImageWithOption(
					fc2Image pImage,
					@Cast("const char*") BytePointer pFilename,
					@Cast("fc2ImageFileFormat") int format,
					Pointer pOption );
	public static native @Cast("fc2Error") int fc2SaveImageWithOption(
					fc2Image pImage,
					String pFilename,
					@Cast("fc2ImageFileFormat") int format,
					Pointer pOption );

	/**
	 *
	 *
	 * @param pImageIn
	 * @param pImageOut
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ConvertImage(
					fc2Image pImageIn,
					fc2Image pImageOut );

	/**
	 * Converts the current image buffer to the specified output format and
	 * stores the result in the specified image. The destination image
	 * does not need to be configured in any way before the call is made.
	 *
	 * @param format Output format of the converted image.
	 * @param pImageIn Input image.
	 * @param pImageOut Output image.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ConvertImageTo(
					@Cast("fc2PixelFormat") int format,
					fc2Image pImageIn,
					fc2Image pImageOut );

	/**
	 * Calculate statistics associated with the image. In order to collect
	 * statistics for a particular channel, the enabled flag for the
	 * channel must be set to true. Statistics can only be collected for
	 * images in Mono8, Mono16, RGB, RGBU, BGR and BGRU.
	 *
	 * @param pImage The fc2Image to be used.
	 * @param pImageStatisticsContext The fc2ImageStatisticsContext to hold the
	 *                                statistics.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2CalculateImageStatistics(
					fc2Image pImage,
					@ByPtrPtr fc2ImageStatisticsContext pImageStatisticsContext );
	/*@}*/

	/**
	* \defgroup CImageStatistics Image Statistics Operation
	*
	* \brief The Image Statistics operation provides the functionality for the user to collect
	* image channel statistics.
	*/
	/*@{*/

	/**
	 * Create a statistics context.
	 *
	 * @param pImageStatisticsContext A statistics context.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2CreateImageStatistics(
					@ByPtrPtr fc2ImageStatisticsContext pImageStatisticsContext );

	/**
	 * Destroy a statistics context.
	 *
	 * @param imageStatisticsContext A statistics context.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2DestroyImageStatistics(
					fc2ImageStatisticsContext imageStatisticsContext );


	/**
	 * Enable all channels.
	 *
	 * @param imageStatisticsContext A statistics context.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ImageStatisticsEnableAll(
				fc2ImageStatisticsContext imageStatisticsContext );

	/**
	 * Disable all channels.
	 *
	 * @param imageStatisticsContext A statistics context.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ImageStatisticsDisableAll(
				fc2ImageStatisticsContext imageStatisticsContext );

	/**
	 * Enable only the grey channel.
	 *
	 * @param imageStatisticsContext A statistics context.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ImageStatisticsEnableGreyOnly(
				fc2ImageStatisticsContext imageStatisticsContext );

	/**
	 * Enable only the RGB channels.
	 *
	 * @param imageStatisticsContext A statistics context.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ImageStatisticsEnableRGBOnly(
				fc2ImageStatisticsContext imageStatisticsContext );

	/**
	 * Enable only the HSL channels.
	 *
	 * @param imageStatisticsContext A statistics context.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2ImageStatisticsEnableHSLOnly(
				fc2ImageStatisticsContext imageStatisticsContext );

	/**
	 * Get the status of a statistics channel.
	 *
	 * @see fc2SetChannelStatus()
	 *
	 * @param imageStatisticsContext A statistics context.
	 * @param channel The statistics channel.
	 * @param pEnabled Whether the channel is enabled.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetChannelStatus(
					fc2ImageStatisticsContext imageStatisticsContext,
					@Cast("fc2StatisticsChannel") int channel,
					@Cast("BOOL*") IntPointer pEnabled );
	public static native @Cast("fc2Error") int fc2GetChannelStatus(
					fc2ImageStatisticsContext imageStatisticsContext,
					@Cast("fc2StatisticsChannel") int channel,
					@Cast("BOOL*") IntBuffer pEnabled );
	public static native @Cast("fc2Error") int fc2GetChannelStatus(
					fc2ImageStatisticsContext imageStatisticsContext,
					@Cast("fc2StatisticsChannel") int channel,
					@Cast("BOOL*") int[] pEnabled );

	/**
	 * Set the status of a statistics channel.
	 *
	 * @see fc2GetChannelStatus()
	 *
	 * @param imageStatisticsContext A statistics context.
	 * @param channel The statistics channel.
	 * @param enabled Whether the channel should be enabled.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2SetChannelStatus(
					fc2ImageStatisticsContext imageStatisticsContext,
					@Cast("fc2StatisticsChannel") int channel,
					@Cast("BOOL") int enabled );

	/**
	 * Get the range of a statistics channel. The values returned
	 * are the maximum possible values for any given pixel in the image.
	 * This is generally 0-255 for 8 bit images, and 0-65535 for
	 * 16 bit images.
	 *
	 * @param imageStatisticsContext A statistics context.
	 * @param channel The statistics channel.
	 * @param pMin The minimum possible value.
	 * @param pMax The maximum possible value.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetChannelRange(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@Cast("unsigned int*") IntPointer pMin,
				@Cast("unsigned int*") IntPointer pMax );
	public static native @Cast("fc2Error") int fc2GetChannelRange(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@Cast("unsigned int*") IntBuffer pMin,
				@Cast("unsigned int*") IntBuffer pMax );
	public static native @Cast("fc2Error") int fc2GetChannelRange(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@Cast("unsigned int*") int[] pMin,
				@Cast("unsigned int*") int[] pMax );

	/**
	 * Get the range of a statistics channel. The values returned
	 * are the maximum values recorded for all pixels in the image.
	 *
	 * @param imageStatisticsContext A statistics context.
	 * @param channel The statistics channel.
	 * @param pPixelValueMin The minimum pixel value.
	 * @param pPixelValueMax The maximum pixel value.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetChannelPixelValueRange(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@Cast("unsigned int*") IntPointer pPixelValueMin,
				@Cast("unsigned int*") IntPointer pPixelValueMax );
	public static native @Cast("fc2Error") int fc2GetChannelPixelValueRange(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@Cast("unsigned int*") IntBuffer pPixelValueMin,
				@Cast("unsigned int*") IntBuffer pPixelValueMax );
	public static native @Cast("fc2Error") int fc2GetChannelPixelValueRange(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@Cast("unsigned int*") int[] pPixelValueMin,
				@Cast("unsigned int*") int[] pPixelValueMax );

	/**
	 * Get the number of unique pixel values in the image.
	 *
	 * @param imageStatisticsContext A statistics context.
	 * @param channel The statistics channel.
	 * @param pNumPixelValues The number of unique pixel values.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetChannelNumPixelValues(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@Cast("unsigned int*") IntPointer pNumPixelValues );
	public static native @Cast("fc2Error") int fc2GetChannelNumPixelValues(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@Cast("unsigned int*") IntBuffer pNumPixelValues );
	public static native @Cast("fc2Error") int fc2GetChannelNumPixelValues(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@Cast("unsigned int*") int[] pNumPixelValues );

	/**
	 * Get the mean of the image.
	 *
	 * @param imageStatisticsContext A statistics context.
	 * @param channel The statistics channel.
	 * @param pPixelValueMean The mean of the image.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetChannelMean(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				FloatPointer pPixelValueMean );
	public static native @Cast("fc2Error") int fc2GetChannelMean(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				FloatBuffer pPixelValueMean );
	public static native @Cast("fc2Error") int fc2GetChannelMean(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				float[] pPixelValueMean );

	/**
	 * Get the histogram for the image.
	 *
	 * @param imageStatisticsContext A statistics context.
	 * @param channel The statistics channel.
	 * @param ppHistogram Pointer to an array containing the histogram.
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetChannelHistogram(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@Cast("int**") PointerPointer ppHistogram );
	public static native @Cast("fc2Error") int fc2GetChannelHistogram(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@ByPtrPtr IntPointer ppHistogram );
	public static native @Cast("fc2Error") int fc2GetChannelHistogram(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@ByPtrPtr IntBuffer ppHistogram );
	public static native @Cast("fc2Error") int fc2GetChannelHistogram(
				fc2ImageStatisticsContext imageStatisticsContext,
				@Cast("fc2StatisticsChannel") int channel,
				@ByPtrPtr int[] ppHistogram );

	/**
	 * Get all statistics for the image.
	 *
	 * @param imageStatisticsContext The statistics context.
	 * @param channel The statistics channel.
	 * @param pRangeMin The minimum possible value.
	 * @param pRangeMax The maximum possible value.
	 * @param pPixelValueMin The minimum pixel value.
	 * @param pPixelValueMax The maximum pixel value.
	 * @param pNumPixelValues The number of unique pixel values.
	 * @param pPixelValueMean The mean of the image.
	 * @param ppHistogram Pointer to an array containing the histogram.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetImageStatistics(
					fc2ImageStatisticsContext imageStatisticsContext,
					@Cast("fc2StatisticsChannel") int channel,
					@Cast("unsigned int*") IntPointer pRangeMin,
					@Cast("unsigned int*") IntPointer pRangeMax,
					@Cast("unsigned int*") IntPointer pPixelValueMin,
					@Cast("unsigned int*") IntPointer pPixelValueMax,
					@Cast("unsigned int*") IntPointer pNumPixelValues,
					FloatPointer pPixelValueMean,
					@Cast("int**") PointerPointer ppHistogram );
	public static native @Cast("fc2Error") int fc2GetImageStatistics(
					fc2ImageStatisticsContext imageStatisticsContext,
					@Cast("fc2StatisticsChannel") int channel,
					@Cast("unsigned int*") IntPointer pRangeMin,
					@Cast("unsigned int*") IntPointer pRangeMax,
					@Cast("unsigned int*") IntPointer pPixelValueMin,
					@Cast("unsigned int*") IntPointer pPixelValueMax,
					@Cast("unsigned int*") IntPointer pNumPixelValues,
					FloatPointer pPixelValueMean,
					@ByPtrPtr IntPointer ppHistogram );
	public static native @Cast("fc2Error") int fc2GetImageStatistics(
					fc2ImageStatisticsContext imageStatisticsContext,
					@Cast("fc2StatisticsChannel") int channel,
					@Cast("unsigned int*") IntBuffer pRangeMin,
					@Cast("unsigned int*") IntBuffer pRangeMax,
					@Cast("unsigned int*") IntBuffer pPixelValueMin,
					@Cast("unsigned int*") IntBuffer pPixelValueMax,
					@Cast("unsigned int*") IntBuffer pNumPixelValues,
					FloatBuffer pPixelValueMean,
					@ByPtrPtr IntBuffer ppHistogram );
	public static native @Cast("fc2Error") int fc2GetImageStatistics(
					fc2ImageStatisticsContext imageStatisticsContext,
					@Cast("fc2StatisticsChannel") int channel,
					@Cast("unsigned int*") int[] pRangeMin,
					@Cast("unsigned int*") int[] pRangeMax,
					@Cast("unsigned int*") int[] pPixelValueMin,
					@Cast("unsigned int*") int[] pPixelValueMax,
					@Cast("unsigned int*") int[] pNumPixelValues,
					float[] pPixelValueMean,
					@ByPtrPtr int[] ppHistogram );

	/*@}*/

	/**
	* \defgroup CAVIRecorder AVI Recording Operation
	*
	* \brief The AVI recording operation provides the functionality for the user to record
	 * images to an AVI file.
	*/
	/*@{*/

	/**
	 * Create a AVI context.
	 *
	 * @param pAVIContext A AVI context.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2CreateAVI(
					@ByPtrPtr fc2AVIContext pAVIContext );

	/**
	 * Open an AVI file in preparation for writing Images to disk.
	 * The size of AVI files is limited to 2GB. The filenames are
	 * automatically generated using the filename specified.
	 *
	 * @param AVIContext The AVI context to use.
	 * @param pFileName The filename of the AVI file.
	 * @param pOption Options to apply to the AVI file.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2AVIOpen(
					fc2AVIContext AVIContext,
					@Cast("const char*") BytePointer pFileName,
					fc2AVIOption pOption );
	public static native @Cast("fc2Error") int fc2AVIOpen(
					fc2AVIContext AVIContext,
					String pFileName,
					fc2AVIOption pOption );

	/**
	 * Open an MJPEG file in preparation for writing Images to disk.
	 * The size of AVI files is limited to 2GB. The filenames are
	 * automatically generated using the filename specified.
	 *
	 * @param AVIContext The AVI context to use.
	 * @param pFileName The filename of the AVI file.
	 * @param pOption Options to apply to the AVI file.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2MJPGOpen(
					fc2AVIContext AVIContext,
					@Cast("const char*") BytePointer pFileName,
					fc2MJPGOption pOption );
	public static native @Cast("fc2Error") int fc2MJPGOpen(
					fc2AVIContext AVIContext,
					String pFileName,
					fc2MJPGOption pOption );

	/**
	 * Open an H.264 file in preparation for writing Images to disk.
	 * The size of AVI files is limited to 2GB. The filenames are
	 * automatically generated using the filename specified.
	 *
	 * @param AVIContext The AVI context to use.
	 * @param pFileName The filename of the AVI file.
	 * @param pOption Options to apply to the AVI file.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2H264Open(
					fc2AVIContext AVIContext,
					@Cast("const char*") BytePointer pFileName,
					fc2H264Option pOption );
	public static native @Cast("fc2Error") int fc2H264Open(
					fc2AVIContext AVIContext,
					String pFileName,
					fc2H264Option pOption );

	/**
	 * Append an image to the AVI file.
	 *
	 * @param AVIContext The AVI context to use.
	 * @param pImage The image to append.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2AVIAppend(
					fc2AVIContext AVIContext,
					fc2Image pImage );

	/**
	 * Close the AVI file.
	 *
	 * @param AVIContext The AVI context to use.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2AVIClose(
					fc2AVIContext AVIContext );

	/**
	 * Destroy a AVI context.
	 *
	 * @param AVIContext A AVI context.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2DestroyAVI(
					fc2AVIContext AVIContext );

	/*@}*/

	/**
	* \defgroup CTopologyNode TopologyNode Operation
	*
	* \brief The TopologyNode operation provides the functionality for the user to
	* generate a tree structure of all cameras and devices connected to a computer.
	*/
	/*@{*/

	/**
	 * Create a TopologyNode context.
	 *
	 * @param pTopologyNodeContext A Topology Node context.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2CreateTopologyNode(
					@ByPtrPtr fc2TopologyNodeContext pTopologyNodeContext );

	/**
	 * Get the PGRGuid associated with the node.
	 *
	 * @param TopologyNodeContext The Topology Node context to use.
	 * @param pGuid The unique identifier associated with the node.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2TopologyNodeGetGuid(
					fc2TopologyNodeContext TopologyNodeContext,
					fc2PGRGuid pGuid);

	/**
	 * Get the device ID associated with the node.
	 *
	 * @param TopologyNodeContext The Topology Node context to use.
	 * @param pID Device ID of the node.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2TopologyNodeGetDeviceId(
					fc2TopologyNodeContext TopologyNodeContext,
					IntPointer pID);
	public static native @Cast("fc2Error") int fc2TopologyNodeGetDeviceId(
					fc2TopologyNodeContext TopologyNodeContext,
					IntBuffer pID);
	public static native @Cast("fc2Error") int fc2TopologyNodeGetDeviceId(
					fc2TopologyNodeContext TopologyNodeContext,
					int[] pID);

	/**
	 * Get the node type associated with the node.
	 *
	 * @param TopologyNodeContext The Topology Node context to use.
	 * @param pNodeType Node type of the node.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2TopologyNodeGetNodeType(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("fc2NodeType*") IntPointer pNodeType);
	public static native @Cast("fc2Error") int fc2TopologyNodeGetNodeType(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("fc2NodeType*") IntBuffer pNodeType);
	public static native @Cast("fc2Error") int fc2TopologyNodeGetNodeType(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("fc2NodeType*") int[] pNodeType);

	/**
	 * Get the interface type associated with the node.
	 *
	 * @param TopologyNodeContext The Topology Node context to use.
	 * @param pInterfaceType Interface type of the node.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2TopologyNodeGetInterfaceType(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("fc2InterfaceType*") IntPointer pInterfaceType);
	public static native @Cast("fc2Error") int fc2TopologyNodeGetInterfaceType(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("fc2InterfaceType*") IntBuffer pInterfaceType);
	public static native @Cast("fc2Error") int fc2TopologyNodeGetInterfaceType(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("fc2InterfaceType*") int[] pInterfaceType);

	/**
	 * Get the number of child nodes.
	 *
	 * @param TopologyNodeContext The Topology Node context to use.
	 * @param pNumChildNodes Number of child nodes.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2TopologyNodeGetNumChildren(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("unsigned int*") IntPointer pNumChildNodes);
	public static native @Cast("fc2Error") int fc2TopologyNodeGetNumChildren(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("unsigned int*") IntBuffer pNumChildNodes);
	public static native @Cast("fc2Error") int fc2TopologyNodeGetNumChildren(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("unsigned int*") int[] pNumChildNodes);

	/**
	 * Get child node located at the specified position.
	 *
	 * @param TopologyNodeContext The Topology Node context to use.
	 * @param position Position of the child node.
	 * @param pChildTopologyNodeContext The Topology Node context the contains
	 *									information on the child topology
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2TopologyNodeGetChild(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("unsigned int") int position,
					@ByPtrPtr fc2TopologyNodeContext pChildTopologyNodeContext);

	/**
	 * Add the specified TopologyNode as a child of the node.
	 *
	 * @param TopologyNodeContext The Topology Node context to use.
	 * @param TopologyNodeChildContext The TopologyNode child context to add.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2TopologyNodeAddChild(
					fc2TopologyNodeContext TopologyNodeContext,
					fc2TopologyNodeContext TopologyNodeChildContext);

	/**
	 * Get the number of ports.
	 *
	 * @param TopologyNodeContext The Topology Node context to use.
	 * @param pNumPorts Number of ports.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2TopologyNodeGetNumPorts(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("unsigned int*") IntPointer pNumPorts);
	public static native @Cast("fc2Error") int fc2TopologyNodeGetNumPorts(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("unsigned int*") IntBuffer pNumPorts);
	public static native @Cast("fc2Error") int fc2TopologyNodeGetNumPorts(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("unsigned int*") int[] pNumPorts);

	/**
	 * Get type of port located at the specified position.
	 *
	 * @param TopologyNodeContext The Topology Node context to use.
	 * @param position Position of the port.
	 * @param pPortType PortType at the specified position.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2TopologyNodeGetPortType(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("unsigned int") int position,
					@Cast("fc2PortType*") IntPointer pPortType);
	public static native @Cast("fc2Error") int fc2TopologyNodeGetPortType(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("unsigned int") int position,
					@Cast("fc2PortType*") IntBuffer pPortType);
	public static native @Cast("fc2Error") int fc2TopologyNodeGetPortType(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("unsigned int") int position,
					@Cast("fc2PortType*") int[] pPortType);

	/**
	 * Add the specified PortType as a port of the node.
	 *
	 * @param TopologyNodeContext The Topology Node context to use.
	 * @param portType childPort The port to add.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2TopologyNodeAddPortType(
					fc2TopologyNodeContext TopologyNodeContext,
					@Cast("fc2PortType") int portType);

	/**
	 * Assign a PGRGuid and device ID to the node.
	 *
	 * @param TopologyNodeContext The Topology Node context to use.
	 * @param guid PGRGuid to be assigned.
	 * @param deviceId Device ID to be assigned.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("BOOL") int fc2TopologyNodeAssignGuidToNode(
					fc2TopologyNodeContext TopologyNodeContext,
					@ByVal fc2PGRGuid guid,
					int deviceId);

	/**
	 * Assign a PGRGuid, device ID and nodeType to the node.
	 *
	 * @param TopologyNodeContext The Topology Node context to use.
	 * @param guid PGRGuid to be assigned.
	 * @param deviceId Device ID to be assigned.
	 * @param nodeType NodeType to be assigned
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("BOOL") int fc2TopologyNodeAssignGuidToNodeEx(
					fc2TopologyNodeContext TopologyNodeContext,
					@ByVal fc2PGRGuid guid,
					int deviceId,
					@Cast("fc2NodeType") int nodeType);

	/**
	 * Destroy a TopologyNode context.
	 *
	 * @param TopologyNodeContext A Topology Node context.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2DestroyTopologyNode(
					fc2TopologyNodeContext TopologyNodeContext );

	/*@}*/

	/**
	* \defgroup CUtilities Utilities
	*
	* \brief The utility operations are used to query for general system
	* information such as operating system, available memory etc.
	* It can also be used to launch browsers, CHM viewers or terminal commands.
	*/
	/*@{*/

	/**
	 * Check for driver compatibility for the given camera guid.
	 *
	 * @param pGuid The PGRGuid of the device to check.
	 *
	 * @return FC2_ERROR_OK if the library is compatible with the currently
	 *         loaded driver, otherwise an error indicating the type of failure.
	 */
	public static native @Cast("fc2Error") int fc2CheckDriver( @Const fc2PGRGuid pGuid);

	/**
	 * Get the driver's name for a device
	 *
	 * @param pGuid The PGRGuid of the device to check.
	 * @param pDeviceName The device name will be returned in this string
	 * @param pDeviceNameLength The length of the device name string returned
	 *
	 * @return An Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetDriverDeviceName(
				@Const fc2PGRGuid pGuid,
				@Cast("char*") BytePointer pDeviceName,
				@Cast("size_t*") SizeTPointer deviceNameLength);
	public static native @Cast("fc2Error") int fc2GetDriverDeviceName(
				@Const fc2PGRGuid pGuid,
				@Cast("char*") ByteBuffer pDeviceName,
				@Cast("size_t*") SizeTPointer deviceNameLength);
	public static native @Cast("fc2Error") int fc2GetDriverDeviceName(
				@Const fc2PGRGuid pGuid,
				@Cast("char*") byte[] pDeviceName,
				@Cast("size_t*") SizeTPointer deviceNameLength);

	/**
	 * Get system information.
	 *
	 * @param pSystemInfo Structure to receive system information.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetSystemInfo( fc2SystemInfo pSystemInfo);

	/**
	 * Get library version.
	 *
	 * @param pVersion Structure to receive the library version.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2GetLibraryVersion( fc2Version pVersion);

	/**
	 * Launch a URL in the system default browser.
	 *
	 * @param pAddress URL to open in browser.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2LaunchBrowser( @Cast("const char*") BytePointer pAddress);
	public static native @Cast("fc2Error") int fc2LaunchBrowser( String pAddress);

	/**
	 * Open a CHM file in the system default CHM viewer.
	 *
	 * @param pFileName Filename of CHM file to open.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2LaunchHelp( @Cast("const char*") BytePointer pFileName);
	public static native @Cast("fc2Error") int fc2LaunchHelp( String pFileName);

	/**
	 * Execute a command in the terminal. This is a blocking call that
	 * will return when the command completes.
	 *
	 * @param pCommand Command to execute.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2LaunchCommand( @Cast("const char*") BytePointer pCommand);
	public static native @Cast("fc2Error") int fc2LaunchCommand( String pCommand);

	/**
	 * Execute a command in the terminal. This is a non-blocking call that
	 * will return immediately. The return value of the command can be
	 * retrieved in the callback.
	 *
	 * @param pCommand Command to execute.
	 * @param pCallback Callback to fire when command is complete.
	 * @param pUserData Data pointer to pass to callback.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("fc2Error") int fc2LaunchCommandAsync(
					@Cast("const char*") BytePointer pCommand,
					fc2AsyncCommandCallback pCallback,
					Pointer pUserData );
	public static native @Cast("fc2Error") int fc2LaunchCommandAsync(
					String pCommand,
					fc2AsyncCommandCallback pCallback,
					Pointer pUserData );

	/**
	 * Get a string representation of an error.
	 *
	 * @param error Error to be parsed.
	 *
	 * @return A fc2Error indicating the success or failure of the function.
	 */
	public static native @Cast("const char*") BytePointer fc2ErrorToDescription(
					@Cast("fc2Error") int error);

	/*@}*/

// #ifdef __cplusplus
// #endif

// #endif // PGR_FC2_FLYCAPTURE2_C_H

// Parsed from MultiSyncLibraryDefs_C.h

//=============================================================================
// Copyright  2011 Point Grey Research, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of Point
// Grey Research, Inc. ("Confidential Information").  You shall not
// disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with PGR.
//
// PGR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. PGR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
//=============================================================================
// $Id:
//=============================================================================

// #ifndef MULTISYNCLIBRARYDEFS_C_H
// #define MULTISYNCLIBRARYDEFS_C_H

// #include <stdlib.h>

//=============================================================================
// C definitions header file for MultiSync.
//
// This file defines the C enumerations, typedefs and structures for MultiSync
//
//=============================================================================

// #ifdef __cplusplus
// #endif

	//=============================================================================
	// Typedefs
	//=============================================================================

// #ifndef FALSE
// #endif

// #ifndef TRUE
// #endif

// #ifndef FULL_32BIT_VALUE
// #endif

	/**
	 * A context to the MultiSync C library. It must be created before
	 * performing any calls to the library.
	 */
	@Namespace @Name("void") @Opaque public static class syncContext extends Pointer {
	    /** Empty constructor. Calls {@code super((Pointer)null)}. */
	    public syncContext() { super((Pointer)null); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public syncContext(Pointer p) { super(p); }
	}


	//=============================================================================
	// Enumerations
	//=============================================================================

	/** enum _syncError */
	public static final int
		SYNC_ERROR_OK = 0,
		SYNC_ERROR_FAILED = 1,
		SYNC_ERROR_ALREADY_STARTED = 2,
		SYNC_ERROR_ALREADY_STOPPED = 3,
		SYNC_ERROR_CONTEXT_NOT_INITIALIZED = 4,
		SYNC_ERROR_UNKNOWN_ERROR = 5;

	/** enum _syncMessage */
	public static final int
		SYNC_MESSAGE_OK = 0,
		SYNC_MESSAGE_FAILED = 1,
		SYNC_MESSAGE_STARTED = 2,
		SYNC_MESSAGE_STOPPED = 3,
		SYNC_MESSAGE_SYNCING = 4,
		SYNC_MESSAGE_NOMASTER = 5,
		SYNC_MESSAGE_THREAD_ERROR = 6,
		SYNC_MESSAGE_DEVICE_ERROR = 7,
		SYNC_MESSAGE_NOT_ENOUGH_DEVICES = 8,
		SYNC_MESSAGE_BUS_RESET = 9,
		SYNC_MESSAGE_NOT_INITIALIZED = 10,
		SYNC_MESSAGE_UNKNOWN_ERROR = 11;

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from MultiSyncLibrary_C.h

//=============================================================================
// Copyright  2008 Point Grey Research, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of Point
// Grey Research, Inc. ("Confidential Information").  You shall not
// disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with PGR.
//
// PGR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. PGR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
//=============================================================================
// $Id:
//=============================================================================

// #ifndef MULTISYNCLIBRARY_C_H
// #define MULTISYNCLIBRARY_C_H

//=============================================================================
// Global C header file for MultiSync
//
// This file defines the C API for MultiSync Library
//=============================================================================

// #include "MultiSyncLibraryPlatform_C.h"
// #include "MultiSyncLibraryDefs_C.h"

// #ifdef __cplusplus
// #endif

	/**
	 * Create a Sync context for MultiSync Library.
	 * This call must be made before any other calls that use a context
	 * will succeed.
	 *
	 * @param pContext A pointer to the syncContext to be created.
	 *
	 * @return A syncError indicating the success or failure of the function.
	 */
	public static native @Cast("syncError") int syncCreateContext(
					@ByPtrPtr syncContext pContext );

	/**
	 * Destory the sync context. This must be called when the user is finished
	 * with the context in order to prevent memory leaks.
	 *
	 * @param context The syncContext to be destoryed.
	 *
	 * @return A syncError indicating the success or failure of the function.
	 */
	public static native @Cast("syncError") int syncDestroyContext(
					syncContext context );

	/**
	 * Start the sync progress
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return A syncError indicating the success or failure of the function.
	 */
	public static native @Cast("syncError") int syncStart(
					syncContext context );

	/**
	 * Stop the sync progress
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return A syncError indicating the success or failure of the function.
	 */
	public static native @Cast("syncError") int syncStop(
					syncContext context );


	/**
	 * Scan newly connected or removed timing bus (for corss-PC syncing only)
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return A syncError indicating the success or failure of the function.
	 */
	public static native @Cast("syncError") int syncRescanMasterTimingBus(
					syncContext context );

	/**
	 * Start the sync progress
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return A syncMessage indicating the sync status.
	 */
	public static native @Cast("syncMessage") int syncGetStatus(
					syncContext context );

	/**
	 * Time since sync started
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return Time sinced synced.
	 */
	public static native double syncGetTimeSinceSynced(
					syncContext context );

	/**
	 * Whether syncing across PCs
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return True if its syncing across PC
	 */
	public static native @Cast("BOOL") int syncIsTimingBusConnected(
					syncContext context );

	/**
	 * Enable across pc synchronization support
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return True if operation was successful
	 */
	public static native @Cast("BOOL") int syncEnableCrossPCSynchronization(
					syncContext context );

	/**
	 * Disable across pc synchronization support
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return True if operation was successful
	 */
	public static native @Cast("BOOL") int syncDisableCrossPCSynchronization(
					syncContext context );

	/**
	 * Query cross pc synchronizaion support status
	 *
	 * @param context The syncContext to be used.
	 *
	 * @return True if cross pc synchronization was supported
	 */
	public static native @Cast("BOOL") int syncQueryCrossPCSynchronizationSetting(
					syncContext context );
// #ifdef __cplusplus
// #endif

// #endif


}
