/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spi.ordered;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.ordered.OrderedSPI;
import org.apache.shardingsphere.spi.ordered.cache.OrderedServicesCache;

public final class OrderedSPIRegistry {
    public static <T extends OrderedSPI<?>> Map<Class<?>, T> getRegisteredServicesByClass(Class<T> orderedSPIClass, Collection<Class<?>> types) {
        Collection<OrderedSPI> registeredServices = OrderedSPIRegistry.getRegisteredServices(orderedSPIClass);
        LinkedHashMap result = new LinkedHashMap(registeredServices.size(), 1.0f);
        for (OrderedSPI each : registeredServices) {
            types.stream().filter(type -> each.getTypeClass() == type).forEach(type -> result.put(type, each));
        }
        return result;
    }

    public static <K, V extends OrderedSPI<?>> Map<K, V> getRegisteredServices(Class<V> orderedSPIClass, Collection<K> types) {
        return OrderedSPIRegistry.getRegisteredServices(orderedSPIClass, types, Comparator.naturalOrder());
    }

    public static <K, V extends OrderedSPI<?>> Map<K, V> getRegisteredServices(Class<V> orderedSPIClass, Collection<K> types, Comparator<Integer> comparator) {
        Optional<Map> cachedServices = OrderedServicesCache.findCachedServices(orderedSPIClass, types).map(optional -> optional);
        if (cachedServices.isPresent()) {
            return cachedServices.get();
        }
        Collection<OrderedSPI> registeredServices = OrderedSPIRegistry.getRegisteredServices(orderedSPIClass, comparator);
        LinkedHashMap result = new LinkedHashMap(registeredServices.size(), 1.0f);
        for (OrderedSPI each : registeredServices) {
            types.stream().filter(type -> each.getTypeClass() == type.getClass()).forEach(type -> result.put(type, each));
        }
        OrderedServicesCache.cacheServices(orderedSPIClass, types, result);
        return result;
    }

    public static <T extends OrderedSPI<?>> Collection<T> getRegisteredServices(Class<T> orderedSPIClass) {
        return OrderedSPIRegistry.getRegisteredServices(orderedSPIClass, Comparator.naturalOrder());
    }

    public static <T extends OrderedSPI<?>> Collection<T> getRegisteredServices(Class<T> orderedSPIClass, Comparator<Integer> comparator) {
        TreeMap<Integer, OrderedSPI> result = new TreeMap<Integer, OrderedSPI>(comparator);
        for (OrderedSPI each : ShardingSphereServiceLoader.getSingletonServiceInstances(orderedSPIClass)) {
            Preconditions.checkArgument((!result.containsKey(each.getOrder()) ? 1 : 0) != 0, (String)"Found same order `%s` with `%s` and `%s`", (Object)each.getOrder(), result.get(each.getOrder()), (Object)each);
            result.put(each.getOrder(), each);
        }
        return result.values();
    }

    @Generated
    private OrderedSPIRegistry() {
    }
}

