/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.converter;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.parser.segment.AbstractTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.AutoTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.KeyGenerateSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.ShardingStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.TableRuleSegment;

public final class ShardingTableRuleStatementConverter {
    public static ShardingRuleConfiguration convert(Collection<AbstractTableRuleSegment> rules) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        rules.forEach(each -> {
            result.getKeyGenerators().putAll(ShardingTableRuleStatementConverter.createKeyGeneratorConfiguration(each));
            if (each instanceof AutoTableRuleSegment) {
                result.getShardingAlgorithms().putAll(ShardingTableRuleStatementConverter.createAlgorithmConfiguration((AutoTableRuleSegment)each));
                result.getAutoTables().add(ShardingTableRuleStatementConverter.createAutoTableRuleConfiguration((AutoTableRuleSegment)each));
            }
            if (each instanceof TableRuleSegment) {
                result.getTables().add(ShardingTableRuleStatementConverter.createTableRuleConfiguration((TableRuleSegment)each));
            }
        });
        return result;
    }

    private static Map<String, ShardingSphereAlgorithmConfiguration> createKeyGeneratorConfiguration(AbstractTableRuleSegment rule) {
        HashMap<String, ShardingSphereAlgorithmConfiguration> result = new HashMap<String, ShardingSphereAlgorithmConfiguration>();
        Optional.ofNullable(rule.getKeyGenerateSegment()).ifPresent(op -> result.put(ShardingTableRuleStatementConverter.getKeyGeneratorName(rule.getLogicTable(), op.getKeyGenerateAlgorithmSegment().getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(op.getKeyGenerateAlgorithmSegment())));
        return result;
    }

    private static Map<String, ShardingSphereAlgorithmConfiguration> createAlgorithmConfiguration(AutoTableRuleSegment rule) {
        HashMap<String, ShardingSphereAlgorithmConfiguration> result = new HashMap<String, ShardingSphereAlgorithmConfiguration>();
        Optional.ofNullable(rule.getShardingAlgorithmSegment()).ifPresent(op -> result.put(ShardingTableRuleStatementConverter.getShardingAlgorithmName(rule.getLogicTable(), op.getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(op)));
        return result;
    }

    public static ShardingSphereAlgorithmConfiguration createAlgorithmConfiguration(AlgorithmSegment segment) {
        return new ShardingSphereAlgorithmConfiguration(segment.getName(), segment.getProps());
    }

    private static ShardingAutoTableRuleConfiguration createAutoTableRuleConfiguration(AutoTableRuleSegment rule) {
        ShardingAutoTableRuleConfiguration result = new ShardingAutoTableRuleConfiguration(rule.getLogicTable(), Joiner.on((String)",").join((Iterable)rule.getDataSourceNodes()));
        result.setShardingStrategy(ShardingTableRuleStatementConverter.createAutoTableStrategyConfiguration(rule));
        Optional.ofNullable(rule.getKeyGenerateSegment()).ifPresent(op -> result.setKeyGenerateStrategy(ShardingTableRuleStatementConverter.createKeyGenerateStrategyConfiguration(rule.getLogicTable(), rule.getKeyGenerateSegment())));
        return result;
    }

    private static ShardingStrategyConfiguration createAutoTableStrategyConfiguration(AutoTableRuleSegment rule) {
        return ShardingTableRuleStatementConverter.createStrategyConfiguration(ShardingStrategyType.STANDARD.name(), rule.getShardingColumn(), ShardingTableRuleStatementConverter.getShardingAlgorithmName(rule.getLogicTable(), rule.getShardingAlgorithmSegment().getName()));
    }

    private static ShardingTableRuleConfiguration createTableRuleConfiguration(TableRuleSegment tableRuleSegment) {
        String dataSourceNodes = String.join((CharSequence)",", tableRuleSegment.getDataSourceNodes());
        ShardingTableRuleConfiguration tableRuleConfiguration = new ShardingTableRuleConfiguration(tableRuleSegment.getLogicTable(), dataSourceNodes);
        Optional.ofNullable(tableRuleSegment.getTableStrategySegment()).ifPresent(op -> tableRuleConfiguration.setTableShardingStrategy(ShardingTableRuleStatementConverter.createShardingStrategyConfiguration(op.getType(), op)));
        Optional.ofNullable(tableRuleSegment.getDatabaseStrategySegment()).ifPresent(op -> tableRuleConfiguration.setDatabaseShardingStrategy(ShardingTableRuleStatementConverter.createShardingStrategyConfiguration(op.getType(), op)));
        Optional.ofNullable(tableRuleSegment.getKeyGenerateSegment()).ifPresent(op -> tableRuleConfiguration.setKeyGenerateStrategy(ShardingTableRuleStatementConverter.createKeyGenerateStrategyConfiguration(tableRuleSegment.getLogicTable(), op)));
        return tableRuleConfiguration;
    }

    private static ShardingStrategyConfiguration createShardingStrategyConfiguration(String type, ShardingStrategySegment segment) {
        return ShardingTableRuleStatementConverter.createStrategyConfiguration(ShardingStrategyType.getValueOf(type).name(), segment.getShardingColumn(), segment.getShardingAlgorithmName());
    }

    private static KeyGenerateStrategyConfiguration createKeyGenerateStrategyConfiguration(String logicTable, KeyGenerateSegment segment) {
        return new KeyGenerateStrategyConfiguration(segment.getKeyGenerateColumn(), ShardingTableRuleStatementConverter.getKeyGeneratorName(logicTable, segment.getKeyGenerateAlgorithmSegment().getName()));
    }

    public static ShardingStrategyConfiguration createStrategyConfiguration(String strategyType, String shardingColumn, String shardingAlgorithmName) {
        ShardingStrategyType shardingStrategyType = ShardingStrategyType.getValueOf(strategyType);
        return shardingStrategyType.getConfiguration(shardingAlgorithmName, shardingColumn);
    }

    private static String getShardingAlgorithmName(String tableName, String algorithmType) {
        return String.format("%s_%s", tableName, algorithmType);
    }

    private static String getKeyGeneratorName(String tableName, String columnName) {
        return String.format("%s_%s", tableName, columnName);
    }

    @Generated
    private ShardingTableRuleStatementConverter() {
    }
}

