/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.jwt.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.oltu.commons.json.CustomizableBuilder;
import org.apache.oltu.commons.json.CustomizableEntityReader;
import org.apache.oltu.oauth2.jwt.JWT;
import org.apache.oltu.oauth2.jwt.io.JWTConstants;

final class JWTClaimsSetParser
extends CustomizableEntityReader<JWT, JWT.Builder>
implements JWTConstants {
    public JWTClaimsSetParser(JWT.Builder builder) {
        super((CustomizableBuilder)builder);
    }

    protected <T> boolean handleProperty(String key, T value) {
        if ("aud".equals(key)) {
            this.handleAudience(value);
        } else if ("exp".equals(key)) {
            ((JWT.Builder)this.getBuilder()).setClaimsSetExpirationTime(((Integer)value).longValue());
        } else if ("iat".equals(key)) {
            ((JWT.Builder)this.getBuilder()).setClaimsSetIssuedAt(((Integer)value).longValue());
        } else if ("iss".equals(key)) {
            ((JWT.Builder)this.getBuilder()).setClaimsSetIssuer(String.valueOf(value));
        } else if ("jti".equals(key)) {
            ((JWT.Builder)this.getBuilder()).setClaimsSetJwdId(String.valueOf(value));
        } else if ("nbf".equals(key)) {
            ((JWT.Builder)this.getBuilder()).setClaimsSetNotBefore(String.valueOf(value));
        } else if ("sub".equals(key)) {
            ((JWT.Builder)this.getBuilder()).setClaimsSetSubject(String.valueOf(value));
        } else if ("typ".equals(key)) {
            ((JWT.Builder)this.getBuilder()).setClaimsSetType(String.valueOf(value));
        } else {
            ((JWT.Builder)this.getBuilder()).setClaimsSetCustomField(key, value);
        }
        return true;
    }

    private <T> void handleAudience(T value) {
        if (value instanceof Collection) {
            ((JWT.Builder)this.getBuilder()).setClaimsSetAudiences(this.collectionToStringList((Collection)value));
        } else if (value instanceof Object[]) {
            ((JWT.Builder)this.getBuilder()).setClaimsSetAudiences(this.arrayToStringList((Object[])value));
        } else {
            ((JWT.Builder)this.getBuilder()).setClaimsSetAudience(String.valueOf(value));
        }
    }

    private List<String> collectionToStringList(Collection<?> values) {
        ArrayList<String> l = new ArrayList<String>();
        for (Object v : values) {
            l.add(String.valueOf(v));
        }
        return l;
    }

    private List<String> arrayToStringList(Object[] values) {
        ArrayList<String> l = new ArrayList<String>();
        for (Object v : values) {
            l.add(String.valueOf(v));
        }
        return l;
    }
}

