/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.jwt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.oltu.commons.json.CustomizableBuilder;
import org.apache.oltu.oauth2.jwt.ClaimsSet;
import org.apache.oltu.oauth2.jwt.Header;

public class JWT {
    private final Header header;
    private final ClaimsSet claimsSet;
    private final String signature;
    private final String rawString;

    JWT(String rawString, Header header, ClaimsSet claimsSet, String signature) {
        this.rawString = rawString;
        this.header = header;
        this.claimsSet = claimsSet;
        this.signature = signature;
    }

    public Header getHeader() {
        return this.header;
    }

    public ClaimsSet getClaimsSet() {
        return this.claimsSet;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getRawString() {
        return this.rawString;
    }

    public String toString() {
        return String.format("-- JWT --%nRaw String: %s%nHeader: %s%nClaims Set: %s%nSignature: %s%n---------", new Object[]{this.rawString != null ? this.rawString : "unknown", this.header, this.claimsSet, this.signature});
    }

    public static final class Builder
    extends CustomizableBuilder<JWT> {
        private final String rawString;
        private String headerType;
        private String headerAlgorithm;
        private String headerContentType;
        private final Map<String, Object> headerCustomFields = new LinkedHashMap<String, Object>();
        private String claimsSetIssuer;
        private String claimsSetSubject;
        private List<String> claimsSetAudiences;
        private long claimsSetExpirationTime;
        private String claimsSetNotBefore;
        private long claimsSetIssuedAt;
        private String claimsSetJwdId;
        private String claimsSetType;
        private final Map<String, Object> claimsSetCustomFields = new LinkedHashMap<String, Object>();
        private String signature;

        public Builder() {
            this(null);
        }

        public Builder(String rawString) {
            this.rawString = rawString;
        }

        public Builder setHeaderType(String headerType) {
            this.headerType = headerType;
            return this;
        }

        public Builder setHeaderAlgorithm(String headerAlgorithm) {
            this.headerAlgorithm = headerAlgorithm;
            return this;
        }

        public Builder setHeaderContentType(String headerContentType) {
            this.headerContentType = headerContentType;
            return this;
        }

        public Builder setHeaderCustomField(String key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("Null key not allowed");
            }
            if (value != null) {
                this.headerCustomFields.put(key, value);
            }
            return this;
        }

        public Builder setClaimsSetIssuer(String claimsSetIssuer) {
            this.claimsSetIssuer = claimsSetIssuer;
            return this;
        }

        public Builder setClaimsSetSubject(String claimsSetSubject) {
            this.claimsSetSubject = claimsSetSubject;
            return this;
        }

        public Builder setClaimsSetAudience(String claimsSetAudience) {
            this.claimsSetAudiences = claimsSetAudience == null ? null : Arrays.asList(claimsSetAudience);
            return this;
        }

        public Builder setClaimsSetAudiences(List<String> claimsSetAudiences) {
            this.claimsSetAudiences = claimsSetAudiences == null ? null : new ArrayList<String>(claimsSetAudiences);
            return this;
        }

        public Builder setClaimsSetExpirationTime(long claimsSetExpirationTime) {
            this.claimsSetExpirationTime = claimsSetExpirationTime;
            return this;
        }

        public Builder setClaimsSetNotBefore(String claimsSetNotBefore) {
            this.claimsSetNotBefore = claimsSetNotBefore;
            return this;
        }

        public Builder setClaimsSetIssuedAt(long claimsSetIssuedAt) {
            this.claimsSetIssuedAt = claimsSetIssuedAt;
            return this;
        }

        public Builder setClaimsSetJwdId(String claimsSetJwdId) {
            this.claimsSetJwdId = claimsSetJwdId;
            return this;
        }

        public Builder setClaimsSetType(String claimsSetType) {
            this.claimsSetType = claimsSetType;
            return this;
        }

        public Builder setClaimsSetCustomField(String key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("Null key not allowed");
            }
            if (value != null) {
                this.claimsSetCustomFields.put(key, value);
            }
            return this;
        }

        public Builder setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public JWT build() {
            return new JWT(this.rawString, new Header(this.headerType, this.headerAlgorithm, this.headerContentType, this.headerCustomFields), new ClaimsSet(this.claimsSetIssuer, this.claimsSetSubject, this.claimsSetAudiences, this.claimsSetExpirationTime, this.claimsSetNotBefore, this.claimsSetIssuedAt, this.claimsSetJwdId, this.claimsSetType, this.claimsSetCustomFields), this.signature);
        }
    }
}

