/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.utils;

import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.dongliu.requests.Parameter;
import net.dongliu.requests.utils.Exceptions;

public class URIEncoder {
    private static final BitSet userInfoWhiteSet;
    private static final BitSet regNameWhiteSet;
    private static BitSet queryWhiteSet;
    private static BitSet segmentWhiteSet;
    private static BitSet fragmentWhiteSet;
    private static final int caseDiff = 32;
    private static final char[] subDelims;

    private static BitSet createBasicSet() {
        int i;
        BitSet basicSet = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            basicSet.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            basicSet.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            basicSet.set(i);
        }
        basicSet.set(45);
        basicSet.set(46);
        basicSet.set(95);
        basicSet.set(126);
        return basicSet;
    }

    public static String encodeParam(String s, Charset charset) {
        return URIEncoder._encode(s, charset, queryWhiteSet);
    }

    public static String decodeParam(String s, Charset charset) {
        return URIEncoder._decode(s, charset, true);
    }

    public static String encodeQuery(Parameter<String> query, Charset charset) {
        return URIEncoder.encodeParam(query.getName(), charset) + "=" + URIEncoder.encodeParam(query.getValue(), charset);
    }

    public static String encodeQueries(Collection<? extends Parameter<String>> queries, Charset charset) {
        StringBuilder sb = new StringBuilder();
        for (Parameter<String> parameter : queries) {
            sb.append(URIEncoder.encodeParam(parameter.getName(), charset));
            sb.append('=');
            sb.append(URIEncoder.encodeParam(parameter.getValue(), charset));
            sb.append('&');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Parameter<String> decodeQuery(String s, Charset charset) {
        int idx = s.indexOf("=");
        if (idx < 0) {
            return Parameter.of("", URIEncoder.decodeParam(s, charset));
        }
        return Parameter.of(URIEncoder.decodeParam(s.substring(0, idx), charset), URIEncoder.decodeParam(s.substring(idx + 1), charset));
    }

    public static List<Parameter<String>> decodeQueries(String queryStr, Charset charset) {
        String[] queries = queryStr.split("&");
        ArrayList<Parameter<String>> list = new ArrayList<Parameter<String>>(queries.length);
        for (String query : queries) {
            list.add(URIEncoder.decodeQuery(query, charset));
        }
        return list;
    }

    public static String encodeSegment(String s, Charset charset) {
        return URIEncoder._encode(s, charset, segmentWhiteSet);
    }

    public static String decodeSegment(String s, Charset charset) {
        return URIEncoder._decode(s, charset, false);
    }

    public static String encodeFragment(String s, Charset charset) {
        return URIEncoder._encode(s, charset, fragmentWhiteSet);
    }

    public static String decodeFragment(String s, Charset charset) {
        return URIEncoder._decode(s, charset, false);
    }

    public static String encodeRegName(String regName) {
        return URIEncoder._encode(regName, StandardCharsets.UTF_8, regNameWhiteSet);
    }

    public static String encodeUserInfo(String userInfo, Charset charset) {
        return URIEncoder._encode(userInfo, charset, userInfoWhiteSet);
    }

    private static String _encode(String s, Charset charset, BitSet whiteSet) {
        boolean needToChange = false;
        StringBuilder sb = new StringBuilder(s.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int i = 0;
        while (i < s.length()) {
            byte[] ba;
            char c = s.charAt(i);
            if (whiteSet.get(c)) {
                sb.append(c);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                charArrayWriter.write(d);
                ++i;
            } while (++i < s.length() && !whiteSet.get(c = s.charAt(i)));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            for (byte b : ba = str.getBytes(charset)) {
                sb.append('%');
                char ch = Character.forDigit(b >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                sb.append(ch);
                ch = Character.forDigit(b & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                sb.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? sb.toString() : s;
    }

    public static String _decode(String s, Charset charset, boolean isQueryPart) {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    if (isQueryPart) {
                        sb.append(' ');
                    } else {
                        sb.append('+');
                    }
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, charset));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    public static String encodeForm(Parameter<String> query, Charset charset) {
        try {
            return URLEncoder.encode(query.getName(), charset.name()) + "=" + URLEncoder.encode(query.getValue(), charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.sneakyThrow(e);
        }
    }

    public static String encodeForms(Collection<? extends Parameter<String>> queries, Charset charset) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Parameter<String> parameter : queries) {
                sb.append(URLEncoder.encode(parameter.getName(), charset.name()));
                sb.append('=');
                sb.append(URLEncoder.encode(parameter.getValue(), charset.name()));
                sb.append('&');
            }
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.sneakyThrow(e);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Parameter<String> decodeForm(String s, Charset charset) {
        int idx = s.indexOf("=");
        try {
            if (idx < 0) {
                return Parameter.of("", URLDecoder.decode(s, charset.name()));
            }
            return Parameter.of(URLDecoder.decode(s.substring(0, idx), charset.name()), URLDecoder.decode(s.substring(idx + 1), charset.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.sneakyThrow(e);
        }
    }

    public static List<Parameter<String>> decodeForms(String queryStr, Charset charset) {
        String[] queries = queryStr.split("&");
        ArrayList<Parameter<String>> list = new ArrayList<Parameter<String>>(queries.length);
        for (String query : queries) {
            list.add(URIEncoder.decodeForm(query, charset));
        }
        return list;
    }

    @Nonnull
    public static List<Parameter<String>> toStringParameters(Collection<? extends Map.Entry<String, ?>> params) {
        ArrayList<Parameter<String>> parameters = new ArrayList<Parameter<String>>(params.size());
        for (Map.Entry<String, ?> entry : params) {
            parameters.add(Parameter.of(entry.getKey(), String.valueOf(entry.getValue())));
        }
        return parameters;
    }

    static {
        subDelims = "!$&'()*+,;=".toCharArray();
        userInfoWhiteSet = URIEncoder.createBasicSet();
        for (char c : subDelims) {
            userInfoWhiteSet.set(c);
        }
        userInfoWhiteSet.set(58);
        regNameWhiteSet = URIEncoder.createBasicSet();
        for (char c : subDelims) {
            regNameWhiteSet.set(c);
        }
        queryWhiteSet = URIEncoder.createBasicSet();
        for (char c : subDelims) {
            queryWhiteSet.set(c);
        }
        queryWhiteSet.set(58);
        queryWhiteSet.set(64);
        queryWhiteSet.set(47);
        queryWhiteSet.set(63);
        segmentWhiteSet = URIEncoder.createBasicSet();
        for (char c : subDelims) {
            segmentWhiteSet.set(c);
        }
        segmentWhiteSet.set(64);
        fragmentWhiteSet = URIEncoder.createBasicSet();
        for (char c : subDelims) {
            segmentWhiteSet.set(c);
        }
        queryWhiteSet.set(58);
        queryWhiteSet.set(64);
        segmentWhiteSet.set(47);
        segmentWhiteSet.set(63);
    }
}

