/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.dongliu.requests.utils.Closeables;

public class ReaderWriters {
    private static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader reader, Writer writer) throws IOException {
        char[] buffer = new char[4096];
        try {
            int read;
            while ((read = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, read);
            }
        }
        finally {
            Closeables.closeQuietly((AutoCloseable)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAll(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[4096];
        try {
            int read;
            while ((read = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, read);
            }
        }
        finally {
            Closeables.closeQuietly((AutoCloseable)reader);
        }
        return sb.toString();
    }

    /*
     * Loose catch block
     */
    public static List<String> readLines(Reader reader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            try (BufferedReader br = ReaderWriters.buffered(reader);){
                String line;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
                ArrayList<String> arrayList = lines;
                return arrayList;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Closeables.closeQuietly((AutoCloseable)reader);
        }
    }

    public static BufferedReader buffered(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long skipAll(Reader reader) throws IOException {
        long count = 0L;
        try {
            long read;
            while ((read = reader.skip(4096L)) != 0L) {
                count += read;
            }
            int c = reader.read();
            if (c == -1) {
                long l = count;
                return l;
            }
            char[] buffer = new char[4096];
            while ((read = (long)reader.read(buffer)) != -1L) {
                count += read;
            }
        }
        finally {
            Closeables.closeQuietly((AutoCloseable)reader);
        }
        return count;
    }
}

