/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ListUtils {
    public static <T> List<T> nullToEmpty(@Nullable List<T> list) {
        return list == null ? ListUtils.of() : list;
    }

    @SafeVarargs
    public static <T> List<T> create(T ... values) {
        ArrayList list = new ArrayList(values.length);
        Collections.addAll(list, values);
        return list;
    }

    public static <T> List<T> of() {
        return Collections.emptyList();
    }

    public static <T> List<T> of(T value) {
        return Collections.singletonList(value);
    }

    @SafeVarargs
    public static <T> List<T> of(T ... values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }
}

