/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.dongliu.requests.utils.Closeables;

public class InputOutputs {
    private static byte[] empty = new byte[0];
    private static final int BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[8192];
        try {
            int read;
            while ((read = input.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        finally {
            Closeables.closeQuietly((AutoCloseable)input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAll(InputStream input, int initialSize) throws IOException {
        initialSize = Math.max(initialSize, 32);
        int total = 0;
        int segmentSize = initialSize;
        ArrayList<byte[]> dataList = new ArrayList<byte[]>();
        try {
            int toRead;
            int read;
            do {
                int b;
                if ((b = input.read()) == -1) {
                    break;
                }
                byte[] segment = new byte[segmentSize];
                if (total > 0) {
                    segmentSize = Math.min(segmentSize * 2, 0x100000);
                }
                segment[0] = (byte)b;
                toRead = segment.length - 1;
                read = InputOutputs.readExact(input, segment, 1, toRead);
                if (Integer.MAX_VALUE - read < total) {
                    throw new RuntimeException("Data large than array max size");
                }
                total += read + 1;
                dataList.add(segment);
            } while (read == toRead);
        }
        finally {
            Closeables.closeQuietly((AutoCloseable)input);
        }
        if (dataList.size() == 0) {
            return empty;
        }
        if (dataList.size() == 1 && total == initialSize) {
            return (byte[])dataList.get(0);
        }
        byte[] data = new byte[total];
        int offset = 0;
        for (byte[] segment : dataList) {
            int size = Math.min(segment.length, total - offset);
            System.arraycopy(segment, 0, data, offset, size);
            offset += size;
        }
        return data;
    }

    public static byte[] readAll(InputStream input) throws IOException {
        return InputOutputs.readAll(input, 32);
    }

    public static int readExact(InputStream input, byte[] data, int offset, int len) throws IOException {
        int read;
        int total = 0;
        while (len > 0 && (read = input.read(data, offset, len)) != -1) {
            total += read;
            offset += read;
            len -= read;
        }
        return total;
    }

    public static int readExact(InputStream input, byte[] data) throws IOException {
        return InputOutputs.readExact(input, data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long consumeAll(InputStream input) throws IOException {
        byte[] buffer = new byte[8192];
        long total = 0L;
        try {
            int read;
            while ((read = input.read(buffer)) > 0) {
                total += (long)read;
            }
        }
        finally {
            Closeables.closeQuietly((AutoCloseable)input);
        }
        return total;
    }

    public static long skipExact(InputStream input, long len) throws IOException {
        long read;
        long count = 0L;
        while (len > 0L && (read = input.skip(len)) != 0L) {
            count += read;
            len -= read;
        }
        if (len == 0L) {
            return count;
        }
        byte[] buffer = new byte[8192];
        while (len > 0L && (read = (long)input.read(buffer, 0, (int)Math.min(len, (long)buffer.length))) != -1L) {
            count += read;
            len -= read;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long skipAll(InputStream input) throws IOException {
        long count = 0L;
        try {
            long read;
            while ((read = input.skip(Math.max(input.available(), 8192))) != 0L) {
                count += read;
            }
            int b = input.read();
            if (b == -1) {
                long l = count;
                return l;
            }
            byte[] buffer = new byte[8192];
            while ((read = (long)input.read(buffer)) != -1L) {
                count += read;
            }
        }
        finally {
            Closeables.closeQuietly((AutoCloseable)input);
        }
        return count;
    }
}

