/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.utils;

import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import net.dongliu.requests.Cookie;
import net.dongliu.requests.Parameter;
import net.dongliu.requests.utils.CookieDateUtil;

public class CookieUtils {
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String effectivePath(String path) {
        int idx = path.lastIndexOf(47);
        if (idx >= 0) {
            return path.substring(0, idx + 1);
        }
        return "/";
    }

    public static String escape(String value) {
        int count = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != ' ' && c != ';' && c != ',') continue;
            ++count;
        }
        if (count == 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value.length() + count * 2);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == ' ' || c == ';' || c == ',') {
                sb.append('%').append(hexChars[c >> 4]).append(hexChars[c & 0xF]);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isSubDomain(String domain, String subDomain) {
        if (domain.length() - 1 == subDomain.length()) {
            return domain.endsWith(subDomain);
        }
        return domain.length() < subDomain.length() && subDomain.endsWith(domain);
    }

    public static Cookie parseCookieHeader(String originDomain, String originPath, String headerValue) {
        String[] items = headerValue.split("; ");
        Map.Entry<String, String> nameValue = CookieUtils.parseCookieNameValue(items[0]);
        String domain = null;
        String path = null;
        long expiry = 0L;
        boolean secure = false;
        block18: for (String item : items) {
            Map.Entry<String, String> attribute = CookieUtils.parseCookieAttribute(item);
            switch (attribute.getKey().toLowerCase()) {
                case "domain": {
                    domain = CookieUtils.parseDomain(originDomain, attribute);
                    continue block18;
                }
                case "path": {
                    path = attribute.getValue().endsWith("/") ? attribute.getValue() : attribute.getValue() + "/";
                    continue block18;
                }
                case "expires": {
                    Date date = CookieDateUtil.parseDate(attribute.getValue());
                    if (date == null) continue block18;
                    expiry = date.getTime();
                    continue block18;
                }
                case "max-age": {
                    try {
                        int seconds = Integer.parseInt(attribute.getValue());
                        if (seconds < 0) continue block18;
                        expiry = System.currentTimeMillis() + (long)(seconds * 1000);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block18;
                }
                case "secure": {
                    secure = true;
                    continue block18;
                }
                case "httponly": {
                    continue block18;
                }
            }
        }
        return new Cookie(domain == null ? originDomain : domain, path == null ? originPath : path, nameValue.getKey(), nameValue.getValue(), expiry, secure);
    }

    private static Map.Entry<String, String> parseCookieNameValue(String str) {
        int idx = str.indexOf("=");
        if (idx < 0) {
            return Parameter.of("", str);
        }
        return Parameter.of(str.substring(0, idx), str.substring(idx + 1));
    }

    private static Map.Entry<String, String> parseCookieAttribute(String str) {
        int idx = str.indexOf("=");
        if (idx < 0) {
            return Parameter.of(str, "");
        }
        return Parameter.of(str.substring(0, idx), str.substring(idx + 1));
    }

    @Nullable
    private static String parseDomain(String currentDomain, Map.Entry<String, String> pair) {
        String domain = pair.getValue();
        if (!domain.startsWith(".")) {
            domain = "." + domain;
        }
        if (!CookieUtils.isSubDomain(domain, currentDomain)) {
            domain = null;
        }
        return domain;
    }
}

