/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.utils;

import javax.annotation.Nullable;

public class Closeables {
    public static void close(@Nullable AutoCloseable closeable, Throwable t) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
        }
    }

    public static void close(Throwable e, AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Throwable t) {
                e.addSuppressed(t);
            }
        }
    }

    @Nullable
    public static Throwable close(AutoCloseable ... closeables) {
        Throwable e = null;
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Throwable t) {
                if (e == null) {
                    e = t;
                    continue;
                }
                e.addSuppressed(t);
            }
        }
        return e;
    }

    public static void closeQuietly(@Nullable AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            Closeables.closeQuietly(closeable);
        }
    }
}

