/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.dongliu.requests.CertificateInfo;
import net.dongliu.requests.exception.RequestsException;
import net.dongliu.requests.utils.Exceptions;

class SSLSocketFactories {
    private static final SSLSocketFactory sslSocketFactoryLazy = SSLSocketFactories._getTrustAllSSLSocketFactory();
    private static final ConcurrentMap<Collection<CertificateInfo>, SSLSocketFactory> map = new ConcurrentHashMap<Collection<CertificateInfo>, SSLSocketFactory>();

    SSLSocketFactories() {
    }

    public static SSLSocketFactory _getTrustAllSSLSocketFactory() {
        SSLContext sslContext;
        TrustAllTrustManager trustManager = new TrustAllTrustManager();
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RequestsException(e);
        }
        return sslContext.getSocketFactory();
    }

    public static SSLSocketFactory getTrustAllSSLSocketFactory() {
        return sslSocketFactoryLazy;
    }

    private static SSLSocketFactory _getCustomSSLSocketFactory(Collection<CertificateInfo> certs) {
        SSLContext sslContext;
        CustomCertTrustManager trustManager = new CustomCertTrustManager(certs);
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RequestsException(e);
        }
        return sslContext.getSocketFactory();
    }

    public static SSLSocketFactory getCustomSSLSocketFactory(Collection<CertificateInfo> certs) {
        if (!map.containsKey(certs)) {
            map.put(certs, SSLSocketFactories._getCustomSSLSocketFactory(certs));
        }
        return (SSLSocketFactory)map.get(certs);
    }

    static class CustomCertTrustManager
    implements X509TrustManager {
        private final Collection<CertificateInfo> certs;
        private final X509TrustManager sunJSSEX509TrustManager;

        public CustomCertTrustManager(Collection<CertificateInfo> certs) {
            this.certs = certs;
            this.sunJSSEX509TrustManager = this.load();
        }

        private X509TrustManager load() {
            TrustManagerFactory trustManagerFactory;
            KeyStore ks;
            try {
                ks = KeyStore.getInstance("JKS");
            }
            catch (KeyStoreException e) {
                throw new RequestsException(e);
            }
            for (CertificateInfo cert : this.certs) {
                try {
                    ks.load(new FileInputStream(cert.getPath()), cert.getPassword() == null ? null : cert.getPassword().toCharArray());
                }
                catch (IOException e) {
                    throw Exceptions.sneakyThrow(e);
                }
                catch (NoSuchAlgorithmException | CertificateException e) {
                    throw new RequestsException(e);
                }
            }
            try {
                trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
                trustManagerFactory.init(ks);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new RequestsException(e);
            }
            for (TrustManager trustManger : trustManagerFactory.getTrustManagers()) {
                if (!(trustManger instanceof X509TrustManager)) continue;
                return (X509TrustManager)trustManger;
            }
            throw new RuntimeException("Couldn't initialize X509TrustManager");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.sunJSSEX509TrustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.sunJSSEX509TrustManager.checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.sunJSSEX509TrustManager.getAcceptedIssuers();
        }
    }

    static class TrustAllTrustManager
    implements X509TrustManager {
        TrustAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

