/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.dongliu.requests.utils.CookieUtils;

@Immutable
public class Cookie
implements Map.Entry<String, String>,
Serializable {
    private final String domain;
    private final String path;
    private final String name;
    private final String value;
    private final long expiry;
    private final boolean secure;

    public Cookie(String domain, String path, String name, String value, long expiry, boolean secure) {
        this.domain = Objects.requireNonNull(domain);
        this.path = Objects.requireNonNull(path);
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
        this.expiry = expiry;
        this.secure = secure;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setValue(String value) {
        throw new UnsupportedOperationException();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public boolean expired(long now) {
        return this.expiry != 0L && this.expiry < now;
    }

    public boolean match(String protocol, String host, String path) {
        if (this.secure && !protocol.equalsIgnoreCase("https")) {
            return false;
        }
        if (this.domain.startsWith(".") ? !CookieUtils.isSubDomain(this.domain, host) : !host.equals(this.domain)) {
            return false;
        }
        return path.startsWith(this.path);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        if (!this.domain.equals(cookie.domain)) {
            return false;
        }
        if (!this.path.equals(cookie.path)) {
            return false;
        }
        return this.name.equals(cookie.name);
    }

    @Override
    public int hashCode() {
        int result = this.domain.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "Cookie{domain='" + this.domain + '\'' + ", path='" + this.path + '\'' + ", name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", expiry=" + this.expiry + '}';
    }
}

