/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableFlatMapSingle<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;
    final boolean delayErrors;

    public ObservableFlatMapSingle(ObservableSource<T> source, Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean delayError) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayError;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new FlatMapSingleObserver<T, R>(observer, this.mapper, this.delayErrors));
    }

    static final class FlatMapSingleObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 8600231336733376951L;
        final Observer<? super R> downstream;
        final boolean delayErrors;
        final CompositeDisposable set;
        final AtomicInteger active;
        final AtomicThrowable errors;
        final Function<? super T, ? extends SingleSource<? extends R>> mapper;
        final AtomicReference<SpscLinkedArrayQueue<R>> queue;
        Disposable upstream;
        volatile boolean cancelled;

        FlatMapSingleObserver(Observer<? super R> actual, Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean delayErrors) {
            this.downstream = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.set = new CompositeDisposable();
            this.errors = new AtomicThrowable();
            this.active = new AtomicInteger(1);
            this.queue = new AtomicReference();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            SingleSource<R> ms;
            try {
                ms = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper returned a null SingleSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.dispose();
                this.onError(ex);
                return;
            }
            this.active.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            if (!this.cancelled && this.set.add(inner)) {
                ms.subscribe(inner);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.active.decrementAndGet();
            if (this.errors.addThrowable(t)) {
                if (!this.delayErrors) {
                    this.set.dispose();
                }
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.active.decrementAndGet();
            this.drain();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerSuccess(InnerObserver inner, R value) {
            this.set.delete(inner);
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.downstream.onNext(value);
                boolean d = this.active.decrementAndGet() == 0;
                SpscLinkedArrayQueue<R> q = this.queue.get();
                if (d && (q == null || q.isEmpty())) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SpscLinkedArrayQueue<R> q;
                SpscLinkedArrayQueue<R> spscLinkedArrayQueue = q = this.getOrCreateQueue();
                synchronized (spscLinkedArrayQueue) {
                    q.offer(value);
                }
                this.active.decrementAndGet();
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        SpscLinkedArrayQueue<R> getOrCreateQueue() {
            SpscLinkedArrayQueue<Object> current;
            do {
                if ((current = this.queue.get()) == null) continue;
                return current;
            } while (!this.queue.compareAndSet(null, current = new SpscLinkedArrayQueue(Observable.bufferSize())));
            return current;
        }

        void innerError(InnerObserver inner, Throwable e) {
            this.set.delete(inner);
            if (this.errors.addThrowable(e)) {
                if (!this.delayErrors) {
                    this.upstream.dispose();
                    this.set.dispose();
                }
                this.active.decrementAndGet();
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void clear() {
            SpscLinkedArrayQueue<R> q = this.queue.get();
            if (q != null) {
                q.clear();
            }
        }

        void drainLoop() {
            int missed = 1;
            Observer<R> a = this.downstream;
            AtomicInteger n = this.active;
            AtomicReference<SpscLinkedArrayQueue<R>> qr = this.queue;
            while (true) {
                boolean empty;
                Throwable ex;
                if (this.cancelled) {
                    this.clear();
                    return;
                }
                if (!this.delayErrors && (ex = (Throwable)this.errors.get()) != null) {
                    this.clear();
                    this.errors.tryTerminateConsumer(a);
                    return;
                }
                boolean d = n.get() == 0;
                SpscLinkedArrayQueue<R> q = qr.get();
                Object v = q != null ? (Object)q.poll() : null;
                boolean bl = empty = v == null;
                if (d && empty) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (!empty) {
                    a.onNext(v);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        final class InnerObserver
        extends AtomicReference<Disposable>
        implements SingleObserver<R>,
        Disposable {
            private static final long serialVersionUID = -502562646270949838L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onSuccess(R value) {
                FlatMapSingleObserver.this.innerSuccess(this, value);
            }

            @Override
            public void onError(Throwable e) {
                FlatMapSingleObserver.this.innerError(this, e);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.get());
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

