/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.io.ClasspathResourceIterable;
import cucumber.runtime.io.FileResource;
import cucumber.runtime.io.FlatteningIterator;
import cucumber.runtime.io.Resource;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Iterator;

public class FileResourceIterator
implements Iterator<Resource> {
    private final FlatteningIterator<Resource> flatteningIterator = new FlatteningIterator();

    public FileResourceIterator(File root, File file, final String suffix) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || ClasspathResourceIterable.hasSuffix(suffix, file.getPath());
            }
        };
        this.flatteningIterator.push(new FileIterator(root, file, filter));
    }

    @Override
    public boolean hasNext() {
        return this.flatteningIterator.hasNext();
    }

    @Override
    public Resource next() {
        return this.flatteningIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class FileIterator
    implements Iterator<Object> {
        private final Iterator<File> files;
        private final FileFilter filter;
        private final File root;

        FileIterator(File root, File file, FileFilter filter) {
            this.root = root;
            if (file.isDirectory()) {
                this.files = Arrays.asList(file.listFiles(filter)).iterator();
            } else if (file.isFile()) {
                this.files = Arrays.asList(file).iterator();
            } else {
                throw new IllegalArgumentException("Not a file or directory: " + file.getAbsolutePath());
            }
            this.filter = filter;
        }

        @Override
        public Object next() {
            File next = this.files.next();
            if (next.isDirectory()) {
                return new FileIterator(this.root, next, this.filter);
            }
            return new FileResource(this.root, next);
        }

        @Override
        public boolean hasNext() {
            return this.files.hasNext();
        }

        @Override
        public void remove() {
            this.files.remove();
        }
    }
}

