/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.DataTable;
import cucumber.runtime.CucumberException;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.table.TableConverter;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Step;
import gherkin.util.FixJava;
import gherkin.util.Mapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class StepDefinitionMatch
extends Match {
    private final StepDefinition stepDefinition;
    private final transient String featurePath;
    private final transient Step step;
    private final LocalizedXStreams localizedXStreams;

    public StepDefinitionMatch(List<Argument> arguments, StepDefinition stepDefinition, String featurePath, Step step, LocalizedXStreams localizedXStreams) {
        super(arguments, stepDefinition.getLocation(false));
        this.stepDefinition = stepDefinition;
        this.featurePath = featurePath;
        this.step = step;
        this.localizedXStreams = localizedXStreams;
    }

    public void runStep(I18n i18n) throws Throwable {
        try {
            this.stepDefinition.execute(i18n, this.transformedArgs(this.step, this.localizedXStreams.get(i18n.getLocale())));
        }
        catch (CucumberException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.removeFrameworkFramesAndAppendStepLocation(t, this.getStepLocation());
        }
    }

    private Object[] transformedArgs(Step step, LocalizedXStreams.LocalizedXStream xStream) {
        int argumentCount = this.getArguments().size();
        if (step.getRows() != null) {
            ++argumentCount;
        } else if (step.getDocString() != null) {
            ++argumentCount;
        }
        Integer parameterCount = this.stepDefinition.getParameterCount();
        if (parameterCount != null && argumentCount != parameterCount) {
            throw this.arityMismatch(parameterCount);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int n = 0;
        for (Argument a : this.getArguments()) {
            ParameterInfo parameterInfo = this.getParameterType(n, (Type)((Object)String.class));
            Object arg = parameterInfo.convert(a.getVal(), xStream);
            result.add(arg);
            ++n;
        }
        if (step.getRows() != null) {
            result.add(this.tableArgument(step, n, xStream));
        } else if (step.getDocString() != null) {
            result.add(step.getDocString().getValue());
        }
        return result.toArray(new Object[result.size()]);
    }

    private ParameterInfo getParameterType(int n, Type argumentType) {
        ParameterInfo parameterInfo = this.stepDefinition.getParameterType(n, argumentType);
        if (parameterInfo == null) {
            parameterInfo = new ParameterInfo(argumentType, null, null, false, null);
        }
        return parameterInfo;
    }

    private Object tableArgument(Step step, int argIndex, LocalizedXStreams.LocalizedXStream xStream) {
        ParameterInfo parameterInfo = this.getParameterType(argIndex, (Type)((Object)DataTable.class));
        TableConverter tableConverter = new TableConverter(xStream, parameterInfo);
        DataTable table = new DataTable(step.getRows(), tableConverter);
        Type type = parameterInfo.getType();
        return tableConverter.convert(table, type, parameterInfo.isTransposed());
    }

    private CucumberException arityMismatch(int parameterCount) {
        List<Argument> arguments = this.createArgumentsForErrorMessage(this.step);
        return new CucumberException(String.format("Arity mismatch: Step Definition '%s' with pattern [%s] is declared with %s parameters. However, the gherkin step has %s arguments %s. \nStep: %s%s", this.stepDefinition.getLocation(true), this.stepDefinition.getPattern(), parameterCount, arguments.size(), arguments, this.step.getKeyword(), this.step.getName()));
    }

    private List<Argument> createArgumentsForErrorMessage(Step step) {
        ArrayList<Argument> arguments = new ArrayList<Argument>(this.getArguments());
        if (step.getDocString() != null) {
            arguments.add(new Argument(Integer.valueOf(-1), "DocString:" + step.getDocString().getValue()));
        }
        if (step.getRows() != null) {
            List rows = FixJava.map((List)step.getRows(), (Mapper)new Mapper<DataTableRow, List<String>>(){

                public List<String> map(DataTableRow row) {
                    return row.getCells();
                }
            });
            arguments.add(new Argument(Integer.valueOf(-1), "Table:" + rows.toString()));
        }
        return arguments;
    }

    private Throwable removeFrameworkFramesAndAppendStepLocation(Throwable error, StackTraceElement stepLocation) {
        int newStackTraceLength;
        StackTraceElement[] stackTraceElements = error.getStackTrace();
        if (stackTraceElements.length == 0 || stepLocation == null) {
            return error;
        }
        for (newStackTraceLength = 1; newStackTraceLength < stackTraceElements.length && !this.stepDefinition.isDefinedAt(stackTraceElements[newStackTraceLength - 1]); ++newStackTraceLength) {
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[newStackTraceLength + 1];
        System.arraycopy(stackTraceElements, 0, newStackTrace, 0, newStackTraceLength);
        newStackTrace[newStackTraceLength] = stepLocation;
        error.setStackTrace(newStackTrace);
        return error;
    }

    public String getPattern() {
        return this.stepDefinition.getPattern();
    }

    public StackTraceElement getStepLocation() {
        return this.step.getStackTraceElement(this.featurePath);
    }

    public String getStepName() {
        return this.step.getName();
    }
}

