/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.retailadvqa_public.client.http;

import com.alibaba.cloudapi.sdk.client.ApacheHttpClient;
import com.alibaba.cloudapi.sdk.enums.HttpMethod;
import com.alibaba.cloudapi.sdk.enums.ParamPosition;
import com.alibaba.cloudapi.sdk.enums.Scheme;
import com.alibaba.cloudapi.sdk.model.ApiRequest;
import com.alibaba.cloudapi.sdk.model.ApiResponse;
import com.alibaba.cloudapi.sdk.model.HttpClientBuilderParams;
import com.aliyuncs.AcsError;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.reader.Reader;
import com.aliyuncs.reader.ReaderFactory;
import com.aliyuncs.retailadvqa_public.client.constants.QAConstant;
import com.aliyuncs.retailadvqa_public.client.constants.enums.InvokerType;
import com.aliyuncs.retailadvqa_public.client.param.ApiClientBuilderParam;
import com.aliyuncs.transform.UnmarshallerContext;
import com.aliyuncs.unmarshaller.Unmarshaller;
import com.aliyuncs.unmarshaller.UnmarshallerFactory;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.junit.Assert;

public class HttpApiClientAPI
extends ApacheHttpClient {
    private String oemCode;
    private String accessId;
    private static final String PATH_PREFIX_OEM = "/openapi/oem/";
    private static final String PATH_PREFIX_OTHER = "/openapi/";

    public void init(ApiClientBuilderParam builderParam) {
        if (builderParam == null) {
            throw new RuntimeException("HttpApiClientAPI init failure ! ApiClientBuilderParam is null");
        }
        this.oemCode = builderParam.getOemCode();
        this.accessId = builderParam.getAccessId();
        HttpClientBuilderParams httpParam = new HttpClientBuilderParams();
        httpParam.setScheme(Scheme.HTTP);
        httpParam.setHost(builderParam.getHost());
        httpParam.setAppKey(builderParam.getAppKey());
        httpParam.setAppSecret(builderParam.getAppSecret());
        httpParam.setConnectionTimeout(builderParam.getConnectionTimeout());
        httpParam.setWriteTimeout(builderParam.getWriteTimeout());
        httpParam.setReadTimeout(builderParam.getReadTimeout());
        super.init(httpParam);
    }

    public ApiResponse invokeMethodSyncMode(String path, AcsRequest acsRequest) {
        ApiRequest request = new ApiRequest(HttpMethod.POST_BODY, path);
        this.addParams(request, acsRequest);
        return this.sendSyncRequest(request);
    }

    private void addParams(ApiRequest request, AcsRequest acsRequest) {
        Object val;
        String key;
        String keyStr;
        if (!StringUtils.isBlank((CharSequence)this.oemCode)) {
            request.addParam("X-GW-OEMAPPCODE", this.oemCode, ParamPosition.HEAD, true);
        }
        if (!StringUtils.isBlank((CharSequence)this.accessId)) {
            request.addParam("X-GW-ACCESSID", this.accessId, ParamPosition.HEAD, true);
        }
        HashMap paramMap = new HashMap();
        for (Object obj : acsRequest.getSysBodyParameters().keySet()) {
            keyStr = String.valueOf(obj);
            key = (char)(keyStr.charAt(0) + 32) + keyStr.substring(1);
            if (paramMap.containsKey(key) || (val = acsRequest.getSysBodyParameters().get(keyStr)) == null) continue;
            request.addParam(key, String.valueOf(val), ParamPosition.QUERY, true);
        }
        for (Object obj : acsRequest.getSysQueryParameters().keySet()) {
            keyStr = String.valueOf(obj);
            key = (char)(keyStr.charAt(0) + 32) + keyStr.substring(1);
            if (paramMap.containsKey(key) || (val = acsRequest.getSysQueryParameters().get(keyStr)) == null) continue;
            request.addParam(key, String.valueOf(val), ParamPosition.QUERY, true);
        }
    }

    public AcsResponse invoke(AcsRequest request, InvokerType invokerTyp) throws ClientException {
        ApiResponse apiResponse = this.invokeApi(request, invokerTyp);
        Object acsResponse = HttpApiClientAPI.apiResponse2AcsResponse(request.getResponseClass(), apiResponse);
        return acsResponse;
    }

    public ApiResponse invokeApi(AcsRequest request, InvokerType invokerType) {
        String pathPrefix;
        Assert.assertNotNull((String)"parameter invokerType must not be null", (Object)((Object)invokerType));
        String action = request.getSysActionName();
        String path = QAConstant.mapActionUrlMapping.get(action);
        switch (invokerType) {
            case OEM: {
                pathPrefix = PATH_PREFIX_OEM;
                break;
            }
            default: {
                pathPrefix = PATH_PREFIX_OTHER;
            }
        }
        ApiResponse apiResponse = this.invokeMethodSyncMode(pathPrefix + path, request);
        return apiResponse;
    }

    public static <T extends AcsResponse> T apiResponse2AcsResponse(Class<T> clazz, ApiResponse apiResponse) throws ClientException {
        String contentType = apiResponse.getContentType().split(";")[0];
        FormatType format = FormatType.mapAcceptToFormat((String)contentType);
        if (FormatType.JSON != format && FormatType.XML != format) {
            byte[] body = apiResponse.getBody();
            if (body != null) {
                throw new ClientException(String.format("Server response has a bad format type: %s;\nThe original return is: %s;", contentType, StringEscapeUtils.unescapeHtml4((String)new String(body))));
            }
            throw new ClientException(String.format("Server response has a bad format type: %s;\nThe original return is: %s;", format, contentType));
        }
        if (apiResponse.getCode() == 200) {
            Unmarshaller unmarshaller = UnmarshallerFactory.getUnmarshaller((FormatType)format);
            String body = new String(apiResponse.getBody());
            try {
                return (T)unmarshaller.unmarshal(clazz, body);
            }
            catch (Exception e) {
                AcsError error = HttpApiClientAPI.readError(apiResponse, format);
                if (500 <= apiResponse.getCode()) {
                    throw new ServerException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
                }
                throw new ClientException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId(), error.getErrorDescription());
            }
        }
        AcsError error = HttpApiClientAPI.readError(apiResponse, format);
        if (500 <= apiResponse.getCode()) {
            throw new ServerException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
        }
        throw new ClientException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId(), error.getErrorDescription());
    }

    public static AcsError readError(ApiResponse apiResponse, FormatType format) throws ClientException {
        AcsError error = new AcsError();
        String responseEndpoint = "Error";
        Reader reader = ReaderFactory.createInstance((FormatType)format);
        UnmarshallerContext context = new UnmarshallerContext();
        String stringContent = new String(apiResponse.getBody());
        if (stringContent == null) {
            error.setErrorCode("(null)");
            error.setErrorMessage("(null)");
            error.setRequestId("(null)");
            error.setStatusCode(apiResponse.getCode());
        } else {
            context.setResponseMap(reader.read(stringContent, responseEndpoint));
            error.setErrorCode((String)context.getResponseMap().get("Error.errorCode"));
            error.setErrorMessage((String)context.getResponseMap().get("Error.exStack"));
            error.setRequestId((String)context.getResponseMap().get("Error.traceId"));
            error.setErrorDescription((String)context.getResponseMap().get("Error.errorDesc"));
            error.setStatusCode(apiResponse.getCode());
        }
        return error;
    }
}

