/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.retailadvqa_public.client.data;

import com.aliyuncs.retailadvqa_public.client.model.ColumnVO;
import com.aliyuncs.retailadvqa_public.client.model.TableVO;
import java.util.ArrayList;

public class TableGenerator {
    public static final String TABLE_SUFFIX = "_qci2";
    public static final String DATASET_SUFFIX = "_qci2";
    public static final String MAI_DATA_OSS_PATH = "/oem/maiscrm/test/mul_workspace/%s";
    public static boolean USE_WS_TABLE = true;
    static AbstractTableFactory factory = USE_WS_TABLE ? new TableWithWsFactory() : new TableFactory();

    public static TableVO generateLabelTable() {
        return factory.generateLabel();
    }

    public static TableVO generateBehavior() {
        return factory.generateBehavior();
    }

    public static TableVO generateBrandDim() {
        return factory.generateBrandDim();
    }

    public static TableVO generateChannelDim() {
        return factory.generateChannelDim();
    }

    public static TableVO generateTypeDim() {
        return factory.generateTypeDim();
    }

    static class TableWithWsFactory
    extends TableFactory {
        TableWithWsFactory() {
        }

        @Override
        public TableVO generateLabel() {
            TableVO testTable = super.generateLabel();
            testTable.getColumns().add(new ColumnVO("ws_id", "varchar", "\u6240\u5c5e\u7a7a\u95f4"));
            testTable.setOssPath(String.format(TableGenerator.MAI_DATA_OSS_PATH, "t_user_info_ws.txt"));
            return testTable;
        }

        @Override
        public TableVO generateBehavior() {
            TableVO testTable = super.generateBehavior();
            testTable.getColumns().add(new ColumnVO("ws_id", "varchar", "\u6240\u5c5e\u7a7a\u95f4"));
            testTable.setOssPath(String.format(TableGenerator.MAI_DATA_OSS_PATH, "behavior_fact_table_ws.txt"));
            return testTable;
        }

        @Override
        public TableVO generateBrandDim() {
            TableVO testTable = super.generateBrandDim();
            testTable.getColumns().add(new ColumnVO("ws_id", "varchar", "\u6240\u5c5e\u7a7a\u95f4"));
            testTable.setOssPath(String.format(TableGenerator.MAI_DATA_OSS_PATH, "behavior_brand_dim_table_ws.txt"));
            return testTable;
        }

        @Override
        public TableVO generateChannelDim() {
            TableVO testTable = super.generateChannelDim();
            testTable.getColumns().add(new ColumnVO("ws_id", "varchar", "\u6240\u5c5e\u7a7a\u95f4"));
            testTable.setOssPath(String.format(TableGenerator.MAI_DATA_OSS_PATH, "behavior_channel_table_ws.txt"));
            return testTable;
        }

        @Override
        public TableVO generateTypeDim() {
            TableVO testTable = super.generateTypeDim();
            testTable.getColumns().add(new ColumnVO("ws_id", "varchar", "\u6240\u5c5e\u7a7a\u95f4"));
            testTable.setOssPath(String.format(TableGenerator.MAI_DATA_OSS_PATH, "behavior_type_dim_table_ws.txt"));
            return testTable;
        }
    }

    static class TableFactory
    implements AbstractTableFactory {
        TableFactory() {
        }

        @Override
        public TableVO generateLabel() {
            TableVO testTable = new TableVO();
            ArrayList<ColumnVO> columnVOList = new ArrayList<ColumnVO>();
            columnVOList.add(new ColumnVO("user_id", "varchar", "id"));
            columnVOList.add(new ColumnVO("user_name", "varchar", "\u59d3\u540d"));
            columnVOList.add(new ColumnVO("love_color", "varchar", "\u559c\u6b22\u7684\u989c\u8272"));
            columnVOList.add(new ColumnVO("ip", "varchar", "ip"));
            columnVOList.add(new ColumnVO("password", "varchar", "\u5bc6\u7801"));
            columnVOList.add(new ColumnVO("job", "varchar", "\u804c\u4e1a"));
            columnVOList.add(new ColumnVO("phone", "varchar", "\u624b\u673a\u53f7"));
            columnVOList.add(new ColumnVO("first_buy_date", "timestamp", "\u7b2c\u4e00\u6b21\u8d2d\u4e70\u65f6\u95f4"));
            columnVOList.add(new ColumnVO("email", "varchar", "\u90ae\u7bb1"));
            columnVOList.add(new ColumnVO("love_thing", "varchar", "\u559c\u6b22\u7684\u4e8b"));
            columnVOList.add(new ColumnVO("sex", "varchar", "\u6027\u522b"));
            columnVOList.add(new ColumnVO("behavior", "double", "behavior"));
            testTable.setColumns(columnVOList);
            testTable.setTableName("oem_maiscrm_user_info_qci2");
            testTable.setOssPath(String.format(TableGenerator.MAI_DATA_OSS_PATH, "t_user_info.txt"));
            return testTable;
        }

        @Override
        public TableVO generateBehavior() {
            TableVO testTable = new TableVO();
            ArrayList<ColumnVO> columnVOList = new ArrayList<ColumnVO>();
            columnVOList.add(new ColumnVO("id", "int", "id"));
            columnVOList.add(new ColumnVO("behavior_user_id", "varchar", "\u884c\u4e3a\u7528\u6237id"));
            columnVOList.add(new ColumnVO("behavior_date", "timestamp", "\u884c\u4e3a\u65e5\u671f"));
            columnVOList.add(new ColumnVO("behavior_type", "varchar", "\u884c\u4e3a\u7c7b\u578b"));
            columnVOList.add(new ColumnVO("behavior_object_type", "varchar", "\u884c\u4e3a\u5bf9\u8c61\u7c7b\u578b"));
            columnVOList.add(new ColumnVO("behavior_object_value", "varchar", "\u884c\u4e3a\u5bf9\u8c61\u503c"));
            columnVOList.add(new ColumnVO("behavior_channel", "varchar", "\u884c\u4e3a\u6e20\u9053"));
            columnVOList.add(new ColumnVO("behavior_counts", "int", "\u884c\u4e3a\u6b21\u6570"));
            columnVOList.add(new ColumnVO("behavior_amounts", "double", "\u884c\u4e3a\u91d1\u989d"));
            columnVOList.add(new ColumnVO("email", "varchar", "\u90ae\u7bb1"));
            columnVOList.add(new ColumnVO("idfa", "varchar", "idfa"));
            columnVOList.add(new ColumnVO("imei", "varchar", "imei"));
            columnVOList.add(new ColumnVO("mobile", "varchar", "\u624b\u673a"));
            columnVOList.add(new ColumnVO("test", "varchar", "test"));
            testTable.setColumns(columnVOList);
            testTable.setTableName("oem_maiscrm_behavior_fact_table_qci2");
            testTable.setOssPath(String.format(TableGenerator.MAI_DATA_OSS_PATH, "behavior_fact_table.txt"));
            return testTable;
        }

        @Override
        public TableVO generateBrandDim() {
            TableVO testTable = new TableVO();
            ArrayList<ColumnVO> columnVOList = new ArrayList<ColumnVO>();
            columnVOList.add(new ColumnVO("id", "int", "id"));
            columnVOList.add(new ColumnVO("brand", "varchar", "\u54c1\u724c"));
            testTable.setColumns(columnVOList);
            testTable.setTableName("oem_maiscrm_behavior_brand_dim_table_qci2");
            testTable.setOssPath(String.format(TableGenerator.MAI_DATA_OSS_PATH, "behavior_brand_dim_table.txt"));
            return testTable;
        }

        @Override
        public TableVO generateChannelDim() {
            TableVO testTable = new TableVO();
            ArrayList<ColumnVO> columnVOList = new ArrayList<ColumnVO>();
            columnVOList.add(new ColumnVO("id", "int", "id"));
            columnVOList.add(new ColumnVO("behavior_channel", "varchar", "\u6e20\u9053"));
            testTable.setColumns(columnVOList);
            testTable.setTableName("oem_maiscrm_behavior_channel_table_qci2");
            testTable.setOssPath(String.format(TableGenerator.MAI_DATA_OSS_PATH, "behavior_channel_table.txt"));
            return testTable;
        }

        @Override
        public TableVO generateTypeDim() {
            TableVO testTable = new TableVO();
            ArrayList<ColumnVO> columnVOList = new ArrayList<ColumnVO>();
            columnVOList.add(new ColumnVO("id", "int", "id"));
            columnVOList.add(new ColumnVO("behavior_type", "varchar", "\u6e20\u9053"));
            testTable.setColumns(columnVOList);
            testTable.setTableName("oem_maiscrm_behavior_type_dim_table_qci2");
            testTable.setOssPath(String.format(TableGenerator.MAI_DATA_OSS_PATH, "behavior_type_dim_table.txt"));
            return testTable;
        }
    }

    static interface AbstractTableFactory {
        public TableVO generateLabel();

        public TableVO generateBehavior();

        public TableVO generateBrandDim();

        public TableVO generateChannelDim();

        public TableVO generateTypeDim();
    }
}

