/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.retailadvqa_public.client;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.retailadvqa_public.client.constants.enums.GatewayType;
import com.aliyuncs.retailadvqa_public.client.constants.enums.InvokerType;
import com.aliyuncs.retailadvqa_public.client.http.HttpApiClientAPI;
import com.aliyuncs.retailadvqa_public.client.http.HttpPopClientAPI;
import com.aliyuncs.retailadvqa_public.client.param.ApiClientBuilderParam;
import com.aliyuncs.retailadvqa_public.client.param.PopClientBuilderParam;

public class QAHttpApiClient {
    private static HttpPopClientAPI popClient = new HttpPopClientAPI();
    private static HttpApiClientAPI apiInstance = new HttpApiClientAPI();

    public static void initApiInstance(ApiClientBuilderParam apiClientBuilderParam) {
        if (apiClientBuilderParam == null) {
            throw new RuntimeException("apiClientBuilderParam must not be null");
        }
        apiInstance.init(apiClientBuilderParam);
    }

    public static void initPopInstance(PopClientBuilderParam popClientBuilderParam) throws ClientException {
        if (popClientBuilderParam == null) {
            throw new RuntimeException("popClientBuilderParam must not be null");
        }
        popClient.init(popClientBuilderParam);
    }

    @Deprecated
    public static AcsResponse invoke(AcsRequest request, GatewayType gatewayType) throws ClientException {
        AcsResponse acsResponse;
        switch (gatewayType) {
            case POP: {
                acsResponse = popClient.invoke(request);
                break;
            }
            default: {
                acsResponse = apiInstance.invoke(request, InvokerType.OEM);
            }
        }
        return acsResponse;
    }

    public static AcsResponse invokeByOem(AcsRequest request, GatewayType gatewayType) throws ClientException {
        AcsResponse acsResponse;
        switch (gatewayType) {
            case POP: {
                acsResponse = popClient.invoke(request);
                break;
            }
            default: {
                acsResponse = apiInstance.invoke(request, InvokerType.OEM);
            }
        }
        return acsResponse;
    }

    public static AcsResponse invokeByOther(AcsRequest request, GatewayType gatewayType) throws ClientException {
        AcsResponse acsResponse;
        switch (gatewayType) {
            case POP: {
                acsResponse = popClient.invoke(request);
                break;
            }
            default: {
                acsResponse = apiInstance.invoke(request, InvokerType.OTHER);
            }
        }
        return acsResponse;
    }

    public static AcsResponse invoke(AcsRequest request, GatewayType gatewayType, InvokerType invokerType) throws ClientException {
        AcsResponse acsResponse;
        switch (gatewayType) {
            case POP: {
                acsResponse = popClient.invoke(request);
                break;
            }
            default: {
                acsResponse = apiInstance.invoke(request, invokerType);
            }
        }
        return acsResponse;
    }
}

