/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Glacier2;

import com.zeroc.Glacier2.RouterPrx;
import com.zeroc.Glacier2.SessionNotExistException;
import com.zeroc.Glacier2.SessionPrx;
import com.zeroc.Ice.ACMHeartbeat;
import com.zeroc.Ice.Connection;
import com.zeroc.Ice.ConnectionLostException;
import com.zeroc.Ice.ConnectionRefusedException;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.InitializationData;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.RequestFailedException;
import com.zeroc.Ice.SignalPolicy;
import com.zeroc.Ice.TimeoutException;
import com.zeroc.Ice.UnknownLocalException;
import com.zeroc.Ice.Util;
import com.zeroc.IceInternal.Ex;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;

public abstract class Application
extends com.zeroc.Ice.Application {
    private static ObjectAdapter _adapter;
    private static RouterPrx _router;
    private static SessionPrx _session;
    private static String _category;

    public Application() {
    }

    public Application(SignalPolicy signalPolicy) {
        super(signalPolicy);
    }

    public abstract SessionPrx createSession();

    public abstract int runWithSession(String[] var1) throws RestartSessionException;

    public void sessionDestroyed() {
    }

    public final int run(String[] args) {
        assert (false);
        return 0;
    }

    public static void restart() throws RestartSessionException {
        throw new RestartSessionException();
    }

    public static RouterPrx router() {
        return _router;
    }

    public static SessionPrx session() {
        return _session;
    }

    public static String categoryForClient() throws SessionNotExistException {
        if (_router == null) {
            throw new SessionNotExistException();
        }
        return _category;
    }

    public static Identity createCallbackIdentity(String name) throws SessionNotExistException {
        return new Identity(name, Application.categoryForClient());
    }

    public static ObjectPrx addWithUUID(Object servant) throws SessionNotExistException {
        return Application.objectAdapter().add(servant, Application.createCallbackIdentity(UUID.randomUUID().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectAdapter objectAdapter() throws SessionNotExistException {
        if (_router == null) {
            throw new SessionNotExistException();
        }
        java.lang.Object object = _mutex;
        synchronized (object) {
            if (_adapter == null) {
                _adapter = Application.communicator().createObjectAdapterWithRouter("", (com.zeroc.Ice.RouterPrx)_router);
                _adapter.activate();
            }
        }
        return _adapter;
    }

    protected int doMain(String[] args, InitializationData initData) {
        DoMainResult r;
        initData.properties.setProperty("Ice.RetryIntervals", "-1");
        do {
            InitializationData id = initData.clone();
            id.properties = id.properties._clone();
            String[] a = (String[])args.clone();
            r = this.doMainInternal(a, id);
        } while (r.restart);
        return r.returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DoMainResult doMainInternal(String[] args, InitializationData initData) {
        boolean sessionCreated;
        DoMainResult r;
        block38: {
            _callbackInProgress = false;
            _destroyed = false;
            _interrupted = false;
            r = new DoMainResult();
            r.restart = false;
            r.returnValue = 0;
            sessionCreated = false;
            try {
                ArrayList remainingArgs = new ArrayList();
                _communicator = Util.initialize((String[])args, (InitializationData)initData, remainingArgs);
                _router = RouterPrx.uncheckedCast((ObjectPrx)Application.communicator().getDefaultRouter());
                if (_router == null) {
                    Util.getProcessLogger().error("no glacier2 router configured");
                    r.returnValue = 1;
                    break block38;
                }
                if (_signalPolicy == SignalPolicy.HandleSignals) {
                    Application.destroyOnInterrupt();
                }
                try {
                    _session = this.createSession();
                    sessionCreated = true;
                }
                catch (LocalException ex) {
                    Util.getProcessLogger().error(Ex.toString((Throwable)ex));
                    r.returnValue = 1;
                }
                if (!sessionCreated) break block38;
                int acmTimeout = 0;
                try {
                    acmTimeout = _router.getACMTimeout();
                }
                catch (OperationNotExistException operationNotExistException) {
                    // empty catch block
                }
                if (acmTimeout <= 0) {
                    acmTimeout = (int)_router.getSessionTimeout();
                }
                if (acmTimeout > 0) {
                    Connection connection = _router.ice_getCachedConnection();
                    assert (connection != null);
                    connection.setACM(OptionalInt.of(acmTimeout), null, Optional.of(ACMHeartbeat.HeartbeatAlways));
                    connection.setCloseCallback(con -> this.sessionDestroyed());
                }
                _category = _router.getCategoryForClient();
                r.returnValue = this.runWithSession(remainingArgs.toArray(new String[remainingArgs.size()]));
            }
            catch (RestartSessionException ex) {
                r.restart = true;
            }
            catch (ConnectionRefusedException ex) {
                Util.getProcessLogger().error(Ex.toString((Throwable)ex));
                r.restart = true;
            }
            catch (ConnectionLostException ex) {
                Util.getProcessLogger().error(Ex.toString((Throwable)ex));
                r.restart = true;
            }
            catch (UnknownLocalException ex) {
                Util.getProcessLogger().error(Ex.toString((Throwable)ex));
                r.restart = true;
            }
            catch (RequestFailedException ex) {
                Util.getProcessLogger().error(Ex.toString((Throwable)ex));
                r.restart = true;
            }
            catch (TimeoutException ex) {
                Util.getProcessLogger().error(Ex.toString((Throwable)ex));
                r.restart = true;
            }
            catch (LocalException ex) {
                Util.getProcessLogger().error(Ex.toString((Throwable)ex));
                r.returnValue = 1;
            }
            catch (Exception ex) {
                Util.getProcessLogger().error("unknown exception:\n" + Ex.toString((Throwable)ex));
                r.returnValue = 1;
            }
            catch (Error err2) {
                Util.getProcessLogger().error("Java error:\n" + Ex.toString((Throwable)err2));
                r.returnValue = 1;
            }
        }
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            Application.defaultInterrupt();
        }
        java.lang.Object err2 = _mutex;
        synchronized (err2) {
            while (_callbackInProgress) {
                try {
                    _mutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (_destroyed) {
                _communicator = null;
            } else {
                _destroyed = true;
            }
        }
        if (sessionCreated && _router != null) {
            try {
                _router.destroySession();
            }
            catch (ConnectionLostException err2) {
            }
            catch (SessionNotExistException err2) {
            }
            catch (Throwable ex) {
                Util.getProcessLogger().error("unexpected exception when destroying the session:\n" + Ex.toString((Throwable)ex));
            }
            _router = null;
        }
        if (_communicator != null) {
            _communicator.destroy();
            _communicator = null;
        }
        java.lang.Object object = _mutex;
        synchronized (object) {
            if (_appHook != null) {
                _appHook.done();
            }
        }
        _adapter = null;
        _router = null;
        _session = null;
        _category = null;
        return r;
    }

    private static class DoMainResult {
        int returnValue;
        boolean restart;

        private DoMainResult() {
        }
    }

    public static class RestartSessionException
    extends Exception {
    }
}

