/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request.impl;

import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.request.QSRequestBody;
import com.qingstor.sdk.request.impl.EmptyRequestBody;
import com.qingstor.sdk.request.impl.InputStreamUploadBody;
import com.qingstor.sdk.utils.QSLoggerUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;

public class QSFormRequestBody
implements QSRequestBody {
    private static Logger logger = QSLoggerUtil.setLoggerHanlder(QSFormRequestBody.class.getName());

    @Override
    public RequestBody getRequestBody(String contentType, long contentLength, String method, Map<String, Object> bodyParams, Map<String, Object> queryParams) throws QSException {
        logger.info("----QSFormRequestBody----");
        MediaType mediaType = MediaType.parse(contentType);
        if (bodyParams != null && bodyParams.size() > 0) {
            Iterator<Map.Entry<String, Object>> iterator = bodyParams.entrySet().iterator();
            if (this.checkHasFileBody(bodyParams)) {
                MultipartBody.Builder requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM);
                String fileKey = "";
                File file = null;
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> entry = iterator.next();
                    String key = entry.getKey();
                    Object bodyObj = bodyParams.get(key);
                    if (bodyObj instanceof File) {
                        fileKey = key;
                        file = (File)bodyObj;
                        continue;
                    }
                    if (bodyObj instanceof InputStream) {
                        requestBody.addFormDataPart("form-data", key, new InputStreamUploadBody(contentType, (InputStream)bodyObj, contentLength));
                        continue;
                    }
                    if (bodyObj instanceof Map) {
                        requestBody.addFormDataPart(key, QSStringUtil.getMapToJson((Map)bodyObj).toString());
                        continue;
                    }
                    Object json = QSStringUtil.objectJSONValue(bodyObj);
                    requestBody.addFormDataPart(key, String.valueOf(json));
                }
                if (file != null) {
                    requestBody.addFormDataPart(fileKey, file.getName(), RequestBody.create(mediaType, file));
                }
                return requestBody.build();
            }
            FormBody.Builder requestFormBody = new FormBody.Builder();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String key = entry.getKey();
                Object bodyObj = bodyParams.get(key);
                Object json = QSStringUtil.objectJSONValue(bodyObj);
                requestFormBody.add(key, String.valueOf(json));
            }
            return requestFormBody.build();
        }
        if (HttpMethod.permitsRequestBody(method)) {
            return new EmptyRequestBody(contentType);
        }
        return null;
    }

    private boolean checkHasFileBody(Map formParams) {
        Iterator iterator = formParams.entrySet().iterator();
        boolean hasFile = false;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            Object bodyObj = formParams.get(key);
            if (bodyObj instanceof File) {
                hasFile = true;
                continue;
            }
            if (!(bodyObj instanceof InputStream)) continue;
            hasFile = true;
        }
        return hasFile;
    }
}

