/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request;

import com.qingstor.sdk.config.EnvContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.QSOkHttpRequestClient;
import com.qingstor.sdk.request.QSRequestBody;
import com.qingstor.sdk.request.impl.QSFormRequestBody;
import com.qingstor.sdk.request.impl.QSMultiPartUploadRequestBody;
import com.qingstor.sdk.request.impl.QSNormalRequestBody;
import com.qingstor.sdk.utils.Base64;
import com.qingstor.sdk.utils.QSLoggerUtil;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import com.qingstor.sdk.utils.QSSignatureUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Request;
import okhttp3.RequestBody;

public class QSBuilder {
    private static final String REQUEST_PREFIX = "/";
    private static Logger logger = QSLoggerUtil.setLoggerHanlder(QSBuilder.class.getName());
    private Map context;
    private RequestInputModel paramsModel;
    private String requestMethod = "GET";
    private Map paramsQuery;
    private Map paramsBody;
    private Map paramsHeaders;
    private Map paramsFormData;
    private String requestUrl;
    private String requestUrlStyle;

    public QSBuilder(Map context, RequestInputModel params) throws QSException {
        this.context = context;
        this.paramsModel = params;
        this.initParams();
        this.initRequestUrl();
    }

    private void initParams() throws QSException {
        this.paramsQuery = QSParamInvokeUtil.getRequestParams(this.paramsModel, "query");
        this.paramsBody = QSParamInvokeUtil.getRequestParams(this.paramsModel, "body");
        this.paramsHeaders = QSParamInvokeUtil.getRequestParams(this.paramsModel, "header");
        this.paramsFormData = QSParamInvokeUtil.getRequestParams(this.paramsModel, "formData");
        this.paramsHeaders = this.headParamEncoding(this.paramsHeaders);
        if (this.context.get("User-Agent") != null) {
            this.paramsHeaders.put("User-Agent", this.context.get("User-Agent"));
        }
        if (this.checkExpiresParam()) {
            this.paramsHeaders.clear();
            this.paramsHeaders.put("Expires", this.context.get("expires"));
        }
        String requestApi = (String)this.context.get("APIName");
        this.initHeadContentMd5(requestApi, this.paramsBody, this.paramsHeaders);
        this.requestMethod = (String)this.context.get("RequestMethod");
    }

    private void doSignature() throws QSException {
        String authSign = this.getParamSignature();
        logger.log(Level.INFO, "== authSign ==\n" + authSign + "\n");
        this.paramsHeaders.put("Authorization", authSign);
    }

    private String getParamSignature() throws QSException {
        String authSign = "";
        EnvContext envContext = (EnvContext)this.context.get("evnContext");
        try {
            if (this.checkExpiresParam()) {
                authSign = QSSignatureUtil.generateSignature(envContext.getAccessSecret(), this.getStringToSignature());
                authSign = URLEncoder.encode(authSign, "UTF-8");
            } else {
                authSign = QSSignatureUtil.generateAuthorization(envContext.getAccessKey(), envContext.getAccessSecret(), this.getStringToSignature());
            }
        }
        catch (Exception e) {
            throw new QSException("Auth signature error", e);
        }
        return authSign;
    }

    private void initRequestUrl() throws QSException {
        EnvContext envContext = (EnvContext)this.context.get("evnContext");
        String bucketName = (String)this.context.get("bucketNameInput");
        String zone = (String)this.context.get("RequestZone");
        String objectName = (String)this.context.get("objectNameInput");
        String requestSuffixPath = this.getRequestSuffixPath((String)this.context.get("RequestURI"), bucketName, objectName);
        this.requestUrlStyle = envContext.getRequestUrlStyle();
        this.requestUrl = this.getSignedUrl(envContext.getRequestUrl(), zone, bucketName, this.paramsQuery, requestSuffixPath);
        logger.log(Level.INFO, "== requestUrl ==\n" + this.requestUrl + "\n");
    }

    private Map headParamEncoding(Map headParams) throws QSException {
        HashMap head = new HashMap();
        for (Map.Entry entry : headParams.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("x-qs-") && !key.startsWith("X-QS-")) {
                head.put(key, headParams.get(key));
                continue;
            }
            String keyValue = QSStringUtil.asciiCharactersEncoding(headParams.get(key) + "");
            head.put(key, keyValue);
        }
        return head;
    }

    private void initHeadContentMd5(String requestApi, Map paramsBody, Map paramsHead) throws QSException {
        if ("DeleteMultipleObjects".equals(requestApi) && paramsBody.size() > 0) {
            Object bodyContent = QSNormalRequestBody.getBodyContent(paramsBody);
            MessageDigest instance = null;
            try {
                instance = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new QSException("MessageDigest MD5 error", e);
            }
            String contentMD5 = new String(Base64.encode(instance.digest(bodyContent.toString().getBytes())));
            paramsHead.put("Content-MD5", contentMD5);
        }
    }

    private String getRequestSuffixPath(String requestPath, String bucketName, String objectName) throws QSException {
        if (QSStringUtil.isEmpty(bucketName)) {
            return REQUEST_PREFIX;
        }
        String suffixPath = requestPath.replace("/<bucket-name>", "").replace("/<object-key>", "");
        objectName = QSStringUtil.isEmpty(objectName) ? "" : QSStringUtil.asciiCharactersEncoding(objectName);
        return String.format("%s%s%s", REQUEST_PREFIX, objectName, suffixPath);
    }

    private String getSignedUrl(String serviceUrl, String zone, String bucketName, Map paramsQuery, String requestSuffixPath) throws QSException {
        String storRequestUrl;
        if ("".equals(bucketName) || bucketName == null) {
            return QSSignatureUtil.generateQSURL(paramsQuery, serviceUrl + requestSuffixPath);
        }
        if ("path_style".equals(this.requestUrlStyle)) {
            storRequestUrl = serviceUrl.replace("://", "://" + zone + ".") + REQUEST_PREFIX + bucketName;
        } else {
            storRequestUrl = serviceUrl.replace("://", "://%s." + zone + ".");
            storRequestUrl = String.format(storRequestUrl, bucketName);
        }
        return QSSignatureUtil.generateQSURL(paramsQuery, storRequestUrl + requestSuffixPath);
    }

    public void setHeader(String key, String authorization) {
        this.paramsHeaders.put(key, authorization);
    }

    public void setSignature(String accessKey, String signature) throws QSException {
        try {
            EnvContext envContext = (EnvContext)this.context.get("evnContext");
            envContext.setAccessKey(accessKey);
            signature = this.checkExpiresParam() ? URLEncoder.encode(signature, "UTF-8") : String.format("QS %s:%s", accessKey, signature);
            this.paramsHeaders.put("Authorization", signature);
        }
        catch (UnsupportedEncodingException e) {
            throw new QSException("Auth signature error", e);
        }
    }

    public String getStringToSignature() throws QSException {
        String bucketName = (String)this.context.get("bucketNameInput");
        String requestPath = (String)this.context.get("RequestURI");
        String objectName = (String)this.context.get("objectNameInput");
        if (this.context.containsKey("objectNameInput")) {
            requestPath = requestPath.replace("<bucket-name>", bucketName);
            requestPath = requestPath.replace("<object-key>", QSStringUtil.asciiCharactersEncoding(objectName));
        } else {
            requestPath = requestPath.replace("<bucket-name>", bucketName + REQUEST_PREFIX);
        }
        return QSSignatureUtil.getStringToSignature(this.requestMethod, requestPath, this.paramsQuery, this.paramsHeaders);
    }

    public RequestBody getRequestBody(QSRequestBody qsRrequestBody) throws QSException {
        this.getSignature();
        RequestBody requestBody = null;
        String contentType = String.valueOf(this.paramsHeaders.get("Content-Type"));
        long contentLength = 0L;
        if (this.paramsHeaders.containsKey("Content-Length")) {
            contentLength = Long.parseLong(this.paramsHeaders.get("Content-Length") + "");
        }
        requestBody = qsRrequestBody != null ? qsRrequestBody.getRequestBody(contentType, contentLength, this.requestMethod, this.paramsBody, this.paramsQuery) : this.getRequestBody();
        return requestBody;
    }

    public RequestBody getRequestBody() throws QSException {
        String requestApi;
        this.getSignature();
        RequestBody requestBody = null;
        String contentType = String.valueOf(this.paramsHeaders.get("Content-Type"));
        long contentLength = 0L;
        if (this.paramsHeaders.containsKey("Content-Length")) {
            contentLength = Long.parseLong(this.paramsHeaders.get("Content-Length") + "");
        }
        requestBody = this.paramsFormData != null && this.paramsFormData.size() > 0 ? new QSFormRequestBody().getRequestBody(contentType, contentLength, this.requestMethod, this.paramsFormData, this.paramsQuery) : ("UploadMultipart".equals(requestApi = (String)this.context.get("APIName")) ? new QSMultiPartUploadRequestBody().getRequestBody(contentType, contentLength, this.requestMethod, this.paramsBody, this.paramsQuery) : new QSNormalRequestBody().getRequestBody(contentType, contentLength, this.requestMethod, this.paramsBody, this.paramsQuery));
        return requestBody;
    }

    public Request getRequest(RequestBody requestBody) throws QSException {
        if (this.checkExpiresParam()) {
            throw new QSException("You need to 'getExpiresRequestUrl' do request!");
        }
        return QSOkHttpRequestClient.getInstance().buildRequest(this.requestMethod, this.requestUrl, requestBody, this.paramsHeaders);
    }

    private boolean checkExpiresParam() {
        Object expiresTime = this.context.get("expires");
        return expiresTime != null;
    }

    public String getExpiresRequestUrl() throws QSException {
        Object expiresTime = this.context.get("expires");
        if (expiresTime != null) {
            String storRequestUrl;
            EnvContext envContext = (EnvContext)this.context.get("evnContext");
            String expireAuth = this.getSignature();
            String serviceUrl = envContext.getRequestUrl();
            String objectName = (String)this.context.get("objectNameInput");
            String bucketName = (String)this.context.get("bucketNameInput");
            String zone = (String)this.context.get("RequestZone");
            if ("path_style".equals(this.requestUrlStyle)) {
                storRequestUrl = serviceUrl.replace("://", "://" + zone + ".") + REQUEST_PREFIX + bucketName;
            } else {
                storRequestUrl = serviceUrl.replace("://", "://%s." + zone + ".");
                storRequestUrl = String.format(storRequestUrl, bucketName);
            }
            objectName = QSStringUtil.asciiCharactersEncoding(objectName);
            String requestPath = (String)this.context.get("RequestURI");
            requestPath = requestPath.replace("/<bucket-name>", "").replace("/<object-key>", objectName);
            if (requestPath != null && requestPath.indexOf("?") > 0) {
                String expiresUrl = String.format(storRequestUrl + "/%s&access_key_id=%s&expires=%s&signature=%s", requestPath, envContext.getAccessKey(), expiresTime + "", expireAuth);
                return QSSignatureUtil.generateQSURL(this.paramsQuery, expiresUrl);
            }
            String expiresUrl = String.format(storRequestUrl + "/%s?access_key_id=%s&expires=%s&signature=%s", requestPath, envContext.getAccessKey(), expiresTime + "", expireAuth);
            return QSSignatureUtil.generateQSURL(this.paramsQuery, expiresUrl);
        }
        throw new QSException("ExpiresRequestUrl error:There is no expirs params");
    }

    private String getSignature() throws QSException {
        String signature = String.valueOf(this.paramsHeaders.get("Authorization"));
        if (QSStringUtil.isEmpty(signature)) {
            this.doSignature();
            return String.valueOf(this.paramsHeaders.get("Authorization"));
        }
        return String.valueOf(signature);
    }
}

