/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.config;

import com.qingstor.sdk.constants.QSConstant;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.request.ParamValidate;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class EnvContext
implements ParamValidate {
    public static String qingcloudStorHost = "qingstor.com";
    public static String default_protocal = "https";
    private String accessKey;
    private String accessSecret;
    private String host;
    private String port;
    private String protocol = default_protocal;
    private String uri;
    private String log_level = QSConstant.LOGGER_ERROR;
    private String additionalUserAgent;
    private String requestUrlStyle;
    private boolean safeOkHttp = true;

    public String getRequestUrlStyle() {
        return this.requestUrlStyle;
    }

    public void setRequestUrlStyle(String requestUrlStyle) {
        this.requestUrlStyle = requestUrlStyle;
    }

    public boolean isSafeOkHttp() {
        return this.safeOkHttp;
    }

    @Deprecated
    public void setSafeOkHttp(boolean safeOkHttp) {
        this.safeOkHttp = safeOkHttp;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public void setAccessSecret(String accessSecret) {
        this.accessSecret = accessSecret;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUri() {
        return this.uri;
    }

    public String getRequestUrl() {
        String joinUrl = this.getProtocol() + "://" + this.getHost();
        if (this.getPort() != null) {
            joinUrl = joinUrl + ":" + this.getPort();
        }
        if (this.getUri() != null) {
            joinUrl = joinUrl + this.getUri();
        }
        return joinUrl;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    private EnvContext() {
    }

    public EnvContext(String accessKey, String accessSecret) {
        this.setAccessKey(accessKey);
        this.setAccessSecret(accessSecret);
        this.setHost(qingcloudStorHost);
        QSConstant.LOGGER_LEVEL = this.getLog_level();
    }

    public static EnvContext loadFromFile(String filePathName) throws QSException {
        EnvContext env = new EnvContext();
        File f = new File(filePathName);
        EnvContext.loadYaml(env, f);
        return env;
    }

    public static void loadYaml(EnvContext env, File f) throws QSException {
        if (f.exists()) {
            Object br = null;
            Yaml yaml = new Yaml();
            try {
                Map confParams = (Map)yaml.load(new FileInputStream(f));
                env.setAccessKey(EnvContext.getYamlConfig("access_key_id", confParams));
                env.setAccessSecret(EnvContext.getYamlConfig("secret_access_key", confParams));
                env.setProtocol(EnvContext.getYamlConfig("protocol", confParams));
                env.setHost(EnvContext.getYamlConfig("host", confParams));
                env.setUri(EnvContext.getYamlConfig("uri", confParams));
                env.setPort(EnvContext.getYamlConfig("port", confParams));
                env.setLog_level(EnvContext.getYamlConfig("log_level", confParams));
                env.setAdditionalUserAgent(EnvContext.getYamlConfig("additional_user_agent", confParams));
                env.setRequestUrlStyle(EnvContext.getYamlConfig("request_url_style", confParams));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new QSException("Yaml config error:", e);
            }
        }
    }

    public static String getYamlConfig(String key, Map config) {
        if (config.containsKey(key)) {
            return String.valueOf(config.get(key));
        }
        return null;
    }

    public String getLog_level() {
        return this.log_level;
    }

    public void setLog_level(String log_level) {
        if (!QSStringUtil.isEmpty(log_level)) {
            QSConstant.LOGGER_LEVEL = log_level;
        }
        this.log_level = log_level;
    }

    public String getAdditionalUserAgent() {
        return this.additionalUserAgent;
    }

    public void setAdditionalUserAgent(String additionalUserAgent) {
        this.additionalUserAgent = additionalUserAgent;
    }

    @Override
    public String validateParam() {
        if (QSStringUtil.isEmpty(this.getAccessKey())) {
            return QSStringUtil.getParameterRequired("AccessKey", "EnvContext");
        }
        if (QSStringUtil.isEmpty(this.getRequestUrl())) {
            return QSStringUtil.getParameterRequired("host", "EnvContext");
        }
        if (!QSStringUtil.isEmpty(this.getAdditionalUserAgent())) {
            for (int i = 0; i < this.getAdditionalUserAgent().length(); ++i) {
                char temp = this.getAdditionalUserAgent().charAt(i);
                char value = temp;
                if (value >= ' ' && value <= '~' && value != ' ' && value != '\"') continue;
                return "additional User-Agent contains characters that not allowed :" + this.getAdditionalUserAgent().substring(i, i + 1);
            }
        }
        return null;
    }
}

