/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.provider;

import com.xxl.rpc.registry.ServiceRegistry;
import com.xxl.rpc.remoting.net.Server;
import com.xxl.rpc.remoting.net.impl.netty.server.NettyServer;
import com.xxl.rpc.remoting.net.params.BaseCallback;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.serialize.impl.HessianSerializer;
import com.xxl.rpc.util.IpUtil;
import com.xxl.rpc.util.NetUtil;
import com.xxl.rpc.util.ThrowableUtil;
import com.xxl.rpc.util.XxlRpcException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlRpcProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(XxlRpcProviderFactory.class);
    private Class<? extends Server> server = NettyServer.class;
    private Class<? extends Serializer> serializer = HessianSerializer.class;
    private int corePoolSize = 60;
    private int maxPoolSize = 300;
    private String ip = null;
    private int port = 7080;
    private String accessToken = null;
    private Class<? extends ServiceRegistry> serviceRegistry = null;
    private Map<String, String> serviceRegistryParam = null;
    private Server serverInstance;
    private Serializer serializerInstance;
    private ServiceRegistry serviceRegistryInstance;
    private String serviceAddress;
    private Map<String, Object> serviceData = new HashMap<String, Object>();

    public void setServer(Class<? extends Server> server) {
        this.server = server;
    }

    public void setSerializer(Class<? extends Serializer> serializer) {
        this.serializer = serializer;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setServiceRegistry(Class<? extends ServiceRegistry> serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setServiceRegistryParam(Map<String, String> serviceRegistryParam) {
        this.serviceRegistryParam = serviceRegistryParam;
    }

    public Serializer getSerializerInstance() {
        return this.serializerInstance;
    }

    public int getPort() {
        return this.port;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void start() throws Exception {
        if (this.server == null) {
            throw new XxlRpcException("xxl-rpc provider server missing.");
        }
        if (this.serializer == null) {
            throw new XxlRpcException("xxl-rpc provider serializer missing.");
        }
        if (this.corePoolSize <= 0 || this.maxPoolSize <= 0 || this.maxPoolSize < this.corePoolSize) {
            this.corePoolSize = 60;
            this.maxPoolSize = 300;
        }
        if (this.ip == null) {
            this.ip = IpUtil.getIp();
        }
        if (this.port <= 0) {
            this.port = 7080;
        }
        if (NetUtil.isPortUsed(this.port)) {
            throw new XxlRpcException("xxl-rpc provider port[" + this.port + "] is used.");
        }
        this.serializerInstance = this.serializer.newInstance();
        this.serviceAddress = IpUtil.getIpPort(this.ip, this.port);
        this.serverInstance = this.server.newInstance();
        this.serverInstance.setStartedCallback(new BaseCallback(){

            @Override
            public void run() throws Exception {
                if (XxlRpcProviderFactory.this.serviceRegistry != null) {
                    XxlRpcProviderFactory.this.serviceRegistryInstance = (ServiceRegistry)XxlRpcProviderFactory.this.serviceRegistry.newInstance();
                    XxlRpcProviderFactory.this.serviceRegistryInstance.start(XxlRpcProviderFactory.this.serviceRegistryParam);
                    if (XxlRpcProviderFactory.this.serviceData.size() > 0) {
                        XxlRpcProviderFactory.this.serviceRegistryInstance.registry(XxlRpcProviderFactory.this.serviceData.keySet(), XxlRpcProviderFactory.this.serviceAddress);
                    }
                }
            }
        });
        this.serverInstance.setStopedCallback(new BaseCallback(){

            @Override
            public void run() {
                if (XxlRpcProviderFactory.this.serviceRegistryInstance != null) {
                    if (XxlRpcProviderFactory.this.serviceData.size() > 0) {
                        XxlRpcProviderFactory.this.serviceRegistryInstance.remove(XxlRpcProviderFactory.this.serviceData.keySet(), XxlRpcProviderFactory.this.serviceAddress);
                    }
                    XxlRpcProviderFactory.this.serviceRegistryInstance.stop();
                    XxlRpcProviderFactory.this.serviceRegistryInstance = null;
                }
            }
        });
        this.serverInstance.start(this);
    }

    public void stop() throws Exception {
        this.serverInstance.stop();
    }

    public Map<String, Object> getServiceData() {
        return this.serviceData;
    }

    public static String makeServiceKey(String iface, String version) {
        String serviceKey = iface;
        if (version != null && version.trim().length() > 0) {
            serviceKey = serviceKey + "#".concat(version);
        }
        return serviceKey;
    }

    public void addService(String iface, String version, Object serviceBean) {
        String serviceKey = XxlRpcProviderFactory.makeServiceKey(iface, version);
        this.serviceData.put(serviceKey, serviceBean);
        logger.info(">>>>>>>>>>> xxl-rpc, provider factory add service success. serviceKey = {}, serviceBean = {}", (Object)serviceKey, serviceBean.getClass());
    }

    public XxlRpcResponse invokeService(XxlRpcRequest xxlRpcRequest) {
        XxlRpcResponse xxlRpcResponse = new XxlRpcResponse();
        xxlRpcResponse.setRequestId(xxlRpcRequest.getRequestId());
        String serviceKey = XxlRpcProviderFactory.makeServiceKey(xxlRpcRequest.getClassName(), xxlRpcRequest.getVersion());
        Object serviceBean = this.serviceData.get(serviceKey);
        if (serviceBean == null) {
            xxlRpcResponse.setErrorMsg("The serviceKey[" + serviceKey + "] not found.");
            return xxlRpcResponse;
        }
        if (System.currentTimeMillis() - xxlRpcRequest.getCreateMillisTime() > 180000L) {
            xxlRpcResponse.setErrorMsg("The timestamp difference between admin and executor exceeds the limit.");
            return xxlRpcResponse;
        }
        if (this.accessToken != null && this.accessToken.trim().length() > 0 && !this.accessToken.trim().equals(xxlRpcRequest.getAccessToken())) {
            xxlRpcResponse.setErrorMsg("The access token[" + xxlRpcRequest.getAccessToken() + "] is wrong.");
            return xxlRpcResponse;
        }
        try {
            Class<?> serviceClass = serviceBean.getClass();
            String methodName = xxlRpcRequest.getMethodName();
            Class<?>[] parameterTypes = xxlRpcRequest.getParameterTypes();
            Object[] parameters = xxlRpcRequest.getParameters();
            Method method = serviceClass.getMethod(methodName, parameterTypes);
            method.setAccessible(true);
            Object result = method.invoke(serviceBean, parameters);
            xxlRpcResponse.setResult(result);
        }
        catch (Throwable t) {
            logger.error("xxl-rpc provider invokeService error.", t);
            xxlRpcResponse.setErrorMsg(ThrowableUtil.toString(t));
        }
        return xxlRpcResponse;
    }
}

