/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.invoker.route.impl;

import com.xxl.rpc.remoting.invoker.route.XxlRpcLoadBalance;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class XxlRpcLoadBalanceLRUStrategy
extends XxlRpcLoadBalance {
    private ConcurrentMap<String, LinkedHashMap<String, String>> jobLRUMap = new ConcurrentHashMap<String, LinkedHashMap<String, String>>();
    private long CACHE_VALID_TIME = 0L;

    public String doRoute(String serviceKey, TreeSet<String> addressSet) {
        LinkedHashMap lruItem;
        if (System.currentTimeMillis() > this.CACHE_VALID_TIME) {
            this.jobLRUMap.clear();
            this.CACHE_VALID_TIME = System.currentTimeMillis() + 86400000L;
        }
        if ((lruItem = (LinkedHashMap)this.jobLRUMap.get(serviceKey)) == null) {
            lruItem = new LinkedHashMap<String, String>(16, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                    return super.size() > 1000;
                }
            };
            this.jobLRUMap.putIfAbsent(serviceKey, lruItem);
        }
        for (String string : addressSet) {
            if (lruItem.containsKey(string)) continue;
            lruItem.put(string, string);
        }
        ArrayList<String> delKeys = new ArrayList<String>();
        for (String existKey : lruItem.keySet()) {
            if (addressSet.contains(existKey)) continue;
            delKeys.add(existKey);
        }
        if (delKeys.size() > 0) {
            for (String delKey : delKeys) {
                lruItem.remove(delKey);
            }
        }
        String string = (String)lruItem.entrySet().iterator().next().getKey();
        String eldestValue = (String)lruItem.get(string);
        return eldestValue;
    }

    @Override
    public String route(String serviceKey, TreeSet<String> addressSet) {
        String finalAddress = this.doRoute(serviceKey, addressSet);
        return finalAddress;
    }
}

