/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.response;

import com.mzlion.core.io.IOUtils;
import com.mzlion.core.json.TypeRef;
import com.mzlion.core.lang.Assert;
import com.mzlion.easyokhttp.exception.HttpClientException;
import com.mzlion.easyokhttp.exception.HttpStatusCodeException;
import com.mzlion.easyokhttp.response.handle.DataHandler;
import com.mzlion.easyokhttp.response.handle.FileDataHandler;
import com.mzlion.easyokhttp.response.handle.JsonDataHandler;
import com.mzlion.easyokhttp.response.handle.StringDataHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import okhttp3.Response;

public class HttpResponse
implements Serializable {
    private static final long serialVersionUID = -861108072820490102L;
    private transient Response rawResponse;
    private boolean isSuccess;
    private String errorMessage;
    private int errorCode;

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean success) {
        this.isSuccess = success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setRawResponse(Response rawResponse) {
        this.rawResponse = rawResponse;
    }

    public String asString() {
        return this.custom(StringDataHandler.create());
    }

    public <E> E asBean(Class<E> targetClass) {
        return this.custom(new JsonDataHandler<E>(targetClass));
    }

    public <E> E asBean(TypeRef<E> typeRef) {
        return this.custom(new JsonDataHandler<E>(typeRef));
    }

    public byte[] asByteData() {
        this.assertSuccess();
        try {
            byte[] byArray = this.rawResponse.body().bytes();
            return byArray;
        }
        catch (IOException e) {
            throw new HttpClientException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.rawResponse);
        }
    }

    public void asFile(File saveFile) {
        Assert.notNull((Object)saveFile, (String)"SaveFile may noy be null.");
        this.custom(new FileDataHandler(saveFile.getParent(), saveFile.getName()));
    }

    public void asStream(OutputStream out) {
        Assert.notNull((Object)out, (String)"OutputStream is null.");
        this.assertSuccess();
        try {
            IOUtils.copy((InputStream)this.rawResponse.body().byteStream(), (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.rawResponse);
        }
    }

    public <T> T custom(DataHandler<T> dataHandler) {
        this.assertSuccess();
        try {
            T t = dataHandler.handle(this.rawResponse);
            return t;
        }
        catch (IOException e) {
            throw new HttpClientException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.rawResponse);
        }
    }

    private void assertSuccess() {
        if (!this.isSuccess) {
            throw new HttpStatusCodeException(this.rawResponse.request().url().toString(), this.errorCode, this.errorMessage);
        }
    }
}

