/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.request;

import com.mzlion.core.json.gson.JsonUtil;
import com.mzlion.core.lang.Assert;
import com.mzlion.easyokhttp.request.BaseBodyHttpRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class TextBodyRequest
extends BaseBodyHttpRequest<TextBodyRequest> {
    private String content;
    private String _type;
    private Charset charset = StandardCharsets.UTF_8;

    public TextBodyRequest(String url) {
        super(url);
    }

    public TextBodyRequest text(String text) {
        this.content = text == null ? "" : text;
        this._type = "text/plain";
        return this;
    }

    public TextBodyRequest json(String json) {
        Assert.hasLength((String)json, (String)"Json may not be null.");
        this.content = json;
        this._type = "application/json";
        return this;
    }

    public TextBodyRequest json(Object value) {
        Assert.notNull((Object)value, (String)"Value may not be null.");
        this.content = JsonUtil.toJson((Object)value);
        this._type = "application/json";
        return this;
    }

    public TextBodyRequest xml(String xml) {
        Assert.hasLength((String)xml, (String)"Xml may not be null.");
        this.content = xml;
        this._type = "application/xml";
        return this;
    }

    public TextBodyRequest html(String html) {
        Assert.hasLength((String)html, (String)"Html may not be null.");
        this.content = html;
        this._type = "application/html";
        return this;
    }

    public TextBodyRequest javascript(String javascript) {
        Assert.hasLength((String)javascript, (String)"Javascript may not be null.");
        this.content = javascript;
        this._type = "application/javascript";
        return this;
    }

    public TextBodyRequest charset(String charset) {
        Assert.hasLength((String)charset, (String)"Charset may not be null.");
        this.charset = Charset.forName(charset);
        return this;
    }

    @Override
    protected RequestBody generateRequestBody() {
        MediaType contentType = MediaType.parse((String)String.format("%s; charset=%s", this._type, this.charset));
        return RequestBody.create((MediaType)contentType, (String)this.content);
    }
}

