/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.BizvaneRole;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@Primary
public class UserServiceImpl
implements UserService {
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private UserCommissionService userCommissionService;
    @Resource
    private CompanyBrandRelationMapper companyBrandRelationMapper;

    public User findOneByCondition(User loginUserInfo) {
        User remoteUser = null;
        if (loginUserInfo.getUnionid() != null) {
            remoteUser = this.bizvaneInterface.getMemberInfo(loginUserInfo);
        }
        ArrayList<Object> authorities = new ArrayList<Object>();
        authorities.add(() -> ((BizvaneRole)BizvaneRole.WECHAT_USER).role());
        if (remoteUser != null) {
            authorities.add(() -> ((BizvaneRole)BizvaneRole.USER).role());
            loginUserInfo.setUserNo(remoteUser.getUserNo());
            loginUserInfo.setFullName(remoteUser.getFullName());
            loginUserInfo.setUserId(remoteUser.getUserId());
            loginUserInfo.setBrandId(remoteUser.getBrandId());
            loginUserInfo.setLevelId(remoteUser.getLevelId());
            loginUserInfo.setHeadImgUrl(remoteUser.getHeadImgUrl());
            loginUserInfo.setEnabledCommission(remoteUser.getEnabledCommission());
            this.userCommissionService.getUserCommissionAccounts(loginUserInfo);
        }
        loginUserInfo.setAuthorities(authorities);
        return loginUserInfo;
    }

    public UserDiscountDTO getUserDiscountInfo(User user) {
        User remoteUser = this.bizvaneInterface.getMemberInfo(user);
        return this.bizvaneInterface.userLevelDiscountInfo(remoteUser.getLevelId());
    }

    public CompanyBrandRelation getCompany(Integer merchantId) {
        Example example = new Example(CompanyBrandRelation.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOneByExample((Object)example);
        return companyBrandRelation;
    }
}

