/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.dto.GoodsQueryDTO;
import com.wmeimob.fastboot.bizvane.entity.Activity;
import com.wmeimob.fastboot.bizvane.entity.Comments;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsGiftRelation;
import com.wmeimob.fastboot.bizvane.entity.GoodsPropValueCustom;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpecRelation;
import com.wmeimob.fastboot.bizvane.mapper.ActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.CommentsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsPropHeadCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecRelationMapper;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@Primary
public class GoodsServiceImpl
implements GoodsService {
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsPropHeadCustomMapper goodsPropHeadCustomMapper;
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private GoodsSpecRelationMapper goodsSpecRelationMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private CommentsMapper commentsMapper;

    public List<Goods> findByCondition(Object condition) {
        GoodsQueryDTO goodsQueryDTO = (GoodsQueryDTO)condition;
        return this.goodsMapper.selectGoodsListByClassifyId(goodsQueryDTO);
    }

    public Goods findOneByCondition(Goods condition) {
        return this.goodsMapper.selectGoodsById(condition);
    }

    public List<GoodsPropValueCustom> getGoodsPropsByGoodsId(Integer goodsId) {
        return this.goodsPropHeadCustomMapper.selectGoodsPropsByGoodsId(goodsId);
    }

    public List<GoodsGiftRelation> getGoodsGiftsByGoodsId(Integer goodsId) {
        return this.goodsMapper.selectGoodsGiftsByGoodsId(goodsId);
    }

    public List<Activity> getGoodsActivityByGoodsId(Integer goodsId) {
        return this.activityMapper.selectGoodsActivityByGoodsId(goodsId);
    }

    public List<GoodsSpecRelation> getGoodsSpecs(Integer goodsId) {
        return this.goodsSpecRelationMapper.selectGoodsSpecs(goodsId);
    }

    public List<GoodsSkuDetail> getGoodsSkus(Integer goodsId) {
        GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
        goodsSkuDetail.setGoodsId(goodsId);
        goodsSkuDetail.setIsDel(Boolean.FALSE);
        return this.goodsSkuDetailMapper.select((Object)goodsSkuDetail);
    }

    public List<Comments> getGoodsEvaluate(Integer goodsId) {
        return this.commentsMapper.selectGoodsEvaluate(goodsId);
    }

    public Goods findById(Integer id) {
        return (Goods)this.goodsMapper.selectByPrimaryKey((Object)id);
    }

    public List<Goods> findByCondition(Goods condition) {
        Example example = new Example(Goods.class);
        Example.Criteria criteria = example.createCriteria();
        if (condition.getIdList() != null && !condition.getIdList().isEmpty()) {
            criteria.andIn("id", (Iterable)condition.getIdList());
        }
        criteria.andEqualTo("merchantId", (Object)condition.getMerchantId()).andLike("goodsName", StringUtils.fullFuzzy((String)condition.getGoodsName())).andEqualTo("isDel", (Object)false).andEqualTo("isShelved", (Object)condition.getIsShelved());
        return this.goodsMapper.selectByExample((Object)example);
    }

    public void incrementSales(List<Goods> collect) {
        this.goodsMapper.incrementSales(collect);
    }
}

