/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.Collect;
import com.wmeimob.fastboot.bizvane.mapper.CollectMapper;
import com.wmeimob.fastboot.bizvane.service.CollectService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class CollectServiceImpl
implements CollectService {
    @Autowired
    private CollectMapper collectMapper;

    public boolean isCollected(Collect collect) {
        int count = this.collectMapper.selectCount((Object)collect);
        return count > 0;
    }

    public List<Collect> findByCondition(Collect collect) {
        return this.collectMapper.selectCollectGoodsList(collect);
    }

    public int delete(Integer[] idArr) {
        if (idArr == null || idArr.length == 0) {
            throw new CustomException("\u6ca1\u6709\u5220\u9664\u4efb\u4f55\u9009\u9879");
        }
        Example example = new Example(Collect.class);
        example.createCriteria().andIn("id", Arrays.asList(idArr));
        int result = this.collectMapper.deleteByExample((Object)example);
        if (result == 0) {
            throw new CustomException("\u6ca1\u6709\u5220\u9664\u4efb\u4f55\u9009\u9879");
        }
        return result;
    }

    public Collect add(Collect collect) {
        InputValidator.checkEmpty((Object)collect.getWechatOpenid(), (String)"openid");
        InputValidator.checkNull((Object)collect.getWechatOpenid(), (String)"favoriteId");
        InputValidator.checkNull((Object)collect.getWechatOpenid(), (String)"favoriteType");
        Example example = new Example(Collect.class);
        example.createCriteria().andEqualTo("wechatOpenid", (Object)collect.getWechatOpenid()).andEqualTo("favoriteId", (Object)collect.getFavoriteId()).andEqualTo("favoriteType", (Object)collect.getFavoriteType());
        List collects = this.collectMapper.selectByExample((Object)example);
        if (!collects.isEmpty()) {
            this.collectMapper.deleteByExample((Object)example);
            return collect;
        }
        Date date = new Date();
        collect.setGmtCreate(date);
        this.collectMapper.insertSelective((Object)collect);
        return collect;
    }
}

