/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.Activity;
import com.wmeimob.fastboot.bizvane.entity.ActivityRule;
import com.wmeimob.fastboot.bizvane.entity.ActivityRuleGift;
import com.wmeimob.fastboot.bizvane.entity.ActivityStipulation;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.enums.ActivitySanEnum;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityStipulationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.service.ActivityService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class ActivityServiceImpl
implements ActivityService {
    @Autowired
    private ActivityGoodsMapper activityGoodsMapper;
    @Autowired
    private ActivityStipulationMapper activityStipulationMapper;
    @Resource
    private ActivityMapper activityMapper;
    @Resource
    private ActivityGiftMapper activityGiftMapper;
    @Autowired
    private ActivityRuleMapper activityRuleMapper;
    @Autowired
    private ActivityRuleGiftMapper activityRuleGiftMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;

    public List<Goods> queryDiscountByShopCartGoods(Integer merchantId, List<Goods> queryDiscountGoods) {
        List activityIds = this.activityGoodsMapper.selectDistinctActivityIds(queryDiscountGoods, merchantId);
        if (null == activityIds || activityIds.isEmpty()) {
            queryDiscountGoods.forEach(x -> x.setDiscount(new BigDecimal("1")));
            return queryDiscountGoods;
        }
        HashMap<Integer, ActivityStipulation> goodsmap = new HashMap<Integer, ActivityStipulation>();
        HashMap<Integer, TreeSet> mapGoodsids = new HashMap<Integer, TreeSet>();
        for (Integer activityId : activityIds) {
            HashSet<Integer> goodsids = new HashSet<Integer>();
            List goodsIds = this.activityGoodsMapper.selectActivityGoodsIdsByActivityId(activityId);
            Integer quantity = 0;
            for (Goods goods : queryDiscountGoods) {
                if (!goodsIds.contains(goods.getId())) continue;
                quantity = quantity + goods.getCount();
                goodsids.add(goods.getId());
            }
            ActivityStipulation activityStipulation = new ActivityStipulation();
            activityStipulation.setActivityId(activityId);
            activityStipulation.setTotal(quantity);
            if (null == (activityStipulation = this.activityStipulationMapper.selectStipulationByCondition(activityStipulation))) continue;
            goodsmap.put(activityId, activityStipulation);
            for (Integer goodsid : goodsids) {
                TreeSet bigDecimals = null;
                if (mapGoodsids.containsKey(goodsid)) {
                    bigDecimals = (TreeSet)mapGoodsids.get(goodsid);
                    bigDecimals.add(activityStipulation.getDiscount());
                } else {
                    bigDecimals = new TreeSet();
                    bigDecimals.add(activityStipulation.getDiscount());
                }
                mapGoodsids.put(goodsid, bigDecimals);
            }
        }
        for (Goods goods : queryDiscountGoods) {
            if (mapGoodsids.containsKey(goods.getId())) {
                TreeSet bigDecimals = (TreeSet)mapGoodsids.get(goods.getId());
                goods.setDiscount((BigDecimal)bigDecimals.first());
                continue;
            }
            goods.setDiscount(new BigDecimal("1"));
        }
        return queryDiscountGoods;
    }

    public List<Goods> queryCurrentGiftGoodsByAmount(Integer merchantId, BigDecimal amount) {
        ArrayList result = new ArrayList();
        Example example = new Example(Activity.class);
        example.orderBy("gmtCreate").desc();
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("status", (Object)Boolean.TRUE).andEqualTo("type", (Object)ActivitySanEnum.FULL_GIFT.getCode()).andCondition("DATE_FORMAT(NOW(),'%Y-%m-%d %H:%i:%S') BETWEEN DATE_FORMAT(begin_date,'%Y-%m-%d %H:%i:%S') AND DATE_FORMAT(end_date,'%Y-%m-%d %H:%i:%S')");
        List activities = this.activityMapper.selectByExample((Object)example);
        for (Activity activity : activities) {
            Example ruleExample = new Example(ActivityRule.class);
            ruleExample.setOrderByClause("amount DESC,sort ASC");
            ruleExample.createCriteria().andEqualTo("activityId", (Object)activity.getId());
            List rules = this.activityRuleMapper.selectByExample((Object)ruleExample);
            result.addAll(rules);
        }
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (ActivityRule rule : result) {
            if (amount.compareTo(new BigDecimal(rule.getAmount())) <= -1) continue;
            Example giftExample = new Example(ActivityRuleGift.class);
            giftExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
            List ruleGifts = this.activityRuleGiftMapper.selectByExample((Object)giftExample);
            for (ActivityRuleGift gift : ruleGifts) {
                Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)gift.getGoodsId());
                Example skuQuery = new Example(GoodsSkuDetail.class);
                skuQuery.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
                GoodsSkuDetail detail = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOneByExample((Object)skuQuery);
                if (detail == null || detail.getStock() == 0) continue;
                goods.setCount(gift.getGoodsNumber());
                goodsList.add(goods);
            }
        }
        return goodsList;
    }

    public List<Activity> findByCondition(Activity condition) {
        String nowDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        Example example = new Example(Activity.class);
        example.createCriteria().andEqualTo("status", (Object)true).andEqualTo("type", (Object)condition.getType()).andLessThanOrEqualTo("beginDate", (Object)nowDate).andGreaterThanOrEqualTo("endDate", (Object)nowDate);
        return this.activityMapper.selectByExample((Object)example);
    }
}

