/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccountLogs;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccounts;
import com.wmeimob.fastboot.bizvane.service.UserCommissionAccountLogsService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.fastboot.util.StringUtils;
import com.wmeimob.wechat.open.core.Wechat3rdPlatformHandler;
import com.wmeimob.wechat.open.exception.LoaderNotFoundException;
import java.io.Serializable;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import me.hao0.wechat.core.Wechat;
import me.hao0.wechat.model.qrcode.WXAQRCodeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/commission"})
public class UserCommissionController {
    private static final Logger log = LoggerFactory.getLogger(UserCommissionController.class);
    @Resource
    private UserCommissionService userCommissionService;
    @Resource
    private UserCommissionAccountLogsService userCommissionAccountLogsService;
    @Resource
    private WechatService wechatService;
    @Resource
    private Wechat3rdPlatformHandler wechat3rdPlatformHandler;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    private static final String USER_WXA_CODE_KEY = "wxacode:appid:%s:userNo:%s";

    @GetMapping
    @PreAuthorize(value="hasRole('USER')")
    public UserCommissionAccounts getUserCommission() {
        User user = (User)SecurityContext.getUser();
        return (UserCommissionAccounts)this.userCommissionService.findById(user.getUserNo());
    }

    @GetMapping(value={"lower"})
    @PreAuthorize(value="hasRole('USER')")
    public List getLowerList() {
        User user = (User)SecurityContext.getUser();
        UserCommissionAccounts userCommissionAccounts = new UserCommissionAccounts();
        userCommissionAccounts.setUserNo(user.getUserNo());
        return this.userCommissionService.findByCondition((Serializable)userCommissionAccounts);
    }

    @GetMapping(value={"lower/{id}"})
    @PreAuthorize(value="hasRole('USER')")
    public List getLowerOrderList(@PathVariable(value="id") Integer accountId) {
        UserCommissionAccountLogs accountLogs = new UserCommissionAccountLogs();
        User user = (User)SecurityContext.getUser();
        accountLogs.setUserNo(user.getUserNo());
        accountLogs.setContributionAccountId(accountId);
        return this.userCommissionAccountLogsService.selectLowerOrderList(accountLogs);
    }

    @GetMapping(value={"log"})
    @PreAuthorize(value="hasRole('USER')")
    public List getLogList(UserCommissionAccountLogs userCommissionAccountLogs) {
        User user = (User)SecurityContext.getUser();
        userCommissionAccountLogs.setUserNo(user.getUserNo());
        return this.userCommissionAccountLogsService.findByCondition((Serializable)userCommissionAccountLogs);
    }

    @PostMapping
    @PreAuthorize(value="hasRole('USER')")
    public void withdrawal(UserCommissionAccountLogs userCommissionAccountLogs) {
        User user = (User)SecurityContext.getUser();
        userCommissionAccountLogs.setOpenId(user.getOpenid());
        userCommissionAccountLogs.setUserNo(user.getUserNo());
        this.userCommissionAccountLogsService.add((Serializable)userCommissionAccountLogs);
    }

    @PreAuthorize(value="hasRole('USER')")
    @PostMapping(value={"binding"})
    public void binding(String userNo) {
        if (userNo == null) {
            log.info("user no is null ");
            return;
        }
        User user = (User)SecurityContext.getUser();
        if (StringUtils.isEmpty((Object)user.getUserNo()) || StringUtils.isEmpty((Object)userNo)) {
            throw new CustomException("\u4f1a\u5458\u7ed1\u5b9a\u53c2\u6570\u6709\u8bef");
        }
        userNo = userNo.replaceAll("USER", "");
        log.info("\u7ed1\u5b9a\u4f1a\u5458\u53c2\u6570 {} <==To==> {}", (Object)user.getUserNo(), (Object)userNo);
        this.userCommissionService.binding(user.getUserNo(), userNo);
    }

    @PostMapping(value={"wxa-code"})
    @PreAuthorize(value="hasRole('USER')")
    public String wxaCode(@RequestHeader(value="appid") String appid) {
        User user = (User)SecurityContext.getUser();
        String key = String.format(USER_WXA_CODE_KEY, appid, user.getUserNo());
        String cacheBase64Code = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (!StringUtils.isEmpty((Object)cacheBase64Code)) {
            return cacheBase64Code;
        }
        Wechat wechat = this.wechatService.getWechat((Object)appid);
        String accessToken = null;
        try {
            accessToken = this.wechat3rdPlatformHandler.getAuthorizerAccessToken(appid).getAccessToken();
            Assert.notNull((Object)accessToken, (String)"get accesstoken error");
        }
        catch (LoaderNotFoundException e) {
            log.error(e.getLocalizedMessage());
        }
        log.info("\u751f\u6210\u7528\u6237 {} \u7684\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801", (Object)user.getUserNo());
        byte[] codeBytes = new byte[]{};
        codeBytes = wechat.qr().getWXACodeUnlimit(accessToken, WXAQRCodeRequest.builder().scene("USER" + user.getUserNo()).page("pages/shouye/main").build());
        String codeBase64 = Base64.getEncoder().encodeToString(codeBytes);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)codeBase64, 3L, TimeUnit.DAYS);
        return codeBase64;
    }
}

