/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.ShopCartDTO;
import com.wmeimob.fastboot.bizvane.entity.ShopCart;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.ShopCartService;
import com.wmeimob.fastboot.core.context.PageContext;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"shop-carts"})
public class ShopCartController {
    private static final Logger log = LoggerFactory.getLogger(ShopCartController.class);
    @Resource
    private ShopCartService shopCartService;

    @PostMapping
    public void add(@RequestBody ShopCart shopCart) {
        log.info("\u6dfb\u52a0\u8d2d\u7269\u8f66:{}", (Object)shopCart);
        this.shopCartService.add((Serializable)this.getCondition(shopCart));
    }

    @DeleteMapping(value={"{id}"})
    public void delete(@PathVariable(value="id") Integer id) {
        ShopCart shopCart = new ShopCart();
        shopCart.setId(id);
        this.shopCartService.delete(id, (Serializable)this.getCondition(shopCart));
    }

    @GetMapping(value={"count"})
    public Integer getShopCart() {
        return this.shopCartService.queryCount(this.getCondition());
    }

    @DeleteMapping
    public void deleteAll(@RequestBody Integer[] idArr) {
        this.shopCartService.delete(idArr);
    }

    @GetMapping
    public PageInfo<ShopCartDTO> getShopCarts() {
        log.info("\u83b7\u53d6\u8d2d\u7269\u8f66\u4e2d\u5546\u54c1\u5217\u8868....START....");
        PageContext.startPage();
        List list = this.shopCartService.queryShopCartGoods(this.getCondition());
        PageInfo pageInfo = new PageInfo(list);
        log.info("\u83b7\u53d6\u8d2d\u7269\u8f66\u4e2d\u5546\u54c1\u5217\u8868....END....  \u7ed3\u679c\u96c6\u4e3a:{}", (Object)pageInfo);
        return pageInfo;
    }

    private ShopCart getCondition() {
        User user = (User)SecurityContext.getUser();
        ShopCart shopCart = new ShopCart();
        shopCart.setWechatOpenid(user.getOpenid());
        shopCart.setMerchantId(user.getMerchantId());
        return shopCart;
    }

    private ShopCart getCondition(ShopCart shopCart) {
        User user = (User)SecurityContext.getUser();
        shopCart.setMerchantId(user.getMerchantId());
        shopCart.setWechatOpenid(user.getOpenid());
        return shopCart;
    }
}

