/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedpr.crypto;

import com.webank.wedpr.crypto.CryptoResult;
import com.webank.wedpr.utils.EnvironmentUtils;
import com.webank.wedpr.utils.NativeUtils;
import java.io.IOException;

public class NativeInterface {
    private static final String LIB_FFI_RESOURCE_PATH;
    private static final String LIB_FFI_NAME = "WeDPR_dynamic_lib/libffi_java_sdk";

    public static native CryptoResult secp256k1EciesEncrypt(String var0, String var1);

    public static native CryptoResult secp256k1EciesDecrypt(String var0, String var1);

    public static native CryptoResult secp256k1GenKeyPair();

    public static native CryptoResult secp256k1DerivePublicKey(String var0);

    public static native CryptoResult keccak256Hash(String var0);

    public static native CryptoResult secp256k1Sign(String var0, String var1);

    public static native CryptoResult secp256k1Verify(String var0, String var1, String var2);

    public static native CryptoResult secp256k1RecoverPublicKey(String var0, String var1);

    public static native CryptoResult sm3Hash(String var0);

    public static native CryptoResult sm2GenKeyPair();

    public static native CryptoResult sm2DerivePublicKey(String var0);

    public static native CryptoResult sm2Sign(String var0, String var1);

    public static native CryptoResult sm2SignFast(String var0, String var1, String var2);

    public static native CryptoResult sm2Verify(String var0, String var1, String var2);

    public static native CryptoResult sm2ComputeHashE(String var0, String var1);

    public static native CryptoResult curve25519VrfProveUtf8(String var0, String var1);

    public static native CryptoResult curve25519VrfProveFastUtf8(String var0, String var1, String var2);

    public static native CryptoResult curve25519VrfVerifyUtf8(String var0, String var1, String var2);

    public static native CryptoResult curve25519VrfDerivePublicKey(String var0);

    public static native CryptoResult curve25519VrfProofToHash(String var0);

    public static native CryptoResult curve25519VrfIsValidPublicKey(String var0);

    private static String resolveLibTail(String os) {
        String tail;
        if ((os = os.toLowerCase()).contains("windows")) {
            tail = ".dll";
        } else if (os.contains("linux")) {
            tail = ".so";
        } else if (os.contains("mac")) {
            tail = ".dylib";
        } else {
            throw new RuntimeException("Unsupported os: " + os);
        }
        return tail;
    }

    private NativeInterface() {
    }

    static {
        String os = System.getProperty("os.name");
        String tail = EnvironmentUtils.getResourceTailByOs(os);
        LIB_FFI_RESOURCE_PATH = LIB_FFI_NAME + tail;
        try {
            NativeUtils.loadLibrary(LIB_FFI_RESOURCE_PATH);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load library", e);
        }
    }
}

