/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.streaming;

import com.qiniu.util.Auth;

public final class UrlFactory {
    private final String hub;
    private final Auth auth;
    private final String rtmpPubDomain;
    private final String rtmpPlayDomain;
    private final String hlsDomain;
    private final String hdlDomain;
    private final String snapDomain;

    public UrlFactory(String hub, Auth auth, String rtmpPubDomain, String rtmpPlayDomain) {
        this(hub, auth, rtmpPubDomain, rtmpPlayDomain, null, null, null);
    }

    public UrlFactory(String hub, Auth auth, String rtmpPubDomain, String rtmpPlayDomain, String hlsDomain, String hdlDomain, String snapDomain) {
        this.hub = hub;
        this.auth = auth;
        this.rtmpPubDomain = rtmpPubDomain;
        this.rtmpPlayDomain = rtmpPlayDomain;
        this.hlsDomain = hlsDomain;
        this.hdlDomain = hdlDomain;
        this.snapDomain = snapDomain;
    }

    public String rtmpPublishUrl(String streamKey) {
        return String.format("rtmp://%s/%s/%s", this.rtmpPubDomain, this.hub, streamKey);
    }

    public String rtmpPublishUrl(String streamKey, int expireAfterSeconds) {
        String token;
        long expire = System.currentTimeMillis() / 1000L + (long)expireAfterSeconds;
        String path = String.format("/%s/%s?e=%d", this.hub, streamKey, expire);
        try {
            token = this.auth.sign(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return String.format("rtmp://%s%s&token=%s", this.rtmpPubDomain, path, token);
    }

    public String rtmpPlayUrl(String streamKey) {
        return String.format("rtmp://%s/%s/%s", this.rtmpPlayDomain, this.hub, streamKey);
    }

    public String hlsPlayUrl(String streamKey) {
        return String.format("http://%s/%s/%s.m3u8", this.hlsDomain, this.hub, streamKey);
    }

    public String hdlPlayUrl(String streamKey) {
        return String.format("http://%s/%s/%s.flv", this.hdlDomain, this.hub, streamKey);
    }

    public String snapshotUrl(String streamKey) {
        return String.format("http://%s/%s/%s.jpg", this.snapDomain, this.hub, streamKey);
    }
}

